# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplianceContentFilteringArgs', 'ApplianceContentFiltering']

@pulumi.input_type
class ApplianceContentFilteringArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[str],
                 allowed_url_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_url_categories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_url_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 url_category_list_size: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ApplianceContentFiltering resource.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_url_patterns: A list of URL patterns that are allowed
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_url_categories: A list of URL categories to block
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_url_patterns: A list of URL patterns that are blocked
        :param pulumi.Input[str] url_category_list_size: URL category list size which is either 'topSites' or 'fullList'
        """
        pulumi.set(__self__, "network_id", network_id)
        if allowed_url_patterns is not None:
            pulumi.set(__self__, "allowed_url_patterns", allowed_url_patterns)
        if blocked_url_categories is not None:
            pulumi.set(__self__, "blocked_url_categories", blocked_url_categories)
        if blocked_url_patterns is not None:
            pulumi.set(__self__, "blocked_url_patterns", blocked_url_patterns)
        if url_category_list_size is not None:
            pulumi.set(__self__, "url_category_list_size", url_category_list_size)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="allowedUrlPatterns")
    def allowed_url_patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of URL patterns that are allowed
        """
        return pulumi.get(self, "allowed_url_patterns")

    @allowed_url_patterns.setter
    def allowed_url_patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_url_patterns", value)

    @property
    @pulumi.getter(name="blockedUrlCategories")
    def blocked_url_categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of URL categories to block
        """
        return pulumi.get(self, "blocked_url_categories")

    @blocked_url_categories.setter
    def blocked_url_categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blocked_url_categories", value)

    @property
    @pulumi.getter(name="blockedUrlPatterns")
    def blocked_url_patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of URL patterns that are blocked
        """
        return pulumi.get(self, "blocked_url_patterns")

    @blocked_url_patterns.setter
    def blocked_url_patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blocked_url_patterns", value)

    @property
    @pulumi.getter(name="urlCategoryListSize")
    def url_category_list_size(self) -> Optional[pulumi.Input[str]]:
        """
        URL category list size which is either 'topSites' or 'fullList'
        """
        return pulumi.get(self, "url_category_list_size")

    @url_category_list_size.setter
    def url_category_list_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url_category_list_size", value)


@pulumi.input_type
class _ApplianceContentFilteringState:
    def __init__(__self__, *,
                 allowed_url_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_url_categories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_url_categories_responses: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceContentFilteringBlockedUrlCategoriesResponseArgs']]]] = None,
                 blocked_url_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 url_category_list_size: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ApplianceContentFiltering resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_url_patterns: A list of URL patterns that are allowed
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_url_categories: A list of URL categories to block
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_url_patterns: A list of URL patterns that are blocked
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] url_category_list_size: URL category list size which is either 'topSites' or 'fullList'
        """
        if allowed_url_patterns is not None:
            pulumi.set(__self__, "allowed_url_patterns", allowed_url_patterns)
        if blocked_url_categories is not None:
            pulumi.set(__self__, "blocked_url_categories", blocked_url_categories)
        if blocked_url_categories_responses is not None:
            pulumi.set(__self__, "blocked_url_categories_responses", blocked_url_categories_responses)
        if blocked_url_patterns is not None:
            pulumi.set(__self__, "blocked_url_patterns", blocked_url_patterns)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if url_category_list_size is not None:
            pulumi.set(__self__, "url_category_list_size", url_category_list_size)

    @property
    @pulumi.getter(name="allowedUrlPatterns")
    def allowed_url_patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of URL patterns that are allowed
        """
        return pulumi.get(self, "allowed_url_patterns")

    @allowed_url_patterns.setter
    def allowed_url_patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_url_patterns", value)

    @property
    @pulumi.getter(name="blockedUrlCategories")
    def blocked_url_categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of URL categories to block
        """
        return pulumi.get(self, "blocked_url_categories")

    @blocked_url_categories.setter
    def blocked_url_categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blocked_url_categories", value)

    @property
    @pulumi.getter(name="blockedUrlCategoriesResponses")
    def blocked_url_categories_responses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceContentFilteringBlockedUrlCategoriesResponseArgs']]]]:
        return pulumi.get(self, "blocked_url_categories_responses")

    @blocked_url_categories_responses.setter
    def blocked_url_categories_responses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceContentFilteringBlockedUrlCategoriesResponseArgs']]]]):
        pulumi.set(self, "blocked_url_categories_responses", value)

    @property
    @pulumi.getter(name="blockedUrlPatterns")
    def blocked_url_patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of URL patterns that are blocked
        """
        return pulumi.get(self, "blocked_url_patterns")

    @blocked_url_patterns.setter
    def blocked_url_patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blocked_url_patterns", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="urlCategoryListSize")
    def url_category_list_size(self) -> Optional[pulumi.Input[str]]:
        """
        URL category list size which is either 'topSites' or 'fullList'
        """
        return pulumi.get(self, "url_category_list_size")

    @url_category_list_size.setter
    def url_category_list_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url_category_list_size", value)


class ApplianceContentFiltering(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_url_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_url_categories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_url_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 url_category_list_size: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.ApplianceContentFiltering("example",
            allowed_url_patterns=[
                "http://www.example.org",
                "http://help.com.au",
            ],
            blocked_url_categories=[
                "meraki:contentFiltering/category/1",
                "meraki:contentFiltering/category/7",
            ],
            blocked_url_patterns=[
                "http://www.example.com",
                "http://www.betting.com",
            ],
            network_id="string",
            url_category_list_size="topSites")
        pulumi.export("merakiNetworksApplianceContentFilteringExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceContentFiltering:ApplianceContentFiltering example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_url_patterns: A list of URL patterns that are allowed
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_url_categories: A list of URL categories to block
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_url_patterns: A list of URL patterns that are blocked
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] url_category_list_size: URL category list size which is either 'topSites' or 'fullList'
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplianceContentFilteringArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.ApplianceContentFiltering("example",
            allowed_url_patterns=[
                "http://www.example.org",
                "http://help.com.au",
            ],
            blocked_url_categories=[
                "meraki:contentFiltering/category/1",
                "meraki:contentFiltering/category/7",
            ],
            blocked_url_patterns=[
                "http://www.example.com",
                "http://www.betting.com",
            ],
            network_id="string",
            url_category_list_size="topSites")
        pulumi.export("merakiNetworksApplianceContentFilteringExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceContentFiltering:ApplianceContentFiltering example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param ApplianceContentFilteringArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplianceContentFilteringArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_url_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_url_categories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_url_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 url_category_list_size: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplianceContentFilteringArgs.__new__(ApplianceContentFilteringArgs)

            __props__.__dict__["allowed_url_patterns"] = allowed_url_patterns
            __props__.__dict__["blocked_url_categories"] = blocked_url_categories
            __props__.__dict__["blocked_url_patterns"] = blocked_url_patterns
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["url_category_list_size"] = url_category_list_size
            __props__.__dict__["blocked_url_categories_responses"] = None
        super(ApplianceContentFiltering, __self__).__init__(
            'meraki:networks/applianceContentFiltering:ApplianceContentFiltering',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_url_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            blocked_url_categories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            blocked_url_categories_responses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceContentFilteringBlockedUrlCategoriesResponseArgs']]]]] = None,
            blocked_url_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            url_category_list_size: Optional[pulumi.Input[str]] = None) -> 'ApplianceContentFiltering':
        """
        Get an existing ApplianceContentFiltering resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_url_patterns: A list of URL patterns that are allowed
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_url_categories: A list of URL categories to block
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_url_patterns: A list of URL patterns that are blocked
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] url_category_list_size: URL category list size which is either 'topSites' or 'fullList'
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplianceContentFilteringState.__new__(_ApplianceContentFilteringState)

        __props__.__dict__["allowed_url_patterns"] = allowed_url_patterns
        __props__.__dict__["blocked_url_categories"] = blocked_url_categories
        __props__.__dict__["blocked_url_categories_responses"] = blocked_url_categories_responses
        __props__.__dict__["blocked_url_patterns"] = blocked_url_patterns
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["url_category_list_size"] = url_category_list_size
        return ApplianceContentFiltering(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedUrlPatterns")
    def allowed_url_patterns(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of URL patterns that are allowed
        """
        return pulumi.get(self, "allowed_url_patterns")

    @property
    @pulumi.getter(name="blockedUrlCategories")
    def blocked_url_categories(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of URL categories to block
        """
        return pulumi.get(self, "blocked_url_categories")

    @property
    @pulumi.getter(name="blockedUrlCategoriesResponses")
    def blocked_url_categories_responses(self) -> pulumi.Output[Sequence['outputs.ApplianceContentFilteringBlockedUrlCategoriesResponse']]:
        return pulumi.get(self, "blocked_url_categories_responses")

    @property
    @pulumi.getter(name="blockedUrlPatterns")
    def blocked_url_patterns(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of URL patterns that are blocked
        """
        return pulumi.get(self, "blocked_url_patterns")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="urlCategoryListSize")
    def url_category_list_size(self) -> pulumi.Output[Optional[str]]:
        """
        URL category list size which is either 'topSites' or 'fullList'
        """
        return pulumi.get(self, "url_category_list_size")

