import * as lambda from '@aws-cdk/aws-lambda';
import * as cdk from '@aws-cdk/core';
/**
 * (experimental) Base options for Parcel bundling.
 *
 * @experimental
 */
export interface ParcelBaseOptions {
    /**
     * (experimental) Whether to minify files when bundling.
     *
     * @default false
     * @experimental
     */
    readonly minify?: boolean;
    /**
     * (experimental) Whether to include source maps when bundling.
     *
     * @default false
     * @experimental
     */
    readonly sourceMaps?: boolean;
    /**
     * (experimental) The cache directory (relative to the project root).
     *
     * Parcel uses a filesystem cache for fast rebuilds.
     *
     * @default - `.parcel-cache` in the working directory
     * @experimental
     */
    readonly cacheDir?: string;
    /**
     * (experimental) The root of the project.
     *
     * This will be used as the source for the volume
     * mounted in the Docker container. If you specify this prop, ensure that
     * this path includes `entry` and any module/dependencies used by your
     * function otherwise bundling will not be possible.
     *
     * @default - the closest path containing a .git folder
     * @experimental
     */
    readonly projectRoot?: string;
    /**
     * (experimental) Environment variables defined when Parcel runs.
     *
     * @default - no environment variables are defined.
     * @experimental
     */
    readonly parcelEnvironment?: {
        [key: string]: string;
    };
    /**
     * (experimental) A list of modules that should be considered as externals (already available in the runtime).
     *
     * @default ['aws-sdk']
     * @experimental
     */
    readonly externalModules?: string[];
    /**
     * (experimental) A list of modules that should be installed instead of bundled.
     *
     * Modules are
     * installed in a Lambda compatible environnment.
     *
     * @default - all modules are bundled
     * @experimental
     */
    readonly nodeModules?: string[];
    /**
     * (experimental) The version of Parcel to use when running in a Docker container.
     *
     * @default - 2.0.0-beta.1
     * @experimental
     */
    readonly parcelVersion?: string;
    /**
     * (experimental) Build arguments to pass when building the bundling image.
     *
     * @default - no build arguments are passed
     * @experimental
     */
    readonly buildArgs?: {
        [key: string]: string;
    };
    /**
     * (experimental) Force bundling in a Docker container even if local bundling is possible.This  is useful if your function relies on node modules that should be installed (`nodeModules`) in a Lambda compatible environment.
     *
     * @default false
     * @experimental
     */
    readonly forceDockerBundling?: boolean;
    /**
     * (experimental) A custom bundling Docker image.
     *
     * This image should have Parcel installed at `/`. If you plan to use `nodeModules`
     * it should also have `npm` or `yarn` depending on the lock file you're using.
     *
     * See https://github.com/aws/aws-cdk/blob/master/packages/%40aws-cdk/aws-lambda-nodejs/parcel/Dockerfile
     * for the default image provided by @aws-cdk/aws-lambda-nodejs.
     *
     * @default - use the Docker image provided by
     * @experimental
     * @aws-cdk /aws-lambda-nodejs
     */
    readonly bundlingDockerImage?: cdk.BundlingDockerImage;
}
/**
 * (experimental) Options for Parcel bundling.
 *
 * @experimental
 */
export interface ParcelOptions extends ParcelBaseOptions {
    /**
     * (experimental) Entry file.
     *
     * @experimental
     */
    readonly entry: string;
    /**
     * (experimental) The runtime of the lambda function.
     *
     * @experimental
     */
    readonly runtime: lambda.Runtime;
}
/**
 * (experimental) Bundling.
 *
 * @experimental
 */
export declare class Bundling {
    /**
     * (experimental) Parcel bundled Lambda asset code.
     *
     * @experimental
     */
    static parcel(options: ParcelOptions): lambda.AssetCode;
}
