/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.tools.ldbdist;

import com.datapps.linkoopdb.jdbc.tools.ldbdist.LDBDistOutputStream;
import com.datapps.linkoopdb.jdbc.tools.net.LdbURLStreamHandlerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;

public class FileClient {
    public FileClient() {
        try {
            FileClient.registerFactory(new LdbURLStreamHandlerFactory());
        }
        catch (Exception e) {
            throw new RuntimeException("create ldbdist connection factory fail", e);
        }
    }

    public boolean put(String uri, InputStream input) throws Exception {
        return this.put(uri, input, false);
    }

    public boolean put(String uri) throws Exception {
        LDBDistOutputStream output = new LDBDistOutputStream(uri, true);
        output.close();
        return true;
    }

    public boolean put(String uri, InputStream input, boolean overwrite) throws Exception {
        LDBDistOutputStream output = new LDBDistOutputStream(uri, true, 0L);
        output.copyStream(input);
        output.close();
        return true;
    }

    public boolean get(String uri, String path) throws Exception {
        LDBDistOutputStream output = new LDBDistOutputStream(uri);
        output.downLoadFromUrl(path);
        output.close();
        return true;
    }

    public boolean delete(String uri) throws IOException {
        return this.delete(uri, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String uri, boolean recursive) throws IOException {
        HttpURLConnection httpUrlConnection = null;
        try {
            httpUrlConnection = (HttpURLConnection)new URL(uri).openConnection();
            httpUrlConnection.setRequestMethod("DELETE");
            httpUrlConnection.setRequestProperty("Recursive", String.valueOf(String.valueOf(recursive)));
            httpUrlConnection.connect();
            boolean bl = httpUrlConnection.getResponseCode() == 200;
            return bl;
        }
        finally {
            if (httpUrlConnection != null) {
                httpUrlConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean get(String uri) throws IOException {
        HttpURLConnection httpUrlConnection = null;
        try {
            httpUrlConnection = (HttpURLConnection)new URL(uri).openConnection();
            httpUrlConnection.setRequestMethod("GET");
            httpUrlConnection.connect();
            boolean bl = httpUrlConnection.getResponseCode() == 200;
            return bl;
        }
        finally {
            if (httpUrlConnection != null) {
                httpUrlConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerFactory(final LdbURLStreamHandlerFactory factory) throws Exception {
        Field factoryField = URL.class.getDeclaredField("factory");
        factoryField.setAccessible(true);
        Field lockField = URL.class.getDeclaredField("streamHandlerLock");
        lockField.setAccessible(true);
        Object object = lockField.get(null);
        synchronized (object) {
            final URLStreamHandlerFactory originalUrlStreamHandlerFactory = (URLStreamHandlerFactory)factoryField.get(null);
            factoryField.set(null, null);
            URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory(){

                @Override
                public URLStreamHandler createURLStreamHandler(String protocol) {
                    if (protocol.equals("ldbdist")) {
                        return factory.createURLStreamHandler(protocol);
                    }
                    if (originalUrlStreamHandlerFactory == null) {
                        return null;
                    }
                    return originalUrlStreamHandlerFactory.createURLStreamHandler(protocol);
                }
            });
        }
    }
}

