/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.types;

import com.datapps.linkoopdb.jdbc.SessionInterface;
import com.datapps.linkoopdb.jdbc.error.Error;
import com.datapps.linkoopdb.jdbc.result.Result;
import com.datapps.linkoopdb.jdbc.result.ResultLob;
import com.datapps.linkoopdb.jdbc.types.BinaryData;
import com.datapps.linkoopdb.jdbc.types.BlobData;
import com.datapps.linkoopdb.jdbc.types.BlobInputStream;
import com.datapps.linkoopdb.jdbc.types.LobLocation;
import java.io.InputStream;

public class BlobDataID
implements BlobData {
    long id;
    long length = -1L;
    LobLocation lobLocation;

    public BlobDataID(long id) {
        this.id = id;
    }

    @Override
    public BlobData duplicate(SessionInterface session) {
        ResultLob resultOut = ResultLob.newLobDuplicateRequest(this.id);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        long lobID = ((ResultLob)resultIn).getLobID();
        return new BlobDataID(lobID);
    }

    @Override
    public void free() {
    }

    @Override
    public InputStream getBinaryStream(SessionInterface session) {
        long length = this.length(session);
        return new BlobInputStream(session, this, 0L, length);
    }

    @Override
    public InputStream getBinaryStream(SessionInterface session, long pos, long length) {
        return new BlobInputStream(session, this, pos, length);
    }

    @Override
    public byte[] getBytes() {
        return null;
    }

    @Override
    public byte[] getBytes(SessionInterface session, long pos, int length) {
        ResultLob resultOut;
        Result resultIn;
        if (this.lobLocation == null) {
            long blobLength = this.length(session);
            if (pos >= blobLength) {
                return new byte[0];
            }
            if (pos + (long)length >= blobLength) {
                length = (int)(blobLength - pos);
            }
        }
        if ((resultIn = session.execute(resultOut = ResultLob.newLobGetBytesRequest(this, pos, length))).isError()) {
            throw Error.error(resultIn);
        }
        return ((ResultLob)resultIn).getByteArray();
    }

    @Override
    public BlobData getBlob(SessionInterface session, long pos, long length) {
        ResultLob resultOut = ResultLob.newLobGetRequest(this.id, pos, length);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw Error.error(resultIn);
        }
        long lobID = ((ResultLob)resultIn).getLobID();
        return new BlobDataID(lobID);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public int getStreamBlockSize() {
        return 0;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public long length(SessionInterface session) {
        if (this.length > -1L) {
            return this.length;
        }
        ResultLob resultOut = ResultLob.newLobGetLengthRequest(this.id, this.lobLocation);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        this.length = ((ResultLob)resultIn).getBlockLength();
        return this.length;
    }

    @Override
    public long bitLength(SessionInterface session) {
        return this.length(session) * 8L;
    }

    @Override
    public boolean isBits() {
        return false;
    }

    @Override
    public long position(SessionInterface session, BlobData pattern, long start) {
        ResultLob resultOut = ResultLob.newLobGetCharPatternPositionRequest(this.id, pattern.getId(), start);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return ((ResultLob)resultIn).getOffset();
    }

    @Override
    public long position(SessionInterface session, byte[] pattern, long start) {
        ResultLob resultOut = ResultLob.newLobGetBytePatternPositionRequest(this.id, pattern, start);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return ((ResultLob)resultIn).getOffset();
    }

    @Override
    public long nonZeroLength(SessionInterface session) {
        ResultLob resultOut = ResultLob.newLobGetTruncateLength(this.id);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return ((ResultLob)resultIn).getBlockLength();
    }

    @Override
    public void setBytes(SessionInterface session, long pos, byte[] bytes, int offset, int len) {
        ResultLob resultOut;
        Result resultIn;
        if (offset != 0 || len != bytes.length) {
            if (!BinaryData.isInLimits(bytes.length, offset, len)) {
                throw new IndexOutOfBoundsException();
            }
            byte[] newbytes = new byte[len];
            System.arraycopy(bytes, offset, newbytes, 0, len);
            bytes = newbytes;
        }
        if ((resultIn = session.execute(resultOut = ResultLob.newLobSetBytesRequest(this, pos, bytes))).isError()) {
            throw resultIn.getException();
        }
        this.length = ((ResultLob)resultIn).getBlockLength();
    }

    @Override
    public void setBytes(SessionInterface session, long pos, byte[] bytes) {
        this.setBytes(session, pos, bytes, 0, bytes.length);
    }

    @Override
    public void setBytes(SessionInterface session, long pos, BlobData b, long offset, long length) {
        if (length > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        byte[] bytes = b.getBytes(session, offset, (int)length);
        this.setBytes(session, pos, bytes, 0, bytes.length);
    }

    @Override
    public void setBinaryStream(SessionInterface session, long pos, InputStream in) {
    }

    @Override
    public void setSession(SessionInterface session) {
    }

    @Override
    public void truncate(SessionInterface session, long len) {
        if (len >= this.length(session)) {
            return;
        }
        ResultLob resultOut = ResultLob.newLobTruncateRequest(this, len);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public LobLocation getLobLocation() {
        return this.lobLocation;
    }

    @Override
    public void setLobLocation(LobLocation lobLocation) {
        this.lobLocation = lobLocation;
    }

    public boolean equals(Object other) {
        if (other instanceof BlobDataID) {
            return this.id == ((BlobDataID)other).id;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.id;
    }
}

