# -*- coding: utf-8 -*-
# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

from google.analytics.admin_v1alpha.services.analytics_admin_service.async_client import (
    AnalyticsAdminServiceAsyncClient,
)
from google.analytics.admin_v1alpha.services.analytics_admin_service.client import (
    AnalyticsAdminServiceClient,
)
from google.analytics.admin_v1alpha.types.analytics_admin import (
    AcknowledgeUserDataCollectionRequest,
    AcknowledgeUserDataCollectionResponse,
    ApproveDisplayVideo360AdvertiserLinkProposalRequest,
    ApproveDisplayVideo360AdvertiserLinkProposalResponse,
    ArchiveCustomDimensionRequest,
    ArchiveCustomMetricRequest,
    AuditUserLinksRequest,
    AuditUserLinksResponse,
    BatchCreateUserLinksRequest,
    BatchCreateUserLinksResponse,
    BatchDeleteUserLinksRequest,
    BatchGetUserLinksRequest,
    BatchGetUserLinksResponse,
    BatchUpdateUserLinksRequest,
    BatchUpdateUserLinksResponse,
    CancelDisplayVideo360AdvertiserLinkProposalRequest,
    CreateConversionEventRequest,
    CreateCustomDimensionRequest,
    CreateCustomMetricRequest,
    CreateDataStreamRequest,
    CreateDisplayVideo360AdvertiserLinkProposalRequest,
    CreateDisplayVideo360AdvertiserLinkRequest,
    CreateFirebaseLinkRequest,
    CreateGoogleAdsLinkRequest,
    CreateMeasurementProtocolSecretRequest,
    CreatePropertyRequest,
    CreateUserLinkRequest,
    DeleteAccountRequest,
    DeleteConversionEventRequest,
    DeleteDataStreamRequest,
    DeleteDisplayVideo360AdvertiserLinkProposalRequest,
    DeleteDisplayVideo360AdvertiserLinkRequest,
    DeleteFirebaseLinkRequest,
    DeleteGoogleAdsLinkRequest,
    DeleteMeasurementProtocolSecretRequest,
    DeletePropertyRequest,
    DeleteUserLinkRequest,
    GetAccountRequest,
    GetConversionEventRequest,
    GetCustomDimensionRequest,
    GetCustomMetricRequest,
    GetDataRetentionSettingsRequest,
    GetDataSharingSettingsRequest,
    GetDataStreamRequest,
    GetDisplayVideo360AdvertiserLinkProposalRequest,
    GetDisplayVideo360AdvertiserLinkRequest,
    GetGlobalSiteTagRequest,
    GetGoogleSignalsSettingsRequest,
    GetMeasurementProtocolSecretRequest,
    GetPropertyRequest,
    GetUserLinkRequest,
    ListAccountsRequest,
    ListAccountsResponse,
    ListAccountSummariesRequest,
    ListAccountSummariesResponse,
    ListConversionEventsRequest,
    ListConversionEventsResponse,
    ListCustomDimensionsRequest,
    ListCustomDimensionsResponse,
    ListCustomMetricsRequest,
    ListCustomMetricsResponse,
    ListDataStreamsRequest,
    ListDataStreamsResponse,
    ListDisplayVideo360AdvertiserLinkProposalsRequest,
    ListDisplayVideo360AdvertiserLinkProposalsResponse,
    ListDisplayVideo360AdvertiserLinksRequest,
    ListDisplayVideo360AdvertiserLinksResponse,
    ListFirebaseLinksRequest,
    ListFirebaseLinksResponse,
    ListGoogleAdsLinksRequest,
    ListGoogleAdsLinksResponse,
    ListMeasurementProtocolSecretsRequest,
    ListMeasurementProtocolSecretsResponse,
    ListPropertiesRequest,
    ListPropertiesResponse,
    ListUserLinksRequest,
    ListUserLinksResponse,
    ProvisionAccountTicketRequest,
    ProvisionAccountTicketResponse,
    SearchChangeHistoryEventsRequest,
    SearchChangeHistoryEventsResponse,
    UpdateAccountRequest,
    UpdateCustomDimensionRequest,
    UpdateCustomMetricRequest,
    UpdateDataRetentionSettingsRequest,
    UpdateDataStreamRequest,
    UpdateDisplayVideo360AdvertiserLinkRequest,
    UpdateGoogleAdsLinkRequest,
    UpdateGoogleSignalsSettingsRequest,
    UpdateMeasurementProtocolSecretRequest,
    UpdatePropertyRequest,
    UpdateUserLinkRequest,
)
from google.analytics.admin_v1alpha.types.resources import (
    Account,
    AccountSummary,
    ActionType,
    ActorType,
    AuditUserLink,
    ChangeHistoryChange,
    ChangeHistoryEvent,
    ChangeHistoryResourceType,
    ConversionEvent,
    CustomDimension,
    CustomMetric,
    DataRetentionSettings,
    DataSharingSettings,
    DataStream,
    DisplayVideo360AdvertiserLink,
    DisplayVideo360AdvertiserLinkProposal,
    FirebaseLink,
    GlobalSiteTag,
    GoogleAdsLink,
    GoogleSignalsConsent,
    GoogleSignalsSettings,
    GoogleSignalsState,
    IndustryCategory,
    LinkProposalInitiatingProduct,
    LinkProposalState,
    LinkProposalStatusDetails,
    MeasurementProtocolSecret,
    Property,
    PropertySummary,
    ServiceLevel,
    UserLink,
)

__all__ = (
    "AnalyticsAdminServiceClient",
    "AnalyticsAdminServiceAsyncClient",
    "AcknowledgeUserDataCollectionRequest",
    "AcknowledgeUserDataCollectionResponse",
    "ApproveDisplayVideo360AdvertiserLinkProposalRequest",
    "ApproveDisplayVideo360AdvertiserLinkProposalResponse",
    "ArchiveCustomDimensionRequest",
    "ArchiveCustomMetricRequest",
    "AuditUserLinksRequest",
    "AuditUserLinksResponse",
    "BatchCreateUserLinksRequest",
    "BatchCreateUserLinksResponse",
    "BatchDeleteUserLinksRequest",
    "BatchGetUserLinksRequest",
    "BatchGetUserLinksResponse",
    "BatchUpdateUserLinksRequest",
    "BatchUpdateUserLinksResponse",
    "CancelDisplayVideo360AdvertiserLinkProposalRequest",
    "CreateConversionEventRequest",
    "CreateCustomDimensionRequest",
    "CreateCustomMetricRequest",
    "CreateDataStreamRequest",
    "CreateDisplayVideo360AdvertiserLinkProposalRequest",
    "CreateDisplayVideo360AdvertiserLinkRequest",
    "CreateFirebaseLinkRequest",
    "CreateGoogleAdsLinkRequest",
    "CreateMeasurementProtocolSecretRequest",
    "CreatePropertyRequest",
    "CreateUserLinkRequest",
    "DeleteAccountRequest",
    "DeleteConversionEventRequest",
    "DeleteDataStreamRequest",
    "DeleteDisplayVideo360AdvertiserLinkProposalRequest",
    "DeleteDisplayVideo360AdvertiserLinkRequest",
    "DeleteFirebaseLinkRequest",
    "DeleteGoogleAdsLinkRequest",
    "DeleteMeasurementProtocolSecretRequest",
    "DeletePropertyRequest",
    "DeleteUserLinkRequest",
    "GetAccountRequest",
    "GetConversionEventRequest",
    "GetCustomDimensionRequest",
    "GetCustomMetricRequest",
    "GetDataRetentionSettingsRequest",
    "GetDataSharingSettingsRequest",
    "GetDataStreamRequest",
    "GetDisplayVideo360AdvertiserLinkProposalRequest",
    "GetDisplayVideo360AdvertiserLinkRequest",
    "GetGlobalSiteTagRequest",
    "GetGoogleSignalsSettingsRequest",
    "GetMeasurementProtocolSecretRequest",
    "GetPropertyRequest",
    "GetUserLinkRequest",
    "ListAccountsRequest",
    "ListAccountsResponse",
    "ListAccountSummariesRequest",
    "ListAccountSummariesResponse",
    "ListConversionEventsRequest",
    "ListConversionEventsResponse",
    "ListCustomDimensionsRequest",
    "ListCustomDimensionsResponse",
    "ListCustomMetricsRequest",
    "ListCustomMetricsResponse",
    "ListDataStreamsRequest",
    "ListDataStreamsResponse",
    "ListDisplayVideo360AdvertiserLinkProposalsRequest",
    "ListDisplayVideo360AdvertiserLinkProposalsResponse",
    "ListDisplayVideo360AdvertiserLinksRequest",
    "ListDisplayVideo360AdvertiserLinksResponse",
    "ListFirebaseLinksRequest",
    "ListFirebaseLinksResponse",
    "ListGoogleAdsLinksRequest",
    "ListGoogleAdsLinksResponse",
    "ListMeasurementProtocolSecretsRequest",
    "ListMeasurementProtocolSecretsResponse",
    "ListPropertiesRequest",
    "ListPropertiesResponse",
    "ListUserLinksRequest",
    "ListUserLinksResponse",
    "ProvisionAccountTicketRequest",
    "ProvisionAccountTicketResponse",
    "SearchChangeHistoryEventsRequest",
    "SearchChangeHistoryEventsResponse",
    "UpdateAccountRequest",
    "UpdateCustomDimensionRequest",
    "UpdateCustomMetricRequest",
    "UpdateDataRetentionSettingsRequest",
    "UpdateDataStreamRequest",
    "UpdateDisplayVideo360AdvertiserLinkRequest",
    "UpdateGoogleAdsLinkRequest",
    "UpdateGoogleSignalsSettingsRequest",
    "UpdateMeasurementProtocolSecretRequest",
    "UpdatePropertyRequest",
    "UpdateUserLinkRequest",
    "Account",
    "AccountSummary",
    "AuditUserLink",
    "ChangeHistoryChange",
    "ChangeHistoryEvent",
    "ConversionEvent",
    "CustomDimension",
    "CustomMetric",
    "DataRetentionSettings",
    "DataSharingSettings",
    "DataStream",
    "DisplayVideo360AdvertiserLink",
    "DisplayVideo360AdvertiserLinkProposal",
    "FirebaseLink",
    "GlobalSiteTag",
    "GoogleAdsLink",
    "GoogleSignalsSettings",
    "LinkProposalStatusDetails",
    "MeasurementProtocolSecret",
    "Property",
    "PropertySummary",
    "UserLink",
    "ActionType",
    "ActorType",
    "ChangeHistoryResourceType",
    "GoogleSignalsConsent",
    "GoogleSignalsState",
    "IndustryCategory",
    "LinkProposalInitiatingProduct",
    "LinkProposalState",
    "ServiceLevel",
)
