from .fun import ispump

import pandas as pd
import numpy as np
import IPython,os,time,warnings,copy
warnings.filterwarnings("ignore")

class check(object):

    def demo():
        '''demo is used to demonstrate typical examples about this class.'''
        demostr = '''
import clubear as cb
#clubear.csv is generated by cb.manager.demo()
pm=cb.pump('clubear.csv') #start a new pump
pm.keep #check the head lists
cb.check(pm).stats() #check the for stats
pm.qlist=['age','height','weight','price','logsales']
cb.check(pm).stats(niter=20,keep=['price']) 
cb.check(pm).corr() #check for correlation
cb.check(pm).table(tv=True) #check table
pm.subsize=10000 #check the subsize
df=pm.go #start to pump data
'''
        print(demostr)

    def __init__(self, pm):
        '''Initialization: get the pump pm.'''
        self.pm = pm

    def stats(self,keep='',niter=10,disp=True):
        '''Compute standard statistics for all quantitative variables.'''
        
        '''check carefully all the pre-conditions'''
        if not ispump(self.pm): print('check.stats: The input seems not a valid pump.'); return
        if not isinstance(keep,str): print('check.stats: The keep must be a str.'); return
        keep=keep.strip()
        if not isinstance(niter,int): print('check.stats: The niter must be an int.'); return
        if niter<1: print('check.stats: The niter must be no less than one.'); return
        if not isinstance(disp,bool): print('check.stats: The input disp should be a bool.'); return
        
        '''some preparation work'''
        df=self.pm.go();heads = list(df.columns);ncolumns=len(heads)
        mylist=sorted([each for each in heads if df.dtypes[each]!='object'])
        if len(keep)>0: mylist=[keep]
        if len(mylist)==0: print('check.stats: No variable needs to be checked!'); return
        
        '''main part for computing statistics'''
        ncov = len(mylist)
        N = np.zeros([niter,ncov])
        MU = np.zeros([niter, ncov])
        Min = np.zeros([niter, ncov])
        Med = np.zeros([niter, ncov])
        Max = np.zeros([niter, ncov])
        SD = np.zeros([niter, ncov])
        SE = np.zeros([niter, ncov])
        Skew = np.zeros([niter, ncov])
        Kurt = np.zeros([niter, ncov])
        Prob = np.zeros([niter,ncov])
        start_time=time.time()
        for n in range(niter):                      
            '''get data and make it float'''
            df = self.pm.go()[mylist];ss=df.shape[0]  
            
            '''create non-missing flag'''
            flag=np.isnan(df)
            Prob[n]=1-np.mean(flag,axis=0)+1.0e-15
            
            '''The 1st bach of stat *without* central'''
            N[n] = ss-np.sum(flag,axis=0)            
            MU[n] = np.nanmean(df, axis=0)
            Min[n] = np.nanmin(df, axis=0)
            Med[n] = np.nanmedian(df, axis=0)
            Max[n] = np.nanmax(df, axis=0)

            '''The 2nd batch of stat *with* central'''
            df =df-MU[n]
            SD[n] = np.sqrt(np.nanmean(df**2, axis=0))+1.0e-12
            Skew[n] = np.nanmean(df**3, axis=0)/SD[n]**3
            Kurt[n] = np.nanmean(df**4, axis=0)/SD[n]**4
            SE[n]=SD[n]**2/N[n]
            
            '''organize for interactive output'''            
            MyN = np.nanmean(N[:(n+1)])
            MyMU = np.nanmean(MU[:(n+1)],axis=0)
            MyMin = np.nanmin(Min[:(n+1)],axis=0)
            MyMed = np.nanmedian(Med[:(n+1)],axis=0)
            MyMax = np.nanmax(Max[:(n+1)],axis=0)
            MySD = np.nanmean(SD[:(n+1)],axis=0)
            MySkew = np.nanmean(Skew[:(n+1)],axis=0)
            MyKurt = np.nanmean(Kurt[:(n+1)],axis=0)
            MyProb = np.abs(1-np.nanmean(Prob[:(n+1)],axis=0))
            MySE=np.sqrt(np.nanmean(SE[:(n+1)],axis=0)/(n+1))

            output = pd.DataFrame(list(zip(MyMU,MySE*100,MySD,MyMin, MyMed, MyMax, MySkew,MyKurt,100*MyProb)))
            output.columns = ['Mu','SE','Std','Min','Med', 'Max','Skew','Kurt','mp']
            output.index = mylist
            
            '''output to screen for interactive analysis'''
            if not disp: continue
            end_time=time.time();elapse_time=end_time-start_time            
            IPython.display.clear_output(wait=True)
            pd.set_option('display.max_columns',100)
            pd.set_option('display.max_rows',100)
            pd.set_option('display.width',100)
            progress = np.round((n+1)/niter*100, 2)
            print('Time elapsed:',('%.1f'%elapse_time),'seconds',end=' ')
            print('with subsample sizes', int(MyN), '.')
            print('Task accomplished: ', ('%.1f'%progress),
                  '% for a total of ', niter, 'random replications.')
            print('');print(np.round(output, 2));print('')
            print('* Mu: the averaged subsample mean; SE: the standard error of Mu in %;')
            print('* Std: the averaged subsample standard deviation; Min: the minimum of the subsample minimum;')
            print('* Med: the median of the subsample median; Max: the maximum of the subsample maximum;')
            print('* Skew: the averaged sample skewness; Kurt: the averaged non-centralized kurtosis.')
            print('* mp: the averaged subsample missing probability in percentage (0%~100%).')
        return output
    
    def corr(self,keep=[],niter=10,disp=True):
        '''corr is used to compute corr for all quantitative variables.'''
        
        '''check carefully all the pre-conditions'''
        if not ispump(self.pm): print('check.corr: The input seems not a valid pump.'); return
        if not isinstance(niter,int): print('check.corr: The niter must be an int.'); return
        if niter<1: print('check.corr: The niter must be no less than one.'); return
        if not isinstance(keep,list): print('check.corr: The keep list must be a list.'); return
        keep=[each.strip() for each in keep]
        if not isinstance(disp,bool): print('check.corr: The input disp should be a bool.'); return
        
        '''some preparation work'''
        df=self.pm.go();heads = list(df.columns);ncolumns=len(heads)
        mylist=sorted([each for each in heads if df.dtypes[each]!='object'])
        if len(keep)>0: mylist=[each for each in mylist if each in keep]
        if len(mylist)==0: print('check.corr: No variable can be checked!'); return
        
        '''main part for computing statistics'''
        ncov = len(mylist)
        corr_total=np.zeros([ncov,ncov])
        start_time=time.time()
        for n in range(niter):
            '''get data and make it float'''
            df = np.array(self.pm.go()[mylist])  
            
            MyN=df.shape[0]             
            '''standardize the data'''
            df = df-np.nanmean(df, axis=0)
            SD = np.sqrt(np.nanmean(df**2,axis=0))+1.0e-12
            df = df/SD
            
            '''this part cannot be replaced by convenient functions'''
            '''due to the existence of NaNs. Be very careful pls.'''
            mycorr=np.zeros([ncov,ncov])
            for j1 in range(ncov):
                for j2 in range(ncov):
                    mycorr[j1,j2]=np.nanmean(df[:,j1]*df[:,j2])
            corr_total=corr_total+mycorr
            
            Corr=pd.DataFrame(corr_total/(n+1))*100
            Corr.index=['['+str(each)+']'+mylist[each] for each in range(ncov)]
            Corr.columns=['['+str(each)+']' for each in range(ncov)]
            
            '''output to screen for interactive analysis'''
            if not disp: continue
            end_time=time.time();elapse_time=end_time-start_time            
            IPython.display.clear_output(wait=True)
            pd.set_option('display.float_format',lambda x: '%.1f'%x)
            pd.set_option('display.max_columns',100)
            pd.set_option('display.max_rows',100)
            pd.set_option('display.width',100)
            progress = np.round((n+1)/niter*100, 2)
            print('Time elapsed:',('%.1f'%elapse_time),'seconds',end=' ')
            print('with subsample sizes', int(MyN), '.')
            print('Task accomplished: ', ('%.1f'%progress),'% for a total of ', niter, 'random replications.')
            print(''); print(np.round(Corr, 1)); print('')
            print('* the averaged subsample correlation coefficients in percentage (0%~100%).')
        return Corr
        
    def table(self,keep='',tv=False,niter=10,disp=True):
        '''table is used to compute frequency tables for all qualitative variables.'''
        
        '''check carefully all the pre-conditions'''
        if not ispump(self.pm): print('check.table: The input seems not a valid pump.'); return
        if not isinstance(tv,bool): print('check.table: The tv must be a bool'); return
        if not isinstance(niter,int): print('check.table: The niter must be an int.'); return
        if niter<1: print('check.table: The niter must be no less than one.'); return
        if not isinstance(keep,str): print('check.table: The keep must be a str.'); return
        keep=keep.strip()
        if not isinstance(disp,bool): print('check.table: The input disp should be a bool.'); return
        
        '''some preparation work'''
        df=self.pm.go();heads = list(df.columns);ncolumns=len(heads)
        mylist=sorted([each for each in heads if df.dtypes[each]=='object'])
        if len(keep)>0: 
            if keep not in heads: print('check.table: The keep variable dose not exists.'); return
            mylist=[keep]
        if len(mylist)==0: print('check.table: No variable can be checked!'); return
        
        ncov = len(mylist)

        '''a lists of sets for level values'''
        value_sets = [set() for each in range(ncov)]
        
        '''a list of Series for level counts'''
        counts = [pd.Series() for each in range(ncov)]
        
        start_time=time.time()
        for n in range(niter):
            df = self.pm.go()[mylist]
               
            for j in range(ncov):
                '''current subsample data computing'''
                new = list(df[mylist[j]].astype('str'))
                value_sets[j] = value_sets[j] | set(new)
                value_list = sorted(list(value_sets[j]))
                value_counts = [new.count(each) for each in value_list]
                
                '''for current count results into Series'''
                pds = pd.Series(value_counts)
                pds.index = value_list
                
                '''merge the current result with the history'''
                current_index = counts[j].index
                pds[current_index] = pds[current_index]+counts[j][current_index]
                counts[j] = pds

            '''for interactive outputs'''
            if not disp: continue
            end_time=time.time();elapse_time=end_time-start_time  
            percent=100.0*(n+1)/niter
            IPython.display.clear_output(wait=True)
            pd.set_option('display.max_columns',100)
            pd.set_option('display.max_rows',100)
            pd.set_option('display.width',100)
            total_counts = int(np.mean([sum(counts[each]) for each in range(ncov)]))
            print('Time elapsed:',('%.1f'%elapse_time),'seconds.')
            print("Task Completed: ", ('%.1f'%percent), '% for a total of',
                  niter, 'iterations for totally', total_counts, 'counts.')
            print("  ")
            max_str=len(str(ncov))
            max_mylist=np.max([len(each) for each in mylist])
            for j in range(ncov):
                args = np.argsort(-counts[j])
                counts[j] = counts[j][args]
                clevels = list(counts[j].index)
                cvalues = list(counts[j])
                jstr='0'*(max_str-len(str(j)))+str(j)
                myliststr=mylist[j]+' '*(max_mylist-len(mylist[j]))
                print('[', jstr, '] No. of levels detected for *', myliststr,'* is:',len(clevels))
                if tv == True:
                    prob = cvalues/np.sum(cvalues)*100
                    max_output_number = np.min([len(clevels), 100])
                    for k in range(max_output_number):
                        print(clevels[k], '=', ('%.2f'%prob[k]), '%', end='|')
                    if len(clevels) > 100:
                        print('*** Note: only top 100 levels displayed...')
                    print('')
                    print('')
        
        counts=[each/np.sum(each) for each in counts]
        Table=pd.Series([[len(each),list(each.index),list(each)] for each in counts])
        Table.index=mylist
        return Table
        