from .fun import ispump

import IPython,os,time,copy
import pandas as pd
import numpy as np
import seaborn as sns
import warnings; warnings.filterwarnings("ignore")
from matplotlib import pyplot as plt
import matplotlib.cm as cm

class plot(object):

    def demo():
        '''demo is used to demonstrate typical examples about this class.'''
        demostr = '''
import clubear as cb
#clubear.csv is generated by cb.manager.demo()
pm=cb.pump('clubear.csv')
pm.qlist=['height','logsales','price','weight']
pt=cb.plot(pm)
pt.hist('logsales')
pt.size('region')
pt.corr()
pt.mu(y='logsales',x='region')
pt.std(y='logsales',x='gender')
pt.box(y='logsales',x='gender')
pt.gbox(y='logsales',x='price')
'''
        print(demostr)

    def __init__(self, pm):
        '''Initialization: check whether pm is a PUMP!.'''

        '''check whether the input is a pump first'''
        if not ispump(pm): print('check: The input seems not a valid pump.'); return        
        self.pm = pm
        
    def hist(self,x='',niter=10,xrange=[99,-99],disp=True):
        '''hist is used to produce histograms for x'''
        
        '''check initial conditionsl carefully'''
        df=self.pm.go();heads=list(df.columns) 
        if not isinstance(niter,int): print('plot.hist: The niter must be an int.'); return
        if niter<1: print('plot.hist: The niter should be no less than 1.'); return
        if not isinstance(x,str): print('plot.hist: The input x should be str.'); return
        x=x.strip()
        if len(x)==0: print('plot.hist: The input x cannot be empty.'); return
        if x not in heads: print('plot.hist: The input x was not found in pump df.'); return
        if df.dtypes[x]=='object': print('plot.hist: The input x is found to be non-numeric.'); return
        xval=list(df[x]);
        if not isinstance(xrange,list): print('plot.hist: The xrange must be a list.'); return
        if len(xrange)!=2: print('plot.hist: The lenth of xrange must be TWO.'); return
        xmin=xrange[0];xmax=xrange[1]
        if not isinstance(xmin,float)|isinstance(xmin,int): print('plot.hist: The xmin must be numeric.'); return
        if not isinstance(xmax,float)|isinstance(xmax,int): print('plot.hist: The xmax must be numeric.'); return
        if xmin>xmax: xmin=np.nanmin(xval);xmax=np.nanmax(xval);
        if xmax<=xmin: print('plot.hist: An valid (xmin,xmax) range cannot be produced.'); return
        if not isinstance(disp,bool): print('plot.hist: The input disp should be a bool.'); return

        nc=31;
        width=(xmax-xmin)/nc
        freq=np.zeros(nc)
        MyMin=np.zeros(niter)
        MyMax=np.zeros(niter)
        start_time=time.time()
        for n in range(niter):
            xval=self.pm.go()[x]
            
            MyMin[n]=np.nanmin(xval)
            MyMax[n]=np.nanmax(xval)
            xval=list(np.floor((xval-xmin)/width))
            xval=[np.max([0,each]) for each in xval]
            xval=[np.min([nc-1,each]) for each in xval]
            myfreq=[xval.count(each) for each in range(nc)]
            freq=freq+myfreq
            percent=freq/np.sum(freq)

            '''compute the dynamic range'''
            Min=np.nanmin(MyMin[:(n+1)])
            Max=np.nanmax(MyMax[:(n+1)])

            '''output to screen for interactive analysis'''
            if not disp: continue
            end_time=time.time();elapsed_time=end_time-start_time            
            IPython.display.clear_output(wait=True)            
            fig,ax = plt.subplots();fig.set_figwidth(15);fig.set_figheight(7.5)
            
            '''determine the number of decimal digits'''
            num_digits=int(2-np.floor(np.log10(np.abs(xmax-xmin))))
            
            xvalstr=[np.round(each*width+xmin,num_digits) for each in range(nc)]
            mytitle=x+':    '+'(xmin,xmax)=('+'%.3f'%xmin+','+'%.3f'%xmax+')'
            mytitle=mytitle+';    (Min,Max)=('+'%.3f'%Min+','+'%.3f'%Max+')'
            ax.set_title(mytitle)
            
            progress = '%.1f'%((n+1)/niter*100)+'%';
            progress=' '*(6-len(progress))+progress
            titlestr='Task accomplished = ['+progress+']; '
            titlestr=titlestr+'    Time elapsed = ['+('%.1f'%elapsed_time)+'] seconds.'
            ax.set_xlabel(titlestr)
            
            colors = cm.rainbow(np.linspace(0, 1, len(xval)))
            sns.barplot(xvalstr,percent)
            plt.show()    
        return freq
        
    def mu(self,y='',x='',niter=10,disp=True):
        '''mu is used to make bar charts for mu of y according to x'''
        
        '''check initial conditionsl carefully'''
        df=self.pm.go(); heads=list(df.columns) 
        if not isinstance(x,str): print('plot.mu: The input x should be str.'); return
        if not isinstance(y,str): print('plot.mu: The input y should be str.'); return
        x=x.strip();y=y.strip()
        if len(x)==0: print('plot.mu: The input x cannot be empty.'); return
        if len(y)==0: print('plot.mu: The input y cannot be empty.'); return
        if x==y: print('plot.mu: The input x and y should be different.'); return
        if x not in heads: print('plot.mu: The input x was not found in pump df.'); return
        if y not in heads: print('plot.mu: The input y was not found in pump df.'); return
        if df.dtypes[y]=='object': print('plot.mu: The input y is found not numeric.'); return
        if not isinstance(niter,int): print('plot.mu: The niter must be an int.'); return
        if niter<1: print('plot.mu: The niter should be no less than 1.'); return
        xval=df[x];levels=list(set(xval));ngrp=len(levels);dtype=str(df.dtypes[x])
        if ngrp>50: print('plot.mu: Too many levels in x please double check.'); return
        if not isinstance(disp,bool): print('plot.mu: The input disp should be a bool.'); return
        
        start_time=time.time()
        SUM=pd.Series(np.zeros(ngrp),levels)        
        SIZE=pd.Series(np.zeros(ngrp),levels)        
        for n in range(niter):
            df=self.pm.go()[[x,y]] 
            flag=list(np.isnan(df[y]))
            flag=[not each for each in flag]
            df=df.iloc[flag]
            df=df.groupby(x)
            
            mysum=df.sum(); mysum=pd.Series(mysum[y],mysum.index)            
            newindex=sorted(list(set(SUM.index)|set(mysum.index)))
            S1=pd.Series(np.zeros(len(newindex)),newindex)
            S2=pd.Series(np.zeros(len(newindex)),newindex)
            for each in SUM.index: S1[each]=SUM[each]
            for each in mysum.index: S2[each]=mysum[each]
            SUM=S1+S2
           
            mysize=df.size(); #a Series already
            newindex=sorted(list(set(SIZE.index)|set(mysize.index)))
            S1=pd.Series(np.zeros(len(newindex)),newindex)
            S2=pd.Series(np.zeros(len(newindex)),newindex)
            for each in SIZE.index: S1[each]=SIZE[each]
            for each in mysize.index: S2[each]=mysize[each]
            SIZE=S1+S2
            
            MU=SUM/SIZE

            '''ready for dynamic outputs'''
            if not disp: continue
            end_time=time.time();elapsed_time=end_time-start_time            
            IPython.display.clear_output(wait=True)            
            fig,ax = plt.subplots(); fig.set_figwidth(15); fig.set_figheight(7.5)
            
            yval=list(MU);xval=list(range(len(yval)))
            progress = '%.1f'%((n+1)/niter*100)+'%';
            progress=' '*(6-len(progress))+progress
            titlestr='Task accomplished = ['+progress+']; '
            titlestr=titlestr+'    Time elapsed = ['+('%.1f'%elapsed_time)+'] seconds.'
            ax.set_title(titlestr)
            ax.set_xlabel(x+' <'+dtype+'>')
            ax.set_ylabel('mu: '+y)
            sns.barplot(MU.index,yval)
            plt.show() 
            
        return MU

    def std(self,y='',x='',niter=10,disp=True):
        '''std is used to make bar charts for std of y according to x'''
        
        '''check the initial conditons carefully'''
        df=self.pm.go(); heads=list(df.columns) 
        if not isinstance(x,str): print('plot.std: The input x should be str.'); return
        if not isinstance(y,str): print('plot.std: The input y should be str.'); return
        x=x.strip();y=y.strip()
        if len(x)==0: print('plot.std: The input x cannot be empty.'); return
        if len(y)==0: print('plot.std: The input y cannot be empty.'); return
        if x==y: print('plot.std: The input x and y should be different.'); return
        if x not in heads: print('plot.std: The input x was not found in pump df.'); return
        if y not in heads: print('plot.std: The input y was not found in pump df.'); return
        if df.dtypes[y]=='object': print('plot.std: The input y is found not numeric.'); return
        if not isinstance(niter,int): print('plot.std: The niter must be an int.'); return
        if niter<1: print('plot.std: The niter should be no less than 1.'); return
        xval=df[x];levels=list(set(xval));ngrp=len(levels);dtype=str(df.dtypes[x])
        if ngrp>50: print('plot.std: Too many levels in x please double check.'); return
        if not isinstance(disp,bool): print('plot.std: The input disp should be a bool.'); return
        
        start_time=time.time()
        SUM=pd.Series(np.zeros(ngrp),levels)        
        SUM2=pd.Series(np.zeros(ngrp),levels)        
        SIZE=pd.Series(np.zeros(ngrp),levels)       
        for n in range(niter):
            df=self.pm.go()[[x,y]];            
            df2=copy.deepcopy(df);df2[y]=df2[y]**2
            flag=list(np.isnan(df[y]*df2[y]))
            flag=[not each for each in flag]
            df=df.iloc[flag];df2=df2.iloc[flag]
            df=df.groupby(x);df2=df2.groupby(x)
            
            mysum=df.sum(); mysum=pd.Series(mysum[y],mysum.index)            
            newindex=sorted(list(set(SUM.index)|set(mysum.index)))
            S1=pd.Series(np.zeros(len(newindex)),newindex)
            S2=pd.Series(np.zeros(len(newindex)),newindex)
            for each in SUM.index: S1[each]=SUM[each]
            for each in mysum.index: S2[each]=mysum[each]
            SUM=S1+S2
           
            mysum=df2.sum(); mysum=pd.Series(mysum[y],mysum.index)            
            newindex=sorted(list(set(SUM.index)|set(mysum.index)))
            S1=pd.Series(np.zeros(len(newindex)),newindex)
            S2=pd.Series(np.zeros(len(newindex)),newindex)
            for each in SUM2.index: S1[each]=SUM2[each]
            for each in mysum.index: S2[each]=mysum[each]
            SUM2=S1+S2
            
            mysize=df.size(); #a Series already
            newindex=sorted(list(set(SIZE.index)|set(mysize.index)))
            S1=pd.Series(np.zeros(len(newindex)),newindex)
            S2=pd.Series(np.zeros(len(newindex)),newindex)
            for each in SIZE.index: S1[each]=SIZE[each]
            for each in mysize.index: S2[each]=mysize[each]
            SIZE=S1+S2
            
            MU=SUM/SIZE; MU2=SUM2/SIZE; SD=np.sqrt(MU2-MU**2)

            '''ready for dynamic outputs'''
            if not disp: continue
            end_time=time.time();elapsed_time=end_time-start_time            
            IPython.display.clear_output(wait=True)            
            fig,ax = plt.subplots(); fig.set_figwidth(15); fig.set_figheight(7.5)
            
            yval=list(SD);xval=list(range(len(yval)))
            progress = '%.1f'%((n+1)/niter*100)+'%';
            progress=' '*(6-len(progress))+progress
            titlestr='Task accomplished = ['+progress+']; '
            titlestr=titlestr+'    Time elapsed = ['+('%.1f'%elapsed_time)+'] seconds.'
            ax.set_title(titlestr)
            ax.set_xlabel(x+' <'+dtype+'>')
            ax.set_ylabel('sd: '+y)
            sns.barplot(SD.index,yval)
            plt.show() 
            
        return SD

    def size(self,x='',niter=10,disp=True):
        '''size is used to make bar charts for size of different x classes.'''
        
        '''check the initial conditons carefully'''
        df=self.pm.go();heads=list(df.columns)
        if not isinstance(x,str): print('plot.size: The input x should be str.'); return
        x=x.strip();
        if len(x)==0: print('plot.size: The input x cannot be empty.'); return
        if x not in heads: print('plot.size: The input x was not found in pump df.'); return
        if not isinstance(niter,int): print('plot.size: The niter must be an int.'); return
        if niter<1: print('plot.size: The niter should be no less than 1.'); return
        xval=list(df[x]);
        if not isinstance(disp,bool): print('plot.size: The input disp should be a bool.'); return
        
        '''if xval us numeric then eliminate nans'''
        isnumeric=False
        if df.dtypes[x]!='object': 
            isnumeric=True
            xval=[each for each in xval if not np.isnan(each)]
            df[x]=df[x].astype('float')
            
        levels=sorted(list(set(xval)));ngrp=len(levels);dtype=str(df.dtypes[x])
        if ngrp>50: print('plot.size: Too many levels in x please double check.'); return
        if ngrp==0: print('plot.size: Change x to be qualitative might help.'); return
                
        start_time=time.time()
        SIZE=pd.Series(np.zeros(ngrp),levels)        
        for n in range(niter):
            df=self.pm.go()[[x]];            
            if isnumeric: df=df.astype('float')
            df=df.groupby(x);
            
            mysize=df.size(); #a Series already
            newindex=sorted(list(set(SIZE.index)|set(mysize.index)))
            S1=pd.Series(np.zeros(len(newindex)),newindex)
            S2=pd.Series(np.zeros(len(newindex)),newindex)
            for each in SIZE.index: S1[each]=SIZE[each]
            for each in mysize.index: S2[each]=mysize[each]
            SIZE=S1+S2
            percent=SIZE/np.sum(SIZE)

            '''for dynamic outputs'''
            if not disp: continue
            end_time=time.time();elapsed_time=end_time-start_time            
            IPython.display.clear_output(wait=True)            
            fig,ax = plt.subplots()
            fig.set_figwidth(15)
            fig.set_figheight(7.5)
            
            yval=list(percent);xval=list(range(len(yval)))
                        
            progress = '%.1f'%((n+1)/niter*100)+'%';
            progress=' '*(6-len(progress))+progress
            titlestr='Task accomplished = ['+progress+']; '
            titlestr=titlestr+'    Time elapsed = ['+('%.1f'%elapsed_time)+'] seconds.'
            ax.set_title(titlestr)
            ax.set_xlabel(x+' <'+dtype+'>')
            ax.set_ylabel('Relative Size')
            sns.barplot(SIZE.index,yval)
            plt.show() 
            
        return percent
            
    def corr(self,keep=[],niter=10,disp=True):
        '''corr is used to plot corr matrix by heatmap.'''
        
        '''check the initial conditons carefully'''
        if not isinstance(niter,int): print('plot.corr: The niter must be an int.'); return
        if niter<1: print('plot.corr: The niter must be no less than one.'); return
        if not isinstance(keep,list): print('plot.corr: The keep list must be a list.'); return
        keep=[each.strip() for each in keep]
        if not isinstance(disp,bool): print('plot.corr: The input disp should be a bool.'); return
        
        '''check whether we have something to stats'''
        df=self.pm.go(); heads = list(df.columns);ncolumns=len(heads)
        mylist=[each for each in heads if df.dtypes[each]!='object']
        if len(keep)>0: mylist=[each for each in mylist if each in keep]
        if len(mylist)<2: print('plot.corr: At least two variables are needed!'); return
        
        '''main part for computing statistics'''
        ncov = len(mylist)
        corr_total=np.zeros([ncov,ncov])
        start_time=time.time()
        for n in range(niter):
            '''get data and make it float'''
            df = np.array(self.pm.go()[mylist])  
            MyN=df.shape[0] 
            
            '''standardize the data'''
            df = df-np.nanmean(df, axis=0)
            SD = np.sqrt(np.nanmean(df**2,axis=0))+1.0e-12
            df = df/SD
            
            '''this part cannot be replaced by convenient functions'''
            '''due to the existence of NaNs. Be very careful pls.'''
            mycorr=np.zeros([ncov,ncov])
            for j1 in range(ncov):
                for j2 in range(ncov):
                    mycorr[j1,j2]=np.nanmean(df[:,j1]*df[:,j2])
            corr_total=corr_total+mycorr
            MyCorr=corr_total/(n+1)*100
            MyCorr=pd.DataFrame(MyCorr);MyCorr.columns=mylist;MyCorr.index=mylist
                        
            '''for dynamic outputs'''
            if not disp: continue            
            end_time=time.time();elapsed_time=end_time-start_time            
            IPython.display.clear_output(wait=True)   
            fig,ax = plt.subplots()
            fig.set_figwidth(15)
            fig.set_figheight(7.5)
                        
            progress = '%.1f'%((n+1)/niter*100)+'%';
            progress=' '*(6-len(progress))+progress
            titlestr='Task accomplished = ['+progress+']; '
            titlestr=titlestr+'    Time elapsed = ['+('%.1f'%elapsed_time)+'] seconds.'
            ax.set_title(titlestr)
            sns.heatmap(MyCorr,cmap='RdBu_r',center=True)
            plt.show()
            
        return MyCorr

    def box(self,y='',x='',niter=10,disp=True):
        '''box is used to make boxplots for y according to x'''
        
        '''check the initial conditons carefully'''
        df=self.pm.go();heads=list(df.columns) 
        if not isinstance(x,str): print('plot.box: The input x should be str.'); return
        if not isinstance(y,str): print('plot.box: The input y should be str.'); return
        x=x.strip();y=y.strip()
        if len(x)==0: print('plot.box: The input x cannot be empty.'); return
        if len(y)==0: print('plot.box: The input y cannot be empty.'); return
        if x==y: print('plot.box: The input x and y should be different.'); return
        if x not in heads: print('plot.box: The input x was not found in pump df.'); return
        if y not in heads: print('plot.box: The input y was not found in pump df.'); return
        if df.dtypes[y]=='object': print('plot.box: The input y is found not numeric.'); return
        if not isinstance(niter,int): print('plot.box: The niter must be an int.'); return
        if niter<1: print('plot.box: The niter should be no less than 1.'); return
        xval=df[x];levels=list(set(xval));ngrp=len(levels);dtype=str(df.dtypes[x])
        if ngrp>50: print('plot.box: Too many levels in x please double check.'); return
        if not isinstance(disp,bool): print('plot.box: The input disp should be a bool.'); return
        
        start_time=time.time()
        Med=pd.Series(np.zeros(ngrp),levels)        
        Q1=pd.Series(np.zeros(ngrp),levels)        
        Q3=pd.Series(np.zeros(ngrp),levels)
        outlier_counts=0
        for n in range(niter):
            df=self.pm.go()[[x,y]];  
            flag=list(np.isnan(df[y]))
            flag=[not each for each in flag]
            df=df.iloc[flag]
            df2=copy.deepcopy(df)
            
            '''group by x'''
            df=df.groupby(x)
            
            grpstat=df.median();grpstat=pd.Series(grpstat[y],grpstat.index)
            newindex=sorted(list(set(Med.index)|set(grpstat.index)))
            S1=pd.Series(np.zeros(len(newindex)),newindex)
            S2=pd.Series(np.zeros(len(newindex)),newindex)
            for each in Med.index: S1[each]=Med[each]
            for each in grpstat.index: S2[each]=grpstat[each]
            Med=S1+S2
            
            grpstat=df.quantile(0.25);grpstat=pd.Series(grpstat[y],grpstat.index)
            newindex=sorted(list(set(Med.index)|set(grpstat.index)))
            S1=pd.Series(np.zeros(len(newindex)),newindex)
            S2=pd.Series(np.zeros(len(newindex)),newindex)
            for each in Q1.index:S1[each]=Q1[each]
            for each in grpstat.index: S2[each]=grpstat[each]
            Q1=S1+S2
            
            grpstat=df.quantile(0.75);grpstat=pd.Series(grpstat[y],grpstat.index)
            newindex=sorted(list(set(Med.index)|set(grpstat.index)))
            S1=pd.Series(np.zeros(len(newindex)),newindex)
            S2=pd.Series(np.zeros(len(newindex)),newindex)
            for each in Q3.index: S1[each]=Q3[each]
            for each in grpstat.index: S2[each]=grpstat[each]
            Q3=S1+S2
            
            MyQ1=Q1/(n+1);MyQ3=Q3/(n+1);MyMed=Med/(n+1)
            MyMin=MyQ1-1.5*(MyQ3-MyQ1);MyMax=MyQ3+1.5*(MyQ3-MyQ1)
            
            outlier_counts=outlier_counts+np.mean(df2[y]>np.max(MyMax))
            outlier_counts=outlier_counts+np.mean(df2[y]<np.min(MyMin))
            outlier_percent=np.round(outlier_counts/(n+1)*100,2)
            
            df=pd.DataFrame(list(zip(MyMin,MyQ1,MyMed,MyQ3,MyMax))).T
            df.columns=Med.index
            
            '''ready for dynamic outputs'''
            if not disp: continue
            end_time=time.time();elapsed_time=end_time-start_time            
            IPython.display.clear_output(wait=True)            
            fig,ax = plt.subplots(); fig.set_figwidth(15); fig.set_figheight(7.5)
            
            progress = '%.1f'%((n+1)/niter*100)+'%';
            progress=' '*(6-len(progress))+progress
            opercent='%.1f'%outlier_percent+'%';
            opercent=' '*(6-len(opercent))+opercent
            titlestr='Task accomplished = ['+progress+']; '
            titlestr=titlestr+'    Time elapsed = ['+('%.1f'%elapsed_time)+'] seconds;'
            titlestr=titlestr+'    Outlier percentage = ['+opercent+'].'
            ax.set_title(titlestr)
            ax.set_xlabel(x+' <'+dtype+'>')
            ax.set_ylabel(y)
            sns.boxplot(data=df,palette="Set2")                        
            plt.show() 
            
        return df

    def gbox(self,y='',x='',niter=10,ngrp=5,disp=True):
        '''gbox is used to make boxplots for y according to x groups'''
        
        '''check the initial conditons carefully'''
        df=self.pm.go();heads=list(df.columns) 
        if not isinstance(x,str): print('plot.gbox: The input x should be str.'); return
        if not isinstance(y,str): print('plot.gbox: The input y should be str.'); return
        x=x.strip();y=y.strip()
        if len(x)==0: print('plot.gbox: The input x cannot be empty.'); return
        if len(y)==0: print('plot.gbox: The input y cannot be empty.'); return
        if x not in heads: print('plot.gbox: The input x was not found in pump df.'); return
        if y not in heads: print('plot.gbox: The input y was not found in pump df.'); return
        if x==y: print('plot.gbox: The input x and y should be different.'); return
        if df.dtypes[x]=='object': print('plot.gbox: The input x is found not numeric.'); return
        if df.dtypes[y]=='object': print('plot.gbox: The input y is found not numeric.'); return
        if not isinstance(niter,int): print('plot.gbox: The niter must be an int.'); return
        if not isinstance(ngrp,int): print('plot.gbox: The ngrp must be an int.'); return
        if niter<1: print('plot.gbox: The niter should be no less than 1.'); return
        if ngrp<2: print('plot.gbox: The ngrp should be no less than 2.'); return
        xval=df[x];xmin=np.nanmin(xval);xmax=np.nanmax(xval);width=xmax-xmin;dtype=str(df.dtypes[x])
        if np.isnan(xmin*xmax): print('plot.gbox: Too many np.nan found in data.'); return
        if width<=0: print('plot.gbox: The range of x seems to be too small.'); return
        if not isinstance(disp,bool): print('plot.gbox: The input disp should be a bool.'); return
        
        quantiles=list(range(1,ngrp))
        quantiles=[each/ngrp for each in quantiles]
        quantiles=[np.nanquantile(xval,each) for each in quantiles]
        
        start_time=time.time()
        levels=list(range(ngrp))
        Med=pd.Series(np.zeros(ngrp),levels)        
        Q1=pd.Series(np.zeros(ngrp),levels)        
        Q3=pd.Series(np.zeros(ngrp),levels)
        outlier_counts=0
        for n in range(niter):
            df=self.pm.go()[[x,y]];   
            flag=list(np.isnan(df[y]))
            flag=[not each for each in flag]
            df=df.iloc[flag]
            df2=copy.deepcopy(df)
            
            ss=df.shape[0]
            xgrp=np.zeros(ss)
            for j in range(len(quantiles)): xgrp=xgrp+1*(df[x]>quantiles[j])
            df[x]=xgrp
            
            '''group by x'''
            df=df.groupby(x)
            
            grpstat=df.median();grpstat=pd.Series(grpstat[y],grpstat.index)
            newindex=sorted(list(set(Med.index)|set(grpstat.index)))
            S1=pd.Series(np.zeros(len(newindex)),newindex)
            S2=pd.Series(np.zeros(len(newindex)),newindex)
            for each in Med.index: S1[each]=Med[each]
            for each in grpstat.index: S2[each]=grpstat[each]
            Med=S1+S2
            
            grpstat=df.quantile(0.25);grpstat=pd.Series(grpstat[y],grpstat.index)
            newindex=sorted(list(set(Med.index)|set(grpstat.index)))
            S1=pd.Series(np.zeros(len(newindex)),newindex)
            S2=pd.Series(np.zeros(len(newindex)),newindex)
            for each in Q1.index:S1[each]=Q1[each]
            for each in grpstat.index: S2[each]=grpstat[each]
            Q1=S1+S2
            
            grpstat=df.quantile(0.75);grpstat=pd.Series(grpstat[y],grpstat.index)
            newindex=sorted(list(set(Med.index)|set(grpstat.index)))
            S1=pd.Series(np.zeros(len(newindex)),newindex)
            S2=pd.Series(np.zeros(len(newindex)),newindex)
            for each in Q3.index: S1[each]=Q3[each]
            for each in grpstat.index: S2[each]=grpstat[each]
            Q3=S1+S2
            
            MyQ1=Q1/(n+1);MyQ3=Q3/(n+1);MyMed=Med/(n+1)
            MyMin=MyQ1-1.5*(MyQ3-MyQ1);MyMax=MyQ3+1.5*(MyQ3-MyQ1)
            
            outlier_counts=outlier_counts+np.mean(df2[y]>np.max(MyMax))
            outlier_counts=outlier_counts+np.mean(df2[y]<np.min(MyMin))
            outlier_percent=np.round(outlier_counts/(n+1)*100,2)
            
            df=pd.DataFrame(list(zip(MyMin,MyQ1,MyMed,MyQ3,MyMax))).T
            grpname=['Group '+str(each) for each in list(Med.index)]
            df.columns=grpname
            
            '''ready for dynamic outputs'''
            if not disp: continue
            end_time=time.time();elapsed_time=end_time-start_time            
            IPython.display.clear_output(wait=True)            
            fig,ax = plt.subplots(); fig.set_figwidth(15); fig.set_figheight(7.5)            
            progress = '%.1f'%((n+1)/niter*100)+'%';
            progress=' '*(6-len(progress))+progress
            opercent='%.1f'%outlier_percent+'%';
            opercent=' '*(6-len(opercent))+opercent
            titlestr='Task accomplished = ['+progress+']; '
            titlestr=titlestr+'    Time elapsed = ['+('%.1f'%elapsed_time)+'] seconds;'
            titlestr=titlestr+'    Outlier percentage = ['+opercent+'].'
            ax.set_title(titlestr)
            ax.set_xlabel('Discretized group by: '+x+' <'+dtype+'>')
            ax.set_ylabel(y)
            sns.boxplot(data=df,palette="Set2")                        
            plt.show() 
            
        return df
      