from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkRenderingCore

VTKKW_FPMM_SHIFT:int
VTKKW_FP_MASK:float
VTKKW_FP_SCALE:float
VTKKW_FP_SHIFT:int
VTK_BUNYKRCF_ARRAY_SIZE:int
VTK_BUNYKRCF_MAX_ARRAYS:int
VTK_CROP_CROSS:int
VTK_CROP_FENCE:int
VTK_CROP_INVERTED_CROSS:float
VTK_CROP_INVERTED_FENCE:int
VTK_CROP_SUBVOLUME:int
VTK_MAX_SHADING_TABLES:int

class vtkVolumeMapper(vtkmodules.vtkRenderingCore.vtkAbstractVolumeMapper):
    class BlendModes(int): ...
    ADDITIVE_BLEND:'BlendModes'
    AVERAGE_INTENSITY_BLEND:'BlendModes'
    COMPOSITE_BLEND:'BlendModes'
    ISOSURFACE_BLEND:'BlendModes'
    MAXIMUM_INTENSITY_BLEND:'BlendModes'
    MINIMUM_INTENSITY_BLEND:'BlendModes'
    SLICE_BLEND:'BlendModes'
    average_ip_scalar_range:'getset_descriptor'
    blend_mode:'getset_descriptor'
    compute_normal_from_opacity:'getset_descriptor'
    cropping:'getset_descriptor'
    cropping_region_flags:'getset_descriptor'
    cropping_region_planes:'getset_descriptor'
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    voxel_cropping_region_planes:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeNormalFromOpacityOff(self) -> None: ...
    def ComputeNormalFromOpacityOn(self) -> None: ...
    def CroppingOff(self) -> None: ...
    def CroppingOn(self) -> None: ...
    def GetAverageIPScalarRange(self) -> Tuple[float, float]: ...
    def GetBlendMode(self) -> int: ...
    def GetComputeNormalFromOpacity(self) -> bool: ...
    def GetCropping(self) -> int: ...
    def GetCroppingMaxValue(self) -> int: ...
    def GetCroppingMinValue(self) -> int: ...
    def GetCroppingRegionFlags(self) -> int: ...
    def GetCroppingRegionFlagsMaxValue(self) -> int: ...
    def GetCroppingRegionFlagsMinValue(self) -> int: ...
    def GetCroppingRegionPlanes(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetInput(self) -> 'vtkDataSet': ...
    @overload
    def GetInput(self, port:int) -> 'vtkDataSet': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetVoxelCroppingRegionPlanes(self) -> Tuple[float, float, float, float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVolumeMapper': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self, ren:'vtkRenderer', vol:'vtkVolume') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVolumeMapper': ...
    @overload
    def SetAverageIPScalarRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetAverageIPScalarRange(self, _arg:Sequence[float]) -> None: ...
    def SetBlendMode(self, _arg:int) -> None: ...
    def SetBlendModeToAdditive(self) -> None: ...
    def SetBlendModeToAverageIntensity(self) -> None: ...
    def SetBlendModeToComposite(self) -> None: ...
    def SetBlendModeToIsoSurface(self) -> None: ...
    def SetBlendModeToMaximumIntensity(self) -> None: ...
    def SetBlendModeToMinimumIntensity(self) -> None: ...
    def SetBlendModeToSlice(self) -> None: ...
    def SetComputeNormalFromOpacity(self, _arg:bool) -> None: ...
    def SetCropping(self, _arg:int) -> None: ...
    def SetCroppingRegionFlags(self, _arg:int) -> None: ...
    def SetCroppingRegionFlagsToCross(self) -> None: ...
    def SetCroppingRegionFlagsToFence(self) -> None: ...
    def SetCroppingRegionFlagsToInvertedCross(self) -> None: ...
    def SetCroppingRegionFlagsToInvertedFence(self) -> None: ...
    def SetCroppingRegionFlagsToSubVolume(self) -> None: ...
    @overload
    def SetCroppingRegionPlanes(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetCroppingRegionPlanes(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetInputData(self, __a:'vtkImageData') -> None: ...
    @overload
    def SetInputData(self, __a:'vtkDataSet') -> None: ...
    @overload
    def SetInputData(self, __a:'vtkRectilinearGrid') -> None: ...

class vtkAnariVolumeInterface(vtkVolumeMapper):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAnariVolumeInterface': ...
    def Render(self, __a:'vtkRenderer', __b:'vtkVolume') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAnariVolumeInterface': ...

class vtkDirectionEncoder(vtkmodules.vtkCommonCore.vtkObject):
    decoded_gradient_table:'getset_descriptor'
    number_of_encoded_directions:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetDecodedGradient(self, value:int) -> Tuple[float, float, float]: ...
    def GetDecodedGradientTable(self) -> Pointer: ...
    def GetEncodedDirection(self, n:MutableSequence[float]) -> int: ...
    def GetNumberOfEncodedDirections(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDirectionEncoder': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDirectionEncoder': ...

class vtkEncodedGradientEstimator(vtkmodules.vtkCommonCore.vtkObject):
    bounds:'getset_descriptor'
    bounds_clip:'getset_descriptor'
    circle_limits:'getset_descriptor'
    compute_gradient_magnitudes:'getset_descriptor'
    cylinder_clip:'getset_descriptor'
    direction_encoder:'getset_descriptor'
    encoded_normals:'getset_descriptor'
    gradient_magnitude_bias:'getset_descriptor'
    gradient_magnitude_scale:'getset_descriptor'
    gradient_magnitudes:'getset_descriptor'
    input_aspect:'getset_descriptor'
    input_data:'getset_descriptor'
    input_size:'getset_descriptor'
    last_update_time_in_cpu_seconds:'getset_descriptor'
    last_update_time_in_seconds:'getset_descriptor'
    number_of_threads:'getset_descriptor'
    number_of_threads_max_value:'getset_descriptor'
    number_of_threads_min_value:'getset_descriptor'
    use_cylinder_clip:'getset_descriptor'
    zero_normal_threshold:'getset_descriptor'
    zero_pad:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BoundsClipOff(self) -> None: ...
    def BoundsClipOn(self) -> None: ...
    def ComputeGradientMagnitudesOff(self) -> None: ...
    def ComputeGradientMagnitudesOn(self) -> None: ...
    def CylinderClipOff(self) -> None: ...
    def CylinderClipOn(self) -> None: ...
    def GetBounds(self) -> Tuple[int, int, int, int, int, int]: ...
    def GetBoundsClip(self) -> int: ...
    def GetBoundsClipMaxValue(self) -> int: ...
    def GetBoundsClipMinValue(self) -> int: ...
    def GetCircleLimits(self) -> Pointer: ...
    def GetComputeGradientMagnitudes(self) -> int: ...
    def GetCylinderClip(self) -> int: ...
    def GetDirectionEncoder(self) -> 'vtkDirectionEncoder': ...
    @overload
    def GetEncodedNormalIndex(self, xyzIndex:int) -> int: ...
    @overload
    def GetEncodedNormalIndex(self, xIndex:int, yIndex:int, zIndex:int) -> int: ...
    def GetEncodedNormals(self) -> Pointer: ...
    def GetGradientMagnitudeBias(self) -> float: ...
    def GetGradientMagnitudeScale(self) -> float: ...
    def GetGradientMagnitudes(self) -> Pointer: ...
    def GetInputAspect(self) -> Tuple[float, float, float]: ...
    def GetInputData(self) -> 'vtkImageData': ...
    def GetInputSize(self) -> Tuple[int, int, int]: ...
    def GetLastUpdateTimeInCPUSeconds(self) -> float: ...
    def GetLastUpdateTimeInSeconds(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfThreads(self) -> int: ...
    def GetNumberOfThreadsMaxValue(self) -> int: ...
    def GetNumberOfThreadsMinValue(self) -> int: ...
    def GetUseCylinderClip(self) -> int: ...
    def GetZeroNormalThreshold(self) -> float: ...
    def GetZeroPad(self) -> int: ...
    def GetZeroPadMaxValue(self) -> int: ...
    def GetZeroPadMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkEncodedGradientEstimator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEncodedGradientEstimator': ...
    @overload
    def SetBounds(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetBounds(self, _arg:Sequence[int]) -> None: ...
    def SetBoundsClip(self, _arg:int) -> None: ...
    def SetComputeGradientMagnitudes(self, _arg:int) -> None: ...
    def SetCylinderClip(self, _arg:int) -> None: ...
    def SetDirectionEncoder(self, direnc:'vtkDirectionEncoder') -> None: ...
    def SetGradientMagnitudeBias(self, _arg:float) -> None: ...
    def SetGradientMagnitudeScale(self, _arg:float) -> None: ...
    def SetInputData(self, __a:'vtkImageData') -> None: ...
    def SetNumberOfThreads(self, _arg:int) -> None: ...
    def SetZeroNormalThreshold(self, v:float) -> None: ...
    def SetZeroPad(self, _arg:int) -> None: ...
    def Update(self) -> None: ...
    def ZeroPadOff(self) -> None: ...
    def ZeroPadOn(self) -> None: ...

class vtkEncodedGradientShader(vtkmodules.vtkCommonCore.vtkObject):
    active_component:'getset_descriptor'
    zero_normal_diffuse_intensity:'getset_descriptor'
    zero_normal_specular_intensity:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetActiveComponent(self) -> int: ...
    def GetActiveComponentMaxValue(self) -> int: ...
    def GetActiveComponentMinValue(self) -> int: ...
    def GetBlueDiffuseShadingTable(self, vol:'vtkVolume') -> Pointer: ...
    def GetBlueSpecularShadingTable(self, vol:'vtkVolume') -> Pointer: ...
    def GetGreenDiffuseShadingTable(self, vol:'vtkVolume') -> Pointer: ...
    def GetGreenSpecularShadingTable(self, vol:'vtkVolume') -> Pointer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRedDiffuseShadingTable(self, vol:'vtkVolume') -> Pointer: ...
    def GetRedSpecularShadingTable(self, vol:'vtkVolume') -> Pointer: ...
    def GetZeroNormalDiffuseIntensity(self) -> float: ...
    def GetZeroNormalDiffuseIntensityMaxValue(self) -> float: ...
    def GetZeroNormalDiffuseIntensityMinValue(self) -> float: ...
    def GetZeroNormalSpecularIntensity(self) -> float: ...
    def GetZeroNormalSpecularIntensityMaxValue(self) -> float: ...
    def GetZeroNormalSpecularIntensityMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkEncodedGradientShader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEncodedGradientShader': ...
    def SetActiveComponent(self, _arg:int) -> None: ...
    def SetZeroNormalDiffuseIntensity(self, _arg:float) -> None: ...
    def SetZeroNormalSpecularIntensity(self, _arg:float) -> None: ...
    def UpdateShadingTable(self, ren:'vtkRenderer', vol:'vtkVolume', gradest:'vtkEncodedGradientEstimator') -> None: ...

class vtkFiniteDifferenceGradientEstimator(vtkEncodedGradientEstimator):
    sample_spacing_in_voxels:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSampleSpacingInVoxels(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFiniteDifferenceGradientEstimator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFiniteDifferenceGradientEstimator': ...
    def SetSampleSpacingInVoxels(self, _arg:int) -> None: ...

class vtkFixedPointRayCastImage(vtkmodules.vtkCommonCore.vtkObject):
    image:'getset_descriptor'
    image_in_use_size:'getset_descriptor'
    image_memory_size:'getset_descriptor'
    image_origin:'getset_descriptor'
    image_sample_distance:'getset_descriptor'
    image_viewport_size:'getset_descriptor'
    use_z_buffer:'getset_descriptor'
    z_buffer:'getset_descriptor'
    z_buffer_origin:'getset_descriptor'
    z_buffer_size:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AllocateImage(self) -> None: ...
    def AllocateZBuffer(self) -> None: ...
    def ClearImage(self) -> None: ...
    def GetImage(self) -> Pointer: ...
    def GetImageInUseSize(self) -> Tuple[int, int]: ...
    def GetImageMemorySize(self) -> Tuple[int, int]: ...
    def GetImageOrigin(self) -> Tuple[int, int]: ...
    def GetImageSampleDistance(self) -> float: ...
    def GetImageViewportSize(self) -> Tuple[int, int]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUseZBuffer(self) -> int: ...
    def GetUseZBufferMaxValue(self) -> int: ...
    def GetUseZBufferMinValue(self) -> int: ...
    def GetZBuffer(self) -> Pointer: ...
    def GetZBufferOrigin(self) -> Tuple[int, int]: ...
    def GetZBufferSize(self) -> Tuple[int, int]: ...
    def GetZBufferValue(self, x:int, y:int) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFixedPointRayCastImage': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFixedPointRayCastImage': ...
    @overload
    def SetImageInUseSize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetImageInUseSize(self, _arg:Sequence[int]) -> None: ...
    @overload
    def SetImageMemorySize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetImageMemorySize(self, _arg:Sequence[int]) -> None: ...
    @overload
    def SetImageOrigin(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetImageOrigin(self, _arg:Sequence[int]) -> None: ...
    def SetImageSampleDistance(self, _arg:float) -> None: ...
    @overload
    def SetImageViewportSize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetImageViewportSize(self, _arg:Sequence[int]) -> None: ...
    def SetUseZBuffer(self, _arg:int) -> None: ...
    @overload
    def SetZBufferOrigin(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetZBufferOrigin(self, _arg:Sequence[int]) -> None: ...
    @overload
    def SetZBufferSize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetZBufferSize(self, _arg:Sequence[int]) -> None: ...
    def UseZBufferOff(self) -> None: ...
    def UseZBufferOn(self) -> None: ...

class vtkFixedPointVolumeRayCastHelper(vtkmodules.vtkCommonCore.vtkObject):
    def __init__(self, **properties:Any) -> None: ...
    def GenerateImage(self, __a:int, __b:int, __c:'vtkVolume', __d:'vtkFixedPointVolumeRayCastMapper') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFixedPointVolumeRayCastHelper': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFixedPointVolumeRayCastHelper': ...

class vtkFixedPointVolumeRayCastCompositeGOHelper(vtkFixedPointVolumeRayCastHelper):
    def __init__(self, **properties:Any) -> None: ...
    def GenerateImage(self, threadID:int, threadCount:int, vol:'vtkVolume', mapper:'vtkFixedPointVolumeRayCastMapper') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFixedPointVolumeRayCastCompositeGOHelper': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFixedPointVolumeRayCastCompositeGOHelper': ...

class vtkFixedPointVolumeRayCastCompositeGOShadeHelper(vtkFixedPointVolumeRayCastHelper):
    def __init__(self, **properties:Any) -> None: ...
    def GenerateImage(self, threadID:int, threadCount:int, vol:'vtkVolume', mapper:'vtkFixedPointVolumeRayCastMapper') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFixedPointVolumeRayCastCompositeGOShadeHelper': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFixedPointVolumeRayCastCompositeGOShadeHelper': ...

class vtkFixedPointVolumeRayCastCompositeHelper(vtkFixedPointVolumeRayCastHelper):
    def __init__(self, **properties:Any) -> None: ...
    def GenerateImage(self, threadID:int, threadCount:int, vol:'vtkVolume', mapper:'vtkFixedPointVolumeRayCastMapper') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFixedPointVolumeRayCastCompositeHelper': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFixedPointVolumeRayCastCompositeHelper': ...

class vtkFixedPointVolumeRayCastCompositeShadeHelper(vtkFixedPointVolumeRayCastHelper):
    def __init__(self, **properties:Any) -> None: ...
    def GenerateImage(self, threadID:int, threadCount:int, vol:'vtkVolume', mapper:'vtkFixedPointVolumeRayCastMapper') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFixedPointVolumeRayCastCompositeShadeHelper': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFixedPointVolumeRayCastCompositeShadeHelper': ...

class vtkFixedPointVolumeRayCastMIPHelper(vtkFixedPointVolumeRayCastHelper):
    def __init__(self, **properties:Any) -> None: ...
    def GenerateImage(self, threadID:int, threadCount:int, vol:'vtkVolume', mapper:'vtkFixedPointVolumeRayCastMapper') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFixedPointVolumeRayCastMIPHelper': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFixedPointVolumeRayCastMIPHelper': ...

class vtkFixedPointVolumeRayCastMapper(vtkVolumeMapper):
    auto_adjust_sample_distances:'getset_descriptor'
    composite_go_helper:'getset_descriptor'
    composite_go_shade_helper:'getset_descriptor'
    composite_helper:'getset_descriptor'
    composite_shade_helper:'getset_descriptor'
    current_scalars:'getset_descriptor'
    final_color_level:'getset_descriptor'
    final_color_window:'getset_descriptor'
    flip_mip_comparison:'getset_descriptor'
    gradient_opacity_required:'getset_descriptor'
    image_sample_distance:'getset_descriptor'
    interactive_sample_distance:'getset_descriptor'
    intermix_intersecting_geometry:'getset_descriptor'
    lock_sample_distance_to_input_spacing:'getset_descriptor'
    maximum_image_sample_distance:'getset_descriptor'
    minimum_image_sample_distance:'getset_descriptor'
    mip_helper:'getset_descriptor'
    number_of_threads:'getset_descriptor'
    previous_scalars:'getset_descriptor'
    ray_cast_image:'getset_descriptor'
    render_window:'getset_descriptor'
    row_bounds:'getset_descriptor'
    sample_distance:'getset_descriptor'
    shading_required:'getset_descriptor'
    table_scale:'getset_descriptor'
    table_shift:'getset_descriptor'
    volume:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AbortRender(self) -> None: ...
    def AutoAdjustSampleDistancesOff(self) -> None: ...
    def AutoAdjustSampleDistancesOn(self) -> None: ...
    def CheckIfCropped(self, pos:MutableSequence[int]) -> int: ...
    def CheckMIPMinMaxVolumeFlag(self, pos:MutableSequence[int], c:int, maxIdx:int, flip:int) -> int: ...
    def CheckMinMaxVolumeFlag(self, pos:MutableSequence[int], c:int) -> int: ...
    def ComputeRayInfo(self, x:int, y:int, pos:MutableSequence[int], dir:MutableSequence[int], numSteps:MutableSequence[int]) -> None: ...
    @overload
    def ComputeRequiredImageSampleDistance(self, desiredTime:float, ren:'vtkRenderer') -> float: ...
    @overload
    def ComputeRequiredImageSampleDistance(self, desiredTime:float, ren:'vtkRenderer', vol:'vtkVolume') -> float: ...
    def CreateCanonicalView(self, volume:'vtkVolume', image:'vtkImageData', blend_mode:int, viewDirection:MutableSequence[float], viewUp:MutableSequence[float]) -> None: ...
    def DisplayRenderedImage(self, __a:'vtkRenderer', __b:'vtkVolume') -> None: ...
    def FixedPointIncrement(self, position:MutableSequence[int], increment:MutableSequence[int]) -> None: ...
    def GetAutoAdjustSampleDistances(self) -> int: ...
    def GetAutoAdjustSampleDistancesMaxValue(self) -> int: ...
    def GetAutoAdjustSampleDistancesMinValue(self) -> int: ...
    def GetColorTable(self, c:int) -> Pointer: ...
    def GetCompositeGOHelper(self) -> 'vtkFixedPointVolumeRayCastCompositeGOHelper': ...
    def GetCompositeGOShadeHelper(self) -> 'vtkFixedPointVolumeRayCastCompositeGOShadeHelper': ...
    def GetCompositeHelper(self) -> 'vtkFixedPointVolumeRayCastCompositeHelper': ...
    def GetCompositeShadeHelper(self) -> 'vtkFixedPointVolumeRayCastCompositeShadeHelper': ...
    def GetCurrentScalars(self) -> 'vtkDataArray': ...
    def GetDiffuseShadingTable(self, c:int) -> Pointer: ...
    @overload
    def GetEstimatedRenderTime(self, ren:'vtkRenderer', vol:'vtkVolume') -> float: ...
    @overload
    def GetEstimatedRenderTime(self, ren:'vtkRenderer') -> float: ...
    def GetFinalColorLevel(self) -> float: ...
    def GetFinalColorWindow(self) -> float: ...
    def GetFlipMIPComparison(self) -> int: ...
    def GetFloatTripleFromPointer(self, v:MutableSequence[float], ptr:MutableSequence[float]) -> None: ...
    def GetGradientOpacityRequired(self) -> int: ...
    def GetGradientOpacityTable(self, c:int) -> Pointer: ...
    def GetImageSampleDistance(self) -> float: ...
    def GetImageSampleDistanceMaxValue(self) -> float: ...
    def GetImageSampleDistanceMinValue(self) -> float: ...
    def GetInteractiveSampleDistance(self) -> float: ...
    def GetIntermixIntersectingGeometry(self) -> int: ...
    def GetIntermixIntersectingGeometryMaxValue(self) -> int: ...
    def GetIntermixIntersectingGeometryMinValue(self) -> int: ...
    def GetLockSampleDistanceToInputSpacing(self) -> int: ...
    def GetLockSampleDistanceToInputSpacingMaxValue(self) -> int: ...
    def GetLockSampleDistanceToInputSpacingMinValue(self) -> int: ...
    def GetMIPHelper(self) -> 'vtkFixedPointVolumeRayCastMIPHelper': ...
    def GetMaximumImageSampleDistance(self) -> float: ...
    def GetMaximumImageSampleDistanceMaxValue(self) -> float: ...
    def GetMaximumImageSampleDistanceMinValue(self) -> float: ...
    def GetMinimumImageSampleDistance(self) -> float: ...
    def GetMinimumImageSampleDistanceMaxValue(self) -> float: ...
    def GetMinimumImageSampleDistanceMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfThreads(self) -> int: ...
    def GetPreviousScalars(self) -> 'vtkDataArray': ...
    def GetRayCastImage(self) -> 'vtkFixedPointRayCastImage': ...
    def GetRenderWindow(self) -> 'vtkRenderWindow': ...
    def GetRowBounds(self) -> Pointer: ...
    def GetSampleDistance(self) -> float: ...
    def GetScalarOpacityTable(self, c:int) -> Pointer: ...
    def GetShadingRequired(self) -> int: ...
    def GetSpecularShadingTable(self, c:int) -> Pointer: ...
    def GetTableScale(self) -> Tuple[float, float, float, float]: ...
    def GetTableShift(self) -> Tuple[float, float, float, float]: ...
    def GetUIntTripleFromPointer(self, v:MutableSequence[int], ptr:MutableSequence[int]) -> None: ...
    def GetVolume(self) -> 'vtkVolume': ...
    def InitializeRayInfo(self, vol:'vtkVolume') -> None: ...
    def IntermixIntersectingGeometryOff(self) -> None: ...
    def IntermixIntersectingGeometryOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LockSampleDistanceToInputSpacingOff(self) -> None: ...
    def LockSampleDistanceToInputSpacingOn(self) -> None: ...
    def LookupColorUC(self, colorTable:MutableSequence[int], scalarOpacityTable:MutableSequence[int], index:int, color:MutableSequence[int]) -> None: ...
    def LookupDependentColorUC(self, colorTable:MutableSequence[int], scalarOpacityTable:MutableSequence[int], index:MutableSequence[int], components:int, color:MutableSequence[int]) -> None: ...
    def NewInstance(self) -> 'vtkFixedPointVolumeRayCastMapper': ...
    def PerImageInitialization(self, __a:'vtkRenderer', __b:'vtkVolume', __c:int, __d:MutableSequence[float], __e:MutableSequence[float], __f:MutableSequence[int]) -> int: ...
    def PerSubVolumeInitialization(self, __a:'vtkRenderer', __b:'vtkVolume', __c:int) -> None: ...
    def PerVolumeInitialization(self, __a:'vtkRenderer', __b:'vtkVolume') -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self, __a:'vtkRenderer', __b:'vtkVolume') -> None: ...
    def RenderSubVolume(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFixedPointVolumeRayCastMapper': ...
    def SetAutoAdjustSampleDistances(self, _arg:int) -> None: ...
    def SetFinalColorLevel(self, _arg:float) -> None: ...
    def SetFinalColorWindow(self, _arg:float) -> None: ...
    def SetImageSampleDistance(self, _arg:float) -> None: ...
    def SetInteractiveSampleDistance(self, _arg:float) -> None: ...
    def SetIntermixIntersectingGeometry(self, _arg:int) -> None: ...
    def SetLockSampleDistanceToInputSpacing(self, _arg:int) -> None: ...
    def SetMaximumImageSampleDistance(self, _arg:float) -> None: ...
    def SetMinimumImageSampleDistance(self, _arg:float) -> None: ...
    def SetNumberOfThreads(self, num:int) -> None: ...
    def SetRayCastImage(self, __a:'vtkFixedPointRayCastImage') -> None: ...
    def SetSampleDistance(self, _arg:float) -> None: ...
    def ShiftVectorDown(self, in_:MutableSequence[int], out:MutableSequence[int]) -> None: ...
    def ShouldUseNearestNeighborInterpolation(self, vol:'vtkVolume') -> int: ...
    @overload
    def ToFixedPointDirection(self, dir:float) -> int: ...
    @overload
    def ToFixedPointDirection(self, in_:MutableSequence[float], out:MutableSequence[int]) -> None: ...
    @overload
    def ToFixedPointPosition(self, val:float) -> int: ...
    @overload
    def ToFixedPointPosition(self, in_:MutableSequence[float], out:MutableSequence[int]) -> None: ...

class vtkGPUVolumeRayCastMapper(vtkVolumeMapper):
    class TFRangeType(int): ...
    BinaryMaskType:int
    LabelMapMaskType:int
    NATIVE:'TFRangeType'
    SCALAR:'TFRangeType'
    auto_adjust_sample_distances:'getset_descriptor'
    clamp_depth_to_backface:'getset_descriptor'
    color_range_type:'getset_descriptor'
    depth_image_scalar_type:'getset_descriptor'
    depth_pass_contour_values:'getset_descriptor'
    final_color_level:'getset_descriptor'
    final_color_window:'getset_descriptor'
    global_illumination_reach:'getset_descriptor'
    gradient_opacity_range_type:'getset_descriptor'
    image_sample_distance:'getset_descriptor'
    input:'getset_descriptor'
    input_connection:'getset_descriptor'
    input_count:'getset_descriptor'
    lock_sample_distance_to_input_spacing:'getset_descriptor'
    mask_blend_factor:'getset_descriptor'
    mask_input:'getset_descriptor'
    mask_type:'getset_descriptor'
    max_memory_fraction:'getset_descriptor'
    max_memory_in_bytes:'getset_descriptor'
    maximum_image_sample_distance:'getset_descriptor'
    minimum_image_sample_distance:'getset_descriptor'
    render_to_image:'getset_descriptor'
    report_progress:'getset_descriptor'
    sample_distance:'getset_descriptor'
    scalar_opacity_range_type:'getset_descriptor'
    transfer2dy_axis_array:'getset_descriptor'
    use_depth_pass:'getset_descriptor'
    use_jittering:'getset_descriptor'
    volumetric_scattering_blending:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AutoAdjustSampleDistancesOff(self) -> None: ...
    def AutoAdjustSampleDistancesOn(self) -> None: ...
    def ClampDepthToBackfaceOff(self) -> None: ...
    def ClampDepthToBackfaceOn(self) -> None: ...
    def CreateCanonicalView(self, ren:'vtkRenderer', volume:'vtkVolume', image:'vtkImageData', blend_mode:int, viewDirection:MutableSequence[float], viewUp:MutableSequence[float]) -> None: ...
    def GPURender(self, __a:'vtkRenderer', __b:'vtkVolume') -> None: ...
    def GetAutoAdjustSampleDistances(self) -> int: ...
    def GetAutoAdjustSampleDistancesMaxValue(self) -> int: ...
    def GetAutoAdjustSampleDistancesMinValue(self) -> int: ...
    def GetBoundsFromPort(self, port:int) -> Tuple[float, float, float, float, float, float]: ...
    def GetClampDepthToBackface(self) -> int: ...
    def GetColorImage(self, __a:'vtkImageData') -> None: ...
    def GetColorRangeType(self) -> int: ...
    def GetDepthImage(self, __a:'vtkImageData') -> None: ...
    def GetDepthImageScalarType(self) -> int: ...
    def GetDepthPassContourValues(self) -> 'vtkContourValues': ...
    def GetFinalColorLevel(self) -> float: ...
    def GetFinalColorWindow(self) -> float: ...
    def GetGlobalIlluminationReach(self) -> float: ...
    def GetGlobalIlluminationReachMaxValue(self) -> float: ...
    def GetGlobalIlluminationReachMinValue(self) -> float: ...
    def GetGradientOpacityRangeType(self) -> int: ...
    def GetImageSampleDistance(self) -> float: ...
    def GetImageSampleDistanceMaxValue(self) -> float: ...
    def GetImageSampleDistanceMinValue(self) -> float: ...
    def GetInput(self) -> 'vtkDataSet': ...
    def GetInputCount(self) -> int: ...
    def GetLockSampleDistanceToInputSpacing(self) -> int: ...
    def GetLockSampleDistanceToInputSpacingMaxValue(self) -> int: ...
    def GetLockSampleDistanceToInputSpacingMinValue(self) -> int: ...
    def GetMaskBlendFactor(self) -> float: ...
    def GetMaskBlendFactorMaxValue(self) -> float: ...
    def GetMaskBlendFactorMinValue(self) -> float: ...
    def GetMaskInput(self) -> 'vtkImageData': ...
    def GetMaskType(self) -> int: ...
    def GetMaxMemoryFraction(self) -> float: ...
    def GetMaxMemoryFractionMaxValue(self) -> float: ...
    def GetMaxMemoryFractionMinValue(self) -> float: ...
    def GetMaxMemoryInBytes(self) -> int: ...
    def GetMaximumImageSampleDistance(self) -> float: ...
    def GetMaximumImageSampleDistanceMaxValue(self) -> float: ...
    def GetMaximumImageSampleDistanceMinValue(self) -> float: ...
    def GetMinimumImageSampleDistance(self) -> float: ...
    def GetMinimumImageSampleDistanceMaxValue(self) -> float: ...
    def GetMinimumImageSampleDistanceMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetReductionRatio(self, ratio:MutableSequence[float]) -> None: ...
    def GetRenderToImage(self) -> int: ...
    def GetReportProgress(self) -> bool: ...
    def GetSampleDistance(self) -> float: ...
    def GetScalarOpacityRangeType(self) -> int: ...
    def GetTransfer2DYAxisArray(self) -> str: ...
    def GetTransformedInput(self, port:int=0) -> 'vtkDataSet': ...
    def GetUseDepthPass(self) -> int: ...
    def GetUseDepthPassMaxValue(self) -> int: ...
    def GetUseDepthPassMinValue(self) -> int: ...
    def GetUseJittering(self) -> int: ...
    def GetUseJitteringMaxValue(self) -> int: ...
    def GetUseJitteringMinValue(self) -> int: ...
    def GetVolumetricScatteringBlending(self) -> float: ...
    def GetVolumetricScatteringBlendingMaxValue(self) -> float: ...
    def GetVolumetricScatteringBlendingMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    def IsRenderSupported(self, window:'vtkRenderWindow', property:'vtkVolumeProperty') -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LockSampleDistanceToInputSpacingOff(self) -> None: ...
    def LockSampleDistanceToInputSpacingOn(self) -> None: ...
    def NewInstance(self) -> 'vtkGPUVolumeRayCastMapper': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    @overload
    def RemoveInputConnection(self, port:int, input:'vtkAlgorithmOutput') -> None: ...
    @overload
    def RemoveInputConnection(self, port:int, idx:int) -> None: ...
    def Render(self, __a:'vtkRenderer', __b:'vtkVolume') -> None: ...
    def RenderToImageOff(self) -> None: ...
    def RenderToImageOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGPUVolumeRayCastMapper': ...
    def SetAutoAdjustSampleDistances(self, _arg:int) -> None: ...
    def SetClampDepthToBackface(self, _arg:int) -> None: ...
    def SetColorRangeType(self, _arg:int) -> None: ...
    def SetDepthImageScalarType(self, _arg:int) -> None: ...
    def SetDepthImageScalarTypeToFloat(self) -> None: ...
    def SetDepthImageScalarTypeToUnsignedChar(self) -> None: ...
    def SetDepthImageScalarTypeToUnsignedShort(self) -> None: ...
    def SetFinalColorLevel(self, _arg:float) -> None: ...
    def SetFinalColorWindow(self, _arg:float) -> None: ...
    def SetGlobalIlluminationReach(self, _arg:float) -> None: ...
    def SetGradientOpacityRangeType(self, _arg:int) -> None: ...
    def SetImageSampleDistance(self, _arg:float) -> None: ...
    @overload
    def SetInputConnection(self, port:int, input:'vtkAlgorithmOutput') -> None: ...
    @overload
    def SetInputConnection(self, input:'vtkAlgorithmOutput') -> None: ...
    def SetLockSampleDistanceToInputSpacing(self, _arg:int) -> None: ...
    def SetMaskBlendFactor(self, _arg:float) -> None: ...
    def SetMaskInput(self, mask:'vtkImageData') -> None: ...
    def SetMaskType(self, _arg:int) -> None: ...
    def SetMaskTypeToBinary(self) -> None: ...
    def SetMaskTypeToLabelMap(self) -> None: ...
    def SetMaxMemoryFraction(self, _arg:float) -> None: ...
    def SetMaxMemoryInBytes(self, _arg:int) -> None: ...
    def SetMaximumImageSampleDistance(self, _arg:float) -> None: ...
    def SetMinimumImageSampleDistance(self, _arg:float) -> None: ...
    def SetRenderToImage(self, _arg:int) -> None: ...
    def SetReportProgress(self, _arg:bool) -> None: ...
    def SetSampleDistance(self, _arg:float) -> None: ...
    def SetScalarOpacityRangeType(self, _arg:int) -> None: ...
    def SetTransfer2DYAxisArray(self, _arg:str) -> None: ...
    def SetUseDepthPass(self, _arg:int) -> None: ...
    def SetUseJittering(self, _arg:int) -> None: ...
    def SetVolumetricScatteringBlending(self, _arg:float) -> None: ...
    def UseDepthPassOff(self) -> None: ...
    def UseDepthPassOn(self) -> None: ...
    def UseJitteringOff(self) -> None: ...
    def UseJitteringOn(self) -> None: ...

class vtkMultiVolume(vtkmodules.vtkRenderingCore.vtkVolume):
    bounds:'getset_descriptor'
    bounds_time:'getset_descriptor'
    data_bounds:'getset_descriptor'
    data_geometry:'getset_descriptor'
    m_time:'getset_descriptor'
    matrix:'getset_descriptor'
    property:'getset_descriptor'
    texture_matrix:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetBoundsTime(self) -> int: ...
    def GetDataBounds(self) -> Pointer: ...
    def GetDataGeometry(self) -> Pointer: ...
    def GetMTime(self) -> int: ...
    @overload
    def GetMatrix(self) -> 'vtkMatrix4x4': ...
    @overload
    def GetMatrix(self, result:'vtkMatrix4x4') -> None: ...
    @overload
    def GetMatrix(self, result:MutableSequence[float]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProperty(self) -> 'vtkVolumeProperty': ...
    def GetTextureMatrix(self) -> 'vtkMatrix4x4': ...
    def GetVolume(self, port:int=0) -> 'vtkVolume': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMultiVolume': ...
    def RemoveVolume(self, port:int) -> None: ...
    def RenderVolumetricGeometry(self, vp:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMultiVolume': ...
    def SetProperty(self, property:'vtkVolumeProperty') -> None: ...
    def SetVolume(self, volume:'vtkVolume', port:int=0) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...

class vtkOSPRayVolumeInterface(vtkVolumeMapper):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOSPRayVolumeInterface': ...
    def Render(self, __a:'vtkRenderer', __b:'vtkVolume') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOSPRayVolumeInterface': ...

class vtkUnstructuredGridVolumeMapper(vtkmodules.vtkRenderingCore.vtkAbstractVolumeMapper):
    COMPOSITE_BLEND:int
    MAXIMUM_INTENSITY_BLEND:int
    blend_mode:'getset_descriptor'
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetBlendMode(self) -> int: ...
    def GetInput(self) -> 'vtkUnstructuredGridBase': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnstructuredGridVolumeMapper': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self, ren:'vtkRenderer', vol:'vtkVolume') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnstructuredGridVolumeMapper': ...
    def SetBlendMode(self, _arg:int) -> None: ...
    def SetBlendModeToComposite(self) -> None: ...
    def SetBlendModeToMaximumIntensity(self) -> None: ...
    @overload
    def SetInputData(self, __a:'vtkUnstructuredGridBase') -> None: ...
    @overload
    def SetInputData(self, __a:'vtkDataSet') -> None: ...

class vtkProjectedTetrahedraMapper(vtkUnstructuredGridVolumeMapper):
    visibility_sort:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetVisibilitySort(self) -> 'vtkVisibilitySort': ...
    def IsA(self, type:str) -> int: ...
    def IsSupported(self, __a:'vtkRenderWindow') -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def MapScalarsToColors(colors:'vtkDataArray', property:'vtkVolumeProperty', scalars:'vtkDataArray') -> None: ...
    def NewInstance(self) -> 'vtkProjectedTetrahedraMapper': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProjectedTetrahedraMapper': ...
    def SetVisibilitySort(self, sort:'vtkVisibilitySort') -> None: ...
    @staticmethod
    def TransformPoints(inPoints:'vtkPoints', projection_mat:Sequence[float], modelview_mat:Sequence[float], outPoints:'vtkFloatArray') -> None: ...

class vtkRayCastImageDisplayHelper(vtkmodules.vtkCommonCore.vtkObject):
    pixel_scale:'getset_descriptor'
    pre_multiplied_colors:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPixelScale(self) -> float: ...
    def GetPreMultipliedColors(self) -> int: ...
    def GetPreMultipliedColorsMaxValue(self) -> int: ...
    def GetPreMultipliedColorsMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRayCastImageDisplayHelper': ...
    def PreMultipliedColorsOff(self) -> None: ...
    def PreMultipliedColorsOn(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    @overload
    def RenderTexture(self, vol:'vtkVolume', ren:'vtkRenderer', imageMemorySize:MutableSequence[int], imageViewportSize:MutableSequence[int], imageInUseSize:MutableSequence[int], imageOrigin:MutableSequence[int], requestedDepth:float, image:MutableSequence[int]) -> None: ...
    @overload
    def RenderTexture(self, vol:'vtkVolume', ren:'vtkRenderer', image:'vtkFixedPointRayCastImage', requestedDepth:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRayCastImageDisplayHelper': ...
    def SetPixelScale(self, _arg:float) -> None: ...
    def SetPreMultipliedColors(self, _arg:int) -> None: ...

class vtkRecursiveSphereDirectionEncoder(vtkDirectionEncoder):
    decoded_gradient_table:'getset_descriptor'
    number_of_encoded_directions:'getset_descriptor'
    recursion_depth:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetDecodedGradient(self, value:int) -> Tuple[float, float, float]: ...
    def GetDecodedGradientTable(self) -> Pointer: ...
    def GetEncodedDirection(self, n:MutableSequence[float]) -> int: ...
    def GetNumberOfEncodedDirections(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRecursionDepth(self) -> int: ...
    def GetRecursionDepthMaxValue(self) -> int: ...
    def GetRecursionDepthMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRecursiveSphereDirectionEncoder': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRecursiveSphereDirectionEncoder': ...
    def SetRecursionDepth(self, _arg:int) -> None: ...

class vtkSphericalDirectionEncoder(vtkDirectionEncoder):
    decoded_gradient_table:'getset_descriptor'
    number_of_encoded_directions:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetDecodedGradient(self, value:int) -> Tuple[float, float, float]: ...
    def GetDecodedGradientTable(self) -> Pointer: ...
    def GetEncodedDirection(self, n:MutableSequence[float]) -> int: ...
    def GetNumberOfEncodedDirections(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSphericalDirectionEncoder': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSphericalDirectionEncoder': ...

class vtkUnstructuredGridVolumeRayCastFunction(vtkmodules.vtkCommonCore.vtkObject):
    def __init__(self, **properties:Any) -> None: ...
    def Finalize(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self, ren:'vtkRenderer', vol:'vtkVolume') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnstructuredGridVolumeRayCastFunction': ...
    def NewIterator(self) -> 'vtkUnstructuredGridVolumeRayCastIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnstructuredGridVolumeRayCastFunction': ...

class vtkUnstructuredGridBunykRayCastFunction(vtkUnstructuredGridVolumeRayCastFunction):
    image_origin:'getset_descriptor'
    image_viewport_size:'getset_descriptor'
    points:'getset_descriptor'
    view_to_world_matrix:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Finalize(self) -> None: ...
    def GetImageOrigin(self) -> Tuple[int, int]: ...
    def GetImageViewportSize(self) -> Tuple[int, int]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPoints(self) -> Pointer: ...
    def GetViewToWorldMatrix(self) -> 'vtkMatrix4x4': ...
    def Initialize(self, ren:'vtkRenderer', vol:'vtkVolume') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnstructuredGridBunykRayCastFunction': ...
    def NewIterator(self) -> 'vtkUnstructuredGridVolumeRayCastIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnstructuredGridBunykRayCastFunction': ...

class vtkUnstructuredGridVolumeRayIntegrator(vtkmodules.vtkCommonCore.vtkObject):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self, volume:'vtkVolume', scalars:'vtkDataArray') -> None: ...
    def Integrate(self, intersectionLengths:'vtkDoubleArray', nearIntersections:'vtkDataArray', farIntersections:'vtkDataArray', color:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnstructuredGridVolumeRayIntegrator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnstructuredGridVolumeRayIntegrator': ...

class vtkUnstructuredGridHomogeneousRayIntegrator(vtkUnstructuredGridVolumeRayIntegrator):
    transfer_function_table_size:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTransferFunctionTableSize(self) -> int: ...
    def Initialize(self, volume:'vtkVolume', scalars:'vtkDataArray') -> None: ...
    def Integrate(self, intersectionLengths:'vtkDoubleArray', nearIntersections:'vtkDataArray', farIntersections:'vtkDataArray', color:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnstructuredGridHomogeneousRayIntegrator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnstructuredGridHomogeneousRayIntegrator': ...
    def SetTransferFunctionTableSize(self, _arg:int) -> None: ...

class vtkUnstructuredGridLinearRayIntegrator(vtkUnstructuredGridVolumeRayIntegrator):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self, volume:'vtkVolume', scalars:'vtkDataArray') -> None: ...
    def Integrate(self, intersectionLengths:'vtkDoubleArray', nearIntersections:'vtkDataArray', farIntersections:'vtkDataArray', color:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def IntegrateRay(length:float, intensity_front:float, attenuation_front:float, intensity_back:float, attenuation_back:float, color:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def IntegrateRay(length:float, color_front:Sequence[float], attenuation_front:float, color_back:Sequence[float], attenuation_back:float, color:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnstructuredGridLinearRayIntegrator': ...
    @staticmethod
    def Psi(length:float, attenuation_front:float, attenuation_back:float) -> float: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnstructuredGridLinearRayIntegrator': ...

class vtkUnstructuredGridPartialPreIntegration(vtkUnstructuredGridVolumeRayIntegrator):
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def BuildPsiTable() -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def GetPsiTable(size:int) -> Pointer: ...
    def Initialize(self, volume:'vtkVolume', scalars:'vtkDataArray') -> None: ...
    def Integrate(self, intersectionLengths:'vtkDoubleArray', nearIntersections:'vtkDataArray', farIntersections:'vtkDataArray', color:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def IntegrateRay(length:float, intensity_front:float, attenuation_front:float, intensity_back:float, attenuation_back:float, color:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def IntegrateRay(length:float, color_front:Sequence[float], attenuation_front:float, color_back:Sequence[float], attenuation_back:float, color:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnstructuredGridPartialPreIntegration': ...
    @staticmethod
    def Psi(taufD:float, taubD:float) -> float: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnstructuredGridPartialPreIntegration': ...

class vtkUnstructuredGridPreIntegration(vtkUnstructuredGridVolumeRayIntegrator):
    incremental_pre_integration:'getset_descriptor'
    integration_table_length_resolution:'getset_descriptor'
    integration_table_length_scale:'getset_descriptor'
    integration_table_scalar_resolution:'getset_descriptor'
    integrator:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetIncrementalPreIntegration(self) -> int: ...
    def GetIndexedTableEntry(self, scalar_front_index:int, scalar_back_index:int, length_index:int, component:int=0) -> Pointer: ...
    def GetIntegrationTableLengthResolution(self) -> int: ...
    def GetIntegrationTableLengthScale(self) -> float: ...
    def GetIntegrationTableScalarResolution(self) -> int: ...
    def GetIntegrationTableScalarScale(self, component:int=0) -> float: ...
    def GetIntegrationTableScalarShift(self, component:int=0) -> float: ...
    def GetIntegrator(self) -> 'vtkUnstructuredGridVolumeRayIntegrator': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPreIntegrationTable(self, component:int=0) -> Pointer: ...
    def GetTableEntry(self, scalar_front:float, scalar_back:float, length:float, component:int=0) -> Pointer: ...
    def IncrementalPreIntegrationOff(self) -> None: ...
    def IncrementalPreIntegrationOn(self) -> None: ...
    def Initialize(self, volume:'vtkVolume', scalars:'vtkDataArray') -> None: ...
    def Integrate(self, intersectionLengths:'vtkDoubleArray', nearIntersections:'vtkDataArray', farIntersections:'vtkDataArray', color:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnstructuredGridPreIntegration': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnstructuredGridPreIntegration': ...
    def SetIncrementalPreIntegration(self, _arg:int) -> None: ...
    def SetIntegrationTableLengthResolution(self, _arg:int) -> None: ...
    def SetIntegrationTableScalarResolution(self, _arg:int) -> None: ...
    def SetIntegrator(self, __a:'vtkUnstructuredGridVolumeRayIntegrator') -> None: ...

class vtkUnstructuredGridVolumeRayCastIterator(vtkmodules.vtkCommonCore.vtkObject):
    bounds:'getset_descriptor'
    max_number_of_intersections:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetBounds(self) -> Tuple[float, float]: ...
    def GetMaxNumberOfIntersections(self) -> int: ...
    def GetNextIntersections(self, intersectedCells:'vtkIdList', intersectionLengths:'vtkDoubleArray', scalars:'vtkDataArray', nearIntersections:'vtkDataArray', farIntersections:'vtkDataArray') -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self, x:int, y:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnstructuredGridVolumeRayCastIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnstructuredGridVolumeRayCastIterator': ...
    @overload
    def SetBounds(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetBounds(self, _arg:Sequence[float]) -> None: ...
    def SetMaxNumberOfIntersections(self, _arg:int) -> None: ...

class vtkUnstructuredGridVolumeRayCastMapper(vtkUnstructuredGridVolumeMapper):
    auto_adjust_sample_distances:'getset_descriptor'
    image_in_use_size:'getset_descriptor'
    image_origin:'getset_descriptor'
    image_sample_distance:'getset_descriptor'
    image_viewport_size:'getset_descriptor'
    intermix_intersecting_geometry:'getset_descriptor'
    maximum_image_sample_distance:'getset_descriptor'
    minimum_image_sample_distance:'getset_descriptor'
    number_of_threads:'getset_descriptor'
    ray_cast_function:'getset_descriptor'
    ray_integrator:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AutoAdjustSampleDistancesOff(self) -> None: ...
    def AutoAdjustSampleDistancesOn(self) -> None: ...
    def CastRays(self, threadID:int, threadCount:int) -> None: ...
    def GetAutoAdjustSampleDistances(self) -> int: ...
    def GetAutoAdjustSampleDistancesMaxValue(self) -> int: ...
    def GetAutoAdjustSampleDistancesMinValue(self) -> int: ...
    def GetImageInUseSize(self) -> Tuple[int, int]: ...
    def GetImageOrigin(self) -> Tuple[int, int]: ...
    def GetImageSampleDistance(self) -> float: ...
    def GetImageSampleDistanceMaxValue(self) -> float: ...
    def GetImageSampleDistanceMinValue(self) -> float: ...
    def GetImageViewportSize(self) -> Tuple[int, int]: ...
    def GetIntermixIntersectingGeometry(self) -> int: ...
    def GetIntermixIntersectingGeometryMaxValue(self) -> int: ...
    def GetIntermixIntersectingGeometryMinValue(self) -> int: ...
    def GetMaximumImageSampleDistance(self) -> float: ...
    def GetMaximumImageSampleDistanceMaxValue(self) -> float: ...
    def GetMaximumImageSampleDistanceMinValue(self) -> float: ...
    def GetMinimumImageSampleDistance(self) -> float: ...
    def GetMinimumImageSampleDistanceMaxValue(self) -> float: ...
    def GetMinimumImageSampleDistanceMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfThreads(self) -> int: ...
    def GetRayCastFunction(self) -> 'vtkUnstructuredGridVolumeRayCastFunction': ...
    def GetRayIntegrator(self) -> 'vtkUnstructuredGridVolumeRayIntegrator': ...
    def IntermixIntersectingGeometryOff(self) -> None: ...
    def IntermixIntersectingGeometryOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnstructuredGridVolumeRayCastMapper': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self, __a:'vtkRenderer', __b:'vtkVolume') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnstructuredGridVolumeRayCastMapper': ...
    def SetAutoAdjustSampleDistances(self, _arg:int) -> None: ...
    def SetImageSampleDistance(self, _arg:float) -> None: ...
    def SetIntermixIntersectingGeometry(self, _arg:int) -> None: ...
    def SetMaximumImageSampleDistance(self, _arg:float) -> None: ...
    def SetMinimumImageSampleDistance(self, _arg:float) -> None: ...
    def SetNumberOfThreads(self, _arg:int) -> None: ...
    def SetRayCastFunction(self, f:'vtkUnstructuredGridVolumeRayCastFunction') -> None: ...
    def SetRayIntegrator(self, ri:'vtkUnstructuredGridVolumeRayIntegrator') -> None: ...

class vtkUnstructuredGridVolumeZSweepMapper(vtkUnstructuredGridVolumeMapper):
    auto_adjust_sample_distances:'getset_descriptor'
    image_in_use_size:'getset_descriptor'
    image_origin:'getset_descriptor'
    image_sample_distance:'getset_descriptor'
    image_viewport_size:'getset_descriptor'
    intermix_intersecting_geometry:'getset_descriptor'
    max_pixel_list_size:'getset_descriptor'
    maximum_image_sample_distance:'getset_descriptor'
    minimum_image_sample_distance:'getset_descriptor'
    ray_integrator:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AutoAdjustSampleDistancesOff(self) -> None: ...
    def AutoAdjustSampleDistancesOn(self) -> None: ...
    def GetAutoAdjustSampleDistances(self) -> int: ...
    def GetAutoAdjustSampleDistancesMaxValue(self) -> int: ...
    def GetAutoAdjustSampleDistancesMinValue(self) -> int: ...
    def GetImageInUseSize(self) -> Tuple[int, int]: ...
    def GetImageOrigin(self) -> Tuple[int, int]: ...
    def GetImageSampleDistance(self) -> float: ...
    def GetImageSampleDistanceMaxValue(self) -> float: ...
    def GetImageSampleDistanceMinValue(self) -> float: ...
    def GetImageViewportSize(self) -> Tuple[int, int]: ...
    def GetIntermixIntersectingGeometry(self) -> int: ...
    def GetIntermixIntersectingGeometryMaxValue(self) -> int: ...
    def GetIntermixIntersectingGeometryMinValue(self) -> int: ...
    def GetMaxPixelListSize(self) -> int: ...
    def GetMaximumImageSampleDistance(self) -> float: ...
    def GetMaximumImageSampleDistanceMaxValue(self) -> float: ...
    def GetMaximumImageSampleDistanceMinValue(self) -> float: ...
    def GetMinimumImageSampleDistance(self) -> float: ...
    def GetMinimumImageSampleDistanceMaxValue(self) -> float: ...
    def GetMinimumImageSampleDistanceMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRayIntegrator(self) -> 'vtkUnstructuredGridVolumeRayIntegrator': ...
    def IntermixIntersectingGeometryOff(self) -> None: ...
    def IntermixIntersectingGeometryOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnstructuredGridVolumeZSweepMapper': ...
    def Render(self, ren:'vtkRenderer', vol:'vtkVolume') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnstructuredGridVolumeZSweepMapper': ...
    def SetAutoAdjustSampleDistances(self, _arg:int) -> None: ...
    def SetImageSampleDistance(self, _arg:float) -> None: ...
    def SetIntermixIntersectingGeometry(self, _arg:int) -> None: ...
    def SetMaxPixelListSize(self, size:int) -> None: ...
    def SetMaximumImageSampleDistance(self, _arg:float) -> None: ...
    def SetMinimumImageSampleDistance(self, _arg:float) -> None: ...
    def SetRayIntegrator(self, ri:'vtkUnstructuredGridVolumeRayIntegrator') -> None: ...

class vtkVolumeOutlineSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    active_plane_color:'getset_descriptor'
    active_plane_id:'getset_descriptor'
    color:'getset_descriptor'
    generate_faces:'getset_descriptor'
    generate_outline:'getset_descriptor'
    generate_scalars:'getset_descriptor'
    volume_mapper:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GenerateFacesOff(self) -> None: ...
    def GenerateFacesOn(self) -> None: ...
    def GenerateOutlineOff(self) -> None: ...
    def GenerateOutlineOn(self) -> None: ...
    def GenerateScalarsOff(self) -> None: ...
    def GenerateScalarsOn(self) -> None: ...
    def GetActivePlaneColor(self) -> Tuple[float, float, float]: ...
    def GetActivePlaneId(self) -> int: ...
    def GetColor(self) -> Tuple[float, float, float]: ...
    def GetGenerateFaces(self) -> int: ...
    def GetGenerateOutline(self) -> int: ...
    def GetGenerateScalars(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetVolumeMapper(self) -> 'vtkVolumeMapper': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVolumeOutlineSource': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVolumeOutlineSource': ...
    @overload
    def SetActivePlaneColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetActivePlaneColor(self, _arg:Sequence[float]) -> None: ...
    def SetActivePlaneId(self, _arg:int) -> None: ...
    @overload
    def SetColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetColor(self, _arg:Sequence[float]) -> None: ...
    def SetGenerateFaces(self, _arg:int) -> None: ...
    def SetGenerateOutline(self, _arg:int) -> None: ...
    def SetGenerateScalars(self, _arg:int) -> None: ...
    def SetVolumeMapper(self, mapper:'vtkVolumeMapper') -> None: ...

class vtkVolumePicker(vtkmodules.vtkRenderingCore.vtkCellPicker):
    cropping_plane_id:'getset_descriptor'
    pick_cropping_planes:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCroppingPlaneId(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPickCroppingPlanes(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVolumePicker': ...
    def PickCroppingPlanesOff(self) -> None: ...
    def PickCroppingPlanesOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVolumePicker': ...
    def SetPickCroppingPlanes(self, _arg:int) -> None: ...

class vtkVolumeRayCastSpaceLeapingImageFilter(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    cache:'getset_descriptor'
    compute_gradient_opacity:'getset_descriptor'
    compute_min_max:'getset_descriptor'
    current_scalars:'getset_descriptor'
    independent_components:'getset_descriptor'
    last_min_max_build_time:'getset_descriptor'
    last_min_max_flag_time:'getset_descriptor'
    min_non_zero_gradient_magnitude_index:'getset_descriptor'
    min_non_zero_scalar_index:'getset_descriptor'
    number_of_independent_components:'getset_descriptor'
    table_scale:'getset_descriptor'
    table_shift:'getset_descriptor'
    table_size:'getset_descriptor'
    update_gradient_opacity_flags:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeGradientOpacityOff(self) -> None: ...
    def ComputeGradientOpacityOn(self) -> None: ...
    @staticmethod
    def ComputeInputExtentsForOutput(inExt:MutableSequence[int], inDim:MutableSequence[int], outExt:MutableSequence[int], inData:'vtkImageData') -> None: ...
    def ComputeMinMaxOff(self) -> None: ...
    def ComputeMinMaxOn(self) -> None: ...
    def ComputeOffset(self, ext:Sequence[int], wholeExt:Sequence[int], nComponents:int) -> int: ...
    def GetComputeGradientOpacity(self) -> int: ...
    def GetComputeMinMax(self) -> int: ...
    def GetCurrentScalars(self) -> 'vtkDataArray': ...
    def GetIndependentComponents(self) -> int: ...
    def GetLastMinMaxBuildTime(self) -> int: ...
    def GetLastMinMaxFlagTime(self) -> int: ...
    def GetMinMaxVolume(self, dims:MutableSequence[int]) -> Pointer: ...
    def GetMinNonZeroGradientMagnitudeIndex(self) -> Pointer: ...
    def GetMinNonZeroScalarIndex(self) -> Pointer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfIndependentComponents(self) -> int: ...
    def GetTableScale(self) -> Tuple[float, float, float, float]: ...
    def GetTableShift(self) -> Tuple[float, float, float, float]: ...
    def GetTableSize(self) -> Tuple[int, int, int, int]: ...
    def GetUpdateGradientOpacityFlags(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVolumeRayCastSpaceLeapingImageFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVolumeRayCastSpaceLeapingImageFilter': ...
    def SetCache(self, imageCache:'vtkImageData') -> None: ...
    def SetComputeGradientOpacity(self, _arg:int) -> None: ...
    def SetComputeMinMax(self, _arg:int) -> None: ...
    def SetCurrentScalars(self, __a:'vtkDataArray') -> None: ...
    def SetGradientOpacityTable(self, c:int, t:MutableSequence[int]) -> None: ...
    def SetIndependentComponents(self, _arg:int) -> None: ...
    def SetScalarOpacityTable(self, c:int, t:MutableSequence[int]) -> None: ...
    @overload
    def SetTableScale(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetTableScale(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetTableShift(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetTableShift(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetTableSize(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int) -> None: ...
    @overload
    def SetTableSize(self, _arg:Sequence[int]) -> None: ...
    def SetUpdateGradientOpacityFlags(self, _arg:int) -> None: ...
    def UpdateGradientOpacityFlagsOff(self) -> None: ...
    def UpdateGradientOpacityFlagsOn(self) -> None: ...

