"""
Custom FinaticServer extension.

This file is protected and will not be overwritten during regeneration.
Add custom logic to extend or override generated FinaticServer behavior.
"""

from src.generated.FinaticServer import FinaticServer as GeneratedFinaticServer


class FinaticServer(GeneratedFinaticServer):
    """Custom FinaticServer class that extends the generated class.

    Use this to add custom initialization logic or override methods.

    NOTE: All convenience methods (get_open_positions, get_pending_orders, get_active_accounts, etc.)
    are now generated by the generator with proper enum coercion.
    No custom code needed - this is just a stub for future customizations.
    """

    # Marker to verify custom class is being used
    __CUSTOM_CLASS__ = True

    # Generator now handles:
    # - All convenience methods (get_open_positions, get_pending_orders, get_active_accounts, etc.)
    # - Session headers for broker endpoints
    # - Portal URL no-cache handling
    # - Metadata transformation for with_metadata parameter
    # - init_session() method (Phase 2C - now generated)
    # - Enum coercion (case-insensitive, no aliases)
    # No custom code needed - this is just a stub for future customizations
