# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from .availablebalance import Availablebalance
from .availabletowithdraw import Availabletowithdraw
from .balancetype import Balancetype
from .buyingpower import Buyingpower
from .cashbalance import Cashbalance
from .currentbalance import Currentbalance
from .initialmargin import Initialmargin
from .maintenancemargin import Maintenancemargin
from .netliquidationvalue import Netliquidationvalue
from .pendingbalance import Pendingbalance
from .totalcashvalue import Totalcashvalue
from .totalrealizedpnl import Totalrealizedpnl
from typing import Optional, Set
from typing_extensions import Self

class FDXBrokerBalance(BaseModel):
    """
    FDX-style broker balance schema following FDX Balance patterns.  Extends FDX Balance schema with broker-specific balance types.
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, alias="_id")
    balance_id: StrictStr = Field(description="Unique balance identifier", alias="balanceId")
    account_id: StrictStr = Field(description="Associated account identifier", alias="accountId")
    internal_account_id: Optional[StrictStr] = Field(default=None, alias="internalAccountId")
    connection_id: Optional[StrictStr] = Field(default=None, alias="connectionId")
    balance_type: Balancetype = Field(alias="balanceType")
    balance_name: Optional[StrictStr] = Field(default=None, alias="balanceName")
    available_balance: Optional[Availablebalance] = Field(default=None, alias="availableBalance")
    current_balance: Optional[Currentbalance] = Field(default=None, alias="currentBalance")
    pending_balance: Optional[Pendingbalance] = Field(default=None, alias="pendingBalance")
    buying_power: Optional[Buyingpower] = Field(default=None, alias="buyingPower")
    cash_balance: Optional[Cashbalance] = Field(default=None, alias="cashBalance")
    net_liquidation_value: Optional[Netliquidationvalue] = Field(default=None, alias="netLiquidationValue")
    initial_margin: Optional[Initialmargin] = Field(default=None, alias="initialMargin")
    maintenance_margin: Optional[Maintenancemargin] = Field(default=None, alias="maintenanceMargin")
    total_cash_value: Optional[Totalcashvalue] = Field(default=None, alias="totalCashValue")
    available_to_withdraw: Optional[Availabletowithdraw] = Field(default=None, alias="availableToWithdraw")
    total_realized_pnl: Optional[Totalrealizedpnl] = Field(default=None, alias="totalRealizedPnl")
    currency_code: Optional[StrictStr] = Field(default=None, alias="currencyCode")
    balance_date: Optional[datetime] = Field(default=None, alias="balanceDate")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    metadata: Optional[Dict[str, Any]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["_id", "balanceId", "accountId", "internalAccountId", "connectionId", "balanceType", "balanceName", "availableBalance", "currentBalance", "pendingBalance", "buyingPower", "cashBalance", "netLiquidationValue", "initialMargin", "maintenanceMargin", "totalCashValue", "availableToWithdraw", "totalRealizedPnl", "currencyCode", "balanceDate", "lastUpdated", "metadata"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FDXBrokerBalance from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of balance_type
        if self.balance_type:
            _dict['balanceType'] = self.balance_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of available_balance
        if self.available_balance:
            _dict['availableBalance'] = self.available_balance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of current_balance
        if self.current_balance:
            _dict['currentBalance'] = self.current_balance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pending_balance
        if self.pending_balance:
            _dict['pendingBalance'] = self.pending_balance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of buying_power
        if self.buying_power:
            _dict['buyingPower'] = self.buying_power.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cash_balance
        if self.cash_balance:
            _dict['cashBalance'] = self.cash_balance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of net_liquidation_value
        if self.net_liquidation_value:
            _dict['netLiquidationValue'] = self.net_liquidation_value.to_dict()
        # override the default output from pydantic by calling `to_dict()` of initial_margin
        if self.initial_margin:
            _dict['initialMargin'] = self.initial_margin.to_dict()
        # override the default output from pydantic by calling `to_dict()` of maintenance_margin
        if self.maintenance_margin:
            _dict['maintenanceMargin'] = self.maintenance_margin.to_dict()
        # override the default output from pydantic by calling `to_dict()` of total_cash_value
        if self.total_cash_value:
            _dict['totalCashValue'] = self.total_cash_value.to_dict()
        # override the default output from pydantic by calling `to_dict()` of available_to_withdraw
        if self.available_to_withdraw:
            _dict['availableToWithdraw'] = self.available_to_withdraw.to_dict()
        # override the default output from pydantic by calling `to_dict()` of total_realized_pnl
        if self.total_realized_pnl:
            _dict['totalRealizedPnl'] = self.total_realized_pnl.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if internal_account_id (nullable) is None
        # and model_fields_set contains the field
        if self.internal_account_id is None and "internal_account_id" in self.model_fields_set:
            _dict['internalAccountId'] = None

        # set to None if connection_id (nullable) is None
        # and model_fields_set contains the field
        if self.connection_id is None and "connection_id" in self.model_fields_set:
            _dict['connectionId'] = None

        # set to None if balance_name (nullable) is None
        # and model_fields_set contains the field
        if self.balance_name is None and "balance_name" in self.model_fields_set:
            _dict['balanceName'] = None

        # set to None if available_balance (nullable) is None
        # and model_fields_set contains the field
        if self.available_balance is None and "available_balance" in self.model_fields_set:
            _dict['availableBalance'] = None

        # set to None if current_balance (nullable) is None
        # and model_fields_set contains the field
        if self.current_balance is None and "current_balance" in self.model_fields_set:
            _dict['currentBalance'] = None

        # set to None if pending_balance (nullable) is None
        # and model_fields_set contains the field
        if self.pending_balance is None and "pending_balance" in self.model_fields_set:
            _dict['pendingBalance'] = None

        # set to None if buying_power (nullable) is None
        # and model_fields_set contains the field
        if self.buying_power is None and "buying_power" in self.model_fields_set:
            _dict['buyingPower'] = None

        # set to None if cash_balance (nullable) is None
        # and model_fields_set contains the field
        if self.cash_balance is None and "cash_balance" in self.model_fields_set:
            _dict['cashBalance'] = None

        # set to None if net_liquidation_value (nullable) is None
        # and model_fields_set contains the field
        if self.net_liquidation_value is None and "net_liquidation_value" in self.model_fields_set:
            _dict['netLiquidationValue'] = None

        # set to None if initial_margin (nullable) is None
        # and model_fields_set contains the field
        if self.initial_margin is None and "initial_margin" in self.model_fields_set:
            _dict['initialMargin'] = None

        # set to None if maintenance_margin (nullable) is None
        # and model_fields_set contains the field
        if self.maintenance_margin is None and "maintenance_margin" in self.model_fields_set:
            _dict['maintenanceMargin'] = None

        # set to None if total_cash_value (nullable) is None
        # and model_fields_set contains the field
        if self.total_cash_value is None and "total_cash_value" in self.model_fields_set:
            _dict['totalCashValue'] = None

        # set to None if available_to_withdraw (nullable) is None
        # and model_fields_set contains the field
        if self.available_to_withdraw is None and "available_to_withdraw" in self.model_fields_set:
            _dict['availableToWithdraw'] = None

        # set to None if total_realized_pnl (nullable) is None
        # and model_fields_set contains the field
        if self.total_realized_pnl is None and "total_realized_pnl" in self.model_fields_set:
            _dict['totalRealizedPnl'] = None

        # set to None if currency_code (nullable) is None
        # and model_fields_set contains the field
        if self.currency_code is None and "currency_code" in self.model_fields_set:
            _dict['currencyCode'] = None

        # set to None if balance_date (nullable) is None
        # and model_fields_set contains the field
        if self.balance_date is None and "balance_date" in self.model_fields_set:
            _dict['balanceDate'] = None

        # set to None if last_updated (nullable) is None
        # and model_fields_set contains the field
        if self.last_updated is None and "last_updated" in self.model_fields_set:
            _dict['lastUpdated'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FDXBrokerBalance from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "_id": obj.get("_id"),
            "balanceId": obj.get("balanceId"),
            "accountId": obj.get("accountId"),
            "internalAccountId": obj.get("internalAccountId"),
            "connectionId": obj.get("connectionId"),
            "balanceType": Balancetype.from_dict(obj["balanceType"]) if obj.get("balanceType") is not None else None,
            "balanceName": obj.get("balanceName"),
            "availableBalance": Availablebalance.from_dict(obj["availableBalance"]) if obj.get("availableBalance") is not None else None,
            "currentBalance": Currentbalance.from_dict(obj["currentBalance"]) if obj.get("currentBalance") is not None else None,
            "pendingBalance": Pendingbalance.from_dict(obj["pendingBalance"]) if obj.get("pendingBalance") is not None else None,
            "buyingPower": Buyingpower.from_dict(obj["buyingPower"]) if obj.get("buyingPower") is not None else None,
            "cashBalance": Cashbalance.from_dict(obj["cashBalance"]) if obj.get("cashBalance") is not None else None,
            "netLiquidationValue": Netliquidationvalue.from_dict(obj["netLiquidationValue"]) if obj.get("netLiquidationValue") is not None else None,
            "initialMargin": Initialmargin.from_dict(obj["initialMargin"]) if obj.get("initialMargin") is not None else None,
            "maintenanceMargin": Maintenancemargin.from_dict(obj["maintenanceMargin"]) if obj.get("maintenanceMargin") is not None else None,
            "totalCashValue": Totalcashvalue.from_dict(obj["totalCashValue"]) if obj.get("totalCashValue") is not None else None,
            "availableToWithdraw": Availabletowithdraw.from_dict(obj["availableToWithdraw"]) if obj.get("availableToWithdraw") is not None else None,
            "totalRealizedPnl": Totalrealizedpnl.from_dict(obj["totalRealizedPnl"]) if obj.get("totalRealizedPnl") is not None else None,
            "currencyCode": obj.get("currencyCode"),
            "balanceDate": obj.get("balanceDate"),
            "lastUpdated": obj.get("lastUpdated"),
            "metadata": obj.get("metadata")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


