# flake8: noqa

TABS = [
    {
        "title": "Exploring IDR",
        "text": "",
        "videos": [
            {
                "id": "dFg2PAF3k7s",
                "title": "From publication to IDR",
                "text": "Find a specific IDR study from a publication. View images and Regions of Interest (ROIs) in IDR. Explore study metadata.",
            },
            {
                "id": "JboK6Kds28U",
                "title": "From gene to phenotypes",
                "text": "Query images by gene. Explore retrieved images and metadata, including associated phenotypes. View images in context of a plate.",
            },
            {
                "id": "stF4Q4m5GZg",
                "title": "From compound to analytics",
                "text": "Query images by compound. Find SARS-CoV-2 dataset. Explore images in relation to analytical data submitted by authors.",
            },
        ],
    },
    {
        "title": "Analyze Data",
        "text": "<p>The IDR server is built with <a target='_blank' href='https://www.openmicroscopy.org/omero/'>OMERO</a>, allowing access to all image data and metadata via an open API in Python, R, Java, MATLAB and REST/JSON. See the <a target='_blank' href='https://omero-guides.readthedocs.io/en/latest/api_usage.html'>OMERO API guide</a> for more information.</p><p>For examples of analysis tools working with OMERO to access and analyze data, see the <a target='_blank' href='https://omero-guides.readthedocs.io/en/latest/external_tools.html'>analysis tools guide</a>.</p>",
        "videos": [
            {
                "id": "tOgKlxyyvSc",
                "title": "Analysis environment setup",
                "text": "Set-up local or on-the-cloud analysis environment. Access images and metadata using API. Run analysis examples. Add your own code.",
            },
            {
                "id": "z19EE0_2JBs",
                "title": "Segment image and compare",
                "text": "Fetch image and labels from IDR. Segment nuclei using <a target='_blank' href='https://github.com/stardist/stardist'>StarDist</a>. Compare new labels with original. Validate software package. Save locally segmentation polygons as geojson.",
            }
        ],
    },
]
