"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyType = exports.Policy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_verifiedpermissions_1 = require("aws-cdk-lib/aws-verifiedpermissions");
const core_1 = require("aws-cdk-lib/core");
class PolicyBase extends core_1.Resource {
}
class Policy extends PolicyBase {
    /**
     *  Import a policy into the CDK using its id.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct id.
     * @param policyId The policy id.
     */
    static fromPolicyId(scope, id, policyId) {
        return Policy.fromPolicyAttributes(scope, id, { policyId });
    }
    /**
     * Import a Policy construct from attributes.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct id.
     * @param attrs A `PolicyAttributes` object.
     * @returns
     */
    static fromPolicyAttributes(scope, id, attrs) {
        class Import extends PolicyBase {
            constructor(policyType, policyId) {
                super(scope, id);
                this.policyType = policyType;
                this.policyId = policyId;
            }
        }
        const policyType = attrs.policyType ?? PolicyType.STATIC;
        return new Import(policyType, attrs.policyId);
    }
    constructor(scope, id, props) {
        super(scope, id);
        // validations
        if (props.definition.static && props.definition.templateLinked) {
            throw new Error('Policy can either be static or templateLinked');
        }
        if (!props.definition.static && !props.definition.templateLinked) {
            throw new Error('Policy must either be static or templateLinked');
        }
        var definition;
        if (props.definition.static) {
            definition = {
                static: {
                    ...props.definition.static,
                    statement: props.definition.static.statement,
                },
            };
        }
        else {
            definition = {
                templateLinked: {
                    policyTemplateId: props.definition.templateLinked.policyTemplate.policyTemplateId,
                    principal: props.definition.templateLinked.principal,
                    resource: props.definition.templateLinked.resource,
                },
            };
        }
        // resource
        this.policy = new aws_verifiedpermissions_1.CfnPolicy(this, id, {
            definition: definition,
            policyStoreId: props.policyStore.policyStoreId,
        });
        // assign construct props
        this.policyId = this.policy.attrPolicyId;
        this.policyType = props.definition.static
            ? PolicyType.STATIC
            : PolicyType.TEMPLATELINKED;
        this.definition = props.definition;
        this.policyStoreId = props.policyStore.policyStoreId;
    }
}
exports.Policy = Policy;
_a = JSII_RTTI_SYMBOL_1;
Policy[_a] = { fqn: "@cdklabs/cdk-verified-permissions.Policy", version: "0.0.1-alpha.3" };
/**
 * PolicyType options
 */
var PolicyType;
(function (PolicyType) {
    PolicyType["STATIC"] = "Static";
    PolicyType["TEMPLATELINKED"] = "TemplateLinked";
})(PolicyType || (exports.PolicyType = PolicyType = {}));
//# sourceMappingURL=data:application/json;base64,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