/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.codec.BitWriter;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrestleReader
extends BaseTiffReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrestleReader.class);
    private ArrayList<String> files;
    private String roiFile;
    private String roiDrawFile;
    private int[] overlaps;

    public TrestleReader() {
        super("Trestle", new String[]{"tif"});
        this.domains = new String[]{"Histology"};
        this.suffixSufficient = false;
        this.suffixNecessary = false;
        this.hasCompanionFiles = true;
        this.datasetDescription = "One .tif file plus several other similarly-named files (e.g. *.FocalPlane-*, .sld, .slx, .ROI)";
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (super.isThisType(name, open)) {
            return true;
        }
        if (!TrestleReader.checkSuffix(name, "tif") && open) {
            Location tiffFile;
            Location current = new Location(name).getAbsoluteFile();
            Location parent = current.getParentFile();
            String tiff = current.getName();
            int index = tiff.lastIndexOf(".");
            if (index >= 0) {
                tiff = tiff.substring(0, index);
            }
            return (tiffFile = new Location(parent, tiff = tiff + ".tif")).exists() && this.isThisType(tiffFile.getAbsolutePath(), open);
        }
        return false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser parser = new TiffParser(stream);
        IFD ifd = parser.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        String copyright = ifd.getIFDTextValue(33432);
        if (copyright == null) {
            return false;
        }
        return copyright.indexOf("Trestle Corp.") >= 0;
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            return this.files.toArray(new String[this.files.size()]);
        }
        String[] allFiles = new String[this.files.size() + 1];
        this.files.toArray(allFiles);
        allFiles[allFiles.length - 1] = this.currentId;
        return allFiles;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        if (this.core.size() == 1) {
            return super.openBytes(no, buf, x, y, w, h);
        }
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.tiffParser.getSamples((IFD)this.ifds.get(this.getCoreIndex()), buf, x, y, w, h, this.overlaps[this.getCoreIndex() * 2], this.overlaps[this.getCoreIndex() * 2 + 1]);
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.files = null;
        }
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            return (int)((IFD)this.ifds.get(this.getCoreIndex())).getTileWidth();
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
            return super.getOptimalTileWidth();
        }
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            return (int)((IFD)this.ifds.get(this.getCoreIndex())).getTileLength();
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
            return super.getOptimalTileHeight();
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        if (!TrestleReader.checkSuffix(id, "tif")) {
            String[] list;
            Location parent = new Location(id).getAbsoluteFile().getParentFile();
            for (String f : list = parent.list(true)) {
                String path;
                if (!TrestleReader.checkSuffix(f, "tif") || !this.isThisType(path = new Location(parent, f).getAbsolutePath())) continue;
                id = path;
                break;
            }
        }
        super.initFile(id);
    }

    @Override
    protected void initStandardMetadata() throws FormatException, IOException {
        String[] list;
        String[] values;
        super.initStandardMetadata();
        this.ifds = this.tiffParser.getIFDs();
        for (IFD ifd : this.ifds) {
            this.tiffParser.fillInIFD(ifd);
        }
        String comment = ((IFD)this.ifds.get(0)).getComment();
        for (String v : values = comment.split(";")) {
            int eq = v.indexOf("=");
            if (eq < 0) continue;
            String key = v.substring(0, eq).trim();
            String value = v.substring(eq + 1).trim();
            this.addGlobalMeta(key, value);
            if (!key.equals("OverlapsXY")) continue;
            String[] overlapValues = value.split(" ");
            this.overlaps = new int[this.ifds.size() * 2];
            for (int i = 0; i < overlapValues.length; ++i) {
                this.overlaps[i] = Integer.parseInt(overlapValues[i]);
            }
        }
        int seriesCount = this.ifds.size();
        this.core.clear();
        for (int i = 0; i < seriesCount; ++i) {
            CoreMetadata c = new CoreMetadata();
            if (i == 0 && !this.hasFlattenedResolutions()) {
                c.resolutionCount = seriesCount;
            }
            this.core.add(c);
        }
        for (int s = 0; s < this.core.size(); ++s) {
            CoreMetadata ms = (CoreMetadata)this.core.get(s);
            IFD ifd = (IFD)this.ifds.get(s);
            PhotoInterp p = ifd.getPhotometricInterpretation();
            int samples = ifd.getSamplesPerPixel();
            ms.rgb = samples > 1 || p == PhotoInterp.RGB;
            long numTileRows = ifd.getTilesPerColumn() - 1L;
            long numTileCols = ifd.getTilesPerRow() - 1L;
            int overlapX = this.overlaps[s * 2];
            int overlapY = this.overlaps[s * 2 + 1];
            ms.sizeX = (int)(ifd.getImageWidth() - numTileCols * (long)overlapX);
            ms.sizeY = (int)(ifd.getImageLength() - numTileRows * (long)overlapY);
            ms.sizeZ = 1;
            ms.sizeT = 1;
            ms.sizeC = ms.rgb ? samples : 1;
            ms.littleEndian = ifd.isLittleEndian();
            ms.indexed = p == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
            ms.imageCount = 1;
            ms.pixelType = ifd.getPixelType();
            ms.metadataComplete = true;
            ms.interleaved = false;
            ms.falseColor = false;
            ms.dimensionOrder = "XYCZT";
            ms.thumbnail = s > 0;
        }
        this.files = new ArrayList();
        Location baseFile = new Location(this.currentId).getAbsoluteFile();
        Location parent = baseFile.getParentFile();
        String name = baseFile.getName();
        if (name.indexOf(".") >= 0) {
            name = name.substring(0, name.indexOf(".") + 1);
        }
        this.roiFile = new Location(parent, name + "ROI").getAbsolutePath();
        this.roiDrawFile = new Location(parent, name + "ROI-draw").getAbsolutePath();
        for (String f : list = parent.list(true)) {
            if (f.equals(baseFile.getName())) continue;
            this.files.add(new Location(parent, f).getAbsolutePath());
        }
    }

    @Override
    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            store.setImageName("Series " + (i + 1), i);
        }
        MetadataLevel level = this.getMetadataOptions().getMetadataLevel();
        if (level != MetadataLevel.MINIMUM && level != MetadataLevel.NO_OVERLAYS && !(this.getMetadataStore() instanceof OMEXMLMetadata)) {
            try {
                this.parseROIs(store);
            }
            catch (IOException e) {
                LOGGER.debug("Could not parse ROIs", e);
            }
        }
    }

    private void parseROIs(MetadataStore store) throws FormatException, IOException {
        String roiID = MetadataTools.createLSID("ROI", 0, 0);
        String maskID = MetadataTools.createLSID("Shape", 0, 0);
        store.setROIID(roiID, 0);
        store.setMaskID(maskID, 0, 0);
        String positionData = DataTools.readFile(this.roiDrawFile);
        String[] coordinates = positionData.split("[ ,]");
        double x1 = Double.parseDouble(coordinates[1]);
        double y1 = Double.parseDouble(coordinates[2]);
        double x2 = Double.parseDouble(coordinates[3]);
        double y2 = Double.parseDouble(coordinates[5]);
        store.setMaskX(x1, 0, 0);
        store.setMaskY(y1, 0, 0);
        store.setMaskWidth(x2 - x1, 0, 0);
        store.setMaskHeight(y2 - y1, 0, 0);
        store.setImageROIRef(roiID, 0, 0);
        ImageReader roiReader = new ImageReader();
        roiReader.setId(this.roiFile);
        byte[] roiPixels = roiReader.openBytes(0);
        roiReader.close();
        BitWriter bits = new BitWriter(roiPixels.length / 8);
        for (int i = 0; i < roiPixels.length; ++i) {
            bits.write(roiPixels[i] == 0 ? 0 : 1, 1);
        }
        store.setMaskBinData(bits.toByteArray(), 0, 0);
    }
}

