/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.util.LittleEndian;

public class EOFRecord
extends Record {
    public static final short sid = 10;

    public EOFRecord() {
    }

    public EOFRecord(RecordInputStream in) {
        super(in);
    }

    @Override
    protected void validateSid(short id) {
        if (id != 10) {
            throw new RecordFormatException("NOT An EOF RECORD");
        }
    }

    @Override
    protected void fillFields(RecordInputStream in) {
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[EOF]\n");
        buffer.append("[/EOF]\n");
        return buffer.toString();
    }

    @Override
    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)10);
        LittleEndian.putShort(data, 2 + offset, (short)0);
        return this.getRecordSize();
    }

    @Override
    public int getRecordSize() {
        return 4;
    }

    @Override
    public short getSid() {
        return 10;
    }

    @Override
    public Object clone() {
        EOFRecord rec = new EOFRecord();
        return rec;
    }
}

