/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.Vector;
import org.apache.commons.io.FileDeleteStrategy;

public class FileCleaningTracker {
    ReferenceQueue q = new ReferenceQueue();
    final Collection trackers = new Vector();
    volatile boolean exitWhenFinished = false;
    Thread reaper;

    public void track(File file2, Object marker) {
        this.track(file2, marker, (FileDeleteStrategy)null);
    }

    public void track(File file2, Object marker, FileDeleteStrategy deleteStrategy) {
        if (file2 == null) {
            throw new NullPointerException("The file must not be null");
        }
        this.addTracker(file2.getPath(), marker, deleteStrategy);
    }

    public void track(String path, Object marker) {
        this.track(path, marker, (FileDeleteStrategy)null);
    }

    public void track(String path, Object marker, FileDeleteStrategy deleteStrategy) {
        if (path == null) {
            throw new NullPointerException("The path must not be null");
        }
        this.addTracker(path, marker, deleteStrategy);
    }

    private synchronized void addTracker(String path, Object marker, FileDeleteStrategy deleteStrategy) {
        if (this.exitWhenFinished) {
            throw new IllegalStateException("No new trackers can be added once exitWhenFinished() is called");
        }
        if (this.reaper == null) {
            this.reaper = new Reaper();
            this.reaper.start();
        }
        this.trackers.add(new Tracker(path, deleteStrategy, marker, this.q));
    }

    public int getTrackCount() {
        return this.trackers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void exitWhenFinished() {
        this.exitWhenFinished = true;
        if (this.reaper != null) {
            Thread thread = this.reaper;
            synchronized (thread) {
                this.reaper.interrupt();
            }
        }
    }

    private static final class Tracker
    extends PhantomReference {
        private final String path;
        private final FileDeleteStrategy deleteStrategy;

        Tracker(String path, FileDeleteStrategy deleteStrategy, Object marker, ReferenceQueue queue) {
            super(marker, queue);
            this.path = path;
            this.deleteStrategy = deleteStrategy == null ? FileDeleteStrategy.NORMAL : deleteStrategy;
        }

        public boolean delete() {
            return this.deleteStrategy.deleteQuietly(new File(this.path));
        }
    }

    private final class Reaper
    extends Thread {
        Reaper() {
            super("File Reaper");
            this.setPriority(10);
            this.setDaemon(true);
        }

        public void run() {
            while (!FileCleaningTracker.this.exitWhenFinished || FileCleaningTracker.this.trackers.size() > 0) {
                Tracker tracker = null;
                try {
                    tracker = (Tracker)FileCleaningTracker.this.q.remove();
                }
                catch (Exception e) {
                    continue;
                }
                if (tracker == null) continue;
                tracker.delete();
                tracker.clear();
                FileCleaningTracker.this.trackers.remove(tracker);
            }
        }
    }
}

