# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.18.2232
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError

from pydantic import Field
from typing_extensions import Annotated
from pydantic import StrictStr, field_validator

from typing import Optional

from vrt_lss_studio.models.basic_tracks_type import BasicTracksType
from vrt_lss_studio.models.table_trip_column_type import TableTripColumnType
from vrt_lss_studio.models.table_trip_filter_list import TableTripFilterList
from vrt_lss_studio.models.table_trip_list import TableTripList
from vrt_lss_studio.models.web_trip import WebTrip
from vrt_lss_studio.models.web_trip_chart_list import WebTripChartList
from vrt_lss_studio.models.web_trip_track_list import WebTripTrackList

from vrt_lss_studio.api_client import ApiClient
from vrt_lss_studio.api_response import ApiResponse
from vrt_lss_studio.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class TripsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_trip(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], web_trip : Annotated[WebTrip, Field(description="New essence creation request.")], **kwargs) -> WebTrip:  # noqa: E501
        """Trip create  # noqa: E501

        New essences creation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_trip(experiment_key, web_trip, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param web_trip: New essence creation request. (required)
        :type web_trip: WebTrip
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WebTrip
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_trip_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.create_trip_with_http_info(experiment_key, web_trip, **kwargs)  # noqa: E501

    @validate_arguments
    def create_trip_with_http_info(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], web_trip : Annotated[WebTrip, Field(description="New essence creation request.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Trip create  # noqa: E501

        New essences creation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_trip_with_http_info(experiment_key, web_trip, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param web_trip: New essence creation request. (required)
        :type web_trip: WebTrip
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WebTrip, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'web_trip'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_trip" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['web_trip'] is not None:
            _body_params = _params['web_trip']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '201': "WebTrip",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/trips', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_trip(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], essence_key : Annotated[Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]], Field(description="Key, unique identifier.")], **kwargs) -> None:  # noqa: E501
        """Remove trip  # noqa: E501

        Removing a trip by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_trip(experiment_key, essence_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param essence_key: Key, unique identifier. (required)
        :type essence_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_trip_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.delete_trip_with_http_info(experiment_key, essence_key, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_trip_with_http_info(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], essence_key : Annotated[Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]], Field(description="Key, unique identifier.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Remove trip  # noqa: E501

        Removing a trip by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_trip_with_http_info(experiment_key, essence_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param essence_key: Key, unique identifier. (required)
        :type essence_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'essence_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_trip" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']

        if _params['essence_key']:
            _path_params['essence_key'] = _params['essence_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/trips/{essence_key}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def read_trip(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], essence_key : Annotated[Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]], Field(description="Key, unique identifier.")], **kwargs) -> WebTrip:  # noqa: E501
        """Read trip  # noqa: E501

        Getting trip information by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_trip(experiment_key, essence_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param essence_key: Key, unique identifier. (required)
        :type essence_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WebTrip
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the read_trip_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.read_trip_with_http_info(experiment_key, essence_key, **kwargs)  # noqa: E501

    @validate_arguments
    def read_trip_with_http_info(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], essence_key : Annotated[Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]], Field(description="Key, unique identifier.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Read trip  # noqa: E501

        Getting trip information by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_trip_with_http_info(experiment_key, essence_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param essence_key: Key, unique identifier. (required)
        :type essence_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WebTrip, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'essence_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_trip" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']

        if _params['essence_key']:
            _path_params['essence_key'] = _params['essence_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "WebTrip",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/trips/{essence_key}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def read_trips(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], offset : Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=0)]], Field(description="The number of items to skip before starting to collect the result set.")] = None, limit : Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=1)]], Field(description="The number of items to return.")] = None, sort_field : Annotated[Optional[TableTripColumnType], Field(description="Trip table column name. ")] = None, sort_direction : Annotated[Optional[StrictStr], Field(description="Sort direction.")] = None, table_trip_filter_list : Annotated[Optional[TableTripFilterList], Field(description="Trip filter.")] = None, **kwargs) -> TableTripList:  # noqa: E501
        """Trip list  # noqa: E501

        Getting a trips list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_trips(experiment_key, offset, limit, sort_field, sort_direction, table_trip_filter_list, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param offset: The number of items to skip before starting to collect the result set.
        :type offset: int
        :param limit: The number of items to return.
        :type limit: int
        :param sort_field: Trip table column name. 
        :type sort_field: TableTripColumnType
        :param sort_direction: Sort direction.
        :type sort_direction: str
        :param table_trip_filter_list: Trip filter.
        :type table_trip_filter_list: TableTripFilterList
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableTripList
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the read_trips_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.read_trips_with_http_info(experiment_key, offset, limit, sort_field, sort_direction, table_trip_filter_list, **kwargs)  # noqa: E501

    @validate_arguments
    def read_trips_with_http_info(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], offset : Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=0)]], Field(description="The number of items to skip before starting to collect the result set.")] = None, limit : Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=1)]], Field(description="The number of items to return.")] = None, sort_field : Annotated[Optional[TableTripColumnType], Field(description="Trip table column name. ")] = None, sort_direction : Annotated[Optional[StrictStr], Field(description="Sort direction.")] = None, table_trip_filter_list : Annotated[Optional[TableTripFilterList], Field(description="Trip filter.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Trip list  # noqa: E501

        Getting a trips list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_trips_with_http_info(experiment_key, offset, limit, sort_field, sort_direction, table_trip_filter_list, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param offset: The number of items to skip before starting to collect the result set.
        :type offset: int
        :param limit: The number of items to return.
        :type limit: int
        :param sort_field: Trip table column name. 
        :type sort_field: TableTripColumnType
        :param sort_direction: Sort direction.
        :type sort_direction: str
        :param table_trip_filter_list: Trip filter.
        :type table_trip_filter_list: TableTripFilterList
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TableTripList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'offset',
            'limit',
            'sort_field',
            'sort_direction',
            'table_trip_filter_list'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_trips" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('sort_field') is not None:  # noqa: E501
            _query_params.append(('sort_field', _params['sort_field'].value))

        if _params.get('sort_direction') is not None:  # noqa: E501
            _query_params.append(('sort_direction', _params['sort_direction']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['table_trip_filter_list'] is not None:
            _body_params = _params['table_trip_filter_list']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "TableTripList",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/trips/batch/list', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def read_trips_charts(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], offset : Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=0)]], Field(description="The number of items to skip before starting to collect the result set.")] = None, limit : Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=1)]], Field(description="The number of items to return.")] = None, sort_field : Annotated[Optional[TableTripColumnType], Field(description="Trip table column name. ")] = None, sort_direction : Annotated[Optional[StrictStr], Field(description="Sort direction.")] = None, table_trip_filter_list : Annotated[Optional[TableTripFilterList], Field(description="Trips filter.")] = None, **kwargs) -> WebTripChartList:  # noqa: E501
        """Trips chart  # noqa: E501

        Getting a trips for chart.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_trips_charts(experiment_key, offset, limit, sort_field, sort_direction, table_trip_filter_list, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param offset: The number of items to skip before starting to collect the result set.
        :type offset: int
        :param limit: The number of items to return.
        :type limit: int
        :param sort_field: Trip table column name. 
        :type sort_field: TableTripColumnType
        :param sort_direction: Sort direction.
        :type sort_direction: str
        :param table_trip_filter_list: Trips filter.
        :type table_trip_filter_list: TableTripFilterList
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WebTripChartList
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the read_trips_charts_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.read_trips_charts_with_http_info(experiment_key, offset, limit, sort_field, sort_direction, table_trip_filter_list, **kwargs)  # noqa: E501

    @validate_arguments
    def read_trips_charts_with_http_info(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], offset : Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=0)]], Field(description="The number of items to skip before starting to collect the result set.")] = None, limit : Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=1)]], Field(description="The number of items to return.")] = None, sort_field : Annotated[Optional[TableTripColumnType], Field(description="Trip table column name. ")] = None, sort_direction : Annotated[Optional[StrictStr], Field(description="Sort direction.")] = None, table_trip_filter_list : Annotated[Optional[TableTripFilterList], Field(description="Trips filter.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Trips chart  # noqa: E501

        Getting a trips for chart.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_trips_charts_with_http_info(experiment_key, offset, limit, sort_field, sort_direction, table_trip_filter_list, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param offset: The number of items to skip before starting to collect the result set.
        :type offset: int
        :param limit: The number of items to return.
        :type limit: int
        :param sort_field: Trip table column name. 
        :type sort_field: TableTripColumnType
        :param sort_direction: Sort direction.
        :type sort_direction: str
        :param table_trip_filter_list: Trips filter.
        :type table_trip_filter_list: TableTripFilterList
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WebTripChartList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'offset',
            'limit',
            'sort_field',
            'sort_direction',
            'table_trip_filter_list'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_trips_charts" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('sort_field') is not None:  # noqa: E501
            _query_params.append(('sort_field', _params['sort_field'].value))

        if _params.get('sort_direction') is not None:  # noqa: E501
            _query_params.append(('sort_direction', _params['sort_direction']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['table_trip_filter_list'] is not None:
            _body_params = _params['table_trip_filter_list']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "WebTripChartList",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/trips/batch/charts', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def read_trips_tracks(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], tracks_type : Annotated[BasicTracksType, Field(description="Track type:   * `LINE` - connecting stop points in a straight line   * `ROAD` - connecting stop points along roads ")], offset : Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=0)]], Field(description="The number of items to skip before starting to collect the result set.")] = None, limit : Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=1)]], Field(description="The number of items to return.")] = None, table_trip_filter_list : Annotated[Optional[TableTripFilterList], Field(description="Trips filter.")] = None, **kwargs) -> WebTripTrackList:  # noqa: E501
        """Trip tracks  # noqa: E501

        Getting a tracks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_trips_tracks(experiment_key, tracks_type, offset, limit, table_trip_filter_list, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param tracks_type: Track type:   * `LINE` - connecting stop points in a straight line   * `ROAD` - connecting stop points along roads  (required)
        :type tracks_type: BasicTracksType
        :param offset: The number of items to skip before starting to collect the result set.
        :type offset: int
        :param limit: The number of items to return.
        :type limit: int
        :param table_trip_filter_list: Trips filter.
        :type table_trip_filter_list: TableTripFilterList
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WebTripTrackList
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the read_trips_tracks_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.read_trips_tracks_with_http_info(experiment_key, tracks_type, offset, limit, table_trip_filter_list, **kwargs)  # noqa: E501

    @validate_arguments
    def read_trips_tracks_with_http_info(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], tracks_type : Annotated[BasicTracksType, Field(description="Track type:   * `LINE` - connecting stop points in a straight line   * `ROAD` - connecting stop points along roads ")], offset : Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=0)]], Field(description="The number of items to skip before starting to collect the result set.")] = None, limit : Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=1)]], Field(description="The number of items to return.")] = None, table_trip_filter_list : Annotated[Optional[TableTripFilterList], Field(description="Trips filter.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Trip tracks  # noqa: E501

        Getting a tracks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_trips_tracks_with_http_info(experiment_key, tracks_type, offset, limit, table_trip_filter_list, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param tracks_type: Track type:   * `LINE` - connecting stop points in a straight line   * `ROAD` - connecting stop points along roads  (required)
        :type tracks_type: BasicTracksType
        :param offset: The number of items to skip before starting to collect the result set.
        :type offset: int
        :param limit: The number of items to return.
        :type limit: int
        :param table_trip_filter_list: Trips filter.
        :type table_trip_filter_list: TableTripFilterList
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WebTripTrackList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'tracks_type',
            'offset',
            'limit',
            'table_trip_filter_list'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_trips_tracks" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']

        if _params['tracks_type']:
            _path_params['tracks_type'] = _params['tracks_type']


        # process the query parameters
        _query_params = []
        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['table_trip_filter_list'] is not None:
            _body_params = _params['table_trip_filter_list']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "WebTripTrackList",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/trips/batch/tracks/{tracks_type}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_trip(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], web_trip : Annotated[WebTrip, Field(description="Essence update request.")], **kwargs) -> WebTrip:  # noqa: E501
        """Trip update  # noqa: E501

        Updating the essence by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_trip(experiment_key, web_trip, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param web_trip: Essence update request. (required)
        :type web_trip: WebTrip
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WebTrip
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_trip_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.update_trip_with_http_info(experiment_key, web_trip, **kwargs)  # noqa: E501

    @validate_arguments
    def update_trip_with_http_info(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], web_trip : Annotated[WebTrip, Field(description="Essence update request.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Trip update  # noqa: E501

        Updating the essence by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_trip_with_http_info(experiment_key, web_trip, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param web_trip: Essence update request. (required)
        :type web_trip: WebTrip
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WebTrip, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'web_trip'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_trip" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['web_trip'] is not None:
            _body_params = _params['web_trip']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "WebTrip",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/trips', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
