# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.18.2232
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel
from vrt_lss_studio.models.time_window import TimeWindow

class AssignedPerformer(BaseModel):
    """
    Performer's shift assigned to the specified time (`shift_time`).  # noqa: E501
    """
    performer_key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Performer's key, unique identifier.")
    shift_key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Performer's shift key.")
    shift_time: Optional[TimeWindow]
    __properties = ["performer_key", "shift_key", "shift_time"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AssignedPerformer:
        """Create an instance of AssignedPerformer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of shift_time
        if self.shift_time:
            _dict['shift_time'] = self.shift_time.to_dict()
        # set to None if shift_time (nullable) is None
        # and __fields_set__ contains the field
        if self.shift_time is None and "shift_time" in self.__fields_set__:
            _dict['shift_time'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AssignedPerformer:
        """Create an instance of AssignedPerformer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AssignedPerformer.parse_obj(obj)

        _obj = AssignedPerformer.parse_obj({
            "performer_key": obj.get("performer_key"),
            "shift_key": obj.get("shift_key"),
            "shift_time": TimeWindow.from_dict(obj.get("shift_time")) if obj.get("shift_time") is not None else None
        })
        return _obj


