# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.18.2232
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel
from vrt_lss_studio.models.capacity import Capacity
from vrt_lss_studio.models.cargo_compatibilities import CargoCompatibilities

class Cargo(BaseModel):
    """
    Cargo. Regardless of capacity, cargo can only move inside the transport box.   # noqa: E501
    """
    key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Cargo key, unique identifier.")
    capacity: Optional[Capacity] = None
    compatibilities: Optional[CargoCompatibilities] = None
    target_box_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="The key of the transport compartment in which the cargo is already located. Applicable only for cargo that is in the order with the type `DROP_FROM_BOX`. For other order types, the key must be empty. ")
    __properties = ["key", "capacity", "compatibilities", "target_box_key"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Cargo:
        """Create an instance of Cargo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of capacity
        if self.capacity:
            _dict['capacity'] = self.capacity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of compatibilities
        if self.compatibilities:
            _dict['compatibilities'] = self.compatibilities.to_dict()
        # set to None if capacity (nullable) is None
        # and __fields_set__ contains the field
        if self.capacity is None and "capacity" in self.__fields_set__:
            _dict['capacity'] = None

        # set to None if compatibilities (nullable) is None
        # and __fields_set__ contains the field
        if self.compatibilities is None and "compatibilities" in self.__fields_set__:
            _dict['compatibilities'] = None

        # set to None if target_box_key (nullable) is None
        # and __fields_set__ contains the field
        if self.target_box_key is None and "target_box_key" in self.__fields_set__:
            _dict['target_box_key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Cargo:
        """Create an instance of Cargo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Cargo.parse_obj(obj)

        _obj = Cargo.parse_obj({
            "key": obj.get("key"),
            "capacity": Capacity.from_dict(obj.get("capacity")) if obj.get("capacity") is not None else None,
            "compatibilities": CargoCompatibilities.from_dict(obj.get("compatibilities")) if obj.get("compatibilities") is not None else None,
            "target_box_key": obj.get("target_box_key")
        })
        return _obj


