# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.18.2232
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel
from vrt_lss_studio.models.entity_error import EntityError
from vrt_lss_studio.models.entity_warning import EntityWarning

class ExperimentCheck(BaseModel):
    """
    The result of checking the data on the experiment.  # noqa: E501
    """
    logical_errors: Optional[Annotated[List[EntityError], Field(min_length=0, max_length=15001)]] = Field(default=None, description="List with fatal errors. ")
    warnings: Optional[Annotated[List[EntityWarning], Field(min_length=0, max_length=15001)]] = Field(default=None, description="Warning list.")
    __properties = ["logical_errors", "warnings"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ExperimentCheck:
        """Create an instance of ExperimentCheck from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in logical_errors (list)
        _items = []
        if self.logical_errors:
            for _item in self.logical_errors:
                if _item:
                    _items.append(_item.to_dict())
            _dict['logical_errors'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in warnings (list)
        _items = []
        if self.warnings:
            for _item in self.warnings:
                if _item:
                    _items.append(_item.to_dict())
            _dict['warnings'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ExperimentCheck:
        """Create an instance of ExperimentCheck from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ExperimentCheck.parse_obj(obj)

        _obj = ExperimentCheck.parse_obj({
            "logical_errors": [EntityError.from_dict(_item) for _item in obj.get("logical_errors")] if obj.get("logical_errors") is not None else None,
            "warnings": [EntityWarning.from_dict(_item) for _item in obj.get("warnings")] if obj.get("warnings") is not None else None
        })
        return _obj


