# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.18.2232
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictStr, field_validator

class LinkedEssence(BaseModel):
    """
    Link to essence.  # noqa: E501
    """
    essence_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(description="Key, unique identifier.")
    essence_type: StrictStr = Field(description="Essence type.")
    __properties = ["essence_key", "essence_type"]

    @validator('essence_type')
    def essence_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('LOCATION', 'ORDER', 'PERFORMER', 'TRANSPORT', 'HARDLINK', 'TRIP', 'FACT'):
            raise ValueError("must be one of enum values ('LOCATION', 'ORDER', 'PERFORMER', 'TRANSPORT', 'HARDLINK', 'TRIP', 'FACT')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LinkedEssence:
        """Create an instance of LinkedEssence from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if essence_key (nullable) is None
        # and __fields_set__ contains the field
        if self.essence_key is None and "essence_key" in self.__fields_set__:
            _dict['essence_key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LinkedEssence:
        """Create an instance of LinkedEssence from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return LinkedEssence.parse_obj(obj)

        _obj = LinkedEssence.parse_obj({
            "essence_key": obj.get("essence_key"),
            "essence_type": obj.get("essence_type")
        })
        return _obj


