# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.18.2232
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, field_validator
from vrt_lss_studio.models.attribute import Attribute
from vrt_lss_studio.models.geopoint import Geopoint
from vrt_lss_studio.models.location_compatibilities import LocationCompatibilities
from vrt_lss_studio.models.time_window import TimeWindow

class Location(BaseModel):
    """
    Location - unique geographical location of the object with accessibility parameters.   # noqa: E501
    """
    key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Location key, unique identifier.")
    geopoint: Geopoint
    arrival_duration: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default='PT0S', description="Time duration according to [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). ")
    departure_duration: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default='PT0S', description="Time duration according to [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). ")
    work_windows: Optional[Annotated[List[TimeWindow], Field(min_length=0, max_length=100)]] = Field(default=None, description="List of time windows for the location. If the list is empty or not specified, the location works without time limits. ")
    compatibilities: Optional[LocationCompatibilities] = None
    attributes: Optional[Annotated[List[Attribute], Field(min_length=0, max_length=1000)]] = Field(default=None, description="Attributes. Used to add service information.")
    __properties = ["key", "geopoint", "arrival_duration", "departure_duration", "work_windows", "compatibilities", "attributes"]

    @validator('arrival_duration')
    def arrival_duration_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    @validator('departure_duration')
    def departure_duration_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Location:
        """Create an instance of Location from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of geopoint
        if self.geopoint:
            _dict['geopoint'] = self.geopoint.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in work_windows (list)
        _items = []
        if self.work_windows:
            for _item in self.work_windows:
                if _item:
                    _items.append(_item.to_dict())
            _dict['work_windows'] = _items
        # override the default output from pydantic by calling `to_dict()` of compatibilities
        if self.compatibilities:
            _dict['compatibilities'] = self.compatibilities.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item in self.attributes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attributes'] = _items
        # set to None if compatibilities (nullable) is None
        # and __fields_set__ contains the field
        if self.compatibilities is None and "compatibilities" in self.__fields_set__:
            _dict['compatibilities'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Location:
        """Create an instance of Location from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Location.parse_obj(obj)

        _obj = Location.parse_obj({
            "key": obj.get("key"),
            "geopoint": Geopoint.from_dict(obj.get("geopoint")) if obj.get("geopoint") is not None else None,
            "arrival_duration": obj.get("arrival_duration") if obj.get("arrival_duration") is not None else 'PT0S',
            "departure_duration": obj.get("departure_duration") if obj.get("departure_duration") is not None else 'PT0S',
            "work_windows": [TimeWindow.from_dict(_item) for _item in obj.get("work_windows")] if obj.get("work_windows") is not None else None,
            "compatibilities": LocationCompatibilities.from_dict(obj.get("compatibilities")) if obj.get("compatibilities") is not None else None,
            "attributes": [Attribute.from_dict(_item) for _item in obj.get("attributes")] if obj.get("attributes") is not None else None
        })
        return _obj


