# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.18.2232
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional, Union
from pydantic import BaseModel, field_validator

class PerformerTariffConstraint(BaseModel):
    """
    The paid period of time is an integral part of the tariff.  # noqa: E501
    """
    stage_length: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default='PT24H', description="Length of the paid period according to [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations).")
    cost_per_unit: Optional[Union[Annotated[float, Field(le=10000, strict=True, ge=0.001)], Annotated[int, Field(le=10000, strict=True, ge=1)]]] = Field(default=0.001, description="Cost within the paid period, monetary unit per second of work. ")
    __properties = ["stage_length", "cost_per_unit"]

    @validator('stage_length')
    def stage_length_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PerformerTariffConstraint:
        """Create an instance of PerformerTariffConstraint from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PerformerTariffConstraint:
        """Create an instance of PerformerTariffConstraint from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PerformerTariffConstraint.parse_obj(obj)

        _obj = PerformerTariffConstraint.parse_obj({
            "stage_length": obj.get("stage_length") if obj.get("stage_length") is not None else 'PT24H',
            "cost_per_unit": obj.get("cost_per_unit") if obj.get("cost_per_unit") is not None else 0.001
        })
        return _obj


