# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.18.2232
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List
from pydantic import BaseModel
from vrt_lss_studio.models.waypoint import Waypoint

class RoutingMatrix(BaseModel):
    """
    Time and distance matrix.  # noqa: E501
    """
    waypoints: Annotated[List[Waypoint], Field(min_length=2, max_length=15001)] = Field(description="Array of geographical points with distances and times calculated between them.")
    distances: Annotated[List[Annotated[List[Annotated[int, Field(le=10000000, strict=True, ge=-1)]], Field(min_length=2, max_length=15001)]], Field(min_length=2, max_length=15001)] = Field(description="Routes length between two neighbors locations, in meters.         The values in the array are ordered according to the elements order in the `waypoints` parameter. Each matrix row is an array of distances from the desired point to every other point. ")
    durations: Annotated[List[Annotated[List[Annotated[int, Field(le=10000000, strict=True, ge=-1)]], Field(min_length=2, max_length=15001)]], Field(min_length=2, max_length=15001)] = Field(description="Array of route durations between two neighbors locations, in seconds. The values in the array are ordered according to the elements order in the `waypoints` parameter. Each matrix row is an array of distances from the desired point to every other point. ")
    __properties = ["waypoints", "distances", "durations"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RoutingMatrix:
        """Create an instance of RoutingMatrix from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in waypoints (list)
        _items = []
        if self.waypoints:
            for _item in self.waypoints:
                if _item:
                    _items.append(_item.to_dict())
            _dict['waypoints'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RoutingMatrix:
        """Create an instance of RoutingMatrix from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RoutingMatrix.parse_obj(obj)

        _obj = RoutingMatrix.parse_obj({
            "waypoints": [Waypoint.from_dict(_item) for _item in obj.get("waypoints")] if obj.get("waypoints") is not None else None,
            "distances": obj.get("distances"),
            "durations": obj.get("durations")
        })
        return _obj


