# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.18.2232
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional, Union
from pydantic import BaseModel, StrictBool, StrictStr, field_validator
from vrt_lss_studio.models.basic_time_window import BasicTimeWindow

class TableTripFields(BaseModel):
    """
    Trip\\stops fields for table.  # noqa: E501
    """
    essence_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="Key, unique identifier.")
    essence_type: Optional[StrictStr] = Field(default='TRIP', description="Essence type.")
    enabled: Optional[StrictBool] = Field(default=True, description="Using essence for calculations.")
    pristine: Optional[StrictBool] = Field(default=True, description="A flag indicating whether changes to the entity have been made relative to the original data. `true` - means that the data is original and has not been changed. ")
    trip_name: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=64)]] = Field(default='', description="Trip name.")
    attributes: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=1000000)]] = Field(default='', description="Attributes.")
    cost: Optional[Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]]] = Field(default=0, description="Total costs calculated based on the performer's and transport tariffs. The total cost is equal to the difference between the total reward (`reward`) and expenses (`cost`). ")
    reward: Optional[Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]]] = Field(default=0, description="The total reward for orders fulfillment.")
    driving_time: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default='PT0S', description="Time duration according to [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). ")
    waiting_time: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default='PT0S', description="Time duration according to [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). ")
    break_time: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default='PT0S', description="Time duration according to [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). ")
    working_time: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default='PT0S', description="Time duration according to [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). ")
    arriving_time: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default='PT0S', description="Time duration according to [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). ")
    departure_time: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default='PT0S', description="Time duration according to [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). ")
    total_time: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default='PT0S', description="Time duration according to [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). ")
    distance: Optional[Annotated[int, Field(le=4000000000, strict=True, ge=0)]] = Field(default=0, description="Distance in meters.")
    time_window: Optional[BasicTimeWindow] = None
    orders_count: Optional[Annotated[int, Field(le=15001, strict=True, ge=0)]] = Field(default=0, description="The total number of planned and assigned orders.")
    plan_orders_count: Optional[Annotated[int, Field(le=15001, strict=True, ge=0)]] = Field(default=0, description="The total number of planned orders.")
    waitlist_orders_count: Optional[Annotated[int, Field(le=15001, strict=True, ge=0)]] = Field(default=0, description="The total number of assigned orders.")
    stops_count: Optional[Annotated[int, Field(le=15001, strict=True, ge=0)]] = Field(default=0, description="The total number of stops (non-unique locations).")
    locations_count: Optional[Annotated[int, Field(le=15001, strict=True, ge=0)]] = Field(default=0, description="The total number of unique locations within one trip.")
    cargo_capacity_ratio_mass: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="The ratio of the total additive measures of the transported cargo to the total capacity of the boxes.")
    cargo_capacity_ratio_volume: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="The ratio of the total additive measures of the transported cargo to the total capacity of the boxes.")
    cargo_capacity_ratio_capacity_a: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="The ratio of the total additive measures of the transported cargo to the total capacity of the boxes.")
    cargo_capacity_ratio_capacity_b: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="The ratio of the total additive measures of the transported cargo to the total capacity of the boxes.")
    cargo_capacity_ratio_capacity_c: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="The ratio of the total additive measures of the transported cargo to the total capacity of the boxes.")
    max_transport_load_mass: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="The ratio of the maximum load of boxes to the total capacity of boxes.")
    max_transport_load_volume: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="The ratio of the maximum load of boxes to the total capacity of boxes.")
    max_transport_load_capacity_a: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="The ratio of the maximum load of boxes to the total capacity of boxes.")
    max_transport_load_capacity_b: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="The ratio of the maximum load of boxes to the total capacity of boxes.")
    max_transport_load_capacity_c: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="The ratio of the maximum load of boxes to the total capacity of boxes.")
    __properties = ["essence_key", "essence_type", "enabled", "pristine", "trip_name", "attributes", "cost", "reward", "driving_time", "waiting_time", "break_time", "working_time", "arriving_time", "departure_time", "total_time", "distance", "time_window", "orders_count", "plan_orders_count", "waitlist_orders_count", "stops_count", "locations_count", "cargo_capacity_ratio_mass", "cargo_capacity_ratio_volume", "cargo_capacity_ratio_capacity_a", "cargo_capacity_ratio_capacity_b", "cargo_capacity_ratio_capacity_c", "max_transport_load_mass", "max_transport_load_volume", "max_transport_load_capacity_a", "max_transport_load_capacity_b", "max_transport_load_capacity_c"]

    @validator('essence_type')
    def essence_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('TRIP', 'STOP'):
            raise ValueError("must be one of enum values ('TRIP', 'STOP')")
        return value

    @validator('driving_time')
    def driving_time_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    @validator('waiting_time')
    def waiting_time_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    @validator('break_time')
    def break_time_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    @validator('working_time')
    def working_time_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    @validator('arriving_time')
    def arriving_time_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    @validator('departure_time')
    def departure_time_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    @validator('total_time')
    def total_time_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TableTripFields:
        """Create an instance of TableTripFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "pristine",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of time_window
        if self.time_window:
            _dict['time_window'] = self.time_window.to_dict()
        # set to None if essence_key (nullable) is None
        # and __fields_set__ contains the field
        if self.essence_key is None and "essence_key" in self.__fields_set__:
            _dict['essence_key'] = None

        # set to None if time_window (nullable) is None
        # and __fields_set__ contains the field
        if self.time_window is None and "time_window" in self.__fields_set__:
            _dict['time_window'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TableTripFields:
        """Create an instance of TableTripFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TableTripFields.parse_obj(obj)

        _obj = TableTripFields.parse_obj({
            "essence_key": obj.get("essence_key"),
            "essence_type": obj.get("essence_type") if obj.get("essence_type") is not None else 'TRIP',
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "pristine": obj.get("pristine") if obj.get("pristine") is not None else True,
            "trip_name": obj.get("trip_name") if obj.get("trip_name") is not None else '',
            "attributes": obj.get("attributes") if obj.get("attributes") is not None else '',
            "cost": obj.get("cost") if obj.get("cost") is not None else 0,
            "reward": obj.get("reward") if obj.get("reward") is not None else 0,
            "driving_time": obj.get("driving_time") if obj.get("driving_time") is not None else 'PT0S',
            "waiting_time": obj.get("waiting_time") if obj.get("waiting_time") is not None else 'PT0S',
            "break_time": obj.get("break_time") if obj.get("break_time") is not None else 'PT0S',
            "working_time": obj.get("working_time") if obj.get("working_time") is not None else 'PT0S',
            "arriving_time": obj.get("arriving_time") if obj.get("arriving_time") is not None else 'PT0S',
            "departure_time": obj.get("departure_time") if obj.get("departure_time") is not None else 'PT0S',
            "total_time": obj.get("total_time") if obj.get("total_time") is not None else 'PT0S',
            "distance": obj.get("distance") if obj.get("distance") is not None else 0,
            "time_window": BasicTimeWindow.from_dict(obj.get("time_window")) if obj.get("time_window") is not None else None,
            "orders_count": obj.get("orders_count") if obj.get("orders_count") is not None else 0,
            "plan_orders_count": obj.get("plan_orders_count") if obj.get("plan_orders_count") is not None else 0,
            "waitlist_orders_count": obj.get("waitlist_orders_count") if obj.get("waitlist_orders_count") is not None else 0,
            "stops_count": obj.get("stops_count") if obj.get("stops_count") is not None else 0,
            "locations_count": obj.get("locations_count") if obj.get("locations_count") is not None else 0,
            "cargo_capacity_ratio_mass": obj.get("cargo_capacity_ratio_mass") if obj.get("cargo_capacity_ratio_mass") is not None else 0,
            "cargo_capacity_ratio_volume": obj.get("cargo_capacity_ratio_volume") if obj.get("cargo_capacity_ratio_volume") is not None else 0,
            "cargo_capacity_ratio_capacity_a": obj.get("cargo_capacity_ratio_capacity_a") if obj.get("cargo_capacity_ratio_capacity_a") is not None else 0,
            "cargo_capacity_ratio_capacity_b": obj.get("cargo_capacity_ratio_capacity_b") if obj.get("cargo_capacity_ratio_capacity_b") is not None else 0,
            "cargo_capacity_ratio_capacity_c": obj.get("cargo_capacity_ratio_capacity_c") if obj.get("cargo_capacity_ratio_capacity_c") is not None else 0,
            "max_transport_load_mass": obj.get("max_transport_load_mass") if obj.get("max_transport_load_mass") is not None else 0,
            "max_transport_load_volume": obj.get("max_transport_load_volume") if obj.get("max_transport_load_volume") is not None else 0,
            "max_transport_load_capacity_a": obj.get("max_transport_load_capacity_a") if obj.get("max_transport_load_capacity_a") is not None else 0,
            "max_transport_load_capacity_b": obj.get("max_transport_load_capacity_b") if obj.get("max_transport_load_capacity_b") is not None else 0,
            "max_transport_load_capacity_c": obj.get("max_transport_load_capacity_c") if obj.get("max_transport_load_capacity_c") is not None else 0
        })
        return _obj


