# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.18.2232
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel
from vrt_lss_studio.models.assigned_performer import AssignedPerformer
from vrt_lss_studio.models.assigned_transport import AssignedTransport
from vrt_lss_studio.models.attribute import Attribute
from vrt_lss_studio.models.trip_state import TripState

class Trip(BaseModel):
    """
    A trip is a sequence of states assigned to the specified performer driving the specified transport.   # noqa: E501
    """
    key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Unique trip identifier.")
    name: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=64)]] = Field(default='', description="Trip name.")
    performer: AssignedPerformer
    transport: AssignedTransport
    states: Annotated[List[TripState], Field(min_length=0, max_length=15001)] = Field(description="List of performer's states.")
    waitlist: Optional[Annotated[List[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]], Field(min_length=0, max_length=15001)]] = Field(default=None, description="A list of keys assigned to orders, but not scheduled for a specific time.")
    attributes: Optional[Annotated[List[Attribute], Field(min_length=0, max_length=1000)]] = Field(default=None, description="Attributes. Used to add service information.")
    __properties = ["key", "name", "performer", "transport", "states", "waitlist", "attributes"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Trip:
        """Create an instance of Trip from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of performer
        if self.performer:
            _dict['performer'] = self.performer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of transport
        if self.transport:
            _dict['transport'] = self.transport.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in states (list)
        _items = []
        if self.states:
            for _item in self.states:
                if _item:
                    _items.append(_item.to_dict())
            _dict['states'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item in self.attributes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attributes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Trip:
        """Create an instance of Trip from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Trip.parse_obj(obj)

        _obj = Trip.parse_obj({
            "key": obj.get("key"),
            "name": obj.get("name") if obj.get("name") is not None else '',
            "performer": AssignedPerformer.from_dict(obj.get("performer")) if obj.get("performer") is not None else None,
            "transport": AssignedTransport.from_dict(obj.get("transport")) if obj.get("transport") is not None else None,
            "states": [TripState.from_dict(_item) for _item in obj.get("states")] if obj.get("states") is not None else None,
            "waitlist": obj.get("waitlist"),
            "attributes": [Attribute.from_dict(_item) for _item in obj.get("attributes")] if obj.get("attributes") is not None else None
        })
        return _obj


