# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.18.2232
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool
from vrt_lss_studio.models.capacity_factor import CapacityFactor
from vrt_lss_studio.models.demand_extra_duration import DemandExtraDuration
from vrt_lss_studio.models.feature_lifetime import FeatureLifetime
from vrt_lss_studio.models.transport_factor import TransportFactor

class TripAssumptions(BaseModel):
    """
    Planning assumptions. Designed to adjust the business logic of planning and mass change of input data.   # noqa: E501
    """
    transport_factor: Optional[Annotated[List[TransportFactor], Field(min_length=0, max_length=12)]] = Field(default=None, description="Transport speed change coefficients.")
    capacity_factor: Optional[Annotated[List[CapacityFactor], Field(min_length=0, max_length=12)]] = Field(default=None, description="Transport capacity change coefficients. Change the `capacity` parameters for all boxes and `max_capacity` for the transport. ")
    demands_extra_duration: Optional[Annotated[List[DemandExtraDuration], Field(min_length=0, max_length=15001)]] = Field(default=None, description="List of additional execution times for the demands by certain performers. Valid for the specified performer-order pair for all performer's shifts and all order execution options. ")
    feature_lifetimes: Optional[Annotated[List[FeatureLifetime], Field(min_length=0, max_length=1000)]] = Field(default=None, description="List of feature tag lifetime. ")
    disable_compatibility: Optional[StrictBool] = Field(default=False, description="Disable the accounting for capacity. If `true` is specified, all becomes compatible with everything. ")
    disable_capacity: Optional[StrictBool] = Field(default=False, description="Disable the accounting for capacity. If `true` is specified, all transports can accommodate an unlimited cargo amount. ")
    same_order_time_window: Optional[StrictBool] = Field(default=False, description="Use for calculation the same (specified) time window for orders and demands. The time window is specified from the beginning of the earliest window to the end of the latest window from all orders and demands. ")
    expand_shift_time_window: Optional[StrictBool] = Field(default=False, description="Expand the time window for performer and transport shifts.  The left border of the first shift extends to the left border of the specified window, right border extends to the right border or to the beginning of the next window for this entity. Each next shift moves the right border to the next shift or to the right border of the specified window. ")
    __properties = ["transport_factor", "capacity_factor", "demands_extra_duration", "feature_lifetimes", "disable_compatibility", "disable_capacity", "same_order_time_window", "expand_shift_time_window"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TripAssumptions:
        """Create an instance of TripAssumptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in transport_factor (list)
        _items = []
        if self.transport_factor:
            for _item in self.transport_factor:
                if _item:
                    _items.append(_item.to_dict())
            _dict['transport_factor'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in capacity_factor (list)
        _items = []
        if self.capacity_factor:
            for _item in self.capacity_factor:
                if _item:
                    _items.append(_item.to_dict())
            _dict['capacity_factor'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in demands_extra_duration (list)
        _items = []
        if self.demands_extra_duration:
            for _item in self.demands_extra_duration:
                if _item:
                    _items.append(_item.to_dict())
            _dict['demands_extra_duration'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in feature_lifetimes (list)
        _items = []
        if self.feature_lifetimes:
            for _item in self.feature_lifetimes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['feature_lifetimes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TripAssumptions:
        """Create an instance of TripAssumptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TripAssumptions.parse_obj(obj)

        _obj = TripAssumptions.parse_obj({
            "transport_factor": [TransportFactor.from_dict(_item) for _item in obj.get("transport_factor")] if obj.get("transport_factor") is not None else None,
            "capacity_factor": [CapacityFactor.from_dict(_item) for _item in obj.get("capacity_factor")] if obj.get("capacity_factor") is not None else None,
            "demands_extra_duration": [DemandExtraDuration.from_dict(_item) for _item in obj.get("demands_extra_duration")] if obj.get("demands_extra_duration") is not None else None,
            "feature_lifetimes": [FeatureLifetime.from_dict(_item) for _item in obj.get("feature_lifetimes")] if obj.get("feature_lifetimes") is not None else None,
            "disable_compatibility": obj.get("disable_compatibility") if obj.get("disable_compatibility") is not None else False,
            "disable_capacity": obj.get("disable_capacity") if obj.get("disable_capacity") is not None else False,
            "same_order_time_window": obj.get("same_order_time_window") if obj.get("same_order_time_window") is not None else False,
            "expand_shift_time_window": obj.get("expand_shift_time_window") if obj.get("expand_shift_time_window") is not None else False
        })
        return _obj


