# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.18.2232
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel
from vrt_lss_studio.models.attribute import Attribute
from vrt_lss_studio.models.cargo_placement import CargoPlacement
from vrt_lss_studio.models.trip_state_flag import TripStateFlag

class TripState(BaseModel):
    """
    Trip state.  # noqa: E501
    """
    time: datetime = Field(description="Start time according to the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6).")
    order_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="Key of the order with which an action is taken.")
    demand_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="Key of the demand with which an action is taken.")
    event_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="Key of the event at which an action is taken.")
    location_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="Key of the location at which an action is taken.")
    flags: Annotated[List[TripStateFlag], Field(min_length=0, max_length=9)] = Field(description="List of flags, describing current state.  Possible flag values (locations):   * `AROUND_LOCATION` - a performer is around a location: finished relocation to the location by routing means.   * `INSIDE_LOCATION` - a performer is inside a location considering arrival and departure time.  Possible flag values (time windows):   * `INSIDE_WORKING_WINDOW` - a performer is inside a formal working shift window from the input task.   * `INSIDE_LOCATION_WINDOW` - a performer is inside an availability window of a location.   * `INSIDE_EVENT_HARD_WINDOW` - a performer is inside the hard window of an event.   * `INSIDE_EVENT_SOFT_WINDOW` - a performer is inside the soft window of an event.  Possible flag values (work states):   * `ON_DEMAND` - a performer is working on a demand.   * `WAITING` - a performer is waiting.         * `RELOCATING` - a performer is relocating.   * `BREAK` - the performer is on a break. ")
    cargo_placements: Optional[Annotated[List[CargoPlacement], Field(min_length=0, max_length=1000)]] = Field(default=None, description="List of cargo placements in transport at the beginning of the state.")
    attributes: Optional[Annotated[List[Attribute], Field(min_length=0, max_length=1000)]] = Field(default=None, description="Attributes. Used to add service information.")
    __properties = ["time", "order_key", "demand_key", "event_key", "location_key", "flags", "cargo_placements", "attributes"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TripState:
        """Create an instance of TripState from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in cargo_placements (list)
        _items = []
        if self.cargo_placements:
            for _item in self.cargo_placements:
                if _item:
                    _items.append(_item.to_dict())
            _dict['cargo_placements'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item in self.attributes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attributes'] = _items
        # set to None if order_key (nullable) is None
        # and __fields_set__ contains the field
        if self.order_key is None and "order_key" in self.__fields_set__:
            _dict['order_key'] = None

        # set to None if demand_key (nullable) is None
        # and __fields_set__ contains the field
        if self.demand_key is None and "demand_key" in self.__fields_set__:
            _dict['demand_key'] = None

        # set to None if event_key (nullable) is None
        # and __fields_set__ contains the field
        if self.event_key is None and "event_key" in self.__fields_set__:
            _dict['event_key'] = None

        # set to None if location_key (nullable) is None
        # and __fields_set__ contains the field
        if self.location_key is None and "location_key" in self.__fields_set__:
            _dict['location_key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TripState:
        """Create an instance of TripState from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TripState.parse_obj(obj)

        _obj = TripState.parse_obj({
            "time": obj.get("time"),
            "order_key": obj.get("order_key"),
            "demand_key": obj.get("demand_key"),
            "event_key": obj.get("event_key"),
            "location_key": obj.get("location_key"),
            "flags": obj.get("flags"),
            "cargo_placements": [CargoPlacement.from_dict(_item) for _item in obj.get("cargo_placements")] if obj.get("cargo_placements") is not None else None,
            "attributes": [Attribute.from_dict(_item) for _item in obj.get("attributes")] if obj.get("attributes") is not None else None
        })
        return _obj


