# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.18.2232
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List
from pydantic import BaseModel

class VersionResult(BaseModel):
    """
    Service version.  # noqa: E501
    """
    major: Annotated[int, Field(le=100, strict=True, ge=1)] = Field(description="Product version. Within a single version, compatibility of common data structures between services is guaranteed. A version change indicates changes that are incompatible with previous versions of the product (and all services). ")
    minor: Annotated[int, Field(le=111, strict=True, ge=0)] = Field(description="Minor version of the service. A version change indicates new functionality. The update is backward compatible with the major version of the service. ")
    build: Annotated[str, Field(min_length=1, strict=True, max_length=64)] = Field(description="Build version.       Contains backwards compatible bug fixes and docs update. ")
    __properties = ["major", "minor", "build"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VersionResult:
        """Create an instance of VersionResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VersionResult:
        """Create an instance of VersionResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return VersionResult.parse_obj(obj)

        _obj = VersionResult.parse_obj({
            "major": obj.get("major"),
            "minor": obj.get("minor"),
            "build": obj.get("build")
        })
        return _obj


