# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.18.2232
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, field_validator
from vrt_lss_studio.models.geopoint import Geopoint

class Waypoint(BaseModel):
    """
    Waypoint.   # noqa: E501
    """
    name: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=1024)]] = Field(default=None, description="Name of the point.")
    geopoint: Geopoint
    duration: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default='PT0S', description="Time duration according to [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). ")
    __properties = ["name", "geopoint", "duration"]

    @validator('duration')
    def duration_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Waypoint:
        """Create an instance of Waypoint from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of geopoint
        if self.geopoint:
            _dict['geopoint'] = self.geopoint.to_dict()
        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Waypoint:
        """Create an instance of Waypoint from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Waypoint.parse_obj(obj)

        _obj = Waypoint.parse_obj({
            "name": obj.get("name"),
            "geopoint": Geopoint.from_dict(obj.get("geopoint")) if obj.get("geopoint") is not None else None,
            "duration": obj.get("duration") if obj.get("duration") is not None else 'PT0S'
        })
        return _obj


