# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.18.2232
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel
from vrt_lss_studio.models.geopoint import Geopoint

class WebTripTrack(BaseModel):
    """
    Track for map.  # noqa: E501
    """
    geopoints: Annotated[List[Geopoint], Field(min_length=0, max_length=1000000)] = Field(description="Array of geographical points describing the route.")
    trip_key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Trip key, unique identifier.")
    trip_name: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=64)]] = Field(default='', description="Trip name.")
    performer_key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Performer's key.")
    performer_shift_key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Performer shift's key, unique identifier.")
    transport_key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Transport's key.")
    transport_shift_key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Transport shift's key, unique identifier.")
    __properties = ["geopoints", "trip_key", "trip_name", "performer_key", "performer_shift_key", "transport_key", "transport_shift_key"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WebTripTrack:
        """Create an instance of WebTripTrack from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in geopoints (list)
        _items = []
        if self.geopoints:
            for _item in self.geopoints:
                if _item:
                    _items.append(_item.to_dict())
            _dict['geopoints'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WebTripTrack:
        """Create an instance of WebTripTrack from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return WebTripTrack.parse_obj(obj)

        _obj = WebTripTrack.parse_obj({
            "geopoints": [Geopoint.from_dict(_item) for _item in obj.get("geopoints")] if obj.get("geopoints") is not None else None,
            "trip_key": obj.get("trip_key"),
            "trip_name": obj.get("trip_name") if obj.get("trip_name") is not None else '',
            "performer_key": obj.get("performer_key"),
            "performer_shift_key": obj.get("performer_shift_key"),
            "transport_key": obj.get("transport_key"),
            "transport_shift_key": obj.get("transport_shift_key")
        })
        return _obj


