# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetClusterPlacementGroupResult',
    'AwaitableGetClusterPlacementGroupResult',
    'get_cluster_placement_group',
    'get_cluster_placement_group_output',
]

@pulumi.output_type
class GetClusterPlacementGroupResult:
    """
    A collection of values returned by getClusterPlacementGroup.
    """
    def __init__(__self__, availability_domain=None, capabilities=None, cluster_placement_group_id=None, cluster_placement_group_type=None, compartment_id=None, defined_tags=None, description=None, freeform_tags=None, id=None, lifecycle_details=None, name=None, opc_dry_run=None, placement_instructions=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if capabilities and not isinstance(capabilities, list):
            raise TypeError("Expected argument 'capabilities' to be a list")
        pulumi.set(__self__, "capabilities", capabilities)
        if cluster_placement_group_id and not isinstance(cluster_placement_group_id, str):
            raise TypeError("Expected argument 'cluster_placement_group_id' to be a str")
        pulumi.set(__self__, "cluster_placement_group_id", cluster_placement_group_id)
        if cluster_placement_group_type and not isinstance(cluster_placement_group_type, str):
            raise TypeError("Expected argument 'cluster_placement_group_type' to be a str")
        pulumi.set(__self__, "cluster_placement_group_type", cluster_placement_group_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if opc_dry_run and not isinstance(opc_dry_run, bool):
            raise TypeError("Expected argument 'opc_dry_run' to be a bool")
        pulumi.set(__self__, "opc_dry_run", opc_dry_run)
        if placement_instructions and not isinstance(placement_instructions, list):
            raise TypeError("Expected argument 'placement_instructions' to be a list")
        pulumi.set(__self__, "placement_instructions", placement_instructions)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        The availability domain of the cluster placement group.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter
    def capabilities(self) -> Sequence['outputs.GetClusterPlacementGroupCapabilityResult']:
        """
        A list of resources that you can create in a cluster placement group.
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> builtins.str:
        return pulumi.get(self, "cluster_placement_group_id")

    @property
    @pulumi.getter(name="clusterPlacementGroupType")
    def cluster_placement_group_type(self) -> builtins.str:
        """
        The type of cluster placement group.
        """
        return pulumi.get(self, "cluster_placement_group_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the cluster placement group.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A description of the cluster placement group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, lifecycle details for a resource in a Failed state might include information to act on.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The user-friendly name of the cluster placement group. The display name for a cluster placement must be unique and you cannot change it. Avoid entering confidential information.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="opcDryRun")
    def opc_dry_run(self) -> builtins.bool:
        return pulumi.get(self, "opc_dry_run")

    @property
    @pulumi.getter(name="placementInstructions")
    def placement_instructions(self) -> Sequence['outputs.GetClusterPlacementGroupPlacementInstructionResult']:
        """
        Details that inform cluster placement group provisioning.
        """
        return pulumi.get(self, "placement_instructions")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the ClusterPlacementGroup.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the cluster placement group was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the cluster placement group was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetClusterPlacementGroupResult(GetClusterPlacementGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterPlacementGroupResult(
            availability_domain=self.availability_domain,
            capabilities=self.capabilities,
            cluster_placement_group_id=self.cluster_placement_group_id,
            cluster_placement_group_type=self.cluster_placement_group_type,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            name=self.name,
            opc_dry_run=self.opc_dry_run,
            placement_instructions=self.placement_instructions,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_cluster_placement_group(cluster_placement_group_id: Optional[builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterPlacementGroupResult:
    """
    This data source provides details about a specific Cluster Placement Group resource in Oracle Cloud Infrastructure Cluster Placement Groups service.

    Gets the specified cluster placement group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cluster_placement_group = oci.ClusterPlacementGroups.get_cluster_placement_group(cluster_placement_group_id=test_cluster_placement_group_oci_cluster_placement_groups_cluster_placement_group["id"])
    ```


    :param builtins.str cluster_placement_group_id: A unique cluster placement group identifier.
    """
    __args__ = dict()
    __args__['clusterPlacementGroupId'] = cluster_placement_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ClusterPlacementGroups/getClusterPlacementGroup:getClusterPlacementGroup', __args__, opts=opts, typ=GetClusterPlacementGroupResult).value

    return AwaitableGetClusterPlacementGroupResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        capabilities=pulumi.get(__ret__, 'capabilities'),
        cluster_placement_group_id=pulumi.get(__ret__, 'cluster_placement_group_id'),
        cluster_placement_group_type=pulumi.get(__ret__, 'cluster_placement_group_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        name=pulumi.get(__ret__, 'name'),
        opc_dry_run=pulumi.get(__ret__, 'opc_dry_run'),
        placement_instructions=pulumi.get(__ret__, 'placement_instructions'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_cluster_placement_group_output(cluster_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterPlacementGroupResult]:
    """
    This data source provides details about a specific Cluster Placement Group resource in Oracle Cloud Infrastructure Cluster Placement Groups service.

    Gets the specified cluster placement group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cluster_placement_group = oci.ClusterPlacementGroups.get_cluster_placement_group(cluster_placement_group_id=test_cluster_placement_group_oci_cluster_placement_groups_cluster_placement_group["id"])
    ```


    :param builtins.str cluster_placement_group_id: A unique cluster placement group identifier.
    """
    __args__ = dict()
    __args__['clusterPlacementGroupId'] = cluster_placement_group_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ClusterPlacementGroups/getClusterPlacementGroup:getClusterPlacementGroup', __args__, opts=opts, typ=GetClusterPlacementGroupResult)
    return __ret__.apply(lambda __response__: GetClusterPlacementGroupResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        capabilities=pulumi.get(__response__, 'capabilities'),
        cluster_placement_group_id=pulumi.get(__response__, 'cluster_placement_group_id'),
        cluster_placement_group_type=pulumi.get(__response__, 'cluster_placement_group_type'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        name=pulumi.get(__response__, 'name'),
        opc_dry_run=pulumi.get(__response__, 'opc_dry_run'),
        placement_instructions=pulumi.get(__response__, 'placement_instructions'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
