# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AddonAddonError',
    'AddonConfiguration',
    'ClusterClusterPodNetworkOption',
    'ClusterEndpoint',
    'ClusterEndpointConfig',
    'ClusterImagePolicyConfig',
    'ClusterImagePolicyConfigKeyDetail',
    'ClusterMetadata',
    'ClusterOptions',
    'ClusterOptionsAddOns',
    'ClusterOptionsAdmissionControllerOptions',
    'ClusterOptionsKubernetesNetworkConfig',
    'ClusterOptionsOpenIdConnectDiscovery',
    'ClusterOptionsOpenIdConnectTokenAuthenticationConfig',
    'ClusterOptionsOpenIdConnectTokenAuthenticationConfigRequiredClaim',
    'ClusterOptionsPersistentVolumeConfig',
    'ClusterOptionsServiceLbConfig',
    'ContainerInstanceContainer',
    'ContainerInstanceContainerHealthCheck',
    'ContainerInstanceContainerHealthCheckHeader',
    'ContainerInstanceContainerResourceConfig',
    'ContainerInstanceContainerSecurityContext',
    'ContainerInstanceContainerSecurityContextCapabilities',
    'ContainerInstanceContainerVolumeMount',
    'ContainerInstanceDnsConfig',
    'ContainerInstanceImagePullSecret',
    'ContainerInstanceShapeConfig',
    'ContainerInstanceVnic',
    'ContainerInstanceVolume',
    'ContainerInstanceVolumeConfig',
    'NodePoolInitialNodeLabel',
    'NodePoolNode',
    'NodePoolNodeConfigDetails',
    'NodePoolNodeConfigDetailsNodePoolPodNetworkOptionDetails',
    'NodePoolNodeConfigDetailsPlacementConfig',
    'NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfig',
    'NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigPreemptionAction',
    'NodePoolNodeError',
    'NodePoolNodeEvictionNodePoolSettings',
    'NodePoolNodePoolCyclingDetails',
    'NodePoolNodeShapeConfig',
    'NodePoolNodeSource',
    'NodePoolNodeSourceDetails',
    'VirtualNodePoolInitialVirtualNodeLabel',
    'VirtualNodePoolPlacementConfiguration',
    'VirtualNodePoolPodConfiguration',
    'VirtualNodePoolTaint',
    'VirtualNodePoolVirtualNodeTags',
    'GetAddonAddonErrorResult',
    'GetAddonConfigurationResult',
    'GetAddonOptionsAddonOptionResult',
    'GetAddonOptionsAddonOptionVersionResult',
    'GetAddonOptionsAddonOptionVersionConfigurationResult',
    'GetAddonOptionsAddonOptionVersionKubernetesVersionFilterResult',
    'GetAddonOptionsFilterResult',
    'GetAddonsAddonResult',
    'GetAddonsAddonAddonErrorResult',
    'GetAddonsAddonConfigurationResult',
    'GetAddonsFilterResult',
    'GetClusterClusterPodNetworkOptionResult',
    'GetClusterEndpointResult',
    'GetClusterEndpointConfigResult',
    'GetClusterImagePolicyConfigResult',
    'GetClusterImagePolicyConfigKeyDetailResult',
    'GetClusterMetadataResult',
    'GetClusterOptionResult',
    'GetClusterOptionAddOnResult',
    'GetClusterOptionAdmissionControllerOptionResult',
    'GetClusterOptionClusterPodNetworkOptionResult',
    'GetClusterOptionKubernetesNetworkConfigResult',
    'GetClusterOptionOpenIdConnectDiscoveryResult',
    'GetClusterOptionOpenIdConnectTokenAuthenticationConfigResult',
    'GetClusterOptionOpenIdConnectTokenAuthenticationConfigRequiredClaimResult',
    'GetClusterOptionPersistentVolumeConfigResult',
    'GetClusterOptionServiceLbConfigResult',
    'GetClusterWorkloadMappingsFilterResult',
    'GetClusterWorkloadMappingsWorkloadMappingResult',
    'GetClustersClusterResult',
    'GetClustersClusterClusterPodNetworkOptionResult',
    'GetClustersClusterEndpointResult',
    'GetClustersClusterEndpointConfigResult',
    'GetClustersClusterImagePolicyConfigResult',
    'GetClustersClusterImagePolicyConfigKeyDetailResult',
    'GetClustersClusterMetadataResult',
    'GetClustersClusterOptionResult',
    'GetClustersClusterOptionAddOnResult',
    'GetClustersClusterOptionAdmissionControllerOptionResult',
    'GetClustersClusterOptionKubernetesNetworkConfigResult',
    'GetClustersClusterOptionOpenIdConnectDiscoveryResult',
    'GetClustersClusterOptionOpenIdConnectTokenAuthenticationConfigResult',
    'GetClustersClusterOptionOpenIdConnectTokenAuthenticationConfigRequiredClaimResult',
    'GetClustersClusterOptionPersistentVolumeConfigResult',
    'GetClustersClusterOptionServiceLbConfigResult',
    'GetClustersFilterResult',
    'GetNodePoolInitialNodeLabelResult',
    'GetNodePoolNodeResult',
    'GetNodePoolNodeConfigDetailResult',
    'GetNodePoolNodeConfigDetailNodePoolPodNetworkOptionDetailResult',
    'GetNodePoolNodeConfigDetailPlacementConfigResult',
    'GetNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigResult',
    'GetNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigPreemptionActionResult',
    'GetNodePoolNodeErrorResult',
    'GetNodePoolNodeEvictionNodePoolSettingResult',
    'GetNodePoolNodePoolCyclingDetailResult',
    'GetNodePoolNodeShapeConfigResult',
    'GetNodePoolNodeSourceResult',
    'GetNodePoolNodeSourceDetailResult',
    'GetNodePoolOptionSourceResult',
    'GetNodePoolsFilterResult',
    'GetNodePoolsNodePoolResult',
    'GetNodePoolsNodePoolInitialNodeLabelResult',
    'GetNodePoolsNodePoolNodeResult',
    'GetNodePoolsNodePoolNodeConfigDetailResult',
    'GetNodePoolsNodePoolNodeConfigDetailNodePoolPodNetworkOptionDetailResult',
    'GetNodePoolsNodePoolNodeConfigDetailPlacementConfigResult',
    'GetNodePoolsNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigResult',
    'GetNodePoolsNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigPreemptionActionResult',
    'GetNodePoolsNodePoolNodeErrorResult',
    'GetNodePoolsNodePoolNodeEvictionNodePoolSettingResult',
    'GetNodePoolsNodePoolNodePoolCyclingDetailResult',
    'GetNodePoolsNodePoolNodeShapeConfigResult',
    'GetNodePoolsNodePoolNodeSourceResult',
    'GetNodePoolsNodePoolNodeSourceDetailResult',
    'GetPodShapesFilterResult',
    'GetPodShapesPodShapeResult',
    'GetPodShapesPodShapeMemoryOptionResult',
    'GetPodShapesPodShapeNetworkBandwidthOptionResult',
    'GetPodShapesPodShapeOcpuOptionResult',
    'GetVirtualNodePoolInitialVirtualNodeLabelResult',
    'GetVirtualNodePoolPlacementConfigurationResult',
    'GetVirtualNodePoolPodConfigurationResult',
    'GetVirtualNodePoolTaintResult',
    'GetVirtualNodePoolVirtualNodeTagResult',
    'GetVirtualNodePoolsFilterResult',
    'GetVirtualNodePoolsVirtualNodePoolResult',
    'GetVirtualNodePoolsVirtualNodePoolInitialVirtualNodeLabelResult',
    'GetVirtualNodePoolsVirtualNodePoolPlacementConfigurationResult',
    'GetVirtualNodePoolsVirtualNodePoolPodConfigurationResult',
    'GetVirtualNodePoolsVirtualNodePoolTaintResult',
    'GetVirtualNodePoolsVirtualNodePoolVirtualNodeTagResult',
    'GetWorkRequestErrorsFilterResult',
    'GetWorkRequestErrorsWorkRequestErrorResult',
    'GetWorkRequestLogEntriesFilterResult',
    'GetWorkRequestLogEntriesWorkRequestLogEntryResult',
    'GetWorkRequestsFilterResult',
    'GetWorkRequestsWorkRequestResult',
    'GetWorkRequestsWorkRequestResourceResult',
]

@pulumi.output_type
class AddonAddonError(dict):
    def __init__(__self__, *,
                 code: Optional[builtins.str] = None,
                 message: Optional[builtins.str] = None,
                 status: Optional[builtins.str] = None):
        """
        :param builtins.str code: A short error code that defines the upstream error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        :param builtins.str message: A human-readable error string of the upstream error.
        :param builtins.str status: The status of the HTTP response encountered in the upstream error.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def code(self) -> Optional[builtins.str]:
        """
        A short error code that defines the upstream error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        A human-readable error string of the upstream error.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        The status of the HTTP response encountered in the upstream error.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class AddonConfiguration(dict):
    def __init__(__self__, *,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str key: (Updatable) configuration key name
        :param builtins.str value: (Updatable) configuration value name
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        (Updatable) configuration key name
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        (Updatable) configuration value name
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ClusterClusterPodNetworkOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cniType":
            suggest = "cni_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterPodNetworkOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterPodNetworkOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterPodNetworkOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cni_type: builtins.str):
        """
        :param builtins.str cni_type: The CNI used by the node pools of this cluster
        """
        pulumi.set(__self__, "cni_type", cni_type)

    @property
    @pulumi.getter(name="cniType")
    def cni_type(self) -> builtins.str:
        """
        The CNI used by the node pools of this cluster
        """
        return pulumi.get(self, "cni_type")


@pulumi.output_type
class ClusterEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "publicEndpoint":
            suggest = "public_endpoint"
        elif key == "vcnHostnameEndpoint":
            suggest = "vcn_hostname_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipv6endpoint: Optional[builtins.str] = None,
                 kubernetes: Optional[builtins.str] = None,
                 private_endpoint: Optional[builtins.str] = None,
                 public_endpoint: Optional[builtins.str] = None,
                 vcn_hostname_endpoint: Optional[builtins.str] = None):
        """
        :param builtins.str ipv6endpoint: The IPv6 networking Kubernetes API server endpoint.
        :param builtins.str kubernetes: The non-native networking Kubernetes API server endpoint.
        :param builtins.str private_endpoint: The private native networking Kubernetes API server endpoint.
        :param builtins.str public_endpoint: The public native networking Kubernetes API server endpoint, if one was requested.
        :param builtins.str vcn_hostname_endpoint: The FQDN assigned to the Kubernetes API private endpoint. Example: 'https://yourVcnHostnameEndpoint'
        """
        if ipv6endpoint is not None:
            pulumi.set(__self__, "ipv6endpoint", ipv6endpoint)
        if kubernetes is not None:
            pulumi.set(__self__, "kubernetes", kubernetes)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if public_endpoint is not None:
            pulumi.set(__self__, "public_endpoint", public_endpoint)
        if vcn_hostname_endpoint is not None:
            pulumi.set(__self__, "vcn_hostname_endpoint", vcn_hostname_endpoint)

    @property
    @pulumi.getter
    def ipv6endpoint(self) -> Optional[builtins.str]:
        """
        The IPv6 networking Kubernetes API server endpoint.
        """
        return pulumi.get(self, "ipv6endpoint")

    @property
    @pulumi.getter
    def kubernetes(self) -> Optional[builtins.str]:
        """
        The non-native networking Kubernetes API server endpoint.
        """
        return pulumi.get(self, "kubernetes")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional[builtins.str]:
        """
        The private native networking Kubernetes API server endpoint.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> Optional[builtins.str]:
        """
        The public native networking Kubernetes API server endpoint, if one was requested.
        """
        return pulumi.get(self, "public_endpoint")

    @property
    @pulumi.getter(name="vcnHostnameEndpoint")
    def vcn_hostname_endpoint(self) -> Optional[builtins.str]:
        """
        The FQDN assigned to the Kubernetes API private endpoint. Example: 'https://yourVcnHostnameEndpoint'
        """
        return pulumi.get(self, "vcn_hostname_endpoint")


@pulumi.output_type
class ClusterEndpointConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "isPublicIpEnabled":
            suggest = "is_public_ip_enabled"
        elif key == "nsgIds":
            suggest = "nsg_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEndpointConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEndpointConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEndpointConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: builtins.str,
                 is_public_ip_enabled: Optional[builtins.bool] = None,
                 nsg_ids: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str subnet_id: The OCID of the regional subnet in which to place the Cluster endpoint.
        :param builtins.bool is_public_ip_enabled: Whether the cluster should be assigned a public IP address. Defaults to false. If set to true on a private subnet, the cluster provisioning will fail.
        :param Sequence[builtins.str] nsg_ids: A list of the OCIDs of the network security groups (NSGs) to apply to the cluster endpoint. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if is_public_ip_enabled is not None:
            pulumi.set(__self__, "is_public_ip_enabled", is_public_ip_enabled)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The OCID of the regional subnet in which to place the Cluster endpoint.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="isPublicIpEnabled")
    def is_public_ip_enabled(self) -> Optional[builtins.bool]:
        """
        Whether the cluster should be assigned a public IP address. Defaults to false. If set to true on a private subnet, the cluster provisioning will fail.
        """
        return pulumi.get(self, "is_public_ip_enabled")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of the OCIDs of the network security groups (NSGs) to apply to the cluster endpoint. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        return pulumi.get(self, "nsg_ids")


@pulumi.output_type
class ClusterImagePolicyConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isPolicyEnabled":
            suggest = "is_policy_enabled"
        elif key == "keyDetails":
            suggest = "key_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterImagePolicyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterImagePolicyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterImagePolicyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_policy_enabled: Optional[builtins.bool] = None,
                 key_details: Optional[Sequence['outputs.ClusterImagePolicyConfigKeyDetail']] = None):
        """
        :param builtins.bool is_policy_enabled: (Updatable) Whether the image verification policy is enabled. Defaults to false. If set to true, the images will be verified against the policy at runtime.
        :param Sequence['ClusterImagePolicyConfigKeyDetailArgs'] key_details: (Updatable) A list of KMS key details.
        """
        if is_policy_enabled is not None:
            pulumi.set(__self__, "is_policy_enabled", is_policy_enabled)
        if key_details is not None:
            pulumi.set(__self__, "key_details", key_details)

    @property
    @pulumi.getter(name="isPolicyEnabled")
    def is_policy_enabled(self) -> Optional[builtins.bool]:
        """
        (Updatable) Whether the image verification policy is enabled. Defaults to false. If set to true, the images will be verified against the policy at runtime.
        """
        return pulumi.get(self, "is_policy_enabled")

    @property
    @pulumi.getter(name="keyDetails")
    def key_details(self) -> Optional[Sequence['outputs.ClusterImagePolicyConfigKeyDetail']]:
        """
        (Updatable) A list of KMS key details.
        """
        return pulumi.get(self, "key_details")


@pulumi.output_type
class ClusterImagePolicyConfigKeyDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterImagePolicyConfigKeyDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterImagePolicyConfigKeyDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterImagePolicyConfigKeyDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: Optional[builtins.str] = None):
        """
        :param builtins.str kms_key_id: (Updatable) The OCIDs of the KMS key that will be used to verify whether the images are signed by an approved source.
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[builtins.str]:
        """
        (Updatable) The OCIDs of the KMS key that will be used to verify whether the images are signed by an approved source.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class ClusterMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdByUserId":
            suggest = "created_by_user_id"
        elif key == "createdByWorkRequestId":
            suggest = "created_by_work_request_id"
        elif key == "deletedByUserId":
            suggest = "deleted_by_user_id"
        elif key == "deletedByWorkRequestId":
            suggest = "deleted_by_work_request_id"
        elif key == "timeCreated":
            suggest = "time_created"
        elif key == "timeCredentialExpiration":
            suggest = "time_credential_expiration"
        elif key == "timeDeleted":
            suggest = "time_deleted"
        elif key == "timeUpdated":
            suggest = "time_updated"
        elif key == "updatedByUserId":
            suggest = "updated_by_user_id"
        elif key == "updatedByWorkRequestId":
            suggest = "updated_by_work_request_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_by_user_id: Optional[builtins.str] = None,
                 created_by_work_request_id: Optional[builtins.str] = None,
                 deleted_by_user_id: Optional[builtins.str] = None,
                 deleted_by_work_request_id: Optional[builtins.str] = None,
                 time_created: Optional[builtins.str] = None,
                 time_credential_expiration: Optional[builtins.str] = None,
                 time_deleted: Optional[builtins.str] = None,
                 time_updated: Optional[builtins.str] = None,
                 updated_by_user_id: Optional[builtins.str] = None,
                 updated_by_work_request_id: Optional[builtins.str] = None):
        """
        :param builtins.str created_by_user_id: The user who created the cluster.
        :param builtins.str created_by_work_request_id: The OCID of the work request which created the cluster.
        :param builtins.str deleted_by_user_id: The user who deleted the cluster.
        :param builtins.str deleted_by_work_request_id: The OCID of the work request which deleted the cluster.
        :param builtins.str time_created: The time the cluster was created.
        :param builtins.str time_credential_expiration: The time until which the cluster credential is valid.
        :param builtins.str time_deleted: The time the cluster was deleted.
        :param builtins.str time_updated: The time the cluster was updated.
        :param builtins.str updated_by_user_id: The user who updated the cluster.
        :param builtins.str updated_by_work_request_id: The OCID of the work request which updated the cluster.
        """
        if created_by_user_id is not None:
            pulumi.set(__self__, "created_by_user_id", created_by_user_id)
        if created_by_work_request_id is not None:
            pulumi.set(__self__, "created_by_work_request_id", created_by_work_request_id)
        if deleted_by_user_id is not None:
            pulumi.set(__self__, "deleted_by_user_id", deleted_by_user_id)
        if deleted_by_work_request_id is not None:
            pulumi.set(__self__, "deleted_by_work_request_id", deleted_by_work_request_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_credential_expiration is not None:
            pulumi.set(__self__, "time_credential_expiration", time_credential_expiration)
        if time_deleted is not None:
            pulumi.set(__self__, "time_deleted", time_deleted)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if updated_by_user_id is not None:
            pulumi.set(__self__, "updated_by_user_id", updated_by_user_id)
        if updated_by_work_request_id is not None:
            pulumi.set(__self__, "updated_by_work_request_id", updated_by_work_request_id)

    @property
    @pulumi.getter(name="createdByUserId")
    def created_by_user_id(self) -> Optional[builtins.str]:
        """
        The user who created the cluster.
        """
        return pulumi.get(self, "created_by_user_id")

    @property
    @pulumi.getter(name="createdByWorkRequestId")
    def created_by_work_request_id(self) -> Optional[builtins.str]:
        """
        The OCID of the work request which created the cluster.
        """
        return pulumi.get(self, "created_by_work_request_id")

    @property
    @pulumi.getter(name="deletedByUserId")
    def deleted_by_user_id(self) -> Optional[builtins.str]:
        """
        The user who deleted the cluster.
        """
        return pulumi.get(self, "deleted_by_user_id")

    @property
    @pulumi.getter(name="deletedByWorkRequestId")
    def deleted_by_work_request_id(self) -> Optional[builtins.str]:
        """
        The OCID of the work request which deleted the cluster.
        """
        return pulumi.get(self, "deleted_by_work_request_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[builtins.str]:
        """
        The time the cluster was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeCredentialExpiration")
    def time_credential_expiration(self) -> Optional[builtins.str]:
        """
        The time until which the cluster credential is valid.
        """
        return pulumi.get(self, "time_credential_expiration")

    @property
    @pulumi.getter(name="timeDeleted")
    def time_deleted(self) -> Optional[builtins.str]:
        """
        The time the cluster was deleted.
        """
        return pulumi.get(self, "time_deleted")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[builtins.str]:
        """
        The time the cluster was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="updatedByUserId")
    def updated_by_user_id(self) -> Optional[builtins.str]:
        """
        The user who updated the cluster.
        """
        return pulumi.get(self, "updated_by_user_id")

    @property
    @pulumi.getter(name="updatedByWorkRequestId")
    def updated_by_work_request_id(self) -> Optional[builtins.str]:
        """
        The OCID of the work request which updated the cluster.
        """
        return pulumi.get(self, "updated_by_work_request_id")


@pulumi.output_type
class ClusterOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addOns":
            suggest = "add_ons"
        elif key == "admissionControllerOptions":
            suggest = "admission_controller_options"
        elif key == "ipFamilies":
            suggest = "ip_families"
        elif key == "kubernetesNetworkConfig":
            suggest = "kubernetes_network_config"
        elif key == "openIdConnectDiscovery":
            suggest = "open_id_connect_discovery"
        elif key == "openIdConnectTokenAuthenticationConfig":
            suggest = "open_id_connect_token_authentication_config"
        elif key == "persistentVolumeConfig":
            suggest = "persistent_volume_config"
        elif key == "serviceLbConfig":
            suggest = "service_lb_config"
        elif key == "serviceLbSubnetIds":
            suggest = "service_lb_subnet_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 add_ons: Optional['outputs.ClusterOptionsAddOns'] = None,
                 admission_controller_options: Optional['outputs.ClusterOptionsAdmissionControllerOptions'] = None,
                 ip_families: Optional[Sequence[builtins.str]] = None,
                 kubernetes_network_config: Optional['outputs.ClusterOptionsKubernetesNetworkConfig'] = None,
                 open_id_connect_discovery: Optional['outputs.ClusterOptionsOpenIdConnectDiscovery'] = None,
                 open_id_connect_token_authentication_config: Optional['outputs.ClusterOptionsOpenIdConnectTokenAuthenticationConfig'] = None,
                 persistent_volume_config: Optional['outputs.ClusterOptionsPersistentVolumeConfig'] = None,
                 service_lb_config: Optional['outputs.ClusterOptionsServiceLbConfig'] = None,
                 service_lb_subnet_ids: Optional[Sequence[builtins.str]] = None):
        """
        :param 'ClusterOptionsAddOnsArgs' add_ons: Configurable cluster add-ons
        :param 'ClusterOptionsAdmissionControllerOptionsArgs' admission_controller_options: (Updatable) Configurable cluster admission controllers
        :param Sequence[builtins.str] ip_families: IP family to use for single stack or define the order of IP families for dual-stack. Available values are [] (defaults to IPv4), [IPv4] (IPv4), [IPv4, IPv6] (IPv4 preferred dual stack).
        :param 'ClusterOptionsKubernetesNetworkConfigArgs' kubernetes_network_config: Network configuration for Kubernetes.
        :param 'ClusterOptionsOpenIdConnectDiscoveryArgs' open_id_connect_discovery: (Updatable) The property that define the status of the OIDC Discovery feature for a cluster.
        :param 'ClusterOptionsOpenIdConnectTokenAuthenticationConfigArgs' open_id_connect_token_authentication_config: (Updatable) The properties that configure OIDC token authentication in kube-apiserver. For more information, see [Configuring the API Server](https://kubernetes.io/docs/reference/access-authn-authz/authentication/#using-flags).
        :param 'ClusterOptionsPersistentVolumeConfigArgs' persistent_volume_config: (Updatable) Configuration to be applied to block volumes created by Kubernetes Persistent Volume Claims (PVC)
        :param 'ClusterOptionsServiceLbConfigArgs' service_lb_config: (Updatable) Configuration to be applied to load balancers created by Kubernetes services
        :param Sequence[builtins.str] service_lb_subnet_ids: The OCIDs of the subnets used for Kubernetes services load balancers.
        """
        if add_ons is not None:
            pulumi.set(__self__, "add_ons", add_ons)
        if admission_controller_options is not None:
            pulumi.set(__self__, "admission_controller_options", admission_controller_options)
        if ip_families is not None:
            pulumi.set(__self__, "ip_families", ip_families)
        if kubernetes_network_config is not None:
            pulumi.set(__self__, "kubernetes_network_config", kubernetes_network_config)
        if open_id_connect_discovery is not None:
            pulumi.set(__self__, "open_id_connect_discovery", open_id_connect_discovery)
        if open_id_connect_token_authentication_config is not None:
            pulumi.set(__self__, "open_id_connect_token_authentication_config", open_id_connect_token_authentication_config)
        if persistent_volume_config is not None:
            pulumi.set(__self__, "persistent_volume_config", persistent_volume_config)
        if service_lb_config is not None:
            pulumi.set(__self__, "service_lb_config", service_lb_config)
        if service_lb_subnet_ids is not None:
            pulumi.set(__self__, "service_lb_subnet_ids", service_lb_subnet_ids)

    @property
    @pulumi.getter(name="addOns")
    def add_ons(self) -> Optional['outputs.ClusterOptionsAddOns']:
        """
        Configurable cluster add-ons
        """
        return pulumi.get(self, "add_ons")

    @property
    @pulumi.getter(name="admissionControllerOptions")
    def admission_controller_options(self) -> Optional['outputs.ClusterOptionsAdmissionControllerOptions']:
        """
        (Updatable) Configurable cluster admission controllers
        """
        return pulumi.get(self, "admission_controller_options")

    @property
    @pulumi.getter(name="ipFamilies")
    def ip_families(self) -> Optional[Sequence[builtins.str]]:
        """
        IP family to use for single stack or define the order of IP families for dual-stack. Available values are [] (defaults to IPv4), [IPv4] (IPv4), [IPv4, IPv6] (IPv4 preferred dual stack).
        """
        return pulumi.get(self, "ip_families")

    @property
    @pulumi.getter(name="kubernetesNetworkConfig")
    def kubernetes_network_config(self) -> Optional['outputs.ClusterOptionsKubernetesNetworkConfig']:
        """
        Network configuration for Kubernetes.
        """
        return pulumi.get(self, "kubernetes_network_config")

    @property
    @pulumi.getter(name="openIdConnectDiscovery")
    def open_id_connect_discovery(self) -> Optional['outputs.ClusterOptionsOpenIdConnectDiscovery']:
        """
        (Updatable) The property that define the status of the OIDC Discovery feature for a cluster.
        """
        return pulumi.get(self, "open_id_connect_discovery")

    @property
    @pulumi.getter(name="openIdConnectTokenAuthenticationConfig")
    def open_id_connect_token_authentication_config(self) -> Optional['outputs.ClusterOptionsOpenIdConnectTokenAuthenticationConfig']:
        """
        (Updatable) The properties that configure OIDC token authentication in kube-apiserver. For more information, see [Configuring the API Server](https://kubernetes.io/docs/reference/access-authn-authz/authentication/#using-flags).
        """
        return pulumi.get(self, "open_id_connect_token_authentication_config")

    @property
    @pulumi.getter(name="persistentVolumeConfig")
    def persistent_volume_config(self) -> Optional['outputs.ClusterOptionsPersistentVolumeConfig']:
        """
        (Updatable) Configuration to be applied to block volumes created by Kubernetes Persistent Volume Claims (PVC)
        """
        return pulumi.get(self, "persistent_volume_config")

    @property
    @pulumi.getter(name="serviceLbConfig")
    def service_lb_config(self) -> Optional['outputs.ClusterOptionsServiceLbConfig']:
        """
        (Updatable) Configuration to be applied to load balancers created by Kubernetes services
        """
        return pulumi.get(self, "service_lb_config")

    @property
    @pulumi.getter(name="serviceLbSubnetIds")
    def service_lb_subnet_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The OCIDs of the subnets used for Kubernetes services load balancers.
        """
        return pulumi.get(self, "service_lb_subnet_ids")


@pulumi.output_type
class ClusterOptionsAddOns(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isKubernetesDashboardEnabled":
            suggest = "is_kubernetes_dashboard_enabled"
        elif key == "isTillerEnabled":
            suggest = "is_tiller_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOptionsAddOns. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOptionsAddOns.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOptionsAddOns.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_kubernetes_dashboard_enabled: Optional[builtins.bool] = None,
                 is_tiller_enabled: Optional[builtins.bool] = None):
        """
        :param builtins.bool is_kubernetes_dashboard_enabled: Whether or not to enable the Kubernetes Dashboard add-on.
        :param builtins.bool is_tiller_enabled: Whether or not to enable the Tiller add-on.
        """
        if is_kubernetes_dashboard_enabled is not None:
            pulumi.set(__self__, "is_kubernetes_dashboard_enabled", is_kubernetes_dashboard_enabled)
        if is_tiller_enabled is not None:
            pulumi.set(__self__, "is_tiller_enabled", is_tiller_enabled)

    @property
    @pulumi.getter(name="isKubernetesDashboardEnabled")
    def is_kubernetes_dashboard_enabled(self) -> Optional[builtins.bool]:
        """
        Whether or not to enable the Kubernetes Dashboard add-on.
        """
        return pulumi.get(self, "is_kubernetes_dashboard_enabled")

    @property
    @pulumi.getter(name="isTillerEnabled")
    def is_tiller_enabled(self) -> Optional[builtins.bool]:
        """
        Whether or not to enable the Tiller add-on.
        """
        return pulumi.get(self, "is_tiller_enabled")


@pulumi.output_type
class ClusterOptionsAdmissionControllerOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isPodSecurityPolicyEnabled":
            suggest = "is_pod_security_policy_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOptionsAdmissionControllerOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOptionsAdmissionControllerOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOptionsAdmissionControllerOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_pod_security_policy_enabled: Optional[builtins.bool] = None):
        """
        :param builtins.bool is_pod_security_policy_enabled: (Updatable) Whether or not to enable the Pod Security Policy admission controller.
        """
        if is_pod_security_policy_enabled is not None:
            pulumi.set(__self__, "is_pod_security_policy_enabled", is_pod_security_policy_enabled)

    @property
    @pulumi.getter(name="isPodSecurityPolicyEnabled")
    def is_pod_security_policy_enabled(self) -> Optional[builtins.bool]:
        """
        (Updatable) Whether or not to enable the Pod Security Policy admission controller.
        """
        return pulumi.get(self, "is_pod_security_policy_enabled")


@pulumi.output_type
class ClusterOptionsKubernetesNetworkConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "podsCidr":
            suggest = "pods_cidr"
        elif key == "servicesCidr":
            suggest = "services_cidr"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOptionsKubernetesNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOptionsKubernetesNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOptionsKubernetesNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pods_cidr: Optional[builtins.str] = None,
                 services_cidr: Optional[builtins.str] = None):
        """
        :param builtins.str pods_cidr: The CIDR block for Kubernetes pods. Optional. For ipv4, defaults to 10.244.0.0/16. For ipv6, defaults to fd00:eeee:eeee:0000::/96.
        :param builtins.str services_cidr: The CIDR block for Kubernetes services. Optional. For ipv4, defaults to 10.96.0.0/16. For ipv6, defaults to fd00:eeee:eeee:0001::/108.
        """
        if pods_cidr is not None:
            pulumi.set(__self__, "pods_cidr", pods_cidr)
        if services_cidr is not None:
            pulumi.set(__self__, "services_cidr", services_cidr)

    @property
    @pulumi.getter(name="podsCidr")
    def pods_cidr(self) -> Optional[builtins.str]:
        """
        The CIDR block for Kubernetes pods. Optional. For ipv4, defaults to 10.244.0.0/16. For ipv6, defaults to fd00:eeee:eeee:0000::/96.
        """
        return pulumi.get(self, "pods_cidr")

    @property
    @pulumi.getter(name="servicesCidr")
    def services_cidr(self) -> Optional[builtins.str]:
        """
        The CIDR block for Kubernetes services. Optional. For ipv4, defaults to 10.96.0.0/16. For ipv6, defaults to fd00:eeee:eeee:0001::/108.
        """
        return pulumi.get(self, "services_cidr")


@pulumi.output_type
class ClusterOptionsOpenIdConnectDiscovery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isOpenIdConnectDiscoveryEnabled":
            suggest = "is_open_id_connect_discovery_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOptionsOpenIdConnectDiscovery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOptionsOpenIdConnectDiscovery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOptionsOpenIdConnectDiscovery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_open_id_connect_discovery_enabled: Optional[builtins.bool] = None):
        """
        :param builtins.bool is_open_id_connect_discovery_enabled: (Updatable) Whether the cluster has OIDC Discovery enabled. Defaults to false. If set to true, the cluster will be assigned a public OIDC Discovery endpoint.
        """
        if is_open_id_connect_discovery_enabled is not None:
            pulumi.set(__self__, "is_open_id_connect_discovery_enabled", is_open_id_connect_discovery_enabled)

    @property
    @pulumi.getter(name="isOpenIdConnectDiscoveryEnabled")
    def is_open_id_connect_discovery_enabled(self) -> Optional[builtins.bool]:
        """
        (Updatable) Whether the cluster has OIDC Discovery enabled. Defaults to false. If set to true, the cluster will be assigned a public OIDC Discovery endpoint.
        """
        return pulumi.get(self, "is_open_id_connect_discovery_enabled")


@pulumi.output_type
class ClusterOptionsOpenIdConnectTokenAuthenticationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isOpenIdConnectAuthEnabled":
            suggest = "is_open_id_connect_auth_enabled"
        elif key == "caCertificate":
            suggest = "ca_certificate"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "configurationFile":
            suggest = "configuration_file"
        elif key == "groupsClaim":
            suggest = "groups_claim"
        elif key == "groupsPrefix":
            suggest = "groups_prefix"
        elif key == "issuerUrl":
            suggest = "issuer_url"
        elif key == "requiredClaims":
            suggest = "required_claims"
        elif key == "signingAlgorithms":
            suggest = "signing_algorithms"
        elif key == "usernameClaim":
            suggest = "username_claim"
        elif key == "usernamePrefix":
            suggest = "username_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOptionsOpenIdConnectTokenAuthenticationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOptionsOpenIdConnectTokenAuthenticationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOptionsOpenIdConnectTokenAuthenticationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_open_id_connect_auth_enabled: builtins.bool,
                 ca_certificate: Optional[builtins.str] = None,
                 client_id: Optional[builtins.str] = None,
                 configuration_file: Optional[builtins.str] = None,
                 groups_claim: Optional[builtins.str] = None,
                 groups_prefix: Optional[builtins.str] = None,
                 issuer_url: Optional[builtins.str] = None,
                 required_claims: Optional[Sequence['outputs.ClusterOptionsOpenIdConnectTokenAuthenticationConfigRequiredClaim']] = None,
                 signing_algorithms: Optional[Sequence[builtins.str]] = None,
                 username_claim: Optional[builtins.str] = None,
                 username_prefix: Optional[builtins.str] = None):
        """
        :param builtins.bool is_open_id_connect_auth_enabled: (Updatable) Whether the cluster has OIDC Auth Config enabled. Defaults to false.
        :param builtins.str ca_certificate: (Updatable) A Base64 encoded public RSA or ECDSA certificates used to signed your identity provider's web certificate.
        :param builtins.str client_id: (Updatable) A client id that all tokens must be issued for.
        :param builtins.str configuration_file: (Updatable) A Base64 encoded string of a Kubernetes OIDC Auth Config file. More info [here](https://kubernetes.io/docs/reference/access-authn-authz/authentication/#using-authentication-configuration)
        :param builtins.str groups_claim: (Updatable) JWT claim to use as the user's group. If the claim is present it must be an array of strings.
        :param builtins.str groups_prefix: (Updatable) Prefix prepended to group claims to prevent clashes with existing names (such as system:groups).
        :param builtins.str issuer_url: (Updatable) URL of the provider that allows the API server to discover public signing keys.  Only URLs that use the https:// scheme are accepted. This is typically the provider's discovery URL,  changed to have an empty path.
        :param Sequence['ClusterOptionsOpenIdConnectTokenAuthenticationConfigRequiredClaimArgs'] required_claims: (Updatable) A key=value pair that describes a required claim in the ID Token. If set, the claim is verified to be present  in the ID Token with a matching value. Repeat this flag to specify multiple claims.
        :param Sequence[builtins.str] signing_algorithms: (Updatable) The signing algorithms accepted. Default is ["RS256"].
        :param builtins.str username_claim: (Updatable) JWT claim to use as the user name. By default sub, which is expected to be a unique identifier of the end  user. Admins can choose other claims, such as email or name, depending on their provider. However, claims  other than email will be prefixed with the issuer URL to prevent naming clashes with other plugins.
        :param builtins.str username_prefix: (Updatable) Prefix prepended to username claims to prevent clashes with existing names (such as system:users).  For example, the value oidc: will create usernames like oidc:jane.doe. If this flag isn't provided and  --oidc-username-claim is a value other than email the prefix defaults to ( Issuer URL )# where  ( Issuer URL ) is the value of --oidc-issuer-url. The value - can be used to disable all prefixing.
        """
        pulumi.set(__self__, "is_open_id_connect_auth_enabled", is_open_id_connect_auth_enabled)
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if configuration_file is not None:
            pulumi.set(__self__, "configuration_file", configuration_file)
        if groups_claim is not None:
            pulumi.set(__self__, "groups_claim", groups_claim)
        if groups_prefix is not None:
            pulumi.set(__self__, "groups_prefix", groups_prefix)
        if issuer_url is not None:
            pulumi.set(__self__, "issuer_url", issuer_url)
        if required_claims is not None:
            pulumi.set(__self__, "required_claims", required_claims)
        if signing_algorithms is not None:
            pulumi.set(__self__, "signing_algorithms", signing_algorithms)
        if username_claim is not None:
            pulumi.set(__self__, "username_claim", username_claim)
        if username_prefix is not None:
            pulumi.set(__self__, "username_prefix", username_prefix)

    @property
    @pulumi.getter(name="isOpenIdConnectAuthEnabled")
    def is_open_id_connect_auth_enabled(self) -> builtins.bool:
        """
        (Updatable) Whether the cluster has OIDC Auth Config enabled. Defaults to false.
        """
        return pulumi.get(self, "is_open_id_connect_auth_enabled")

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[builtins.str]:
        """
        (Updatable) A Base64 encoded public RSA or ECDSA certificates used to signed your identity provider's web certificate.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[builtins.str]:
        """
        (Updatable) A client id that all tokens must be issued for.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="configurationFile")
    def configuration_file(self) -> Optional[builtins.str]:
        """
        (Updatable) A Base64 encoded string of a Kubernetes OIDC Auth Config file. More info [here](https://kubernetes.io/docs/reference/access-authn-authz/authentication/#using-authentication-configuration)
        """
        return pulumi.get(self, "configuration_file")

    @property
    @pulumi.getter(name="groupsClaim")
    def groups_claim(self) -> Optional[builtins.str]:
        """
        (Updatable) JWT claim to use as the user's group. If the claim is present it must be an array of strings.
        """
        return pulumi.get(self, "groups_claim")

    @property
    @pulumi.getter(name="groupsPrefix")
    def groups_prefix(self) -> Optional[builtins.str]:
        """
        (Updatable) Prefix prepended to group claims to prevent clashes with existing names (such as system:groups).
        """
        return pulumi.get(self, "groups_prefix")

    @property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> Optional[builtins.str]:
        """
        (Updatable) URL of the provider that allows the API server to discover public signing keys.  Only URLs that use the https:// scheme are accepted. This is typically the provider's discovery URL,  changed to have an empty path.
        """
        return pulumi.get(self, "issuer_url")

    @property
    @pulumi.getter(name="requiredClaims")
    def required_claims(self) -> Optional[Sequence['outputs.ClusterOptionsOpenIdConnectTokenAuthenticationConfigRequiredClaim']]:
        """
        (Updatable) A key=value pair that describes a required claim in the ID Token. If set, the claim is verified to be present  in the ID Token with a matching value. Repeat this flag to specify multiple claims.
        """
        return pulumi.get(self, "required_claims")

    @property
    @pulumi.getter(name="signingAlgorithms")
    def signing_algorithms(self) -> Optional[Sequence[builtins.str]]:
        """
        (Updatable) The signing algorithms accepted. Default is ["RS256"].
        """
        return pulumi.get(self, "signing_algorithms")

    @property
    @pulumi.getter(name="usernameClaim")
    def username_claim(self) -> Optional[builtins.str]:
        """
        (Updatable) JWT claim to use as the user name. By default sub, which is expected to be a unique identifier of the end  user. Admins can choose other claims, such as email or name, depending on their provider. However, claims  other than email will be prefixed with the issuer URL to prevent naming clashes with other plugins.
        """
        return pulumi.get(self, "username_claim")

    @property
    @pulumi.getter(name="usernamePrefix")
    def username_prefix(self) -> Optional[builtins.str]:
        """
        (Updatable) Prefix prepended to username claims to prevent clashes with existing names (such as system:users).  For example, the value oidc: will create usernames like oidc:jane.doe. If this flag isn't provided and  --oidc-username-claim is a value other than email the prefix defaults to ( Issuer URL )# where  ( Issuer URL ) is the value of --oidc-issuer-url. The value - can be used to disable all prefixing.
        """
        return pulumi.get(self, "username_prefix")


@pulumi.output_type
class ClusterOptionsOpenIdConnectTokenAuthenticationConfigRequiredClaim(dict):
    def __init__(__self__, *,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str key: (Updatable) The key of the pair.
        :param builtins.str value: (Updatable) The value of the pair.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        (Updatable) The key of the pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        (Updatable) The value of the pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ClusterOptionsPersistentVolumeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "definedTags":
            suggest = "defined_tags"
        elif key == "freeformTags":
            suggest = "freeform_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOptionsPersistentVolumeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOptionsPersistentVolumeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOptionsPersistentVolumeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 defined_tags: Optional[Mapping[str, builtins.str]] = None,
                 freeform_tags: Optional[Mapping[str, builtins.str]] = None):
        """
        :param Mapping[str, builtins.str] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, builtins.str] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")


@pulumi.output_type
class ClusterOptionsServiceLbConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "definedTags":
            suggest = "defined_tags"
        elif key == "freeformTags":
            suggest = "freeform_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOptionsServiceLbConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOptionsServiceLbConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOptionsServiceLbConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 defined_tags: Optional[Mapping[str, builtins.str]] = None,
                 freeform_tags: Optional[Mapping[str, builtins.str]] = None):
        """
        :param Mapping[str, builtins.str] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, builtins.str] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")


@pulumi.output_type
class ContainerInstanceContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageUrl":
            suggest = "image_url"
        elif key == "availabilityDomain":
            suggest = "availability_domain"
        elif key == "compartmentId":
            suggest = "compartment_id"
        elif key == "containerId":
            suggest = "container_id"
        elif key == "containerInstanceId":
            suggest = "container_instance_id"
        elif key == "definedTags":
            suggest = "defined_tags"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "exitCode":
            suggest = "exit_code"
        elif key == "faultDomain":
            suggest = "fault_domain"
        elif key == "freeformTags":
            suggest = "freeform_tags"
        elif key == "healthChecks":
            suggest = "health_checks"
        elif key == "isResourcePrincipalDisabled":
            suggest = "is_resource_principal_disabled"
        elif key == "lifecycleDetails":
            suggest = "lifecycle_details"
        elif key == "resourceConfig":
            suggest = "resource_config"
        elif key == "securityContext":
            suggest = "security_context"
        elif key == "systemTags":
            suggest = "system_tags"
        elif key == "timeCreated":
            suggest = "time_created"
        elif key == "timeTerminated":
            suggest = "time_terminated"
        elif key == "timeUpdated":
            suggest = "time_updated"
        elif key == "volumeMounts":
            suggest = "volume_mounts"
        elif key == "workingDirectory":
            suggest = "working_directory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerInstanceContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerInstanceContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerInstanceContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_url: builtins.str,
                 arguments: Optional[Sequence[builtins.str]] = None,
                 availability_domain: Optional[builtins.str] = None,
                 commands: Optional[Sequence[builtins.str]] = None,
                 compartment_id: Optional[builtins.str] = None,
                 container_id: Optional[builtins.str] = None,
                 container_instance_id: Optional[builtins.str] = None,
                 defined_tags: Optional[Mapping[str, builtins.str]] = None,
                 display_name: Optional[builtins.str] = None,
                 environment_variables: Optional[Mapping[str, builtins.str]] = None,
                 exit_code: Optional[builtins.int] = None,
                 fault_domain: Optional[builtins.str] = None,
                 freeform_tags: Optional[Mapping[str, builtins.str]] = None,
                 health_checks: Optional[Sequence['outputs.ContainerInstanceContainerHealthCheck']] = None,
                 is_resource_principal_disabled: Optional[builtins.bool] = None,
                 lifecycle_details: Optional[builtins.str] = None,
                 resource_config: Optional['outputs.ContainerInstanceContainerResourceConfig'] = None,
                 security_context: Optional['outputs.ContainerInstanceContainerSecurityContext'] = None,
                 state: Optional[builtins.str] = None,
                 system_tags: Optional[Mapping[str, builtins.str]] = None,
                 time_created: Optional[builtins.str] = None,
                 time_terminated: Optional[builtins.str] = None,
                 time_updated: Optional[builtins.str] = None,
                 volume_mounts: Optional[Sequence['outputs.ContainerInstanceContainerVolumeMount']] = None,
                 working_directory: Optional[builtins.str] = None):
        """
        :param builtins.str image_url: A URL identifying the image that the container runs in, such as docker.io/library/busybox:latest. If you do not provide a tag, the tag will default to latest.
               
               If no registry is provided, will default the registry to public docker hub `docker.io/library`.
               
               The registry used for container image must be reachable over the Container Instance's VNIC.
        :param Sequence[builtins.str] arguments: A list of string arguments for a container's ENTRYPOINT process.
               
               Many containers use an ENTRYPOINT process pointing to a shell (/bin/bash). For those containers, this argument list specifies the main command in the container process.
               
               The total size of all arguments combined must be 64 KB or smaller.
        :param builtins.str availability_domain: The availability domain where the container instance runs.
        :param Sequence[builtins.str] commands: An optional command that overrides the ENTRYPOINT process. If you do not provide a value, the existing ENTRYPOINT process defined in the image is used.
        :param builtins.str compartment_id: (Updatable) The compartment OCID.
        :param builtins.str container_id: The OCID of the container.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`.
        :param builtins.str display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information. If you don't provide a name, a name is generated automatically.
        :param Mapping[str, builtins.str] environment_variables: A map of additional environment variables to set in the environment of the container's ENTRYPOINT process. These variables are in addition to any variables already defined in the container's image.
               
               The total size of all environment variables combined, name and values, must be 64 KB or smaller.
        :param builtins.str fault_domain: The fault domain where the container instance runs.
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param Sequence['ContainerInstanceContainerHealthCheckArgs'] health_checks: list of container health checks to check container status and take appropriate action if container status is failed. There are two types of health checks that we currently support HTTP and TCP.
        :param builtins.bool is_resource_principal_disabled: Determines if the container will have access to the container instance resource principal.
               
               This method utilizes resource principal version 2.2. For information on how to use the exposed resource principal elements, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdk_authentication_methods.htm#sdk_authentication_methods_resource_principal.
        :param builtins.str lifecycle_details: A message that describes the current state of the container in more detail. Can be used to provide actionable information.
        :param 'ContainerInstanceContainerResourceConfigArgs' resource_config: The size and amount of resources available to the container.
        :param 'ContainerInstanceContainerSecurityContextArgs' security_context: Security context for container.
        :param builtins.str state: (Updatable) The target state for the Container Instance. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param Mapping[str, builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`.
        :param builtins.str time_created: The time the container instance was created, in the format defined by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param builtins.str time_updated: The time the container instance was updated, in the format defined by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param Sequence['ContainerInstanceContainerVolumeMountArgs'] volume_mounts: List of the volume mounts.
        :param builtins.str working_directory: The working directory within the container's filesystem for the container process. If not specified, the default working directory from the image is used.
        """
        pulumi.set(__self__, "image_url", image_url)
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if container_id is not None:
            pulumi.set(__self__, "container_id", container_id)
        if container_instance_id is not None:
            pulumi.set(__self__, "container_instance_id", container_instance_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if exit_code is not None:
            pulumi.set(__self__, "exit_code", exit_code)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if health_checks is not None:
            pulumi.set(__self__, "health_checks", health_checks)
        if is_resource_principal_disabled is not None:
            pulumi.set(__self__, "is_resource_principal_disabled", is_resource_principal_disabled)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if resource_config is not None:
            pulumi.set(__self__, "resource_config", resource_config)
        if security_context is not None:
            pulumi.set(__self__, "security_context", security_context)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_terminated is not None:
            pulumi.set(__self__, "time_terminated", time_terminated)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> builtins.str:
        """
        A URL identifying the image that the container runs in, such as docker.io/library/busybox:latest. If you do not provide a tag, the tag will default to latest.

        If no registry is provided, will default the registry to public docker hub `docker.io/library`.

        The registry used for container image must be reachable over the Container Instance's VNIC.
        """
        return pulumi.get(self, "image_url")

    @property
    @pulumi.getter
    def arguments(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of string arguments for a container's ENTRYPOINT process.

        Many containers use an ENTRYPOINT process pointing to a shell (/bin/bash). For those containers, this argument list specifies the main command in the container process.

        The total size of all arguments combined must be 64 KB or smaller.
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[builtins.str]:
        """
        The availability domain where the container instance runs.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[builtins.str]]:
        """
        An optional command that overrides the ENTRYPOINT process. If you do not provide a value, the existing ENTRYPOINT process defined in the image is used.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        (Updatable) The compartment OCID.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="containerId")
    def container_id(self) -> Optional[builtins.str]:
        """
        The OCID of the container.
        """
        return pulumi.get(self, "container_id")

    @property
    @pulumi.getter(name="containerInstanceId")
    def container_instance_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "container_instance_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`.
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information. If you don't provide a name, a name is generated automatically.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, builtins.str]]:
        """
        A map of additional environment variables to set in the environment of the container's ENTRYPOINT process. These variables are in addition to any variables already defined in the container's image.

        The total size of all environment variables combined, name and values, must be 64 KB or smaller.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="exitCode")
    def exit_code(self) -> Optional[builtins.int]:
        return pulumi.get(self, "exit_code")

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[builtins.str]:
        """
        The fault domain where the container instance runs.
        """
        return pulumi.get(self, "fault_domain")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Optional[Sequence['outputs.ContainerInstanceContainerHealthCheck']]:
        """
        list of container health checks to check container status and take appropriate action if container status is failed. There are two types of health checks that we currently support HTTP and TCP.
        """
        return pulumi.get(self, "health_checks")

    @property
    @pulumi.getter(name="isResourcePrincipalDisabled")
    def is_resource_principal_disabled(self) -> Optional[builtins.bool]:
        """
        Determines if the container will have access to the container instance resource principal.

        This method utilizes resource principal version 2.2. For information on how to use the exposed resource principal elements, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdk_authentication_methods.htm#sdk_authentication_methods_resource_principal.
        """
        return pulumi.get(self, "is_resource_principal_disabled")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[builtins.str]:
        """
        A message that describes the current state of the container in more detail. Can be used to provide actionable information.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="resourceConfig")
    def resource_config(self) -> Optional['outputs.ContainerInstanceContainerResourceConfig']:
        """
        The size and amount of resources available to the container.
        """
        return pulumi.get(self, "resource_config")

    @property
    @pulumi.getter(name="securityContext")
    def security_context(self) -> Optional['outputs.ContainerInstanceContainerSecurityContext']:
        """
        Security context for container.
        """
        return pulumi.get(self, "security_context")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        (Updatable) The target state for the Container Instance. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`.
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[builtins.str]:
        """
        The time the container instance was created, in the format defined by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeTerminated")
    def time_terminated(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_terminated")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[builtins.str]:
        """
        The time the container instance was updated, in the format defined by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.ContainerInstanceContainerVolumeMount']]:
        """
        List of the volume mounts.
        """
        return pulumi.get(self, "volume_mounts")

    @property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[builtins.str]:
        """
        The working directory within the container's filesystem for the container process. If not specified, the default working directory from the image is used.
        """
        return pulumi.get(self, "working_directory")


@pulumi.output_type
class ContainerInstanceContainerHealthCheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthCheckType":
            suggest = "health_check_type"
        elif key == "failureAction":
            suggest = "failure_action"
        elif key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "initialDelayInSeconds":
            suggest = "initial_delay_in_seconds"
        elif key == "intervalInSeconds":
            suggest = "interval_in_seconds"
        elif key == "statusDetails":
            suggest = "status_details"
        elif key == "successThreshold":
            suggest = "success_threshold"
        elif key == "timeoutInSeconds":
            suggest = "timeout_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerInstanceContainerHealthCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerInstanceContainerHealthCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerInstanceContainerHealthCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health_check_type: builtins.str,
                 failure_action: Optional[builtins.str] = None,
                 failure_threshold: Optional[builtins.int] = None,
                 headers: Optional[Sequence['outputs.ContainerInstanceContainerHealthCheckHeader']] = None,
                 initial_delay_in_seconds: Optional[builtins.int] = None,
                 interval_in_seconds: Optional[builtins.int] = None,
                 name: Optional[builtins.str] = None,
                 path: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None,
                 status: Optional[builtins.str] = None,
                 status_details: Optional[builtins.str] = None,
                 success_threshold: Optional[builtins.int] = None,
                 timeout_in_seconds: Optional[builtins.int] = None):
        """
        :param builtins.str health_check_type: Container health check type.
        :param builtins.str failure_action: The action will be triggered when the container health check fails. There are two types of action: KILL or NONE. The default action is KILL. If failure action is KILL, the container will be subject to the container restart policy.
        :param builtins.int failure_threshold: Number of consecutive failures at which we consider the check failed.
        :param Sequence['ContainerInstanceContainerHealthCheckHeaderArgs'] headers: Container health check HTTP headers.
        :param builtins.int initial_delay_in_seconds: The initial delay in seconds before start checking container health status.
        :param builtins.int interval_in_seconds: Number of seconds between two consecutive runs for checking container health.
        :param builtins.str name: Health check name.
        :param builtins.str path: Container health check HTTP path.
        :param builtins.int port: Container health check HTTP port.
        :param builtins.int success_threshold: Number of consecutive successes at which we consider the check succeeded again after it was in failure state.
        :param builtins.int timeout_in_seconds: Length of waiting time in seconds before marking health check failed.
        """
        pulumi.set(__self__, "health_check_type", health_check_type)
        if failure_action is not None:
            pulumi.set(__self__, "failure_action", failure_action)
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if initial_delay_in_seconds is not None:
            pulumi.set(__self__, "initial_delay_in_seconds", initial_delay_in_seconds)
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_details is not None:
            pulumi.set(__self__, "status_details", status_details)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)

    @property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> builtins.str:
        """
        Container health check type.
        """
        return pulumi.get(self, "health_check_type")

    @property
    @pulumi.getter(name="failureAction")
    def failure_action(self) -> Optional[builtins.str]:
        """
        The action will be triggered when the container health check fails. There are two types of action: KILL or NONE. The default action is KILL. If failure action is KILL, the container will be subject to the container restart policy.
        """
        return pulumi.get(self, "failure_action")

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[builtins.int]:
        """
        Number of consecutive failures at which we consider the check failed.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.ContainerInstanceContainerHealthCheckHeader']]:
        """
        Container health check HTTP headers.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="initialDelayInSeconds")
    def initial_delay_in_seconds(self) -> Optional[builtins.int]:
        """
        The initial delay in seconds before start checking container health status.
        """
        return pulumi.get(self, "initial_delay_in_seconds")

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[builtins.int]:
        """
        Number of seconds between two consecutive runs for checking container health.
        """
        return pulumi.get(self, "interval_in_seconds")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Health check name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        Container health check HTTP path.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        Container health check HTTP port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusDetails")
    def status_details(self) -> Optional[builtins.str]:
        return pulumi.get(self, "status_details")

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[builtins.int]:
        """
        Number of consecutive successes at which we consider the check succeeded again after it was in failure state.
        """
        return pulumi.get(self, "success_threshold")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[builtins.int]:
        """
        Length of waiting time in seconds before marking health check failed.
        """
        return pulumi.get(self, "timeout_in_seconds")


@pulumi.output_type
class ContainerInstanceContainerHealthCheckHeader(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str name: Container HTTP header Key.
        :param builtins.str value: Container HTTP header value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Container HTTP header Key.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        Container HTTP header value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ContainerInstanceContainerResourceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryLimitInGbs":
            suggest = "memory_limit_in_gbs"
        elif key == "vcpusLimit":
            suggest = "vcpus_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerInstanceContainerResourceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerInstanceContainerResourceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerInstanceContainerResourceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_limit_in_gbs: Optional[builtins.float] = None,
                 vcpus_limit: Optional[builtins.float] = None):
        """
        :param builtins.float memory_limit_in_gbs: The maximum amount of memory that can be consumed by the container's process.
               
               If you do not set a value, then the process may use all available memory on the instance.
        :param builtins.float vcpus_limit: The maximum amount of CPUs that can be consumed by the container's process.
               
               If you do not set a value, then the process can use all available CPU resources on the instance.
               
               CPU usage is defined in terms of logical CPUs. This means that the maximum possible value on an E3 ContainerInstance with 1 OCPU is 2.0.
               
               A container with a 2.0 vcpusLimit could consume up to 100% of the CPU resources available on the container instance. Values can be fractional. A value of "1.5" means that the container can consume at most the equivalent of 1 and a half logical CPUs worth of CPU capacity.
        """
        if memory_limit_in_gbs is not None:
            pulumi.set(__self__, "memory_limit_in_gbs", memory_limit_in_gbs)
        if vcpus_limit is not None:
            pulumi.set(__self__, "vcpus_limit", vcpus_limit)

    @property
    @pulumi.getter(name="memoryLimitInGbs")
    def memory_limit_in_gbs(self) -> Optional[builtins.float]:
        """
        The maximum amount of memory that can be consumed by the container's process.

        If you do not set a value, then the process may use all available memory on the instance.
        """
        return pulumi.get(self, "memory_limit_in_gbs")

    @property
    @pulumi.getter(name="vcpusLimit")
    def vcpus_limit(self) -> Optional[builtins.float]:
        """
        The maximum amount of CPUs that can be consumed by the container's process.

        If you do not set a value, then the process can use all available CPU resources on the instance.

        CPU usage is defined in terms of logical CPUs. This means that the maximum possible value on an E3 ContainerInstance with 1 OCPU is 2.0.

        A container with a 2.0 vcpusLimit could consume up to 100% of the CPU resources available on the container instance. Values can be fractional. A value of "1.5" means that the container can consume at most the equivalent of 1 and a half logical CPUs worth of CPU capacity.
        """
        return pulumi.get(self, "vcpus_limit")


@pulumi.output_type
class ContainerInstanceContainerSecurityContext(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isNonRootUserCheckEnabled":
            suggest = "is_non_root_user_check_enabled"
        elif key == "isRootFileSystemReadonly":
            suggest = "is_root_file_system_readonly"
        elif key == "runAsGroup":
            suggest = "run_as_group"
        elif key == "runAsUser":
            suggest = "run_as_user"
        elif key == "securityContextType":
            suggest = "security_context_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerInstanceContainerSecurityContext. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerInstanceContainerSecurityContext.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerInstanceContainerSecurityContext.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capabilities: Optional['outputs.ContainerInstanceContainerSecurityContextCapabilities'] = None,
                 is_non_root_user_check_enabled: Optional[builtins.bool] = None,
                 is_root_file_system_readonly: Optional[builtins.bool] = None,
                 run_as_group: Optional[builtins.int] = None,
                 run_as_user: Optional[builtins.int] = None,
                 security_context_type: Optional[builtins.str] = None):
        """
        :param 'ContainerInstanceContainerSecurityContextCapabilitiesArgs' capabilities: Linux Container capabilities to configure capabilities of container.
        :param builtins.bool is_non_root_user_check_enabled: Indicates if the container must run as a non-root user. If true, the service validates the container image at runtime to ensure that it is not going to run with UID 0 (root) and fails the container instance creation if the validation fails.
        :param builtins.bool is_root_file_system_readonly: Determines if the container will have a read-only root file system. Default value is false.
        :param builtins.int run_as_group: The group ID (GID) to run the entrypoint process of the container. Uses runtime default if not provided.
        :param builtins.int run_as_user: The user ID (UID) to run the entrypoint process of the container. Defaults to user specified UID in container image metadata if not provided. This must be provided if runAsGroup is provided.
        :param builtins.str security_context_type: The type of security context
        """
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if is_non_root_user_check_enabled is not None:
            pulumi.set(__self__, "is_non_root_user_check_enabled", is_non_root_user_check_enabled)
        if is_root_file_system_readonly is not None:
            pulumi.set(__self__, "is_root_file_system_readonly", is_root_file_system_readonly)
        if run_as_group is not None:
            pulumi.set(__self__, "run_as_group", run_as_group)
        if run_as_user is not None:
            pulumi.set(__self__, "run_as_user", run_as_user)
        if security_context_type is not None:
            pulumi.set(__self__, "security_context_type", security_context_type)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional['outputs.ContainerInstanceContainerSecurityContextCapabilities']:
        """
        Linux Container capabilities to configure capabilities of container.
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter(name="isNonRootUserCheckEnabled")
    def is_non_root_user_check_enabled(self) -> Optional[builtins.bool]:
        """
        Indicates if the container must run as a non-root user. If true, the service validates the container image at runtime to ensure that it is not going to run with UID 0 (root) and fails the container instance creation if the validation fails.
        """
        return pulumi.get(self, "is_non_root_user_check_enabled")

    @property
    @pulumi.getter(name="isRootFileSystemReadonly")
    def is_root_file_system_readonly(self) -> Optional[builtins.bool]:
        """
        Determines if the container will have a read-only root file system. Default value is false.
        """
        return pulumi.get(self, "is_root_file_system_readonly")

    @property
    @pulumi.getter(name="runAsGroup")
    def run_as_group(self) -> Optional[builtins.int]:
        """
        The group ID (GID) to run the entrypoint process of the container. Uses runtime default if not provided.
        """
        return pulumi.get(self, "run_as_group")

    @property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional[builtins.int]:
        """
        The user ID (UID) to run the entrypoint process of the container. Defaults to user specified UID in container image metadata if not provided. This must be provided if runAsGroup is provided.
        """
        return pulumi.get(self, "run_as_user")

    @property
    @pulumi.getter(name="securityContextType")
    def security_context_type(self) -> Optional[builtins.str]:
        """
        The type of security context
        """
        return pulumi.get(self, "security_context_type")


@pulumi.output_type
class ContainerInstanceContainerSecurityContextCapabilities(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addCapabilities":
            suggest = "add_capabilities"
        elif key == "dropCapabilities":
            suggest = "drop_capabilities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerInstanceContainerSecurityContextCapabilities. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerInstanceContainerSecurityContextCapabilities.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerInstanceContainerSecurityContextCapabilities.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 add_capabilities: Optional[Sequence[builtins.str]] = None,
                 drop_capabilities: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] add_capabilities: A list of additional configurable container capabilities.
        :param Sequence[builtins.str] drop_capabilities: A list of container capabilities that can be dropped.
        """
        if add_capabilities is not None:
            pulumi.set(__self__, "add_capabilities", add_capabilities)
        if drop_capabilities is not None:
            pulumi.set(__self__, "drop_capabilities", drop_capabilities)

    @property
    @pulumi.getter(name="addCapabilities")
    def add_capabilities(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of additional configurable container capabilities.
        """
        return pulumi.get(self, "add_capabilities")

    @property
    @pulumi.getter(name="dropCapabilities")
    def drop_capabilities(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of container capabilities that can be dropped.
        """
        return pulumi.get(self, "drop_capabilities")


@pulumi.output_type
class ContainerInstanceContainerVolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"
        elif key == "volumeName":
            suggest = "volume_name"
        elif key == "isReadOnly":
            suggest = "is_read_only"
        elif key == "subPath":
            suggest = "sub_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerInstanceContainerVolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerInstanceContainerVolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerInstanceContainerVolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: builtins.str,
                 volume_name: builtins.str,
                 is_read_only: Optional[builtins.bool] = None,
                 partition: Optional[builtins.int] = None,
                 sub_path: Optional[builtins.str] = None):
        """
        :param builtins.str mount_path: The volume access path.
        :param builtins.str volume_name: The name of the volume. Avoid entering confidential information.
        :param builtins.bool is_read_only: Whether the volume was mounted in read-only mode. By default, the volume is not read-only.
        :param builtins.int partition: If there is more than one partition in the volume, reference this number of partitions. Here is an example: Number  Start   End     Size    File system  Name                  Flags 1      1049kB  106MB   105MB   fat16        EFI System Partition  boot, esp 2      106MB   1180MB  1074MB  xfs 3      1180MB  50.0GB  48.8GB                                     lvm
        :param builtins.str sub_path: A subpath inside the referenced volume.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "volume_name", volume_name)
        if is_read_only is not None:
            pulumi.set(__self__, "is_read_only", is_read_only)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if sub_path is not None:
            pulumi.set(__self__, "sub_path", sub_path)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> builtins.str:
        """
        The volume access path.
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> builtins.str:
        """
        The name of the volume. Avoid entering confidential information.
        """
        return pulumi.get(self, "volume_name")

    @property
    @pulumi.getter(name="isReadOnly")
    def is_read_only(self) -> Optional[builtins.bool]:
        """
        Whether the volume was mounted in read-only mode. By default, the volume is not read-only.
        """
        return pulumi.get(self, "is_read_only")

    @property
    @pulumi.getter
    def partition(self) -> Optional[builtins.int]:
        """
        If there is more than one partition in the volume, reference this number of partitions. Here is an example: Number  Start   End     Size    File system  Name                  Flags 1      1049kB  106MB   105MB   fat16        EFI System Partition  boot, esp 2      106MB   1180MB  1074MB  xfs 3      1180MB  50.0GB  48.8GB                                     lvm
        """
        return pulumi.get(self, "partition")

    @property
    @pulumi.getter(name="subPath")
    def sub_path(self) -> Optional[builtins.str]:
        """
        A subpath inside the referenced volume.
        """
        return pulumi.get(self, "sub_path")


@pulumi.output_type
class ContainerInstanceDnsConfig(dict):
    def __init__(__self__, *,
                 nameservers: Optional[Sequence[builtins.str]] = None,
                 options: Optional[Sequence[builtins.str]] = None,
                 searches: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] nameservers: IP address of a name server that the resolver should query, either an IPv4 address (in dot notation), or an IPv6 address in colon (and possibly dot) notation. If null, uses nameservers from subnet dhcpDnsOptions.
        :param Sequence[builtins.str] options: Options allows certain internal resolver variables to be modified. Options are a list of objects in https://man7.org/linux/man-pages/man5/resolv.conf.5.html. Examples: ["ndots:n", "edns0"].
        :param Sequence[builtins.str] searches: Search list for host-name lookup. If null, we will use searches from subnet dhcpDnsOptios.
        """
        if nameservers is not None:
            pulumi.set(__self__, "nameservers", nameservers)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if searches is not None:
            pulumi.set(__self__, "searches", searches)

    @property
    @pulumi.getter
    def nameservers(self) -> Optional[Sequence[builtins.str]]:
        """
        IP address of a name server that the resolver should query, either an IPv4 address (in dot notation), or an IPv6 address in colon (and possibly dot) notation. If null, uses nameservers from subnet dhcpDnsOptions.
        """
        return pulumi.get(self, "nameservers")

    @property
    @pulumi.getter
    def options(self) -> Optional[Sequence[builtins.str]]:
        """
        Options allows certain internal resolver variables to be modified. Options are a list of objects in https://man7.org/linux/man-pages/man5/resolv.conf.5.html. Examples: ["ndots:n", "edns0"].
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def searches(self) -> Optional[Sequence[builtins.str]]:
        """
        Search list for host-name lookup. If null, we will use searches from subnet dhcpDnsOptios.
        """
        return pulumi.get(self, "searches")


@pulumi.output_type
class ContainerInstanceImagePullSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "registryEndpoint":
            suggest = "registry_endpoint"
        elif key == "secretType":
            suggest = "secret_type"
        elif key == "secretId":
            suggest = "secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerInstanceImagePullSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerInstanceImagePullSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerInstanceImagePullSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 registry_endpoint: builtins.str,
                 secret_type: builtins.str,
                 password: Optional[builtins.str] = None,
                 secret_id: Optional[builtins.str] = None,
                 username: Optional[builtins.str] = None):
        """
        :param builtins.str registry_endpoint: The registry endpoint of the container image.
        :param builtins.str secret_type: The type of ImagePullSecret.
        :param builtins.str password: The password which should be used with the registry for authentication. The value is expected in base64 format.
        :param builtins.str secret_id: The OCID of the secret for registry credentials.
        :param builtins.str username: The username which should be used with the registry for authentication. The value is expected in base64 format.
        """
        pulumi.set(__self__, "registry_endpoint", registry_endpoint)
        pulumi.set(__self__, "secret_type", secret_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="registryEndpoint")
    def registry_endpoint(self) -> builtins.str:
        """
        The registry endpoint of the container image.
        """
        return pulumi.get(self, "registry_endpoint")

    @property
    @pulumi.getter(name="secretType")
    def secret_type(self) -> builtins.str:
        """
        The type of ImagePullSecret.
        """
        return pulumi.get(self, "secret_type")

    @property
    @pulumi.getter
    def password(self) -> Optional[builtins.str]:
        """
        The password which should be used with the registry for authentication. The value is expected in base64 format.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[builtins.str]:
        """
        The OCID of the secret for registry credentials.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        The username which should be used with the registry for authentication. The value is expected in base64 format.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ContainerInstanceShapeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGbs":
            suggest = "memory_in_gbs"
        elif key == "networkingBandwidthInGbps":
            suggest = "networking_bandwidth_in_gbps"
        elif key == "processorDescription":
            suggest = "processor_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerInstanceShapeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerInstanceShapeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerInstanceShapeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ocpus: builtins.float,
                 memory_in_gbs: Optional[builtins.float] = None,
                 networking_bandwidth_in_gbps: Optional[builtins.float] = None,
                 processor_description: Optional[builtins.str] = None):
        """
        :param builtins.float ocpus: The total number of OCPUs available to the container instance.
        :param builtins.float memory_in_gbs: The total amount of memory available to the container instance (GB).
        :param builtins.float networking_bandwidth_in_gbps: The networking bandwidth available to the container instance, in gigabits per second.
        :param builtins.str processor_description: A short description of the container instance's processor (CPU).
        """
        pulumi.set(__self__, "ocpus", ocpus)
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if networking_bandwidth_in_gbps is not None:
            pulumi.set(__self__, "networking_bandwidth_in_gbps", networking_bandwidth_in_gbps)
        if processor_description is not None:
            pulumi.set(__self__, "processor_description", processor_description)

    @property
    @pulumi.getter
    def ocpus(self) -> builtins.float:
        """
        The total number of OCPUs available to the container instance.
        """
        return pulumi.get(self, "ocpus")

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[builtins.float]:
        """
        The total amount of memory available to the container instance (GB).
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter(name="networkingBandwidthInGbps")
    def networking_bandwidth_in_gbps(self) -> Optional[builtins.float]:
        """
        The networking bandwidth available to the container instance, in gigabits per second.
        """
        return pulumi.get(self, "networking_bandwidth_in_gbps")

    @property
    @pulumi.getter(name="processorDescription")
    def processor_description(self) -> Optional[builtins.str]:
        """
        A short description of the container instance's processor (CPU).
        """
        return pulumi.get(self, "processor_description")


@pulumi.output_type
class ContainerInstanceVnic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "definedTags":
            suggest = "defined_tags"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "freeformTags":
            suggest = "freeform_tags"
        elif key == "hostnameLabel":
            suggest = "hostname_label"
        elif key == "isPublicIpAssigned":
            suggest = "is_public_ip_assigned"
        elif key == "nsgIds":
            suggest = "nsg_ids"
        elif key == "privateIp":
            suggest = "private_ip"
        elif key == "skipSourceDestCheck":
            suggest = "skip_source_dest_check"
        elif key == "vnicId":
            suggest = "vnic_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerInstanceVnic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerInstanceVnic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerInstanceVnic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: builtins.str,
                 defined_tags: Optional[Mapping[str, builtins.str]] = None,
                 display_name: Optional[builtins.str] = None,
                 freeform_tags: Optional[Mapping[str, builtins.str]] = None,
                 hostname_label: Optional[builtins.str] = None,
                 is_public_ip_assigned: Optional[builtins.bool] = None,
                 nsg_ids: Optional[Sequence[builtins.str]] = None,
                 private_ip: Optional[builtins.str] = None,
                 skip_source_dest_check: Optional[builtins.bool] = None,
                 vnic_id: Optional[builtins.str] = None):
        """
        :param builtins.str subnet_id: The OCID of the subnet to create the VNIC in.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`.
        :param builtins.str display_name: A user-friendly name for the VNIC. Does not have to be unique. Avoid entering confidential information.
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param builtins.str hostname_label: The hostname for the VNIC's primary private IP. Used for DNS.
        :param builtins.bool is_public_ip_assigned: Whether the VNIC should be assigned a public IP address.
        :param Sequence[builtins.str] nsg_ids: A list of the OCIDs of the network security groups (NSGs) to add the VNIC to.
        :param builtins.str private_ip: A private IP address of your choice to assign to the VNIC. Must be an available IP address within the subnet's CIDR.
        :param builtins.bool skip_source_dest_check: Whether the source/destination check is disabled on the VNIC.
        :param builtins.str vnic_id: The identifier of the virtual network interface card (VNIC) over which the containers accessing this network can communicate with the larger virtual cloud network.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hostname_label is not None:
            pulumi.set(__self__, "hostname_label", hostname_label)
        if is_public_ip_assigned is not None:
            pulumi.set(__self__, "is_public_ip_assigned", is_public_ip_assigned)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if skip_source_dest_check is not None:
            pulumi.set(__self__, "skip_source_dest_check", skip_source_dest_check)
        if vnic_id is not None:
            pulumi.set(__self__, "vnic_id", vnic_id)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The OCID of the subnet to create the VNIC in.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`.
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-friendly name for the VNIC. Does not have to be unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="hostnameLabel")
    def hostname_label(self) -> Optional[builtins.str]:
        """
        The hostname for the VNIC's primary private IP. Used for DNS.
        """
        return pulumi.get(self, "hostname_label")

    @property
    @pulumi.getter(name="isPublicIpAssigned")
    def is_public_ip_assigned(self) -> Optional[builtins.bool]:
        """
        Whether the VNIC should be assigned a public IP address.
        """
        return pulumi.get(self, "is_public_ip_assigned")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of the OCIDs of the network security groups (NSGs) to add the VNIC to.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[builtins.str]:
        """
        A private IP address of your choice to assign to the VNIC. Must be an available IP address within the subnet's CIDR.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="skipSourceDestCheck")
    def skip_source_dest_check(self) -> Optional[builtins.bool]:
        """
        Whether the source/destination check is disabled on the VNIC.
        """
        return pulumi.get(self, "skip_source_dest_check")

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> Optional[builtins.str]:
        """
        The identifier of the virtual network interface card (VNIC) over which the containers accessing this network can communicate with the larger virtual cloud network.
        """
        return pulumi.get(self, "vnic_id")


@pulumi.output_type
class ContainerInstanceVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumeType":
            suggest = "volume_type"
        elif key == "backingStore":
            suggest = "backing_store"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerInstanceVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerInstanceVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerInstanceVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 volume_type: builtins.str,
                 backing_store: Optional[builtins.str] = None,
                 configs: Optional[Sequence['outputs.ContainerInstanceVolumeConfig']] = None):
        """
        :param builtins.str name: The name of the volume. This must be unique within a single container instance.
        :param builtins.str volume_type: The type of volume.
        :param builtins.str backing_store: The volume type of the empty directory, can be either File Storage or Memory.
        :param Sequence['ContainerInstanceVolumeConfigArgs'] configs: Contains key value pairs which can be mounted as individual files inside the container. The value needs to be base64 encoded. It is decoded to plain text before the mount.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "volume_type", volume_type)
        if backing_store is not None:
            pulumi.set(__self__, "backing_store", backing_store)
        if configs is not None:
            pulumi.set(__self__, "configs", configs)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the volume. This must be unique within a single container instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> builtins.str:
        """
        The type of volume.
        """
        return pulumi.get(self, "volume_type")

    @property
    @pulumi.getter(name="backingStore")
    def backing_store(self) -> Optional[builtins.str]:
        """
        The volume type of the empty directory, can be either File Storage or Memory.
        """
        return pulumi.get(self, "backing_store")

    @property
    @pulumi.getter
    def configs(self) -> Optional[Sequence['outputs.ContainerInstanceVolumeConfig']]:
        """
        Contains key value pairs which can be mounted as individual files inside the container. The value needs to be base64 encoded. It is decoded to plain text before the mount.
        """
        return pulumi.get(self, "configs")


@pulumi.output_type
class ContainerInstanceVolumeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileName":
            suggest = "file_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerInstanceVolumeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerInstanceVolumeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerInstanceVolumeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data: Optional[builtins.str] = None,
                 file_name: Optional[builtins.str] = None,
                 path: Optional[builtins.str] = None):
        """
        :param builtins.str data: The base64 encoded contents of the file. The contents are decoded to plain text before mounted as a file to a container inside container instance.
        :param builtins.str file_name: The name of the file. The fileName should be unique across the volume.
        :param builtins.str path: (Optional) Relative path for this file inside the volume mount directory. By default, the file is presented at the root of the volume mount path.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def data(self) -> Optional[builtins.str]:
        """
        The base64 encoded contents of the file. The contents are decoded to plain text before mounted as a file to a container inside container instance.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[builtins.str]:
        """
        The name of the file. The fileName should be unique across the volume.
        """
        return pulumi.get(self, "file_name")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        (Optional) Relative path for this file inside the volume mount directory. By default, the file is presented at the root of the volume mount path.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class NodePoolInitialNodeLabel(dict):
    def __init__(__self__, *,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str key: (Updatable) The key of the pair.
        :param builtins.str value: (Updatable) The value of the pair.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        (Updatable) The key of the pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        (Updatable) The value of the pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NodePoolNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityDomain":
            suggest = "availability_domain"
        elif key == "definedTags":
            suggest = "defined_tags"
        elif key == "faultDomain":
            suggest = "fault_domain"
        elif key == "freeformTags":
            suggest = "freeform_tags"
        elif key == "kubernetesVersion":
            suggest = "kubernetes_version"
        elif key == "lifecycleDetails":
            suggest = "lifecycle_details"
        elif key == "nodePoolId":
            suggest = "node_pool_id"
        elif key == "privateIp":
            suggest = "private_ip"
        elif key == "publicIp":
            suggest = "public_ip"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_domain: Optional[builtins.str] = None,
                 defined_tags: Optional[Mapping[str, builtins.str]] = None,
                 errors: Optional[Sequence['outputs.NodePoolNodeError']] = None,
                 fault_domain: Optional[builtins.str] = None,
                 freeform_tags: Optional[Mapping[str, builtins.str]] = None,
                 id: Optional[builtins.str] = None,
                 kubernetes_version: Optional[builtins.str] = None,
                 lifecycle_details: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 node_pool_id: Optional[builtins.str] = None,
                 private_ip: Optional[builtins.str] = None,
                 public_ip: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None,
                 subnet_id: Optional[builtins.str] = None):
        """
        :param builtins.str availability_domain: The name of the availability domain in which this node is placed.
        :param Mapping[str, builtins.str] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Sequence['NodePoolNodeErrorArgs'] errors: An error that may be associated with the node.
        :param builtins.str fault_domain: The fault domain of this node.
        :param Mapping[str, builtins.str] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param builtins.str id: The OCID of the compute instance backing this node.
        :param builtins.str kubernetes_version: (Updatable) The version of Kubernetes to install on the nodes in the node pool.
        :param builtins.str lifecycle_details: Details about the state of the node.
        :param builtins.str name: (Updatable) The name of the node pool. Avoid entering confidential information.
        :param builtins.str node_pool_id: The OCID of the node pool to which this node belongs.
        :param builtins.str private_ip: The private IP address of this node.
        :param builtins.str public_ip: The public IP address of this node.
        :param builtins.str state: The state of the nodepool.
        :param builtins.str subnet_id: The OCID of the subnet in which this node is placed.
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kubernetes_version is not None:
            pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_pool_id is not None:
            pulumi.set(__self__, "node_pool_id", node_pool_id)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[builtins.str]:
        """
        The name of the availability domain in which this node is placed.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def errors(self) -> Optional[Sequence['outputs.NodePoolNodeError']]:
        """
        An error that may be associated with the node.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[builtins.str]:
        """
        The fault domain of this node.
        """
        return pulumi.get(self, "fault_domain")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The OCID of the compute instance backing this node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[builtins.str]:
        """
        (Updatable) The version of Kubernetes to install on the nodes in the node pool.
        """
        return pulumi.get(self, "kubernetes_version")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[builtins.str]:
        """
        Details about the state of the node.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        (Updatable) The name of the node pool. Avoid entering confidential information.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodePoolId")
    def node_pool_id(self) -> Optional[builtins.str]:
        """
        The OCID of the node pool to which this node belongs.
        """
        return pulumi.get(self, "node_pool_id")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[builtins.str]:
        """
        The private IP address of this node.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[builtins.str]:
        """
        The public IP address of this node.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The state of the nodepool.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[builtins.str]:
        """
        The OCID of the subnet in which this node is placed.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class NodePoolNodeConfigDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "placementConfigs":
            suggest = "placement_configs"
        elif key == "definedTags":
            suggest = "defined_tags"
        elif key == "freeformTags":
            suggest = "freeform_tags"
        elif key == "isPvEncryptionInTransitEnabled":
            suggest = "is_pv_encryption_in_transit_enabled"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "nodePoolPodNetworkOptionDetails":
            suggest = "node_pool_pod_network_option_details"
        elif key == "nsgIds":
            suggest = "nsg_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolNodeConfigDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolNodeConfigDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolNodeConfigDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 placement_configs: Sequence['outputs.NodePoolNodeConfigDetailsPlacementConfig'],
                 size: builtins.int,
                 defined_tags: Optional[Mapping[str, builtins.str]] = None,
                 freeform_tags: Optional[Mapping[str, builtins.str]] = None,
                 is_pv_encryption_in_transit_enabled: Optional[builtins.bool] = None,
                 kms_key_id: Optional[builtins.str] = None,
                 node_pool_pod_network_option_details: Optional['outputs.NodePoolNodeConfigDetailsNodePoolPodNetworkOptionDetails'] = None,
                 nsg_ids: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence['NodePoolNodeConfigDetailsPlacementConfigArgs'] placement_configs: (Updatable) The placement configurations for the node pool. Provide one placement configuration for each availability domain in which you intend to launch a node.
               
               To use the node pool with a regional subnet, provide a placement configuration for each availability domain, and include the regional subnet in each placement configuration.
        :param builtins.int size: (Updatable) The number of nodes that should be in the node pool.
        :param Mapping[str, builtins.str] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, builtins.str] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param builtins.bool is_pv_encryption_in_transit_enabled: (Updatable) Whether to enable in-transit encryption for the data volume's paravirtualized attachment. This field applies to both block volumes and boot volumes. The default value is false.
        :param builtins.str kms_key_id: (Updatable) The OCID of the Key Management Service key assigned to the boot volume.
        :param 'NodePoolNodeConfigDetailsNodePoolPodNetworkOptionDetailsArgs' node_pool_pod_network_option_details: (Updatable) The CNI related configuration of pods in the node pool.
        :param Sequence[builtins.str] nsg_ids: (Updatable) The OCIDs of the Network Security Group(s) to associate nodes for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        pulumi.set(__self__, "placement_configs", placement_configs)
        pulumi.set(__self__, "size", size)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_pv_encryption_in_transit_enabled is not None:
            pulumi.set(__self__, "is_pv_encryption_in_transit_enabled", is_pv_encryption_in_transit_enabled)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if node_pool_pod_network_option_details is not None:
            pulumi.set(__self__, "node_pool_pod_network_option_details", node_pool_pod_network_option_details)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)

    @property
    @pulumi.getter(name="placementConfigs")
    def placement_configs(self) -> Sequence['outputs.NodePoolNodeConfigDetailsPlacementConfig']:
        """
        (Updatable) The placement configurations for the node pool. Provide one placement configuration for each availability domain in which you intend to launch a node.

        To use the node pool with a regional subnet, provide a placement configuration for each availability domain, and include the regional subnet in each placement configuration.
        """
        return pulumi.get(self, "placement_configs")

    @property
    @pulumi.getter
    def size(self) -> builtins.int:
        """
        (Updatable) The number of nodes that should be in the node pool.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isPvEncryptionInTransitEnabled")
    def is_pv_encryption_in_transit_enabled(self) -> Optional[builtins.bool]:
        """
        (Updatable) Whether to enable in-transit encryption for the data volume's paravirtualized attachment. This field applies to both block volumes and boot volumes. The default value is false.
        """
        return pulumi.get(self, "is_pv_encryption_in_transit_enabled")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[builtins.str]:
        """
        (Updatable) The OCID of the Key Management Service key assigned to the boot volume.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="nodePoolPodNetworkOptionDetails")
    def node_pool_pod_network_option_details(self) -> Optional['outputs.NodePoolNodeConfigDetailsNodePoolPodNetworkOptionDetails']:
        """
        (Updatable) The CNI related configuration of pods in the node pool.
        """
        return pulumi.get(self, "node_pool_pod_network_option_details")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        (Updatable) The OCIDs of the Network Security Group(s) to associate nodes for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        return pulumi.get(self, "nsg_ids")


@pulumi.output_type
class NodePoolNodeConfigDetailsNodePoolPodNetworkOptionDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cniType":
            suggest = "cni_type"
        elif key == "maxPodsPerNode":
            suggest = "max_pods_per_node"
        elif key == "podNsgIds":
            suggest = "pod_nsg_ids"
        elif key == "podSubnetIds":
            suggest = "pod_subnet_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolNodeConfigDetailsNodePoolPodNetworkOptionDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolNodeConfigDetailsNodePoolPodNetworkOptionDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolNodeConfigDetailsNodePoolPodNetworkOptionDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cni_type: builtins.str,
                 max_pods_per_node: Optional[builtins.int] = None,
                 pod_nsg_ids: Optional[Sequence[builtins.str]] = None,
                 pod_subnet_ids: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str cni_type: (Updatable) The CNI plugin used by this node pool
        :param builtins.int max_pods_per_node: (Updatable) The max number of pods per node in the node pool. This value will be limited by the number of VNICs attachable to the node pool shape
        :param Sequence[builtins.str] pod_nsg_ids: (Updatable) The OCIDs of the Network Security Group(s) to associate pods for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        :param Sequence[builtins.str] pod_subnet_ids: (Updatable) The OCIDs of the subnets in which to place pods for this node pool. This can be one of the node pool subnet IDs
        """
        pulumi.set(__self__, "cni_type", cni_type)
        if max_pods_per_node is not None:
            pulumi.set(__self__, "max_pods_per_node", max_pods_per_node)
        if pod_nsg_ids is not None:
            pulumi.set(__self__, "pod_nsg_ids", pod_nsg_ids)
        if pod_subnet_ids is not None:
            pulumi.set(__self__, "pod_subnet_ids", pod_subnet_ids)

    @property
    @pulumi.getter(name="cniType")
    def cni_type(self) -> builtins.str:
        """
        (Updatable) The CNI plugin used by this node pool
        """
        return pulumi.get(self, "cni_type")

    @property
    @pulumi.getter(name="maxPodsPerNode")
    def max_pods_per_node(self) -> Optional[builtins.int]:
        """
        (Updatable) The max number of pods per node in the node pool. This value will be limited by the number of VNICs attachable to the node pool shape
        """
        return pulumi.get(self, "max_pods_per_node")

    @property
    @pulumi.getter(name="podNsgIds")
    def pod_nsg_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        (Updatable) The OCIDs of the Network Security Group(s) to associate pods for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        return pulumi.get(self, "pod_nsg_ids")

    @property
    @pulumi.getter(name="podSubnetIds")
    def pod_subnet_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        (Updatable) The OCIDs of the subnets in which to place pods for this node pool. This can be one of the node pool subnet IDs
        """
        return pulumi.get(self, "pod_subnet_ids")


@pulumi.output_type
class NodePoolNodeConfigDetailsPlacementConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityDomain":
            suggest = "availability_domain"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "capacityReservationId":
            suggest = "capacity_reservation_id"
        elif key == "faultDomains":
            suggest = "fault_domains"
        elif key == "preemptibleNodeConfig":
            suggest = "preemptible_node_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolNodeConfigDetailsPlacementConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolNodeConfigDetailsPlacementConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolNodeConfigDetailsPlacementConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_domain: builtins.str,
                 subnet_id: builtins.str,
                 capacity_reservation_id: Optional[builtins.str] = None,
                 fault_domains: Optional[Sequence[builtins.str]] = None,
                 preemptible_node_config: Optional['outputs.NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfig'] = None):
        """
        :param builtins.str availability_domain: (Updatable) The availability domain in which to place nodes. Example: `Uocm:PHX-AD-1`
        :param builtins.str subnet_id: (Updatable) The OCID of the subnet in which to place nodes.
        :param builtins.str capacity_reservation_id: (Updatable) The OCID of the compute capacity reservation in which to place the compute instance.
        :param Sequence[builtins.str] fault_domains: (Updatable) A list of fault domains in which to place nodes.
        :param 'NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigArgs' preemptible_node_config: (Updatable) Configuration options for preemptible nodes.
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if capacity_reservation_id is not None:
            pulumi.set(__self__, "capacity_reservation_id", capacity_reservation_id)
        if fault_domains is not None:
            pulumi.set(__self__, "fault_domains", fault_domains)
        if preemptible_node_config is not None:
            pulumi.set(__self__, "preemptible_node_config", preemptible_node_config)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        (Updatable) The availability domain in which to place nodes. Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        (Updatable) The OCID of the subnet in which to place nodes.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> Optional[builtins.str]:
        """
        (Updatable) The OCID of the compute capacity reservation in which to place the compute instance.
        """
        return pulumi.get(self, "capacity_reservation_id")

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> Optional[Sequence[builtins.str]]:
        """
        (Updatable) A list of fault domains in which to place nodes.
        """
        return pulumi.get(self, "fault_domains")

    @property
    @pulumi.getter(name="preemptibleNodeConfig")
    def preemptible_node_config(self) -> Optional['outputs.NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfig']:
        """
        (Updatable) Configuration options for preemptible nodes.
        """
        return pulumi.get(self, "preemptible_node_config")


@pulumi.output_type
class NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preemptionAction":
            suggest = "preemption_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 preemption_action: 'outputs.NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigPreemptionAction'):
        """
        :param 'NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigPreemptionActionArgs' preemption_action: (Updatable) The action to run when the preemptible node is interrupted for eviction.
        """
        pulumi.set(__self__, "preemption_action", preemption_action)

    @property
    @pulumi.getter(name="preemptionAction")
    def preemption_action(self) -> 'outputs.NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigPreemptionAction':
        """
        (Updatable) The action to run when the preemptible node is interrupted for eviction.
        """
        return pulumi.get(self, "preemption_action")


@pulumi.output_type
class NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigPreemptionAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isPreserveBootVolume":
            suggest = "is_preserve_boot_volume"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigPreemptionAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigPreemptionAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigPreemptionAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 is_preserve_boot_volume: Optional[builtins.bool] = None):
        """
        :param builtins.str type: (Updatable) The type of action to run when the instance is interrupted for eviction.
        :param builtins.bool is_preserve_boot_volume: (Updatable) Whether to preserve the boot volume that was used to launch the preemptible instance when the instance is terminated. Defaults to false if not specified.
        """
        pulumi.set(__self__, "type", type)
        if is_preserve_boot_volume is not None:
            pulumi.set(__self__, "is_preserve_boot_volume", is_preserve_boot_volume)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        (Updatable) The type of action to run when the instance is interrupted for eviction.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="isPreserveBootVolume")
    def is_preserve_boot_volume(self) -> Optional[builtins.bool]:
        """
        (Updatable) Whether to preserve the boot volume that was used to launch the preemptible instance when the instance is terminated. Defaults to false if not specified.
        """
        return pulumi.get(self, "is_preserve_boot_volume")


@pulumi.output_type
class NodePoolNodeError(dict):
    def __init__(__self__, *,
                 code: Optional[builtins.str] = None,
                 message: Optional[builtins.str] = None,
                 status: Optional[builtins.str] = None):
        """
        :param builtins.str code: A short error code that defines the upstream error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        :param builtins.str message: A human-readable error string of the upstream error.
        :param builtins.str status: The status of the HTTP response encountered in the upstream error.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def code(self) -> Optional[builtins.str]:
        """
        A short error code that defines the upstream error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        A human-readable error string of the upstream error.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        The status of the HTTP response encountered in the upstream error.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class NodePoolNodeEvictionNodePoolSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evictionGraceDuration":
            suggest = "eviction_grace_duration"
        elif key == "isForceActionAfterGraceDuration":
            suggest = "is_force_action_after_grace_duration"
        elif key == "isForceDeleteAfterGraceDuration":
            suggest = "is_force_delete_after_grace_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolNodeEvictionNodePoolSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolNodeEvictionNodePoolSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolNodeEvictionNodePoolSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 eviction_grace_duration: Optional[builtins.str] = None,
                 is_force_action_after_grace_duration: Optional[builtins.bool] = None,
                 is_force_delete_after_grace_duration: Optional[builtins.bool] = None):
        """
        :param builtins.str eviction_grace_duration: (Updatable) Duration after which OKE will give up eviction of the pods on the node. PT0M will indicate you want to delete the node without cordon and drain. Default PT60M, Min PT0M, Max: PT60M. Format ISO 8601 e.g PT30M
        :param builtins.bool is_force_action_after_grace_duration: (Updatable) If the node action should be performed if not all the pods can be evicted in the grace period
        :param builtins.bool is_force_delete_after_grace_duration: (Updatable) If the underlying compute instance should be deleted if you cannot evict all the pods in grace period
        """
        if eviction_grace_duration is not None:
            pulumi.set(__self__, "eviction_grace_duration", eviction_grace_duration)
        if is_force_action_after_grace_duration is not None:
            pulumi.set(__self__, "is_force_action_after_grace_duration", is_force_action_after_grace_duration)
        if is_force_delete_after_grace_duration is not None:
            pulumi.set(__self__, "is_force_delete_after_grace_duration", is_force_delete_after_grace_duration)

    @property
    @pulumi.getter(name="evictionGraceDuration")
    def eviction_grace_duration(self) -> Optional[builtins.str]:
        """
        (Updatable) Duration after which OKE will give up eviction of the pods on the node. PT0M will indicate you want to delete the node without cordon and drain. Default PT60M, Min PT0M, Max: PT60M. Format ISO 8601 e.g PT30M
        """
        return pulumi.get(self, "eviction_grace_duration")

    @property
    @pulumi.getter(name="isForceActionAfterGraceDuration")
    def is_force_action_after_grace_duration(self) -> Optional[builtins.bool]:
        """
        (Updatable) If the node action should be performed if not all the pods can be evicted in the grace period
        """
        return pulumi.get(self, "is_force_action_after_grace_duration")

    @property
    @pulumi.getter(name="isForceDeleteAfterGraceDuration")
    def is_force_delete_after_grace_duration(self) -> Optional[builtins.bool]:
        """
        (Updatable) If the underlying compute instance should be deleted if you cannot evict all the pods in grace period
        """
        return pulumi.get(self, "is_force_delete_after_grace_duration")


@pulumi.output_type
class NodePoolNodePoolCyclingDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cycleModes":
            suggest = "cycle_modes"
        elif key == "isNodeCyclingEnabled":
            suggest = "is_node_cycling_enabled"
        elif key == "maximumSurge":
            suggest = "maximum_surge"
        elif key == "maximumUnavailable":
            suggest = "maximum_unavailable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolNodePoolCyclingDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolNodePoolCyclingDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolNodePoolCyclingDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cycle_modes: Optional[Sequence[builtins.str]] = None,
                 is_node_cycling_enabled: Optional[builtins.bool] = None,
                 maximum_surge: Optional[builtins.str] = None,
                 maximum_unavailable: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] cycle_modes: (Updatable) An ordered list of cycle modes that should be performed on the OKE nodes.
        :param builtins.bool is_node_cycling_enabled: (Updatable) If cycling operation should be performed on the nodes in the node pool.
        :param builtins.str maximum_surge: (Updatable) Maximum additional new compute instances that would be temporarily created and added to nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 1, Ranges from 0 to Nodepool size or 0% to 100%
        :param builtins.str maximum_unavailable: (Updatable) Maximum active nodes that would be terminated from nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 0, Ranges from 0 to Nodepool size or 0% to 100%
        """
        if cycle_modes is not None:
            pulumi.set(__self__, "cycle_modes", cycle_modes)
        if is_node_cycling_enabled is not None:
            pulumi.set(__self__, "is_node_cycling_enabled", is_node_cycling_enabled)
        if maximum_surge is not None:
            pulumi.set(__self__, "maximum_surge", maximum_surge)
        if maximum_unavailable is not None:
            pulumi.set(__self__, "maximum_unavailable", maximum_unavailable)

    @property
    @pulumi.getter(name="cycleModes")
    def cycle_modes(self) -> Optional[Sequence[builtins.str]]:
        """
        (Updatable) An ordered list of cycle modes that should be performed on the OKE nodes.
        """
        return pulumi.get(self, "cycle_modes")

    @property
    @pulumi.getter(name="isNodeCyclingEnabled")
    def is_node_cycling_enabled(self) -> Optional[builtins.bool]:
        """
        (Updatable) If cycling operation should be performed on the nodes in the node pool.
        """
        return pulumi.get(self, "is_node_cycling_enabled")

    @property
    @pulumi.getter(name="maximumSurge")
    def maximum_surge(self) -> Optional[builtins.str]:
        """
        (Updatable) Maximum additional new compute instances that would be temporarily created and added to nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 1, Ranges from 0 to Nodepool size or 0% to 100%
        """
        return pulumi.get(self, "maximum_surge")

    @property
    @pulumi.getter(name="maximumUnavailable")
    def maximum_unavailable(self) -> Optional[builtins.str]:
        """
        (Updatable) Maximum active nodes that would be terminated from nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 0, Ranges from 0 to Nodepool size or 0% to 100%
        """
        return pulumi.get(self, "maximum_unavailable")


@pulumi.output_type
class NodePoolNodeShapeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGbs":
            suggest = "memory_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolNodeShapeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolNodeShapeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolNodeShapeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_in_gbs: Optional[builtins.float] = None,
                 ocpus: Optional[builtins.float] = None):
        """
        :param builtins.float memory_in_gbs: (Updatable) The total amount of memory available to each node, in gigabytes.
        :param builtins.float ocpus: (Updatable) The total number of OCPUs available to each node in the node pool. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[builtins.float]:
        """
        (Updatable) The total amount of memory available to each node, in gigabytes.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> Optional[builtins.float]:
        """
        (Updatable) The total number of OCPUs available to each node in the node pool. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class NodePoolNodeSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageId":
            suggest = "image_id"
        elif key == "sourceName":
            suggest = "source_name"
        elif key == "sourceType":
            suggest = "source_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolNodeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolNodeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolNodeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_id: Optional[builtins.str] = None,
                 source_name: Optional[builtins.str] = None,
                 source_type: Optional[builtins.str] = None):
        """
        :param builtins.str image_id: The OCID of the image used to boot the node.
        :param builtins.str source_name: The user-friendly name of the entity corresponding to the OCID.
        :param builtins.str source_type: The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        """
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if source_name is not None:
            pulumi.set(__self__, "source_name", source_name)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[builtins.str]:
        """
        The OCID of the image used to boot the node.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> Optional[builtins.str]:
        """
        The user-friendly name of the entity corresponding to the OCID.
        """
        return pulumi.get(self, "source_name")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[builtins.str]:
        """
        The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class NodePoolNodeSourceDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageId":
            suggest = "image_id"
        elif key == "sourceType":
            suggest = "source_type"
        elif key == "bootVolumeSizeInGbs":
            suggest = "boot_volume_size_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolNodeSourceDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolNodeSourceDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolNodeSourceDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_id: builtins.str,
                 source_type: builtins.str,
                 boot_volume_size_in_gbs: Optional[builtins.str] = None):
        """
        :param builtins.str image_id: (Updatable) The OCID of the image used to boot the node.
        :param builtins.str source_type: (Updatable) The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        :param builtins.str boot_volume_size_in_gbs: (Updatable) The size of the boot volume in GBs. Minimum value is 50 GB. See [here](https://docs.cloud.oracle.com/en-us/iaas/Content/Block/Concepts/bootvolumes.htm) for max custom boot volume sizing and OS-specific requirements.
        """
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "source_type", source_type)
        if boot_volume_size_in_gbs is not None:
            pulumi.set(__self__, "boot_volume_size_in_gbs", boot_volume_size_in_gbs)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> builtins.str:
        """
        (Updatable) The OCID of the image used to boot the node.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> builtins.str:
        """
        (Updatable) The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter(name="bootVolumeSizeInGbs")
    def boot_volume_size_in_gbs(self) -> Optional[builtins.str]:
        """
        (Updatable) The size of the boot volume in GBs. Minimum value is 50 GB. See [here](https://docs.cloud.oracle.com/en-us/iaas/Content/Block/Concepts/bootvolumes.htm) for max custom boot volume sizing and OS-specific requirements.
        """
        return pulumi.get(self, "boot_volume_size_in_gbs")


@pulumi.output_type
class VirtualNodePoolInitialVirtualNodeLabel(dict):
    def __init__(__self__, *,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str key: (Updatable) The key of the pair.
        :param builtins.str value: (Updatable) The value of the pair.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        (Updatable) The key of the pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        (Updatable) The value of the pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class VirtualNodePoolPlacementConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityDomain":
            suggest = "availability_domain"
        elif key == "faultDomains":
            suggest = "fault_domains"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNodePoolPlacementConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNodePoolPlacementConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNodePoolPlacementConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_domain: builtins.str,
                 fault_domains: Sequence[builtins.str],
                 subnet_id: builtins.str):
        """
        :param builtins.str availability_domain: (Updatable) The availability domain in which to place virtual nodes. Example: `Uocm:PHX-AD-1`
        :param Sequence[builtins.str] fault_domains: (Updatable) The fault domain of this virtual node.
        :param builtins.str subnet_id: (Updatable) The OCID of the subnet in which to place virtual nodes.
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "fault_domains", fault_domains)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        (Updatable) The availability domain in which to place virtual nodes. Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> Sequence[builtins.str]:
        """
        (Updatable) The fault domain of this virtual node.
        """
        return pulumi.get(self, "fault_domains")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        (Updatable) The OCID of the subnet in which to place virtual nodes.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class VirtualNodePoolPodConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "nsgIds":
            suggest = "nsg_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNodePoolPodConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNodePoolPodConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNodePoolPodConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 shape: builtins.str,
                 subnet_id: builtins.str,
                 nsg_ids: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str shape: (Updatable) Shape of the pods.
        :param builtins.str subnet_id: (Updatable) The regional subnet where pods' VNIC will be placed.
        :param Sequence[builtins.str] nsg_ids: (Updatable) List of network security group IDs applied to the Pod VNIC.
        """
        pulumi.set(__self__, "shape", shape)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)

    @property
    @pulumi.getter
    def shape(self) -> builtins.str:
        """
        (Updatable) Shape of the pods.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        (Updatable) The regional subnet where pods' VNIC will be placed.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        (Updatable) List of network security group IDs applied to the Pod VNIC.
        """
        return pulumi.get(self, "nsg_ids")


@pulumi.output_type
class VirtualNodePoolTaint(dict):
    def __init__(__self__, *,
                 effect: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str effect: (Updatable) The effect of the pair.
        :param builtins.str key: (Updatable) The key of the pair.
        :param builtins.str value: (Updatable) The value of the pair.
        """
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[builtins.str]:
        """
        (Updatable) The effect of the pair.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        (Updatable) The key of the pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        (Updatable) The value of the pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class VirtualNodePoolVirtualNodeTags(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "definedTags":
            suggest = "defined_tags"
        elif key == "freeformTags":
            suggest = "freeform_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNodePoolVirtualNodeTags. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNodePoolVirtualNodeTags.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNodePoolVirtualNodeTags.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 defined_tags: Optional[Mapping[str, builtins.str]] = None,
                 freeform_tags: Optional[Mapping[str, builtins.str]] = None):
        """
        :param Mapping[str, builtins.str] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, builtins.str] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")


@pulumi.output_type
class GetAddonAddonErrorResult(dict):
    def __init__(__self__, *,
                 code: builtins.str,
                 message: builtins.str,
                 status: builtins.str):
        """
        :param builtins.str code: A short error code that defines the upstream error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        :param builtins.str message: A human-readable error string of the upstream error.
        :param builtins.str status: The status of the HTTP response encountered in the upstream error.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def code(self) -> builtins.str:
        """
        A short error code that defines the upstream error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        """
        A human-readable error string of the upstream error.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The status of the HTTP response encountered in the upstream error.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetAddonConfigurationResult(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: configuration key name
        :param builtins.str value: configuration value name
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        configuration key name
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        configuration value name
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAddonOptionsAddonOptionResult(dict):
    def __init__(__self__, *,
                 addon_group: builtins.str,
                 addon_schema_version: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 is_essential: builtins.bool,
                 name: builtins.str,
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str,
                 versions: Sequence['outputs.GetAddonOptionsAddonOptionVersionResult']):
        """
        :param builtins.str addon_group: Addon group info, a namespace concept that groups addons with similar functionalities.
        :param builtins.str addon_schema_version: Addon definition schema version to validate addon.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str description: Information about the addon version.
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param builtins.bool is_essential: Is it an essential addon for cluster operation or not.
        :param builtins.str name: Name of the addon and it would be unique.
        :param builtins.str state: The life cycle state of the addon.
        :param Mapping[str, builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param builtins.str time_created: The time the work request was created.
        :param Sequence['GetAddonOptionsAddonOptionVersionArgs'] versions: The resources this work request affects.
        """
        pulumi.set(__self__, "addon_group", addon_group)
        pulumi.set(__self__, "addon_schema_version", addon_schema_version)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "is_essential", is_essential)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "versions", versions)

    @property
    @pulumi.getter(name="addonGroup")
    def addon_group(self) -> builtins.str:
        """
        Addon group info, a namespace concept that groups addons with similar functionalities.
        """
        return pulumi.get(self, "addon_group")

    @property
    @pulumi.getter(name="addonSchemaVersion")
    def addon_schema_version(self) -> builtins.str:
        """
        Addon definition schema version to validate addon.
        """
        return pulumi.get(self, "addon_schema_version")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Information about the addon version.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isEssential")
    def is_essential(self) -> builtins.bool:
        """
        Is it an essential addon for cluster operation or not.
        """
        return pulumi.get(self, "is_essential")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the addon and it would be unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The life cycle state of the addon.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the work request was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def versions(self) -> Sequence['outputs.GetAddonOptionsAddonOptionVersionResult']:
        """
        The resources this work request affects.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class GetAddonOptionsAddonOptionVersionResult(dict):
    def __init__(__self__, *,
                 configurations: Sequence['outputs.GetAddonOptionsAddonOptionVersionConfigurationResult'],
                 description: builtins.str,
                 kubernetes_version_filters: Sequence['outputs.GetAddonOptionsAddonOptionVersionKubernetesVersionFilterResult'],
                 status: builtins.str,
                 version_number: builtins.str):
        """
        :param Sequence['GetAddonOptionsAddonOptionVersionConfigurationArgs'] configurations: Addon version configuration details.
        :param builtins.str description: Information about the addon version.
        :param Sequence['GetAddonOptionsAddonOptionVersionKubernetesVersionFilterArgs'] kubernetes_version_filters: The range of kubernetes versions an addon can be configured.
        :param builtins.str status: Current state of the addon, only active will be visible to customer, visibility of versions in other status will be filtered  based on limits property.
        :param builtins.str version_number: Version number, need be comparable within an addon.
        """
        pulumi.set(__self__, "configurations", configurations)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "kubernetes_version_filters", kubernetes_version_filters)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "version_number", version_number)

    @property
    @pulumi.getter
    def configurations(self) -> Sequence['outputs.GetAddonOptionsAddonOptionVersionConfigurationResult']:
        """
        Addon version configuration details.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Information about the addon version.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="kubernetesVersionFilters")
    def kubernetes_version_filters(self) -> Sequence['outputs.GetAddonOptionsAddonOptionVersionKubernetesVersionFilterResult']:
        """
        The range of kubernetes versions an addon can be configured.
        """
        return pulumi.get(self, "kubernetes_version_filters")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Current state of the addon, only active will be visible to customer, visibility of versions in other status will be filtered  based on limits property.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> builtins.str:
        """
        Version number, need be comparable within an addon.
        """
        return pulumi.get(self, "version_number")


@pulumi.output_type
class GetAddonOptionsAddonOptionVersionConfigurationResult(dict):
    def __init__(__self__, *,
                 description: builtins.str,
                 display_name: builtins.str,
                 is_required: builtins.bool,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str description: Information about the addon version.
        :param builtins.str display_name: Display name of addon version.
        :param builtins.bool is_required: If the the configuration is required or not.
        :param builtins.str key: Addon configuration key
        :param builtins.str value: Addon configuration value
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "is_required", is_required)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Information about the addon version.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Display name of addon version.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="isRequired")
    def is_required(self) -> builtins.bool:
        """
        If the the configuration is required or not.
        """
        return pulumi.get(self, "is_required")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Addon configuration key
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Addon configuration value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAddonOptionsAddonOptionVersionKubernetesVersionFilterResult(dict):
    def __init__(__self__, *,
                 exact_kubernetes_versions: Sequence[builtins.str],
                 maximum_version: builtins.str,
                 minimal_version: builtins.str):
        """
        :param Sequence[builtins.str] exact_kubernetes_versions: The exact version of kubernetes that are compatible.
        :param builtins.str maximum_version: The latest kubernetes version.
        :param builtins.str minimal_version: The earliest kubernetes version.
        """
        pulumi.set(__self__, "exact_kubernetes_versions", exact_kubernetes_versions)
        pulumi.set(__self__, "maximum_version", maximum_version)
        pulumi.set(__self__, "minimal_version", minimal_version)

    @property
    @pulumi.getter(name="exactKubernetesVersions")
    def exact_kubernetes_versions(self) -> Sequence[builtins.str]:
        """
        The exact version of kubernetes that are compatible.
        """
        return pulumi.get(self, "exact_kubernetes_versions")

    @property
    @pulumi.getter(name="maximumVersion")
    def maximum_version(self) -> builtins.str:
        """
        The latest kubernetes version.
        """
        return pulumi.get(self, "maximum_version")

    @property
    @pulumi.getter(name="minimalVersion")
    def minimal_version(self) -> builtins.str:
        """
        The earliest kubernetes version.
        """
        return pulumi.get(self, "minimal_version")


@pulumi.output_type
class GetAddonOptionsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: Name of the addon and it would be unique.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the addon and it would be unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetAddonsAddonResult(dict):
    def __init__(__self__, *,
                 addon_errors: Sequence['outputs.GetAddonsAddonAddonErrorResult'],
                 addon_name: builtins.str,
                 cluster_id: builtins.str,
                 configurations: Sequence['outputs.GetAddonsAddonConfigurationResult'],
                 current_installed_version: builtins.str,
                 remove_addon_resources_on_delete: builtins.bool,
                 state: builtins.str,
                 time_created: builtins.str,
                 version: builtins.str,
                 override_existing: Optional[builtins.bool] = None):
        """
        :param Sequence['GetAddonsAddonAddonErrorArgs'] addon_errors: The error info of the addon.
        :param builtins.str addon_name: The name of the addon.
        :param builtins.str cluster_id: The OCID of the cluster.
        :param Sequence['GetAddonsAddonConfigurationArgs'] configurations: Addon configuration details.
        :param builtins.str current_installed_version: current installed version of the addon
        :param builtins.str state: The state of the addon.
        :param builtins.str time_created: The time the cluster was created.
        :param builtins.str version: selected addon version, or null indicates autoUpdate
        """
        pulumi.set(__self__, "addon_errors", addon_errors)
        pulumi.set(__self__, "addon_name", addon_name)
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "configurations", configurations)
        pulumi.set(__self__, "current_installed_version", current_installed_version)
        pulumi.set(__self__, "remove_addon_resources_on_delete", remove_addon_resources_on_delete)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "version", version)
        if override_existing is not None:
            pulumi.set(__self__, "override_existing", override_existing)

    @property
    @pulumi.getter(name="addonErrors")
    def addon_errors(self) -> Sequence['outputs.GetAddonsAddonAddonErrorResult']:
        """
        The error info of the addon.
        """
        return pulumi.get(self, "addon_errors")

    @property
    @pulumi.getter(name="addonName")
    def addon_name(self) -> builtins.str:
        """
        The name of the addon.
        """
        return pulumi.get(self, "addon_name")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> builtins.str:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def configurations(self) -> Sequence['outputs.GetAddonsAddonConfigurationResult']:
        """
        Addon configuration details.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter(name="currentInstalledVersion")
    def current_installed_version(self) -> builtins.str:
        """
        current installed version of the addon
        """
        return pulumi.get(self, "current_installed_version")

    @property
    @pulumi.getter(name="removeAddonResourcesOnDelete")
    def remove_addon_resources_on_delete(self) -> builtins.bool:
        return pulumi.get(self, "remove_addon_resources_on_delete")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The state of the addon.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the cluster was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        selected addon version, or null indicates autoUpdate
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="overrideExisting")
    def override_existing(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "override_existing")


@pulumi.output_type
class GetAddonsAddonAddonErrorResult(dict):
    def __init__(__self__, *,
                 code: builtins.str,
                 message: builtins.str,
                 status: builtins.str):
        """
        :param builtins.str code: A short error code that defines the upstream error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        :param builtins.str message: A human-readable error string of the upstream error.
        :param builtins.str status: The status of the HTTP response encountered in the upstream error.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def code(self) -> builtins.str:
        """
        A short error code that defines the upstream error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        """
        A human-readable error string of the upstream error.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The status of the HTTP response encountered in the upstream error.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetAddonsAddonConfigurationResult(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: configuration key name
        :param builtins.str value: configuration value name
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        configuration key name
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        configuration value name
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAddonsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetClusterClusterPodNetworkOptionResult(dict):
    def __init__(__self__, *,
                 cni_type: builtins.str):
        """
        :param builtins.str cni_type: The CNI used by the node pools of this cluster
        """
        pulumi.set(__self__, "cni_type", cni_type)

    @property
    @pulumi.getter(name="cniType")
    def cni_type(self) -> builtins.str:
        """
        The CNI used by the node pools of this cluster
        """
        return pulumi.get(self, "cni_type")


@pulumi.output_type
class GetClusterEndpointResult(dict):
    def __init__(__self__, *,
                 ipv6endpoint: builtins.str,
                 kubernetes: builtins.str,
                 private_endpoint: builtins.str,
                 public_endpoint: builtins.str,
                 vcn_hostname_endpoint: builtins.str):
        """
        :param builtins.str ipv6endpoint: The IPv6 networking Kubernetes API server endpoint.
        :param builtins.str kubernetes: The non-native networking Kubernetes API server endpoint.
        :param builtins.str private_endpoint: The private native networking Kubernetes API server endpoint.
        :param builtins.str public_endpoint: The public native networking Kubernetes API server endpoint, if one was requested.
        :param builtins.str vcn_hostname_endpoint: The FQDN assigned to the Kubernetes API private endpoint. Example: 'https://yourVcnHostnameEndpoint'
        """
        pulumi.set(__self__, "ipv6endpoint", ipv6endpoint)
        pulumi.set(__self__, "kubernetes", kubernetes)
        pulumi.set(__self__, "private_endpoint", private_endpoint)
        pulumi.set(__self__, "public_endpoint", public_endpoint)
        pulumi.set(__self__, "vcn_hostname_endpoint", vcn_hostname_endpoint)

    @property
    @pulumi.getter
    def ipv6endpoint(self) -> builtins.str:
        """
        The IPv6 networking Kubernetes API server endpoint.
        """
        return pulumi.get(self, "ipv6endpoint")

    @property
    @pulumi.getter
    def kubernetes(self) -> builtins.str:
        """
        The non-native networking Kubernetes API server endpoint.
        """
        return pulumi.get(self, "kubernetes")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> builtins.str:
        """
        The private native networking Kubernetes API server endpoint.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> builtins.str:
        """
        The public native networking Kubernetes API server endpoint, if one was requested.
        """
        return pulumi.get(self, "public_endpoint")

    @property
    @pulumi.getter(name="vcnHostnameEndpoint")
    def vcn_hostname_endpoint(self) -> builtins.str:
        """
        The FQDN assigned to the Kubernetes API private endpoint. Example: 'https://yourVcnHostnameEndpoint'
        """
        return pulumi.get(self, "vcn_hostname_endpoint")


@pulumi.output_type
class GetClusterEndpointConfigResult(dict):
    def __init__(__self__, *,
                 is_public_ip_enabled: builtins.bool,
                 nsg_ids: Sequence[builtins.str],
                 subnet_id: builtins.str):
        """
        :param builtins.bool is_public_ip_enabled: Whether the cluster should be assigned a public IP address. Defaults to false. If set to true on a private subnet, the cluster provisioning will fail.
        :param Sequence[builtins.str] nsg_ids: A list of the OCIDs of the network security groups (NSGs) to apply to the cluster endpoint. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        :param builtins.str subnet_id: The OCID of the regional subnet in which to place the Cluster endpoint.
        """
        pulumi.set(__self__, "is_public_ip_enabled", is_public_ip_enabled)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="isPublicIpEnabled")
    def is_public_ip_enabled(self) -> builtins.bool:
        """
        Whether the cluster should be assigned a public IP address. Defaults to false. If set to true on a private subnet, the cluster provisioning will fail.
        """
        return pulumi.get(self, "is_public_ip_enabled")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[builtins.str]:
        """
        A list of the OCIDs of the network security groups (NSGs) to apply to the cluster endpoint. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The OCID of the regional subnet in which to place the Cluster endpoint.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetClusterImagePolicyConfigResult(dict):
    def __init__(__self__, *,
                 is_policy_enabled: builtins.bool,
                 key_details: Sequence['outputs.GetClusterImagePolicyConfigKeyDetailResult']):
        """
        :param builtins.bool is_policy_enabled: Whether the image verification policy is enabled. Defaults to false. If set to true, the images will be verified against the policy at runtime.
        :param Sequence['GetClusterImagePolicyConfigKeyDetailArgs'] key_details: A list of KMS key details.
        """
        pulumi.set(__self__, "is_policy_enabled", is_policy_enabled)
        pulumi.set(__self__, "key_details", key_details)

    @property
    @pulumi.getter(name="isPolicyEnabled")
    def is_policy_enabled(self) -> builtins.bool:
        """
        Whether the image verification policy is enabled. Defaults to false. If set to true, the images will be verified against the policy at runtime.
        """
        return pulumi.get(self, "is_policy_enabled")

    @property
    @pulumi.getter(name="keyDetails")
    def key_details(self) -> Sequence['outputs.GetClusterImagePolicyConfigKeyDetailResult']:
        """
        A list of KMS key details.
        """
        return pulumi.get(self, "key_details")


@pulumi.output_type
class GetClusterImagePolicyConfigKeyDetailResult(dict):
    def __init__(__self__, *,
                 kms_key_id: builtins.str):
        """
        :param builtins.str kms_key_id: The OCID of the KMS key to be used as the master encryption key for Kubernetes secret encryption.
        """
        pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> builtins.str:
        """
        The OCID of the KMS key to be used as the master encryption key for Kubernetes secret encryption.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class GetClusterMetadataResult(dict):
    def __init__(__self__, *,
                 created_by_user_id: builtins.str,
                 created_by_work_request_id: builtins.str,
                 deleted_by_user_id: builtins.str,
                 deleted_by_work_request_id: builtins.str,
                 time_created: builtins.str,
                 time_credential_expiration: builtins.str,
                 time_deleted: builtins.str,
                 time_updated: builtins.str,
                 updated_by_user_id: builtins.str,
                 updated_by_work_request_id: builtins.str):
        """
        :param builtins.str created_by_user_id: The user who created the cluster.
        :param builtins.str created_by_work_request_id: The OCID of the work request which created the cluster.
        :param builtins.str deleted_by_user_id: The user who deleted the cluster.
        :param builtins.str deleted_by_work_request_id: The OCID of the work request which deleted the cluster.
        :param builtins.str time_created: The time the cluster was created.
        :param builtins.str time_credential_expiration: The time until which the cluster credential is valid.
        :param builtins.str time_deleted: The time the cluster was deleted.
        :param builtins.str time_updated: The time the cluster was updated.
        :param builtins.str updated_by_user_id: The user who updated the cluster.
        :param builtins.str updated_by_work_request_id: The OCID of the work request which updated the cluster.
        """
        pulumi.set(__self__, "created_by_user_id", created_by_user_id)
        pulumi.set(__self__, "created_by_work_request_id", created_by_work_request_id)
        pulumi.set(__self__, "deleted_by_user_id", deleted_by_user_id)
        pulumi.set(__self__, "deleted_by_work_request_id", deleted_by_work_request_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_credential_expiration", time_credential_expiration)
        pulumi.set(__self__, "time_deleted", time_deleted)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "updated_by_user_id", updated_by_user_id)
        pulumi.set(__self__, "updated_by_work_request_id", updated_by_work_request_id)

    @property
    @pulumi.getter(name="createdByUserId")
    def created_by_user_id(self) -> builtins.str:
        """
        The user who created the cluster.
        """
        return pulumi.get(self, "created_by_user_id")

    @property
    @pulumi.getter(name="createdByWorkRequestId")
    def created_by_work_request_id(self) -> builtins.str:
        """
        The OCID of the work request which created the cluster.
        """
        return pulumi.get(self, "created_by_work_request_id")

    @property
    @pulumi.getter(name="deletedByUserId")
    def deleted_by_user_id(self) -> builtins.str:
        """
        The user who deleted the cluster.
        """
        return pulumi.get(self, "deleted_by_user_id")

    @property
    @pulumi.getter(name="deletedByWorkRequestId")
    def deleted_by_work_request_id(self) -> builtins.str:
        """
        The OCID of the work request which deleted the cluster.
        """
        return pulumi.get(self, "deleted_by_work_request_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the cluster was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeCredentialExpiration")
    def time_credential_expiration(self) -> builtins.str:
        """
        The time until which the cluster credential is valid.
        """
        return pulumi.get(self, "time_credential_expiration")

    @property
    @pulumi.getter(name="timeDeleted")
    def time_deleted(self) -> builtins.str:
        """
        The time the cluster was deleted.
        """
        return pulumi.get(self, "time_deleted")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the cluster was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="updatedByUserId")
    def updated_by_user_id(self) -> builtins.str:
        """
        The user who updated the cluster.
        """
        return pulumi.get(self, "updated_by_user_id")

    @property
    @pulumi.getter(name="updatedByWorkRequestId")
    def updated_by_work_request_id(self) -> builtins.str:
        """
        The OCID of the work request which updated the cluster.
        """
        return pulumi.get(self, "updated_by_work_request_id")


@pulumi.output_type
class GetClusterOptionResult(dict):
    def __init__(__self__, *,
                 add_ons: Sequence['outputs.GetClusterOptionAddOnResult'],
                 admission_controller_options: Sequence['outputs.GetClusterOptionAdmissionControllerOptionResult'],
                 ip_families: Sequence[builtins.str],
                 kubernetes_network_configs: Sequence['outputs.GetClusterOptionKubernetesNetworkConfigResult'],
                 open_id_connect_discoveries: Sequence['outputs.GetClusterOptionOpenIdConnectDiscoveryResult'],
                 open_id_connect_token_authentication_configs: Sequence['outputs.GetClusterOptionOpenIdConnectTokenAuthenticationConfigResult'],
                 persistent_volume_configs: Sequence['outputs.GetClusterOptionPersistentVolumeConfigResult'],
                 service_lb_configs: Sequence['outputs.GetClusterOptionServiceLbConfigResult'],
                 service_lb_subnet_ids: Sequence[builtins.str]):
        """
        :param Sequence['GetClusterOptionAddOnArgs'] add_ons: Configurable cluster add-ons
        :param Sequence['GetClusterOptionAdmissionControllerOptionArgs'] admission_controller_options: Configurable cluster admission controllers
        :param Sequence[builtins.str] ip_families: IP family to use for single stack or define the order of IP families for dual-stack. Available values are [] (defaults to IPv4), [IPv4] (IPv4), [IPv4, IPv6] (IPv4 preferred dual stack).
        :param Sequence['GetClusterOptionKubernetesNetworkConfigArgs'] kubernetes_network_configs: Network configuration for Kubernetes.
        :param Sequence['GetClusterOptionOpenIdConnectDiscoveryArgs'] open_id_connect_discoveries: The property that define the status of the OIDC Discovery feature for a cluster.
        :param Sequence['GetClusterOptionOpenIdConnectTokenAuthenticationConfigArgs'] open_id_connect_token_authentication_configs: The properties that configure OIDC token authentication in kube-apiserver. For more information, see [Configuring the API Server](https://kubernetes.io/docs/reference/access-authn-authz/authentication/#using-flags).
        :param Sequence['GetClusterOptionPersistentVolumeConfigArgs'] persistent_volume_configs: Configuration to be applied to block volumes created by Kubernetes Persistent Volume Claims (PVC)
        :param Sequence['GetClusterOptionServiceLbConfigArgs'] service_lb_configs: Configuration to be applied to load balancers created by Kubernetes services
        :param Sequence[builtins.str] service_lb_subnet_ids: The OCIDs of the subnets used for Kubernetes services load balancers.
        """
        pulumi.set(__self__, "add_ons", add_ons)
        pulumi.set(__self__, "admission_controller_options", admission_controller_options)
        pulumi.set(__self__, "ip_families", ip_families)
        pulumi.set(__self__, "kubernetes_network_configs", kubernetes_network_configs)
        pulumi.set(__self__, "open_id_connect_discoveries", open_id_connect_discoveries)
        pulumi.set(__self__, "open_id_connect_token_authentication_configs", open_id_connect_token_authentication_configs)
        pulumi.set(__self__, "persistent_volume_configs", persistent_volume_configs)
        pulumi.set(__self__, "service_lb_configs", service_lb_configs)
        pulumi.set(__self__, "service_lb_subnet_ids", service_lb_subnet_ids)

    @property
    @pulumi.getter(name="addOns")
    def add_ons(self) -> Sequence['outputs.GetClusterOptionAddOnResult']:
        """
        Configurable cluster add-ons
        """
        return pulumi.get(self, "add_ons")

    @property
    @pulumi.getter(name="admissionControllerOptions")
    def admission_controller_options(self) -> Sequence['outputs.GetClusterOptionAdmissionControllerOptionResult']:
        """
        Configurable cluster admission controllers
        """
        return pulumi.get(self, "admission_controller_options")

    @property
    @pulumi.getter(name="ipFamilies")
    def ip_families(self) -> Sequence[builtins.str]:
        """
        IP family to use for single stack or define the order of IP families for dual-stack. Available values are [] (defaults to IPv4), [IPv4] (IPv4), [IPv4, IPv6] (IPv4 preferred dual stack).
        """
        return pulumi.get(self, "ip_families")

    @property
    @pulumi.getter(name="kubernetesNetworkConfigs")
    def kubernetes_network_configs(self) -> Sequence['outputs.GetClusterOptionKubernetesNetworkConfigResult']:
        """
        Network configuration for Kubernetes.
        """
        return pulumi.get(self, "kubernetes_network_configs")

    @property
    @pulumi.getter(name="openIdConnectDiscoveries")
    def open_id_connect_discoveries(self) -> Sequence['outputs.GetClusterOptionOpenIdConnectDiscoveryResult']:
        """
        The property that define the status of the OIDC Discovery feature for a cluster.
        """
        return pulumi.get(self, "open_id_connect_discoveries")

    @property
    @pulumi.getter(name="openIdConnectTokenAuthenticationConfigs")
    def open_id_connect_token_authentication_configs(self) -> Sequence['outputs.GetClusterOptionOpenIdConnectTokenAuthenticationConfigResult']:
        """
        The properties that configure OIDC token authentication in kube-apiserver. For more information, see [Configuring the API Server](https://kubernetes.io/docs/reference/access-authn-authz/authentication/#using-flags).
        """
        return pulumi.get(self, "open_id_connect_token_authentication_configs")

    @property
    @pulumi.getter(name="persistentVolumeConfigs")
    def persistent_volume_configs(self) -> Sequence['outputs.GetClusterOptionPersistentVolumeConfigResult']:
        """
        Configuration to be applied to block volumes created by Kubernetes Persistent Volume Claims (PVC)
        """
        return pulumi.get(self, "persistent_volume_configs")

    @property
    @pulumi.getter(name="serviceLbConfigs")
    def service_lb_configs(self) -> Sequence['outputs.GetClusterOptionServiceLbConfigResult']:
        """
        Configuration to be applied to load balancers created by Kubernetes services
        """
        return pulumi.get(self, "service_lb_configs")

    @property
    @pulumi.getter(name="serviceLbSubnetIds")
    def service_lb_subnet_ids(self) -> Sequence[builtins.str]:
        """
        The OCIDs of the subnets used for Kubernetes services load balancers.
        """
        return pulumi.get(self, "service_lb_subnet_ids")


@pulumi.output_type
class GetClusterOptionAddOnResult(dict):
    def __init__(__self__, *,
                 is_kubernetes_dashboard_enabled: builtins.bool,
                 is_tiller_enabled: builtins.bool):
        """
        :param builtins.bool is_kubernetes_dashboard_enabled: Whether or not to enable the Kubernetes Dashboard add-on.
        :param builtins.bool is_tiller_enabled: Whether or not to enable the Tiller add-on.
        """
        pulumi.set(__self__, "is_kubernetes_dashboard_enabled", is_kubernetes_dashboard_enabled)
        pulumi.set(__self__, "is_tiller_enabled", is_tiller_enabled)

    @property
    @pulumi.getter(name="isKubernetesDashboardEnabled")
    def is_kubernetes_dashboard_enabled(self) -> builtins.bool:
        """
        Whether or not to enable the Kubernetes Dashboard add-on.
        """
        return pulumi.get(self, "is_kubernetes_dashboard_enabled")

    @property
    @pulumi.getter(name="isTillerEnabled")
    def is_tiller_enabled(self) -> builtins.bool:
        """
        Whether or not to enable the Tiller add-on.
        """
        return pulumi.get(self, "is_tiller_enabled")


@pulumi.output_type
class GetClusterOptionAdmissionControllerOptionResult(dict):
    def __init__(__self__, *,
                 is_pod_security_policy_enabled: builtins.bool):
        """
        :param builtins.bool is_pod_security_policy_enabled: Whether or not to enable the Pod Security Policy admission controller.
        """
        pulumi.set(__self__, "is_pod_security_policy_enabled", is_pod_security_policy_enabled)

    @property
    @pulumi.getter(name="isPodSecurityPolicyEnabled")
    def is_pod_security_policy_enabled(self) -> builtins.bool:
        """
        Whether or not to enable the Pod Security Policy admission controller.
        """
        return pulumi.get(self, "is_pod_security_policy_enabled")


@pulumi.output_type
class GetClusterOptionClusterPodNetworkOptionResult(dict):
    def __init__(__self__, *,
                 cni_type: builtins.str):
        """
        :param builtins.str cni_type: The CNI used by the node pools of this cluster
        """
        pulumi.set(__self__, "cni_type", cni_type)

    @property
    @pulumi.getter(name="cniType")
    def cni_type(self) -> builtins.str:
        """
        The CNI used by the node pools of this cluster
        """
        return pulumi.get(self, "cni_type")


@pulumi.output_type
class GetClusterOptionKubernetesNetworkConfigResult(dict):
    def __init__(__self__, *,
                 pods_cidr: builtins.str,
                 services_cidr: builtins.str):
        """
        :param builtins.str pods_cidr: The CIDR block for Kubernetes pods. Optional. For ipv4, defaults to 10.244.0.0/16. For ipv6, defaults to fd00:eeee:eeee:0000::/96.
        :param builtins.str services_cidr: The CIDR block for Kubernetes services. Optional. For ipv4, defaults to 10.96.0.0/16. For ipv6, defaults to fd00:eeee:eeee:0001::/108.
        """
        pulumi.set(__self__, "pods_cidr", pods_cidr)
        pulumi.set(__self__, "services_cidr", services_cidr)

    @property
    @pulumi.getter(name="podsCidr")
    def pods_cidr(self) -> builtins.str:
        """
        The CIDR block for Kubernetes pods. Optional. For ipv4, defaults to 10.244.0.0/16. For ipv6, defaults to fd00:eeee:eeee:0000::/96.
        """
        return pulumi.get(self, "pods_cidr")

    @property
    @pulumi.getter(name="servicesCidr")
    def services_cidr(self) -> builtins.str:
        """
        The CIDR block for Kubernetes services. Optional. For ipv4, defaults to 10.96.0.0/16. For ipv6, defaults to fd00:eeee:eeee:0001::/108.
        """
        return pulumi.get(self, "services_cidr")


@pulumi.output_type
class GetClusterOptionOpenIdConnectDiscoveryResult(dict):
    def __init__(__self__, *,
                 is_open_id_connect_discovery_enabled: builtins.bool):
        """
        :param builtins.bool is_open_id_connect_discovery_enabled: Whether the cluster has OIDC Discovery enabled. Defaults to false. If set to true, the cluster will be assigned a public OIDC Discovery endpoint.
        """
        pulumi.set(__self__, "is_open_id_connect_discovery_enabled", is_open_id_connect_discovery_enabled)

    @property
    @pulumi.getter(name="isOpenIdConnectDiscoveryEnabled")
    def is_open_id_connect_discovery_enabled(self) -> builtins.bool:
        """
        Whether the cluster has OIDC Discovery enabled. Defaults to false. If set to true, the cluster will be assigned a public OIDC Discovery endpoint.
        """
        return pulumi.get(self, "is_open_id_connect_discovery_enabled")


@pulumi.output_type
class GetClusterOptionOpenIdConnectTokenAuthenticationConfigResult(dict):
    def __init__(__self__, *,
                 ca_certificate: builtins.str,
                 client_id: builtins.str,
                 configuration_file: builtins.str,
                 groups_claim: builtins.str,
                 groups_prefix: builtins.str,
                 is_open_id_connect_auth_enabled: builtins.bool,
                 issuer_url: builtins.str,
                 required_claims: Sequence['outputs.GetClusterOptionOpenIdConnectTokenAuthenticationConfigRequiredClaimResult'],
                 signing_algorithms: Sequence[builtins.str],
                 username_claim: builtins.str,
                 username_prefix: builtins.str):
        """
        :param builtins.str ca_certificate: A Base64 encoded public RSA or ECDSA certificates used to signed your identity provider's web certificate.
        :param builtins.str client_id: A client id that all tokens must be issued for.
        :param builtins.str configuration_file: A Base64 encoded string of a Kubernetes OIDC Auth Config file. More info [here](https://kubernetes.io/docs/reference/access-authn-authz/authentication/#using-authentication-configuration)
        :param builtins.str groups_claim: JWT claim to use as the user's group. If the claim is present it must be an array of strings.
        :param builtins.str groups_prefix: Prefix prepended to group claims to prevent clashes with existing names (such as system:groups).
        :param builtins.bool is_open_id_connect_auth_enabled: Whether the cluster has OIDC Auth Config enabled. Defaults to false.
        :param builtins.str issuer_url: URL of the provider that allows the API server to discover public signing keys.  Only URLs that use the https:// scheme are accepted. This is typically the provider's discovery URL,  changed to have an empty path.
        :param Sequence['GetClusterOptionOpenIdConnectTokenAuthenticationConfigRequiredClaimArgs'] required_claims: A key=value pair that describes a required claim in the ID Token. If set, the claim is verified to be present  in the ID Token with a matching value. Repeat this flag to specify multiple claims.
        :param Sequence[builtins.str] signing_algorithms: The signing algorithms accepted. Default is ["RS256"].
        :param builtins.str username_claim: JWT claim to use as the user name. By default sub, which is expected to be a unique identifier of the end  user. Admins can choose other claims, such as email or name, depending on their provider. However, claims  other than email will be prefixed with the issuer URL to prevent naming clashes with other plugins.
        :param builtins.str username_prefix: Prefix prepended to username claims to prevent clashes with existing names (such as system:users).  For example, the value oidc: will create usernames like oidc:jane.doe. If this flag isn't provided and  --oidc-username-claim is a value other than email the prefix defaults to ( Issuer URL )# where  ( Issuer URL ) is the value of --oidc-issuer-url. The value - can be used to disable all prefixing.
        """
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "configuration_file", configuration_file)
        pulumi.set(__self__, "groups_claim", groups_claim)
        pulumi.set(__self__, "groups_prefix", groups_prefix)
        pulumi.set(__self__, "is_open_id_connect_auth_enabled", is_open_id_connect_auth_enabled)
        pulumi.set(__self__, "issuer_url", issuer_url)
        pulumi.set(__self__, "required_claims", required_claims)
        pulumi.set(__self__, "signing_algorithms", signing_algorithms)
        pulumi.set(__self__, "username_claim", username_claim)
        pulumi.set(__self__, "username_prefix", username_prefix)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> builtins.str:
        """
        A Base64 encoded public RSA or ECDSA certificates used to signed your identity provider's web certificate.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> builtins.str:
        """
        A client id that all tokens must be issued for.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="configurationFile")
    def configuration_file(self) -> builtins.str:
        """
        A Base64 encoded string of a Kubernetes OIDC Auth Config file. More info [here](https://kubernetes.io/docs/reference/access-authn-authz/authentication/#using-authentication-configuration)
        """
        return pulumi.get(self, "configuration_file")

    @property
    @pulumi.getter(name="groupsClaim")
    def groups_claim(self) -> builtins.str:
        """
        JWT claim to use as the user's group. If the claim is present it must be an array of strings.
        """
        return pulumi.get(self, "groups_claim")

    @property
    @pulumi.getter(name="groupsPrefix")
    def groups_prefix(self) -> builtins.str:
        """
        Prefix prepended to group claims to prevent clashes with existing names (such as system:groups).
        """
        return pulumi.get(self, "groups_prefix")

    @property
    @pulumi.getter(name="isOpenIdConnectAuthEnabled")
    def is_open_id_connect_auth_enabled(self) -> builtins.bool:
        """
        Whether the cluster has OIDC Auth Config enabled. Defaults to false.
        """
        return pulumi.get(self, "is_open_id_connect_auth_enabled")

    @property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> builtins.str:
        """
        URL of the provider that allows the API server to discover public signing keys.  Only URLs that use the https:// scheme are accepted. This is typically the provider's discovery URL,  changed to have an empty path.
        """
        return pulumi.get(self, "issuer_url")

    @property
    @pulumi.getter(name="requiredClaims")
    def required_claims(self) -> Sequence['outputs.GetClusterOptionOpenIdConnectTokenAuthenticationConfigRequiredClaimResult']:
        """
        A key=value pair that describes a required claim in the ID Token. If set, the claim is verified to be present  in the ID Token with a matching value. Repeat this flag to specify multiple claims.
        """
        return pulumi.get(self, "required_claims")

    @property
    @pulumi.getter(name="signingAlgorithms")
    def signing_algorithms(self) -> Sequence[builtins.str]:
        """
        The signing algorithms accepted. Default is ["RS256"].
        """
        return pulumi.get(self, "signing_algorithms")

    @property
    @pulumi.getter(name="usernameClaim")
    def username_claim(self) -> builtins.str:
        """
        JWT claim to use as the user name. By default sub, which is expected to be a unique identifier of the end  user. Admins can choose other claims, such as email or name, depending on their provider. However, claims  other than email will be prefixed with the issuer URL to prevent naming clashes with other plugins.
        """
        return pulumi.get(self, "username_claim")

    @property
    @pulumi.getter(name="usernamePrefix")
    def username_prefix(self) -> builtins.str:
        """
        Prefix prepended to username claims to prevent clashes with existing names (such as system:users).  For example, the value oidc: will create usernames like oidc:jane.doe. If this flag isn't provided and  --oidc-username-claim is a value other than email the prefix defaults to ( Issuer URL )# where  ( Issuer URL ) is the value of --oidc-issuer-url. The value - can be used to disable all prefixing.
        """
        return pulumi.get(self, "username_prefix")


@pulumi.output_type
class GetClusterOptionOpenIdConnectTokenAuthenticationConfigRequiredClaimResult(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The key of the pair.
        :param builtins.str value: The value of the pair.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetClusterOptionPersistentVolumeConfigResult(dict):
    def __init__(__self__, *,
                 defined_tags: Mapping[str, builtins.str],
                 freeform_tags: Mapping[str, builtins.str]):
        """
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")


@pulumi.output_type
class GetClusterOptionServiceLbConfigResult(dict):
    def __init__(__self__, *,
                 defined_tags: Mapping[str, builtins.str],
                 freeform_tags: Mapping[str, builtins.str]):
        """
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")


@pulumi.output_type
class GetClusterWorkloadMappingsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetClusterWorkloadMappingsWorkloadMappingResult(dict):
    def __init__(__self__, *,
                 cluster_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 mapped_compartment_id: builtins.str,
                 mapped_tenancy_id: builtins.str,
                 namespace: builtins.str,
                 state: builtins.str,
                 time_created: builtins.str):
        """
        :param builtins.str cluster_id: The OCID of the cluster.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param builtins.str id: The ocid of the workloadMapping.
        :param builtins.str mapped_compartment_id: The OCID of the mapped customer compartment.
        :param builtins.str mapped_tenancy_id: The OCID of the mapped customer tenancy.
        :param builtins.str namespace: The namespace of the workloadMapping.
        :param builtins.str state: The state of the workloadMapping.
        :param builtins.str time_created: The time the cluster was created.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "mapped_compartment_id", mapped_compartment_id)
        pulumi.set(__self__, "mapped_tenancy_id", mapped_tenancy_id)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> builtins.str:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ocid of the workloadMapping.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="mappedCompartmentId")
    def mapped_compartment_id(self) -> builtins.str:
        """
        The OCID of the mapped customer compartment.
        """
        return pulumi.get(self, "mapped_compartment_id")

    @property
    @pulumi.getter(name="mappedTenancyId")
    def mapped_tenancy_id(self) -> builtins.str:
        """
        The OCID of the mapped customer tenancy.
        """
        return pulumi.get(self, "mapped_tenancy_id")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        The namespace of the workloadMapping.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The state of the workloadMapping.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the cluster was created.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetClustersClusterResult(dict):
    def __init__(__self__, *,
                 available_kubernetes_upgrades: Sequence[builtins.str],
                 cluster_pod_network_options: Sequence['outputs.GetClustersClusterClusterPodNetworkOptionResult'],
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 endpoint_configs: Sequence['outputs.GetClustersClusterEndpointConfigResult'],
                 endpoints: Sequence['outputs.GetClustersClusterEndpointResult'],
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 image_policy_configs: Sequence['outputs.GetClustersClusterImagePolicyConfigResult'],
                 kms_key_id: builtins.str,
                 kubernetes_version: builtins.str,
                 lifecycle_details: builtins.str,
                 metadatas: Sequence['outputs.GetClustersClusterMetadataResult'],
                 name: builtins.str,
                 open_id_connect_discovery_endpoint: builtins.str,
                 open_id_connect_discovery_key: builtins.str,
                 options: Sequence['outputs.GetClustersClusterOptionResult'],
                 state: builtins.str,
                 type: builtins.str,
                 vcn_id: builtins.str):
        """
        :param Sequence[builtins.str] available_kubernetes_upgrades: Available Kubernetes versions to which the clusters masters may be upgraded.
        :param Sequence['GetClustersClusterClusterPodNetworkOptionArgs'] cluster_pod_network_options: Available CNIs and network options for existing and new node pools of the cluster
        :param builtins.str compartment_id: The OCID of the compartment.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Sequence['GetClustersClusterEndpointConfigArgs'] endpoint_configs: The network configuration for access to the Cluster control plane.
        :param Sequence['GetClustersClusterEndpointArgs'] endpoints: Endpoints served up by the cluster masters.
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param builtins.str id: The OCID of the cluster.
        :param Sequence['GetClustersClusterImagePolicyConfigArgs'] image_policy_configs: The image verification policy for signature validation.
        :param builtins.str kms_key_id: The OCID of the KMS key to be used as the master encryption key for Kubernetes secret encryption.
        :param builtins.str kubernetes_version: The version of Kubernetes running on the cluster masters.
        :param builtins.str lifecycle_details: Details about the state of the cluster masters.
        :param Sequence['GetClustersClusterMetadataArgs'] metadatas: Metadata about the cluster.
        :param builtins.str name: The name to filter on.
        :param builtins.str open_id_connect_discovery_endpoint: The cluster-specific OpenID Connect Discovery endpoint
        :param builtins.str open_id_connect_discovery_key: The cluster-specific OpenID Connect Discovery Key to derive the DiscoveryEndpoint
        :param Sequence['GetClustersClusterOptionArgs'] options: Optional attributes for the cluster.
        :param builtins.str state: A cluster lifecycle state to filter on. Can have multiple parameters of this name.
        :param builtins.str type: Type of cluster. Values can be BASIC_CLUSTER or ENHANCED_CLUSTER. For more information, see [Cluster Types](https://docs.cloud.oracle.com/iaas/Content/ContEng/Tasks/contengcomparingenhancedwithbasicclusters_topic.htm)
        :param builtins.str vcn_id: The OCID of the virtual cloud network (VCN) in which the cluster exists.
        """
        pulumi.set(__self__, "available_kubernetes_upgrades", available_kubernetes_upgrades)
        pulumi.set(__self__, "cluster_pod_network_options", cluster_pod_network_options)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "endpoint_configs", endpoint_configs)
        pulumi.set(__self__, "endpoints", endpoints)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_policy_configs", image_policy_configs)
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "metadatas", metadatas)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "open_id_connect_discovery_endpoint", open_id_connect_discovery_endpoint)
        pulumi.set(__self__, "open_id_connect_discovery_key", open_id_connect_discovery_key)
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="availableKubernetesUpgrades")
    def available_kubernetes_upgrades(self) -> Sequence[builtins.str]:
        """
        Available Kubernetes versions to which the clusters masters may be upgraded.
        """
        return pulumi.get(self, "available_kubernetes_upgrades")

    @property
    @pulumi.getter(name="clusterPodNetworkOptions")
    def cluster_pod_network_options(self) -> Sequence['outputs.GetClustersClusterClusterPodNetworkOptionResult']:
        """
        Available CNIs and network options for existing and new node pools of the cluster
        """
        return pulumi.get(self, "cluster_pod_network_options")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="endpointConfigs")
    def endpoint_configs(self) -> Sequence['outputs.GetClustersClusterEndpointConfigResult']:
        """
        The network configuration for access to the Cluster control plane.
        """
        return pulumi.get(self, "endpoint_configs")

    @property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetClustersClusterEndpointResult']:
        """
        Endpoints served up by the cluster masters.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imagePolicyConfigs")
    def image_policy_configs(self) -> Sequence['outputs.GetClustersClusterImagePolicyConfigResult']:
        """
        The image verification policy for signature validation.
        """
        return pulumi.get(self, "image_policy_configs")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> builtins.str:
        """
        The OCID of the KMS key to be used as the master encryption key for Kubernetes secret encryption.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> builtins.str:
        """
        The version of Kubernetes running on the cluster masters.
        """
        return pulumi.get(self, "kubernetes_version")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Details about the state of the cluster masters.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def metadatas(self) -> Sequence['outputs.GetClustersClusterMetadataResult']:
        """
        Metadata about the cluster.
        """
        return pulumi.get(self, "metadatas")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name to filter on.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="openIdConnectDiscoveryEndpoint")
    def open_id_connect_discovery_endpoint(self) -> builtins.str:
        """
        The cluster-specific OpenID Connect Discovery endpoint
        """
        return pulumi.get(self, "open_id_connect_discovery_endpoint")

    @property
    @pulumi.getter(name="openIdConnectDiscoveryKey")
    def open_id_connect_discovery_key(self) -> builtins.str:
        """
        The cluster-specific OpenID Connect Discovery Key to derive the DiscoveryEndpoint
        """
        return pulumi.get(self, "open_id_connect_discovery_key")

    @property
    @pulumi.getter
    def options(self) -> Sequence['outputs.GetClustersClusterOptionResult']:
        """
        Optional attributes for the cluster.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A cluster lifecycle state to filter on. Can have multiple parameters of this name.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of cluster. Values can be BASIC_CLUSTER or ENHANCED_CLUSTER. For more information, see [Cluster Types](https://docs.cloud.oracle.com/iaas/Content/ContEng/Tasks/contengcomparingenhancedwithbasicclusters_topic.htm)
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> builtins.str:
        """
        The OCID of the virtual cloud network (VCN) in which the cluster exists.
        """
        return pulumi.get(self, "vcn_id")


@pulumi.output_type
class GetClustersClusterClusterPodNetworkOptionResult(dict):
    def __init__(__self__, *,
                 cni_type: builtins.str):
        """
        :param builtins.str cni_type: The CNI used by the node pools of this cluster
        """
        pulumi.set(__self__, "cni_type", cni_type)

    @property
    @pulumi.getter(name="cniType")
    def cni_type(self) -> builtins.str:
        """
        The CNI used by the node pools of this cluster
        """
        return pulumi.get(self, "cni_type")


@pulumi.output_type
class GetClustersClusterEndpointResult(dict):
    def __init__(__self__, *,
                 ipv6endpoint: builtins.str,
                 kubernetes: builtins.str,
                 private_endpoint: builtins.str,
                 public_endpoint: builtins.str,
                 vcn_hostname_endpoint: builtins.str):
        """
        :param builtins.str ipv6endpoint: The IPv6 networking Kubernetes API server endpoint.
        :param builtins.str kubernetes: The non-native networking Kubernetes API server endpoint.
        :param builtins.str private_endpoint: The private native networking Kubernetes API server endpoint.
        :param builtins.str public_endpoint: The public native networking Kubernetes API server endpoint, if one was requested.
        :param builtins.str vcn_hostname_endpoint: The FQDN assigned to the Kubernetes API private endpoint. Example: 'https://yourVcnHostnameEndpoint'
        """
        pulumi.set(__self__, "ipv6endpoint", ipv6endpoint)
        pulumi.set(__self__, "kubernetes", kubernetes)
        pulumi.set(__self__, "private_endpoint", private_endpoint)
        pulumi.set(__self__, "public_endpoint", public_endpoint)
        pulumi.set(__self__, "vcn_hostname_endpoint", vcn_hostname_endpoint)

    @property
    @pulumi.getter
    def ipv6endpoint(self) -> builtins.str:
        """
        The IPv6 networking Kubernetes API server endpoint.
        """
        return pulumi.get(self, "ipv6endpoint")

    @property
    @pulumi.getter
    def kubernetes(self) -> builtins.str:
        """
        The non-native networking Kubernetes API server endpoint.
        """
        return pulumi.get(self, "kubernetes")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> builtins.str:
        """
        The private native networking Kubernetes API server endpoint.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> builtins.str:
        """
        The public native networking Kubernetes API server endpoint, if one was requested.
        """
        return pulumi.get(self, "public_endpoint")

    @property
    @pulumi.getter(name="vcnHostnameEndpoint")
    def vcn_hostname_endpoint(self) -> builtins.str:
        """
        The FQDN assigned to the Kubernetes API private endpoint. Example: 'https://yourVcnHostnameEndpoint'
        """
        return pulumi.get(self, "vcn_hostname_endpoint")


@pulumi.output_type
class GetClustersClusterEndpointConfigResult(dict):
    def __init__(__self__, *,
                 is_public_ip_enabled: builtins.bool,
                 nsg_ids: Sequence[builtins.str],
                 subnet_id: builtins.str):
        """
        :param builtins.bool is_public_ip_enabled: Whether the cluster should be assigned a public IP address. Defaults to false. If set to true on a private subnet, the cluster provisioning will fail.
        :param Sequence[builtins.str] nsg_ids: A list of the OCIDs of the network security groups (NSGs) to apply to the cluster endpoint. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        :param builtins.str subnet_id: The OCID of the regional subnet in which to place the Cluster endpoint.
        """
        pulumi.set(__self__, "is_public_ip_enabled", is_public_ip_enabled)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="isPublicIpEnabled")
    def is_public_ip_enabled(self) -> builtins.bool:
        """
        Whether the cluster should be assigned a public IP address. Defaults to false. If set to true on a private subnet, the cluster provisioning will fail.
        """
        return pulumi.get(self, "is_public_ip_enabled")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[builtins.str]:
        """
        A list of the OCIDs of the network security groups (NSGs) to apply to the cluster endpoint. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The OCID of the regional subnet in which to place the Cluster endpoint.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetClustersClusterImagePolicyConfigResult(dict):
    def __init__(__self__, *,
                 is_policy_enabled: builtins.bool,
                 key_details: Sequence['outputs.GetClustersClusterImagePolicyConfigKeyDetailResult']):
        """
        :param builtins.bool is_policy_enabled: Whether the image verification policy is enabled. Defaults to false. If set to true, the images will be verified against the policy at runtime.
        :param Sequence['GetClustersClusterImagePolicyConfigKeyDetailArgs'] key_details: A list of KMS key details.
        """
        pulumi.set(__self__, "is_policy_enabled", is_policy_enabled)
        pulumi.set(__self__, "key_details", key_details)

    @property
    @pulumi.getter(name="isPolicyEnabled")
    def is_policy_enabled(self) -> builtins.bool:
        """
        Whether the image verification policy is enabled. Defaults to false. If set to true, the images will be verified against the policy at runtime.
        """
        return pulumi.get(self, "is_policy_enabled")

    @property
    @pulumi.getter(name="keyDetails")
    def key_details(self) -> Sequence['outputs.GetClustersClusterImagePolicyConfigKeyDetailResult']:
        """
        A list of KMS key details.
        """
        return pulumi.get(self, "key_details")


@pulumi.output_type
class GetClustersClusterImagePolicyConfigKeyDetailResult(dict):
    def __init__(__self__, *,
                 kms_key_id: builtins.str):
        """
        :param builtins.str kms_key_id: The OCID of the KMS key to be used as the master encryption key for Kubernetes secret encryption.
        """
        pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> builtins.str:
        """
        The OCID of the KMS key to be used as the master encryption key for Kubernetes secret encryption.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class GetClustersClusterMetadataResult(dict):
    def __init__(__self__, *,
                 created_by_user_id: builtins.str,
                 created_by_work_request_id: builtins.str,
                 deleted_by_user_id: builtins.str,
                 deleted_by_work_request_id: builtins.str,
                 time_created: builtins.str,
                 time_credential_expiration: builtins.str,
                 time_deleted: builtins.str,
                 time_updated: builtins.str,
                 updated_by_user_id: builtins.str,
                 updated_by_work_request_id: builtins.str):
        """
        :param builtins.str created_by_user_id: The user who created the cluster.
        :param builtins.str created_by_work_request_id: The OCID of the work request which created the cluster.
        :param builtins.str deleted_by_user_id: The user who deleted the cluster.
        :param builtins.str deleted_by_work_request_id: The OCID of the work request which deleted the cluster.
        :param builtins.str time_created: The time the cluster was created.
        :param builtins.str time_credential_expiration: The time until which the cluster credential is valid.
        :param builtins.str time_deleted: The time the cluster was deleted.
        :param builtins.str time_updated: The time the cluster was updated.
        :param builtins.str updated_by_user_id: The user who updated the cluster.
        :param builtins.str updated_by_work_request_id: The OCID of the work request which updated the cluster.
        """
        pulumi.set(__self__, "created_by_user_id", created_by_user_id)
        pulumi.set(__self__, "created_by_work_request_id", created_by_work_request_id)
        pulumi.set(__self__, "deleted_by_user_id", deleted_by_user_id)
        pulumi.set(__self__, "deleted_by_work_request_id", deleted_by_work_request_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_credential_expiration", time_credential_expiration)
        pulumi.set(__self__, "time_deleted", time_deleted)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "updated_by_user_id", updated_by_user_id)
        pulumi.set(__self__, "updated_by_work_request_id", updated_by_work_request_id)

    @property
    @pulumi.getter(name="createdByUserId")
    def created_by_user_id(self) -> builtins.str:
        """
        The user who created the cluster.
        """
        return pulumi.get(self, "created_by_user_id")

    @property
    @pulumi.getter(name="createdByWorkRequestId")
    def created_by_work_request_id(self) -> builtins.str:
        """
        The OCID of the work request which created the cluster.
        """
        return pulumi.get(self, "created_by_work_request_id")

    @property
    @pulumi.getter(name="deletedByUserId")
    def deleted_by_user_id(self) -> builtins.str:
        """
        The user who deleted the cluster.
        """
        return pulumi.get(self, "deleted_by_user_id")

    @property
    @pulumi.getter(name="deletedByWorkRequestId")
    def deleted_by_work_request_id(self) -> builtins.str:
        """
        The OCID of the work request which deleted the cluster.
        """
        return pulumi.get(self, "deleted_by_work_request_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the cluster was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeCredentialExpiration")
    def time_credential_expiration(self) -> builtins.str:
        """
        The time until which the cluster credential is valid.
        """
        return pulumi.get(self, "time_credential_expiration")

    @property
    @pulumi.getter(name="timeDeleted")
    def time_deleted(self) -> builtins.str:
        """
        The time the cluster was deleted.
        """
        return pulumi.get(self, "time_deleted")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the cluster was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="updatedByUserId")
    def updated_by_user_id(self) -> builtins.str:
        """
        The user who updated the cluster.
        """
        return pulumi.get(self, "updated_by_user_id")

    @property
    @pulumi.getter(name="updatedByWorkRequestId")
    def updated_by_work_request_id(self) -> builtins.str:
        """
        The OCID of the work request which updated the cluster.
        """
        return pulumi.get(self, "updated_by_work_request_id")


@pulumi.output_type
class GetClustersClusterOptionResult(dict):
    def __init__(__self__, *,
                 add_ons: Sequence['outputs.GetClustersClusterOptionAddOnResult'],
                 admission_controller_options: Sequence['outputs.GetClustersClusterOptionAdmissionControllerOptionResult'],
                 ip_families: Sequence[builtins.str],
                 kubernetes_network_configs: Sequence['outputs.GetClustersClusterOptionKubernetesNetworkConfigResult'],
                 open_id_connect_discoveries: Sequence['outputs.GetClustersClusterOptionOpenIdConnectDiscoveryResult'],
                 open_id_connect_token_authentication_configs: Sequence['outputs.GetClustersClusterOptionOpenIdConnectTokenAuthenticationConfigResult'],
                 persistent_volume_configs: Sequence['outputs.GetClustersClusterOptionPersistentVolumeConfigResult'],
                 service_lb_configs: Sequence['outputs.GetClustersClusterOptionServiceLbConfigResult'],
                 service_lb_subnet_ids: Sequence[builtins.str]):
        """
        :param Sequence['GetClustersClusterOptionAddOnArgs'] add_ons: Configurable cluster add-ons
        :param Sequence['GetClustersClusterOptionAdmissionControllerOptionArgs'] admission_controller_options: Configurable cluster admission controllers
        :param Sequence[builtins.str] ip_families: IP family to use for single stack or define the order of IP families for dual-stack. Available values are [] (defaults to IPv4), [IPv4] (IPv4), [IPv4, IPv6] (IPv4 preferred dual stack).
        :param Sequence['GetClustersClusterOptionKubernetesNetworkConfigArgs'] kubernetes_network_configs: Network configuration for Kubernetes.
        :param Sequence['GetClustersClusterOptionOpenIdConnectDiscoveryArgs'] open_id_connect_discoveries: The property that define the status of the OIDC Discovery feature for a cluster.
        :param Sequence['GetClustersClusterOptionOpenIdConnectTokenAuthenticationConfigArgs'] open_id_connect_token_authentication_configs: The properties that configure OIDC token authentication in kube-apiserver. For more information, see [Configuring the API Server](https://kubernetes.io/docs/reference/access-authn-authz/authentication/#using-flags).
        :param Sequence['GetClustersClusterOptionPersistentVolumeConfigArgs'] persistent_volume_configs: Configuration to be applied to block volumes created by Kubernetes Persistent Volume Claims (PVC)
        :param Sequence['GetClustersClusterOptionServiceLbConfigArgs'] service_lb_configs: Configuration to be applied to load balancers created by Kubernetes services
        :param Sequence[builtins.str] service_lb_subnet_ids: The OCIDs of the subnets used for Kubernetes services load balancers.
        """
        pulumi.set(__self__, "add_ons", add_ons)
        pulumi.set(__self__, "admission_controller_options", admission_controller_options)
        pulumi.set(__self__, "ip_families", ip_families)
        pulumi.set(__self__, "kubernetes_network_configs", kubernetes_network_configs)
        pulumi.set(__self__, "open_id_connect_discoveries", open_id_connect_discoveries)
        pulumi.set(__self__, "open_id_connect_token_authentication_configs", open_id_connect_token_authentication_configs)
        pulumi.set(__self__, "persistent_volume_configs", persistent_volume_configs)
        pulumi.set(__self__, "service_lb_configs", service_lb_configs)
        pulumi.set(__self__, "service_lb_subnet_ids", service_lb_subnet_ids)

    @property
    @pulumi.getter(name="addOns")
    def add_ons(self) -> Sequence['outputs.GetClustersClusterOptionAddOnResult']:
        """
        Configurable cluster add-ons
        """
        return pulumi.get(self, "add_ons")

    @property
    @pulumi.getter(name="admissionControllerOptions")
    def admission_controller_options(self) -> Sequence['outputs.GetClustersClusterOptionAdmissionControllerOptionResult']:
        """
        Configurable cluster admission controllers
        """
        return pulumi.get(self, "admission_controller_options")

    @property
    @pulumi.getter(name="ipFamilies")
    def ip_families(self) -> Sequence[builtins.str]:
        """
        IP family to use for single stack or define the order of IP families for dual-stack. Available values are [] (defaults to IPv4), [IPv4] (IPv4), [IPv4, IPv6] (IPv4 preferred dual stack).
        """
        return pulumi.get(self, "ip_families")

    @property
    @pulumi.getter(name="kubernetesNetworkConfigs")
    def kubernetes_network_configs(self) -> Sequence['outputs.GetClustersClusterOptionKubernetesNetworkConfigResult']:
        """
        Network configuration for Kubernetes.
        """
        return pulumi.get(self, "kubernetes_network_configs")

    @property
    @pulumi.getter(name="openIdConnectDiscoveries")
    def open_id_connect_discoveries(self) -> Sequence['outputs.GetClustersClusterOptionOpenIdConnectDiscoveryResult']:
        """
        The property that define the status of the OIDC Discovery feature for a cluster.
        """
        return pulumi.get(self, "open_id_connect_discoveries")

    @property
    @pulumi.getter(name="openIdConnectTokenAuthenticationConfigs")
    def open_id_connect_token_authentication_configs(self) -> Sequence['outputs.GetClustersClusterOptionOpenIdConnectTokenAuthenticationConfigResult']:
        """
        The properties that configure OIDC token authentication in kube-apiserver. For more information, see [Configuring the API Server](https://kubernetes.io/docs/reference/access-authn-authz/authentication/#using-flags).
        """
        return pulumi.get(self, "open_id_connect_token_authentication_configs")

    @property
    @pulumi.getter(name="persistentVolumeConfigs")
    def persistent_volume_configs(self) -> Sequence['outputs.GetClustersClusterOptionPersistentVolumeConfigResult']:
        """
        Configuration to be applied to block volumes created by Kubernetes Persistent Volume Claims (PVC)
        """
        return pulumi.get(self, "persistent_volume_configs")

    @property
    @pulumi.getter(name="serviceLbConfigs")
    def service_lb_configs(self) -> Sequence['outputs.GetClustersClusterOptionServiceLbConfigResult']:
        """
        Configuration to be applied to load balancers created by Kubernetes services
        """
        return pulumi.get(self, "service_lb_configs")

    @property
    @pulumi.getter(name="serviceLbSubnetIds")
    def service_lb_subnet_ids(self) -> Sequence[builtins.str]:
        """
        The OCIDs of the subnets used for Kubernetes services load balancers.
        """
        return pulumi.get(self, "service_lb_subnet_ids")


@pulumi.output_type
class GetClustersClusterOptionAddOnResult(dict):
    def __init__(__self__, *,
                 is_kubernetes_dashboard_enabled: builtins.bool,
                 is_tiller_enabled: builtins.bool):
        """
        :param builtins.bool is_kubernetes_dashboard_enabled: Whether or not to enable the Kubernetes Dashboard add-on.
        :param builtins.bool is_tiller_enabled: Whether or not to enable the Tiller add-on.
        """
        pulumi.set(__self__, "is_kubernetes_dashboard_enabled", is_kubernetes_dashboard_enabled)
        pulumi.set(__self__, "is_tiller_enabled", is_tiller_enabled)

    @property
    @pulumi.getter(name="isKubernetesDashboardEnabled")
    def is_kubernetes_dashboard_enabled(self) -> builtins.bool:
        """
        Whether or not to enable the Kubernetes Dashboard add-on.
        """
        return pulumi.get(self, "is_kubernetes_dashboard_enabled")

    @property
    @pulumi.getter(name="isTillerEnabled")
    def is_tiller_enabled(self) -> builtins.bool:
        """
        Whether or not to enable the Tiller add-on.
        """
        return pulumi.get(self, "is_tiller_enabled")


@pulumi.output_type
class GetClustersClusterOptionAdmissionControllerOptionResult(dict):
    def __init__(__self__, *,
                 is_pod_security_policy_enabled: builtins.bool):
        """
        :param builtins.bool is_pod_security_policy_enabled: Whether or not to enable the Pod Security Policy admission controller.
        """
        pulumi.set(__self__, "is_pod_security_policy_enabled", is_pod_security_policy_enabled)

    @property
    @pulumi.getter(name="isPodSecurityPolicyEnabled")
    def is_pod_security_policy_enabled(self) -> builtins.bool:
        """
        Whether or not to enable the Pod Security Policy admission controller.
        """
        return pulumi.get(self, "is_pod_security_policy_enabled")


@pulumi.output_type
class GetClustersClusterOptionKubernetesNetworkConfigResult(dict):
    def __init__(__self__, *,
                 pods_cidr: builtins.str,
                 services_cidr: builtins.str):
        """
        :param builtins.str pods_cidr: The CIDR block for Kubernetes pods. Optional. For ipv4, defaults to 10.244.0.0/16. For ipv6, defaults to fd00:eeee:eeee:0000::/96.
        :param builtins.str services_cidr: The CIDR block for Kubernetes services. Optional. For ipv4, defaults to 10.96.0.0/16. For ipv6, defaults to fd00:eeee:eeee:0001::/108.
        """
        pulumi.set(__self__, "pods_cidr", pods_cidr)
        pulumi.set(__self__, "services_cidr", services_cidr)

    @property
    @pulumi.getter(name="podsCidr")
    def pods_cidr(self) -> builtins.str:
        """
        The CIDR block for Kubernetes pods. Optional. For ipv4, defaults to 10.244.0.0/16. For ipv6, defaults to fd00:eeee:eeee:0000::/96.
        """
        return pulumi.get(self, "pods_cidr")

    @property
    @pulumi.getter(name="servicesCidr")
    def services_cidr(self) -> builtins.str:
        """
        The CIDR block for Kubernetes services. Optional. For ipv4, defaults to 10.96.0.0/16. For ipv6, defaults to fd00:eeee:eeee:0001::/108.
        """
        return pulumi.get(self, "services_cidr")


@pulumi.output_type
class GetClustersClusterOptionOpenIdConnectDiscoveryResult(dict):
    def __init__(__self__, *,
                 is_open_id_connect_discovery_enabled: builtins.bool):
        """
        :param builtins.bool is_open_id_connect_discovery_enabled: Whether the cluster has OIDC Discovery enabled. Defaults to false. If set to true, the cluster will be assigned a public OIDC Discovery endpoint.
        """
        pulumi.set(__self__, "is_open_id_connect_discovery_enabled", is_open_id_connect_discovery_enabled)

    @property
    @pulumi.getter(name="isOpenIdConnectDiscoveryEnabled")
    def is_open_id_connect_discovery_enabled(self) -> builtins.bool:
        """
        Whether the cluster has OIDC Discovery enabled. Defaults to false. If set to true, the cluster will be assigned a public OIDC Discovery endpoint.
        """
        return pulumi.get(self, "is_open_id_connect_discovery_enabled")


@pulumi.output_type
class GetClustersClusterOptionOpenIdConnectTokenAuthenticationConfigResult(dict):
    def __init__(__self__, *,
                 ca_certificate: builtins.str,
                 client_id: builtins.str,
                 configuration_file: builtins.str,
                 groups_claim: builtins.str,
                 groups_prefix: builtins.str,
                 is_open_id_connect_auth_enabled: builtins.bool,
                 issuer_url: builtins.str,
                 required_claims: Sequence['outputs.GetClustersClusterOptionOpenIdConnectTokenAuthenticationConfigRequiredClaimResult'],
                 signing_algorithms: Sequence[builtins.str],
                 username_claim: builtins.str,
                 username_prefix: builtins.str):
        """
        :param builtins.str ca_certificate: A Base64 encoded public RSA or ECDSA certificates used to signed your identity provider's web certificate.
        :param builtins.str client_id: A client id that all tokens must be issued for.
        :param builtins.str configuration_file: A Base64 encoded string of a Kubernetes OIDC Auth Config file. More info [here](https://kubernetes.io/docs/reference/access-authn-authz/authentication/#using-authentication-configuration)
        :param builtins.str groups_claim: JWT claim to use as the user's group. If the claim is present it must be an array of strings.
        :param builtins.str groups_prefix: Prefix prepended to group claims to prevent clashes with existing names (such as system:groups).
        :param builtins.bool is_open_id_connect_auth_enabled: Whether the cluster has OIDC Auth Config enabled. Defaults to false.
        :param builtins.str issuer_url: URL of the provider that allows the API server to discover public signing keys.  Only URLs that use the https:// scheme are accepted. This is typically the provider's discovery URL,  changed to have an empty path.
        :param Sequence['GetClustersClusterOptionOpenIdConnectTokenAuthenticationConfigRequiredClaimArgs'] required_claims: A key=value pair that describes a required claim in the ID Token. If set, the claim is verified to be present  in the ID Token with a matching value. Repeat this flag to specify multiple claims.
        :param Sequence[builtins.str] signing_algorithms: The signing algorithms accepted. Default is ["RS256"].
        :param builtins.str username_claim: JWT claim to use as the user name. By default sub, which is expected to be a unique identifier of the end  user. Admins can choose other claims, such as email or name, depending on their provider. However, claims  other than email will be prefixed with the issuer URL to prevent naming clashes with other plugins.
        :param builtins.str username_prefix: Prefix prepended to username claims to prevent clashes with existing names (such as system:users).  For example, the value oidc: will create usernames like oidc:jane.doe. If this flag isn't provided and  --oidc-username-claim is a value other than email the prefix defaults to ( Issuer URL )# where  ( Issuer URL ) is the value of --oidc-issuer-url. The value - can be used to disable all prefixing.
        """
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "configuration_file", configuration_file)
        pulumi.set(__self__, "groups_claim", groups_claim)
        pulumi.set(__self__, "groups_prefix", groups_prefix)
        pulumi.set(__self__, "is_open_id_connect_auth_enabled", is_open_id_connect_auth_enabled)
        pulumi.set(__self__, "issuer_url", issuer_url)
        pulumi.set(__self__, "required_claims", required_claims)
        pulumi.set(__self__, "signing_algorithms", signing_algorithms)
        pulumi.set(__self__, "username_claim", username_claim)
        pulumi.set(__self__, "username_prefix", username_prefix)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> builtins.str:
        """
        A Base64 encoded public RSA or ECDSA certificates used to signed your identity provider's web certificate.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> builtins.str:
        """
        A client id that all tokens must be issued for.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="configurationFile")
    def configuration_file(self) -> builtins.str:
        """
        A Base64 encoded string of a Kubernetes OIDC Auth Config file. More info [here](https://kubernetes.io/docs/reference/access-authn-authz/authentication/#using-authentication-configuration)
        """
        return pulumi.get(self, "configuration_file")

    @property
    @pulumi.getter(name="groupsClaim")
    def groups_claim(self) -> builtins.str:
        """
        JWT claim to use as the user's group. If the claim is present it must be an array of strings.
        """
        return pulumi.get(self, "groups_claim")

    @property
    @pulumi.getter(name="groupsPrefix")
    def groups_prefix(self) -> builtins.str:
        """
        Prefix prepended to group claims to prevent clashes with existing names (such as system:groups).
        """
        return pulumi.get(self, "groups_prefix")

    @property
    @pulumi.getter(name="isOpenIdConnectAuthEnabled")
    def is_open_id_connect_auth_enabled(self) -> builtins.bool:
        """
        Whether the cluster has OIDC Auth Config enabled. Defaults to false.
        """
        return pulumi.get(self, "is_open_id_connect_auth_enabled")

    @property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> builtins.str:
        """
        URL of the provider that allows the API server to discover public signing keys.  Only URLs that use the https:// scheme are accepted. This is typically the provider's discovery URL,  changed to have an empty path.
        """
        return pulumi.get(self, "issuer_url")

    @property
    @pulumi.getter(name="requiredClaims")
    def required_claims(self) -> Sequence['outputs.GetClustersClusterOptionOpenIdConnectTokenAuthenticationConfigRequiredClaimResult']:
        """
        A key=value pair that describes a required claim in the ID Token. If set, the claim is verified to be present  in the ID Token with a matching value. Repeat this flag to specify multiple claims.
        """
        return pulumi.get(self, "required_claims")

    @property
    @pulumi.getter(name="signingAlgorithms")
    def signing_algorithms(self) -> Sequence[builtins.str]:
        """
        The signing algorithms accepted. Default is ["RS256"].
        """
        return pulumi.get(self, "signing_algorithms")

    @property
    @pulumi.getter(name="usernameClaim")
    def username_claim(self) -> builtins.str:
        """
        JWT claim to use as the user name. By default sub, which is expected to be a unique identifier of the end  user. Admins can choose other claims, such as email or name, depending on their provider. However, claims  other than email will be prefixed with the issuer URL to prevent naming clashes with other plugins.
        """
        return pulumi.get(self, "username_claim")

    @property
    @pulumi.getter(name="usernamePrefix")
    def username_prefix(self) -> builtins.str:
        """
        Prefix prepended to username claims to prevent clashes with existing names (such as system:users).  For example, the value oidc: will create usernames like oidc:jane.doe. If this flag isn't provided and  --oidc-username-claim is a value other than email the prefix defaults to ( Issuer URL )# where  ( Issuer URL ) is the value of --oidc-issuer-url. The value - can be used to disable all prefixing.
        """
        return pulumi.get(self, "username_prefix")


@pulumi.output_type
class GetClustersClusterOptionOpenIdConnectTokenAuthenticationConfigRequiredClaimResult(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The key of the pair.
        :param builtins.str value: The value of the pair.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetClustersClusterOptionPersistentVolumeConfigResult(dict):
    def __init__(__self__, *,
                 defined_tags: Mapping[str, builtins.str],
                 freeform_tags: Mapping[str, builtins.str]):
        """
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")


@pulumi.output_type
class GetClustersClusterOptionServiceLbConfigResult(dict):
    def __init__(__self__, *,
                 defined_tags: Mapping[str, builtins.str],
                 freeform_tags: Mapping[str, builtins.str]):
        """
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")


@pulumi.output_type
class GetClustersFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: The name to filter on.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name to filter on.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetNodePoolInitialNodeLabelResult(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The key of the pair.
        :param builtins.str value: The value of the pair.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetNodePoolNodeResult(dict):
    def __init__(__self__, *,
                 availability_domain: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 errors: Sequence['outputs.GetNodePoolNodeErrorResult'],
                 fault_domain: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 kubernetes_version: builtins.str,
                 lifecycle_details: builtins.str,
                 name: builtins.str,
                 node_pool_id: builtins.str,
                 private_ip: builtins.str,
                 public_ip: builtins.str,
                 state: builtins.str,
                 subnet_id: builtins.str):
        """
        :param builtins.str availability_domain: The name of the availability domain in which this node is placed.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Sequence['GetNodePoolNodeErrorArgs'] errors: An error that may be associated with the node.
        :param builtins.str fault_domain: The fault domain of this node.
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param builtins.str id: The OCID of the compute instance backing this node.
        :param builtins.str kubernetes_version: The version of Kubernetes this node is running.
        :param builtins.str lifecycle_details: Details about the state of the node.
        :param builtins.str name: The name of the node.
        :param builtins.str node_pool_id: The OCID of the node pool.
        :param builtins.str private_ip: The private IP address of this node.
        :param builtins.str public_ip: The public IP address of this node.
        :param builtins.str state: The state of the nodepool.
        :param builtins.str subnet_id: The OCID of the subnet in which this node is placed.
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "fault_domain", fault_domain)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "node_pool_id", node_pool_id)
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "public_ip", public_ip)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        The name of the availability domain in which this node is placed.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.GetNodePoolNodeErrorResult']:
        """
        An error that may be associated with the node.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> builtins.str:
        """
        The fault domain of this node.
        """
        return pulumi.get(self, "fault_domain")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the compute instance backing this node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> builtins.str:
        """
        The version of Kubernetes this node is running.
        """
        return pulumi.get(self, "kubernetes_version")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Details about the state of the node.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the node.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodePoolId")
    def node_pool_id(self) -> builtins.str:
        """
        The OCID of the node pool.
        """
        return pulumi.get(self, "node_pool_id")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> builtins.str:
        """
        The private IP address of this node.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> builtins.str:
        """
        The public IP address of this node.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The state of the nodepool.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The OCID of the subnet in which this node is placed.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetNodePoolNodeConfigDetailResult(dict):
    def __init__(__self__, *,
                 defined_tags: Mapping[str, builtins.str],
                 freeform_tags: Mapping[str, builtins.str],
                 is_pv_encryption_in_transit_enabled: builtins.bool,
                 kms_key_id: builtins.str,
                 node_pool_pod_network_option_details: Sequence['outputs.GetNodePoolNodeConfigDetailNodePoolPodNetworkOptionDetailResult'],
                 nsg_ids: Sequence[builtins.str],
                 placement_configs: Sequence['outputs.GetNodePoolNodeConfigDetailPlacementConfigResult'],
                 size: builtins.int):
        """
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param builtins.bool is_pv_encryption_in_transit_enabled: Whether to enable in-transit encryption for the data volume's paravirtualized attachment. This field applies to both block volumes and boot volumes. The default value is false.
        :param builtins.str kms_key_id: The OCID of the Key Management Service key assigned to the boot volume.
        :param Sequence['GetNodePoolNodeConfigDetailNodePoolPodNetworkOptionDetailArgs'] node_pool_pod_network_option_details: The CNI related configuration of pods in the node pool.
        :param Sequence[builtins.str] nsg_ids: The OCIDs of the Network Security Group(s) to associate nodes for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        :param Sequence['GetNodePoolNodeConfigDetailPlacementConfigArgs'] placement_configs: The placement configurations for the node pool. Provide one placement configuration for each availability domain in which you intend to launch a node.
        :param builtins.int size: The number of nodes in the node pool.
        """
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "is_pv_encryption_in_transit_enabled", is_pv_encryption_in_transit_enabled)
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        pulumi.set(__self__, "node_pool_pod_network_option_details", node_pool_pod_network_option_details)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "placement_configs", placement_configs)
        pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isPvEncryptionInTransitEnabled")
    def is_pv_encryption_in_transit_enabled(self) -> builtins.bool:
        """
        Whether to enable in-transit encryption for the data volume's paravirtualized attachment. This field applies to both block volumes and boot volumes. The default value is false.
        """
        return pulumi.get(self, "is_pv_encryption_in_transit_enabled")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> builtins.str:
        """
        The OCID of the Key Management Service key assigned to the boot volume.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="nodePoolPodNetworkOptionDetails")
    def node_pool_pod_network_option_details(self) -> Sequence['outputs.GetNodePoolNodeConfigDetailNodePoolPodNetworkOptionDetailResult']:
        """
        The CNI related configuration of pods in the node pool.
        """
        return pulumi.get(self, "node_pool_pod_network_option_details")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[builtins.str]:
        """
        The OCIDs of the Network Security Group(s) to associate nodes for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="placementConfigs")
    def placement_configs(self) -> Sequence['outputs.GetNodePoolNodeConfigDetailPlacementConfigResult']:
        """
        The placement configurations for the node pool. Provide one placement configuration for each availability domain in which you intend to launch a node.
        """
        return pulumi.get(self, "placement_configs")

    @property
    @pulumi.getter
    def size(self) -> builtins.int:
        """
        The number of nodes in the node pool.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class GetNodePoolNodeConfigDetailNodePoolPodNetworkOptionDetailResult(dict):
    def __init__(__self__, *,
                 cni_type: builtins.str,
                 max_pods_per_node: builtins.int,
                 pod_nsg_ids: Sequence[builtins.str],
                 pod_subnet_ids: Sequence[builtins.str]):
        """
        :param builtins.str cni_type: The CNI plugin used by this node pool
        :param builtins.int max_pods_per_node: The max number of pods per node in the node pool. This value will be limited by the number of VNICs attachable to the node pool shape
        :param Sequence[builtins.str] pod_nsg_ids: The OCIDs of the Network Security Group(s) to associate pods for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        :param Sequence[builtins.str] pod_subnet_ids: The OCIDs of the subnets in which to place pods for this node pool. This can be one of the node pool subnet IDs
        """
        pulumi.set(__self__, "cni_type", cni_type)
        pulumi.set(__self__, "max_pods_per_node", max_pods_per_node)
        pulumi.set(__self__, "pod_nsg_ids", pod_nsg_ids)
        pulumi.set(__self__, "pod_subnet_ids", pod_subnet_ids)

    @property
    @pulumi.getter(name="cniType")
    def cni_type(self) -> builtins.str:
        """
        The CNI plugin used by this node pool
        """
        return pulumi.get(self, "cni_type")

    @property
    @pulumi.getter(name="maxPodsPerNode")
    def max_pods_per_node(self) -> builtins.int:
        """
        The max number of pods per node in the node pool. This value will be limited by the number of VNICs attachable to the node pool shape
        """
        return pulumi.get(self, "max_pods_per_node")

    @property
    @pulumi.getter(name="podNsgIds")
    def pod_nsg_ids(self) -> Sequence[builtins.str]:
        """
        The OCIDs of the Network Security Group(s) to associate pods for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        return pulumi.get(self, "pod_nsg_ids")

    @property
    @pulumi.getter(name="podSubnetIds")
    def pod_subnet_ids(self) -> Sequence[builtins.str]:
        """
        The OCIDs of the subnets in which to place pods for this node pool. This can be one of the node pool subnet IDs
        """
        return pulumi.get(self, "pod_subnet_ids")


@pulumi.output_type
class GetNodePoolNodeConfigDetailPlacementConfigResult(dict):
    def __init__(__self__, *,
                 availability_domain: builtins.str,
                 capacity_reservation_id: builtins.str,
                 fault_domains: Sequence[builtins.str],
                 preemptible_node_configs: Sequence['outputs.GetNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigResult'],
                 subnet_id: builtins.str):
        """
        :param builtins.str availability_domain: The name of the availability domain in which this node is placed.
        :param builtins.str capacity_reservation_id: The OCID of the compute capacity reservation in which to place the compute instance.
        :param Sequence[builtins.str] fault_domains: A list of fault domains in which to place nodes.
        :param Sequence['GetNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigArgs'] preemptible_node_configs: Configuration options for preemptible nodes.
        :param builtins.str subnet_id: The OCID of the subnet in which this node is placed.
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "capacity_reservation_id", capacity_reservation_id)
        pulumi.set(__self__, "fault_domains", fault_domains)
        pulumi.set(__self__, "preemptible_node_configs", preemptible_node_configs)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        The name of the availability domain in which this node is placed.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> builtins.str:
        """
        The OCID of the compute capacity reservation in which to place the compute instance.
        """
        return pulumi.get(self, "capacity_reservation_id")

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> Sequence[builtins.str]:
        """
        A list of fault domains in which to place nodes.
        """
        return pulumi.get(self, "fault_domains")

    @property
    @pulumi.getter(name="preemptibleNodeConfigs")
    def preemptible_node_configs(self) -> Sequence['outputs.GetNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigResult']:
        """
        Configuration options for preemptible nodes.
        """
        return pulumi.get(self, "preemptible_node_configs")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The OCID of the subnet in which this node is placed.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigResult(dict):
    def __init__(__self__, *,
                 preemption_actions: Sequence['outputs.GetNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigPreemptionActionResult']):
        """
        :param Sequence['GetNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigPreemptionActionArgs'] preemption_actions: The action to run when the preemptible node is interrupted for eviction.
        """
        pulumi.set(__self__, "preemption_actions", preemption_actions)

    @property
    @pulumi.getter(name="preemptionActions")
    def preemption_actions(self) -> Sequence['outputs.GetNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigPreemptionActionResult']:
        """
        The action to run when the preemptible node is interrupted for eviction.
        """
        return pulumi.get(self, "preemption_actions")


@pulumi.output_type
class GetNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigPreemptionActionResult(dict):
    def __init__(__self__, *,
                 is_preserve_boot_volume: builtins.bool,
                 type: builtins.str):
        """
        :param builtins.bool is_preserve_boot_volume: Whether to preserve the boot volume that was used to launch the preemptible instance when the instance is terminated. Defaults to false if not specified.
        :param builtins.str type: The type of action to run when the instance is interrupted for eviction.
        """
        pulumi.set(__self__, "is_preserve_boot_volume", is_preserve_boot_volume)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="isPreserveBootVolume")
    def is_preserve_boot_volume(self) -> builtins.bool:
        """
        Whether to preserve the boot volume that was used to launch the preemptible instance when the instance is terminated. Defaults to false if not specified.
        """
        return pulumi.get(self, "is_preserve_boot_volume")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of action to run when the instance is interrupted for eviction.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNodePoolNodeErrorResult(dict):
    def __init__(__self__, *,
                 code: builtins.str,
                 message: builtins.str,
                 status: builtins.str):
        """
        :param builtins.str code: A short error code that defines the upstream error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        :param builtins.str message: A human-readable error string of the upstream error.
        :param builtins.str status: The status of the HTTP response encountered in the upstream error.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def code(self) -> builtins.str:
        """
        A short error code that defines the upstream error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        """
        A human-readable error string of the upstream error.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The status of the HTTP response encountered in the upstream error.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetNodePoolNodeEvictionNodePoolSettingResult(dict):
    def __init__(__self__, *,
                 eviction_grace_duration: builtins.str,
                 is_force_action_after_grace_duration: builtins.bool,
                 is_force_delete_after_grace_duration: builtins.bool):
        """
        :param builtins.str eviction_grace_duration: Duration after which OKE will give up eviction of the pods on the node. PT0M will indicate you want to delete the node without cordon and drain. Default PT60M, Min PT0M, Max: PT60M. Format ISO 8601 e.g PT30M
        :param builtins.bool is_force_action_after_grace_duration: If the node action should be performed if not all the pods can be evicted in the grace period
        :param builtins.bool is_force_delete_after_grace_duration: If the underlying compute instance should be deleted if you cannot evict all the pods in grace period
        """
        pulumi.set(__self__, "eviction_grace_duration", eviction_grace_duration)
        pulumi.set(__self__, "is_force_action_after_grace_duration", is_force_action_after_grace_duration)
        pulumi.set(__self__, "is_force_delete_after_grace_duration", is_force_delete_after_grace_duration)

    @property
    @pulumi.getter(name="evictionGraceDuration")
    def eviction_grace_duration(self) -> builtins.str:
        """
        Duration after which OKE will give up eviction of the pods on the node. PT0M will indicate you want to delete the node without cordon and drain. Default PT60M, Min PT0M, Max: PT60M. Format ISO 8601 e.g PT30M
        """
        return pulumi.get(self, "eviction_grace_duration")

    @property
    @pulumi.getter(name="isForceActionAfterGraceDuration")
    def is_force_action_after_grace_duration(self) -> builtins.bool:
        """
        If the node action should be performed if not all the pods can be evicted in the grace period
        """
        return pulumi.get(self, "is_force_action_after_grace_duration")

    @property
    @pulumi.getter(name="isForceDeleteAfterGraceDuration")
    def is_force_delete_after_grace_duration(self) -> builtins.bool:
        """
        If the underlying compute instance should be deleted if you cannot evict all the pods in grace period
        """
        return pulumi.get(self, "is_force_delete_after_grace_duration")


@pulumi.output_type
class GetNodePoolNodePoolCyclingDetailResult(dict):
    def __init__(__self__, *,
                 cycle_modes: Sequence[builtins.str],
                 is_node_cycling_enabled: builtins.bool,
                 maximum_surge: builtins.str,
                 maximum_unavailable: builtins.str):
        """
        :param Sequence[builtins.str] cycle_modes: An ordered list of cycle modes that should be performed on the OKE nodes.
        :param builtins.bool is_node_cycling_enabled: If cycling operation should be performed on the nodes in the node pool.
        :param builtins.str maximum_surge: Maximum additional new compute instances that would be temporarily created and added to nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 1, Ranges from 0 to Nodepool size or 0% to 100%
        :param builtins.str maximum_unavailable: Maximum active nodes that would be terminated from nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 0, Ranges from 0 to Nodepool size or 0% to 100%
        """
        pulumi.set(__self__, "cycle_modes", cycle_modes)
        pulumi.set(__self__, "is_node_cycling_enabled", is_node_cycling_enabled)
        pulumi.set(__self__, "maximum_surge", maximum_surge)
        pulumi.set(__self__, "maximum_unavailable", maximum_unavailable)

    @property
    @pulumi.getter(name="cycleModes")
    def cycle_modes(self) -> Sequence[builtins.str]:
        """
        An ordered list of cycle modes that should be performed on the OKE nodes.
        """
        return pulumi.get(self, "cycle_modes")

    @property
    @pulumi.getter(name="isNodeCyclingEnabled")
    def is_node_cycling_enabled(self) -> builtins.bool:
        """
        If cycling operation should be performed on the nodes in the node pool.
        """
        return pulumi.get(self, "is_node_cycling_enabled")

    @property
    @pulumi.getter(name="maximumSurge")
    def maximum_surge(self) -> builtins.str:
        """
        Maximum additional new compute instances that would be temporarily created and added to nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 1, Ranges from 0 to Nodepool size or 0% to 100%
        """
        return pulumi.get(self, "maximum_surge")

    @property
    @pulumi.getter(name="maximumUnavailable")
    def maximum_unavailable(self) -> builtins.str:
        """
        Maximum active nodes that would be terminated from nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 0, Ranges from 0 to Nodepool size or 0% to 100%
        """
        return pulumi.get(self, "maximum_unavailable")


@pulumi.output_type
class GetNodePoolNodeShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: builtins.float,
                 ocpus: builtins.float):
        """
        :param builtins.float memory_in_gbs: The total amount of memory available to each node, in gigabytes.
        :param builtins.float ocpus: The total number of OCPUs available to each node in the node pool. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> builtins.float:
        """
        The total amount of memory available to each node, in gigabytes.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> builtins.float:
        """
        The total number of OCPUs available to each node in the node pool. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetNodePoolNodeSourceResult(dict):
    def __init__(__self__, *,
                 image_id: builtins.str,
                 source_name: builtins.str,
                 source_type: builtins.str):
        """
        :param builtins.str image_id: The OCID of the image used to boot the node.
        :param builtins.str source_name: The user-friendly name of the entity corresponding to the OCID.
        :param builtins.str source_type: The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        """
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "source_name", source_name)
        pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> builtins.str:
        """
        The OCID of the image used to boot the node.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> builtins.str:
        """
        The user-friendly name of the entity corresponding to the OCID.
        """
        return pulumi.get(self, "source_name")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> builtins.str:
        """
        The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetNodePoolNodeSourceDetailResult(dict):
    def __init__(__self__, *,
                 boot_volume_size_in_gbs: builtins.str,
                 image_id: builtins.str,
                 source_type: builtins.str):
        """
        :param builtins.str boot_volume_size_in_gbs: The size of the boot volume in GBs. Minimum value is 50 GB. See [here](https://docs.cloud.oracle.com/en-us/iaas/Content/Block/Concepts/bootvolumes.htm) for max custom boot volume sizing and OS-specific requirements.
        :param builtins.str image_id: The OCID of the image used to boot the node.
        :param builtins.str source_type: The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        """
        pulumi.set(__self__, "boot_volume_size_in_gbs", boot_volume_size_in_gbs)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="bootVolumeSizeInGbs")
    def boot_volume_size_in_gbs(self) -> builtins.str:
        """
        The size of the boot volume in GBs. Minimum value is 50 GB. See [here](https://docs.cloud.oracle.com/en-us/iaas/Content/Block/Concepts/bootvolumes.htm) for max custom boot volume sizing and OS-specific requirements.
        """
        return pulumi.get(self, "boot_volume_size_in_gbs")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> builtins.str:
        """
        The OCID of the image used to boot the node.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> builtins.str:
        """
        The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetNodePoolOptionSourceResult(dict):
    def __init__(__self__, *,
                 image_id: builtins.str,
                 source_name: builtins.str,
                 source_type: builtins.str):
        """
        :param builtins.str image_id: The OCID of the image.
        :param builtins.str source_name: The user-friendly name of the entity corresponding to the OCID.
        :param builtins.str source_type: The source type of this option. `IMAGE` means the OCID is of an image.
        """
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "source_name", source_name)
        pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> builtins.str:
        """
        The OCID of the image.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> builtins.str:
        """
        The user-friendly name of the entity corresponding to the OCID.
        """
        return pulumi.get(self, "source_name")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> builtins.str:
        """
        The source type of this option. `IMAGE` means the OCID is of an image.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetNodePoolsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: The name to filter on.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name to filter on.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetNodePoolsNodePoolResult(dict):
    def __init__(__self__, *,
                 cluster_id: builtins.str,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 initial_node_labels: Sequence['outputs.GetNodePoolsNodePoolInitialNodeLabelResult'],
                 kubernetes_version: builtins.str,
                 lifecycle_details: builtins.str,
                 name: builtins.str,
                 node_config_details: Sequence['outputs.GetNodePoolsNodePoolNodeConfigDetailResult'],
                 node_eviction_node_pool_settings: Sequence['outputs.GetNodePoolsNodePoolNodeEvictionNodePoolSettingResult'],
                 node_image_id: builtins.str,
                 node_image_name: builtins.str,
                 node_metadata: Mapping[str, builtins.str],
                 node_pool_cycling_details: Sequence['outputs.GetNodePoolsNodePoolNodePoolCyclingDetailResult'],
                 node_pool_id: builtins.str,
                 node_shape: builtins.str,
                 node_shape_configs: Sequence['outputs.GetNodePoolsNodePoolNodeShapeConfigResult'],
                 node_source_details: Sequence['outputs.GetNodePoolsNodePoolNodeSourceDetailResult'],
                 node_sources: Sequence['outputs.GetNodePoolsNodePoolNodeSourceResult'],
                 nodes: Sequence['outputs.GetNodePoolsNodePoolNodeResult'],
                 quantity_per_subnet: builtins.int,
                 ssh_public_key: builtins.str,
                 state: builtins.str,
                 subnet_ids: Sequence[builtins.str]):
        """
        :param builtins.str cluster_id: The OCID of the cluster.
        :param builtins.str compartment_id: The OCID of the compartment.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param builtins.str id: The OCID of the node pool.
        :param Sequence['GetNodePoolsNodePoolInitialNodeLabelArgs'] initial_node_labels: A list of key/value pairs to add to nodes after they join the Kubernetes cluster.
        :param builtins.str kubernetes_version: The version of Kubernetes running on the nodes in the node pool.
        :param builtins.str lifecycle_details: Details about the state of the nodepool.
        :param builtins.str name: The name to filter on.
        :param Sequence['GetNodePoolsNodePoolNodeConfigDetailArgs'] node_config_details: The configuration of nodes in the node pool.
        :param Sequence['GetNodePoolsNodePoolNodeEvictionNodePoolSettingArgs'] node_eviction_node_pool_settings: Node Eviction Details configuration
        :param builtins.str node_image_id: Deprecated. see `nodeSource`. The OCID of the image running on the nodes in the node pool.
        :param builtins.str node_image_name: Deprecated. see `nodeSource`. The name of the image running on the nodes in the node pool.
        :param Sequence['GetNodePoolsNodePoolNodePoolCyclingDetailArgs'] node_pool_cycling_details: Node Pool Cycling Details
        :param builtins.str node_shape: The name of the node shape of the nodes in the node pool.
        :param Sequence['GetNodePoolsNodePoolNodeShapeConfigArgs'] node_shape_configs: The shape configuration of the nodes.
        :param Sequence['GetNodePoolsNodePoolNodeSourceDetailArgs'] node_source_details: Source running on the nodes in the node pool.
        :param Sequence['GetNodePoolsNodePoolNodeSourceArgs'] node_sources: Deprecated. see `nodeSourceDetails`. Source running on the nodes in the node pool.
        :param builtins.int quantity_per_subnet: The number of nodes in each subnet.
        :param builtins.str ssh_public_key: The SSH public key on each node in the node pool on launch.
        :param builtins.str state: A list of nodepool lifecycle states on which to filter on, matching any of the list items (OR logic). eg. [ACTIVE, DELETING]
        :param Sequence[builtins.str] subnet_ids: The OCIDs of the subnets in which to place nodes for this node pool.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "initial_node_labels", initial_node_labels)
        pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "node_config_details", node_config_details)
        pulumi.set(__self__, "node_eviction_node_pool_settings", node_eviction_node_pool_settings)
        pulumi.set(__self__, "node_image_id", node_image_id)
        pulumi.set(__self__, "node_image_name", node_image_name)
        pulumi.set(__self__, "node_metadata", node_metadata)
        pulumi.set(__self__, "node_pool_cycling_details", node_pool_cycling_details)
        pulumi.set(__self__, "node_pool_id", node_pool_id)
        pulumi.set(__self__, "node_shape", node_shape)
        pulumi.set(__self__, "node_shape_configs", node_shape_configs)
        pulumi.set(__self__, "node_source_details", node_source_details)
        pulumi.set(__self__, "node_sources", node_sources)
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "quantity_per_subnet", quantity_per_subnet)
        pulumi.set(__self__, "ssh_public_key", ssh_public_key)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> builtins.str:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the node pool.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="initialNodeLabels")
    def initial_node_labels(self) -> Sequence['outputs.GetNodePoolsNodePoolInitialNodeLabelResult']:
        """
        A list of key/value pairs to add to nodes after they join the Kubernetes cluster.
        """
        return pulumi.get(self, "initial_node_labels")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> builtins.str:
        """
        The version of Kubernetes running on the nodes in the node pool.
        """
        return pulumi.get(self, "kubernetes_version")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Details about the state of the nodepool.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name to filter on.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeConfigDetails")
    def node_config_details(self) -> Sequence['outputs.GetNodePoolsNodePoolNodeConfigDetailResult']:
        """
        The configuration of nodes in the node pool.
        """
        return pulumi.get(self, "node_config_details")

    @property
    @pulumi.getter(name="nodeEvictionNodePoolSettings")
    def node_eviction_node_pool_settings(self) -> Sequence['outputs.GetNodePoolsNodePoolNodeEvictionNodePoolSettingResult']:
        """
        Node Eviction Details configuration
        """
        return pulumi.get(self, "node_eviction_node_pool_settings")

    @property
    @pulumi.getter(name="nodeImageId")
    @_utilities.deprecated("""The 'node_image_id' field has been deprecated. Please use 'node_source_details' instead. If both fields are specified, then 'node_source_details' will be used.""")
    def node_image_id(self) -> builtins.str:
        """
        Deprecated. see `nodeSource`. The OCID of the image running on the nodes in the node pool.
        """
        return pulumi.get(self, "node_image_id")

    @property
    @pulumi.getter(name="nodeImageName")
    @_utilities.deprecated("""The 'node_image_name' field has been deprecated. Please use 'node_source_details' instead. If both fields are specified, then 'node_source_details' will be used.""")
    def node_image_name(self) -> builtins.str:
        """
        Deprecated. see `nodeSource`. The name of the image running on the nodes in the node pool.
        """
        return pulumi.get(self, "node_image_name")

    @property
    @pulumi.getter(name="nodeMetadata")
    def node_metadata(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "node_metadata")

    @property
    @pulumi.getter(name="nodePoolCyclingDetails")
    def node_pool_cycling_details(self) -> Sequence['outputs.GetNodePoolsNodePoolNodePoolCyclingDetailResult']:
        """
        Node Pool Cycling Details
        """
        return pulumi.get(self, "node_pool_cycling_details")

    @property
    @pulumi.getter(name="nodePoolId")
    def node_pool_id(self) -> builtins.str:
        return pulumi.get(self, "node_pool_id")

    @property
    @pulumi.getter(name="nodeShape")
    def node_shape(self) -> builtins.str:
        """
        The name of the node shape of the nodes in the node pool.
        """
        return pulumi.get(self, "node_shape")

    @property
    @pulumi.getter(name="nodeShapeConfigs")
    def node_shape_configs(self) -> Sequence['outputs.GetNodePoolsNodePoolNodeShapeConfigResult']:
        """
        The shape configuration of the nodes.
        """
        return pulumi.get(self, "node_shape_configs")

    @property
    @pulumi.getter(name="nodeSourceDetails")
    def node_source_details(self) -> Sequence['outputs.GetNodePoolsNodePoolNodeSourceDetailResult']:
        """
        Source running on the nodes in the node pool.
        """
        return pulumi.get(self, "node_source_details")

    @property
    @pulumi.getter(name="nodeSources")
    def node_sources(self) -> Sequence['outputs.GetNodePoolsNodePoolNodeSourceResult']:
        """
        Deprecated. see `nodeSourceDetails`. Source running on the nodes in the node pool.
        """
        return pulumi.get(self, "node_sources")

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.GetNodePoolsNodePoolNodeResult']:
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter(name="quantityPerSubnet")
    def quantity_per_subnet(self) -> builtins.int:
        """
        The number of nodes in each subnet.
        """
        return pulumi.get(self, "quantity_per_subnet")

    @property
    @pulumi.getter(name="sshPublicKey")
    def ssh_public_key(self) -> builtins.str:
        """
        The SSH public key on each node in the node pool on launch.
        """
        return pulumi.get(self, "ssh_public_key")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A list of nodepool lifecycle states on which to filter on, matching any of the list items (OR logic). eg. [ACTIVE, DELETING]
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[builtins.str]:
        """
        The OCIDs of the subnets in which to place nodes for this node pool.
        """
        return pulumi.get(self, "subnet_ids")


@pulumi.output_type
class GetNodePoolsNodePoolInitialNodeLabelResult(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The key of the pair.
        :param builtins.str value: The value of the pair.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetNodePoolsNodePoolNodeResult(dict):
    def __init__(__self__, *,
                 availability_domain: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 errors: Sequence['outputs.GetNodePoolsNodePoolNodeErrorResult'],
                 fault_domain: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 kubernetes_version: builtins.str,
                 lifecycle_details: builtins.str,
                 name: builtins.str,
                 node_pool_id: builtins.str,
                 private_ip: builtins.str,
                 public_ip: builtins.str,
                 state: builtins.str,
                 subnet_id: builtins.str):
        """
        :param builtins.str availability_domain: The availability domain in which to place nodes. Example: `Uocm:PHX-AD-1`
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param builtins.str id: The OCID of the node pool.
        :param builtins.str kubernetes_version: The version of Kubernetes running on the nodes in the node pool.
        :param builtins.str lifecycle_details: Details about the state of the nodepool.
        :param builtins.str name: The name to filter on.
        :param builtins.str state: A list of nodepool lifecycle states on which to filter on, matching any of the list items (OR logic). eg. [ACTIVE, DELETING]
        :param builtins.str subnet_id: The OCID of the subnet in which to place nodes.
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "fault_domain", fault_domain)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "node_pool_id", node_pool_id)
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "public_ip", public_ip)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        The availability domain in which to place nodes. Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.GetNodePoolsNodePoolNodeErrorResult']:
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> builtins.str:
        return pulumi.get(self, "fault_domain")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the node pool.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> builtins.str:
        """
        The version of Kubernetes running on the nodes in the node pool.
        """
        return pulumi.get(self, "kubernetes_version")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Details about the state of the nodepool.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name to filter on.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodePoolId")
    def node_pool_id(self) -> builtins.str:
        return pulumi.get(self, "node_pool_id")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> builtins.str:
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> builtins.str:
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A list of nodepool lifecycle states on which to filter on, matching any of the list items (OR logic). eg. [ACTIVE, DELETING]
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The OCID of the subnet in which to place nodes.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetNodePoolsNodePoolNodeConfigDetailResult(dict):
    def __init__(__self__, *,
                 defined_tags: Mapping[str, builtins.str],
                 freeform_tags: Mapping[str, builtins.str],
                 is_pv_encryption_in_transit_enabled: builtins.bool,
                 kms_key_id: builtins.str,
                 node_pool_pod_network_option_details: Sequence['outputs.GetNodePoolsNodePoolNodeConfigDetailNodePoolPodNetworkOptionDetailResult'],
                 nsg_ids: Sequence[builtins.str],
                 placement_configs: Sequence['outputs.GetNodePoolsNodePoolNodeConfigDetailPlacementConfigResult'],
                 size: builtins.int):
        """
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param builtins.bool is_pv_encryption_in_transit_enabled: Whether to enable in-transit encryption for the data volume's paravirtualized attachment. This field applies to both block volumes and boot volumes. The default value is false.
        :param builtins.str kms_key_id: The OCID of the Key Management Service key assigned to the boot volume.
        :param Sequence['GetNodePoolsNodePoolNodeConfigDetailNodePoolPodNetworkOptionDetailArgs'] node_pool_pod_network_option_details: The CNI related configuration of pods in the node pool.
        :param Sequence[builtins.str] nsg_ids: The OCIDs of the Network Security Group(s) to associate nodes for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        :param Sequence['GetNodePoolsNodePoolNodeConfigDetailPlacementConfigArgs'] placement_configs: The placement configurations for the node pool. Provide one placement configuration for each availability domain in which you intend to launch a node.
        :param builtins.int size: The number of nodes in the node pool.
        """
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "is_pv_encryption_in_transit_enabled", is_pv_encryption_in_transit_enabled)
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        pulumi.set(__self__, "node_pool_pod_network_option_details", node_pool_pod_network_option_details)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "placement_configs", placement_configs)
        pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isPvEncryptionInTransitEnabled")
    def is_pv_encryption_in_transit_enabled(self) -> builtins.bool:
        """
        Whether to enable in-transit encryption for the data volume's paravirtualized attachment. This field applies to both block volumes and boot volumes. The default value is false.
        """
        return pulumi.get(self, "is_pv_encryption_in_transit_enabled")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> builtins.str:
        """
        The OCID of the Key Management Service key assigned to the boot volume.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="nodePoolPodNetworkOptionDetails")
    def node_pool_pod_network_option_details(self) -> Sequence['outputs.GetNodePoolsNodePoolNodeConfigDetailNodePoolPodNetworkOptionDetailResult']:
        """
        The CNI related configuration of pods in the node pool.
        """
        return pulumi.get(self, "node_pool_pod_network_option_details")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[builtins.str]:
        """
        The OCIDs of the Network Security Group(s) to associate nodes for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="placementConfigs")
    def placement_configs(self) -> Sequence['outputs.GetNodePoolsNodePoolNodeConfigDetailPlacementConfigResult']:
        """
        The placement configurations for the node pool. Provide one placement configuration for each availability domain in which you intend to launch a node.
        """
        return pulumi.get(self, "placement_configs")

    @property
    @pulumi.getter
    def size(self) -> builtins.int:
        """
        The number of nodes in the node pool.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class GetNodePoolsNodePoolNodeConfigDetailNodePoolPodNetworkOptionDetailResult(dict):
    def __init__(__self__, *,
                 cni_type: builtins.str,
                 max_pods_per_node: builtins.int,
                 pod_nsg_ids: Sequence[builtins.str],
                 pod_subnet_ids: Sequence[builtins.str]):
        """
        :param builtins.str cni_type: The CNI plugin used by this node pool
        :param builtins.int max_pods_per_node: The max number of pods per node in the node pool. This value will be limited by the number of VNICs attachable to the node pool shape
        :param Sequence[builtins.str] pod_nsg_ids: The OCIDs of the Network Security Group(s) to associate pods for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        :param Sequence[builtins.str] pod_subnet_ids: The OCIDs of the subnets in which to place pods for this node pool. This can be one of the node pool subnet IDs
        """
        pulumi.set(__self__, "cni_type", cni_type)
        pulumi.set(__self__, "max_pods_per_node", max_pods_per_node)
        pulumi.set(__self__, "pod_nsg_ids", pod_nsg_ids)
        pulumi.set(__self__, "pod_subnet_ids", pod_subnet_ids)

    @property
    @pulumi.getter(name="cniType")
    def cni_type(self) -> builtins.str:
        """
        The CNI plugin used by this node pool
        """
        return pulumi.get(self, "cni_type")

    @property
    @pulumi.getter(name="maxPodsPerNode")
    def max_pods_per_node(self) -> builtins.int:
        """
        The max number of pods per node in the node pool. This value will be limited by the number of VNICs attachable to the node pool shape
        """
        return pulumi.get(self, "max_pods_per_node")

    @property
    @pulumi.getter(name="podNsgIds")
    def pod_nsg_ids(self) -> Sequence[builtins.str]:
        """
        The OCIDs of the Network Security Group(s) to associate pods for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        return pulumi.get(self, "pod_nsg_ids")

    @property
    @pulumi.getter(name="podSubnetIds")
    def pod_subnet_ids(self) -> Sequence[builtins.str]:
        """
        The OCIDs of the subnets in which to place pods for this node pool. This can be one of the node pool subnet IDs
        """
        return pulumi.get(self, "pod_subnet_ids")


@pulumi.output_type
class GetNodePoolsNodePoolNodeConfigDetailPlacementConfigResult(dict):
    def __init__(__self__, *,
                 availability_domain: builtins.str,
                 capacity_reservation_id: builtins.str,
                 fault_domains: Sequence[builtins.str],
                 preemptible_node_configs: Sequence['outputs.GetNodePoolsNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigResult'],
                 subnet_id: builtins.str):
        """
        :param builtins.str availability_domain: The availability domain in which to place nodes. Example: `Uocm:PHX-AD-1`
        :param builtins.str capacity_reservation_id: The OCID of the compute capacity reservation in which to place the compute instance.
        :param Sequence[builtins.str] fault_domains: A list of fault domains in which to place nodes.
        :param Sequence['GetNodePoolsNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigArgs'] preemptible_node_configs: Configuration options for preemptible nodes.
        :param builtins.str subnet_id: The OCID of the subnet in which to place nodes.
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "capacity_reservation_id", capacity_reservation_id)
        pulumi.set(__self__, "fault_domains", fault_domains)
        pulumi.set(__self__, "preemptible_node_configs", preemptible_node_configs)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        The availability domain in which to place nodes. Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> builtins.str:
        """
        The OCID of the compute capacity reservation in which to place the compute instance.
        """
        return pulumi.get(self, "capacity_reservation_id")

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> Sequence[builtins.str]:
        """
        A list of fault domains in which to place nodes.
        """
        return pulumi.get(self, "fault_domains")

    @property
    @pulumi.getter(name="preemptibleNodeConfigs")
    def preemptible_node_configs(self) -> Sequence['outputs.GetNodePoolsNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigResult']:
        """
        Configuration options for preemptible nodes.
        """
        return pulumi.get(self, "preemptible_node_configs")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The OCID of the subnet in which to place nodes.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetNodePoolsNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigResult(dict):
    def __init__(__self__, *,
                 preemption_actions: Sequence['outputs.GetNodePoolsNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigPreemptionActionResult']):
        """
        :param Sequence['GetNodePoolsNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigPreemptionActionArgs'] preemption_actions: The action to run when the preemptible node is interrupted for eviction.
        """
        pulumi.set(__self__, "preemption_actions", preemption_actions)

    @property
    @pulumi.getter(name="preemptionActions")
    def preemption_actions(self) -> Sequence['outputs.GetNodePoolsNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigPreemptionActionResult']:
        """
        The action to run when the preemptible node is interrupted for eviction.
        """
        return pulumi.get(self, "preemption_actions")


@pulumi.output_type
class GetNodePoolsNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigPreemptionActionResult(dict):
    def __init__(__self__, *,
                 is_preserve_boot_volume: builtins.bool,
                 type: builtins.str):
        """
        :param builtins.bool is_preserve_boot_volume: Whether to preserve the boot volume that was used to launch the preemptible instance when the instance is terminated. Defaults to false if not specified.
        :param builtins.str type: The type of action to run when the instance is interrupted for eviction.
        """
        pulumi.set(__self__, "is_preserve_boot_volume", is_preserve_boot_volume)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="isPreserveBootVolume")
    def is_preserve_boot_volume(self) -> builtins.bool:
        """
        Whether to preserve the boot volume that was used to launch the preemptible instance when the instance is terminated. Defaults to false if not specified.
        """
        return pulumi.get(self, "is_preserve_boot_volume")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of action to run when the instance is interrupted for eviction.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNodePoolsNodePoolNodeErrorResult(dict):
    def __init__(__self__, *,
                 code: builtins.str,
                 message: builtins.str,
                 status: builtins.str):
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def code(self) -> builtins.str:
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        return pulumi.get(self, "status")


@pulumi.output_type
class GetNodePoolsNodePoolNodeEvictionNodePoolSettingResult(dict):
    def __init__(__self__, *,
                 eviction_grace_duration: builtins.str,
                 is_force_action_after_grace_duration: builtins.bool,
                 is_force_delete_after_grace_duration: builtins.bool):
        """
        :param builtins.str eviction_grace_duration: Duration after which OKE will give up eviction of the pods on the node. PT0M will indicate you want to delete the node without cordon and drain. Default PT60M, Min PT0M, Max: PT60M. Format ISO 8601 e.g PT30M
        :param builtins.bool is_force_action_after_grace_duration: If the node action should be performed if not all the pods can be evicted in the grace period
        :param builtins.bool is_force_delete_after_grace_duration: If the underlying compute instance should be deleted if you cannot evict all the pods in grace period
        """
        pulumi.set(__self__, "eviction_grace_duration", eviction_grace_duration)
        pulumi.set(__self__, "is_force_action_after_grace_duration", is_force_action_after_grace_duration)
        pulumi.set(__self__, "is_force_delete_after_grace_duration", is_force_delete_after_grace_duration)

    @property
    @pulumi.getter(name="evictionGraceDuration")
    def eviction_grace_duration(self) -> builtins.str:
        """
        Duration after which OKE will give up eviction of the pods on the node. PT0M will indicate you want to delete the node without cordon and drain. Default PT60M, Min PT0M, Max: PT60M. Format ISO 8601 e.g PT30M
        """
        return pulumi.get(self, "eviction_grace_duration")

    @property
    @pulumi.getter(name="isForceActionAfterGraceDuration")
    def is_force_action_after_grace_duration(self) -> builtins.bool:
        """
        If the node action should be performed if not all the pods can be evicted in the grace period
        """
        return pulumi.get(self, "is_force_action_after_grace_duration")

    @property
    @pulumi.getter(name="isForceDeleteAfterGraceDuration")
    def is_force_delete_after_grace_duration(self) -> builtins.bool:
        """
        If the underlying compute instance should be deleted if you cannot evict all the pods in grace period
        """
        return pulumi.get(self, "is_force_delete_after_grace_duration")


@pulumi.output_type
class GetNodePoolsNodePoolNodePoolCyclingDetailResult(dict):
    def __init__(__self__, *,
                 cycle_modes: Sequence[builtins.str],
                 is_node_cycling_enabled: builtins.bool,
                 maximum_surge: builtins.str,
                 maximum_unavailable: builtins.str):
        """
        :param Sequence[builtins.str] cycle_modes: An ordered list of cycle modes that should be performed on the OKE nodes.
        :param builtins.bool is_node_cycling_enabled: If cycling operation should be performed on the nodes in the node pool.
        :param builtins.str maximum_surge: Maximum additional new compute instances that would be temporarily created and added to nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 1, Ranges from 0 to Nodepool size or 0% to 100%
        :param builtins.str maximum_unavailable: Maximum active nodes that would be terminated from nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 0, Ranges from 0 to Nodepool size or 0% to 100%
        """
        pulumi.set(__self__, "cycle_modes", cycle_modes)
        pulumi.set(__self__, "is_node_cycling_enabled", is_node_cycling_enabled)
        pulumi.set(__self__, "maximum_surge", maximum_surge)
        pulumi.set(__self__, "maximum_unavailable", maximum_unavailable)

    @property
    @pulumi.getter(name="cycleModes")
    def cycle_modes(self) -> Sequence[builtins.str]:
        """
        An ordered list of cycle modes that should be performed on the OKE nodes.
        """
        return pulumi.get(self, "cycle_modes")

    @property
    @pulumi.getter(name="isNodeCyclingEnabled")
    def is_node_cycling_enabled(self) -> builtins.bool:
        """
        If cycling operation should be performed on the nodes in the node pool.
        """
        return pulumi.get(self, "is_node_cycling_enabled")

    @property
    @pulumi.getter(name="maximumSurge")
    def maximum_surge(self) -> builtins.str:
        """
        Maximum additional new compute instances that would be temporarily created and added to nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 1, Ranges from 0 to Nodepool size or 0% to 100%
        """
        return pulumi.get(self, "maximum_surge")

    @property
    @pulumi.getter(name="maximumUnavailable")
    def maximum_unavailable(self) -> builtins.str:
        """
        Maximum active nodes that would be terminated from nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 0, Ranges from 0 to Nodepool size or 0% to 100%
        """
        return pulumi.get(self, "maximum_unavailable")


@pulumi.output_type
class GetNodePoolsNodePoolNodeShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: builtins.float,
                 ocpus: builtins.float):
        """
        :param builtins.float memory_in_gbs: The total amount of memory available to each node, in gigabytes.
        :param builtins.float ocpus: The total number of OCPUs available to each node in the node pool. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> builtins.float:
        """
        The total amount of memory available to each node, in gigabytes.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> builtins.float:
        """
        The total number of OCPUs available to each node in the node pool. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetNodePoolsNodePoolNodeSourceResult(dict):
    def __init__(__self__, *,
                 image_id: builtins.str,
                 source_name: builtins.str,
                 source_type: builtins.str):
        """
        :param builtins.str image_id: The OCID of the image used to boot the node.
        :param builtins.str source_name: The user-friendly name of the entity corresponding to the OCID.
        :param builtins.str source_type: The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        """
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "source_name", source_name)
        pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> builtins.str:
        """
        The OCID of the image used to boot the node.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> builtins.str:
        """
        The user-friendly name of the entity corresponding to the OCID.
        """
        return pulumi.get(self, "source_name")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> builtins.str:
        """
        The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetNodePoolsNodePoolNodeSourceDetailResult(dict):
    def __init__(__self__, *,
                 boot_volume_size_in_gbs: builtins.str,
                 image_id: builtins.str,
                 source_type: builtins.str):
        """
        :param builtins.str boot_volume_size_in_gbs: The size of the boot volume in GBs. Minimum value is 50 GB. See [here](https://docs.cloud.oracle.com/en-us/iaas/Content/Block/Concepts/bootvolumes.htm) for max custom boot volume sizing and OS-specific requirements.
        :param builtins.str image_id: The OCID of the image used to boot the node.
        :param builtins.str source_type: The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        """
        pulumi.set(__self__, "boot_volume_size_in_gbs", boot_volume_size_in_gbs)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="bootVolumeSizeInGbs")
    def boot_volume_size_in_gbs(self) -> builtins.str:
        """
        The size of the boot volume in GBs. Minimum value is 50 GB. See [here](https://docs.cloud.oracle.com/en-us/iaas/Content/Block/Concepts/bootvolumes.htm) for max custom boot volume sizing and OS-specific requirements.
        """
        return pulumi.get(self, "boot_volume_size_in_gbs")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> builtins.str:
        """
        The OCID of the image used to boot the node.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> builtins.str:
        """
        The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetPodShapesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: The name to filter on.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name to filter on.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPodShapesPodShapeResult(dict):
    def __init__(__self__, *,
                 memory_options: Sequence['outputs.GetPodShapesPodShapeMemoryOptionResult'],
                 name: builtins.str,
                 network_bandwidth_options: Sequence['outputs.GetPodShapesPodShapeNetworkBandwidthOptionResult'],
                 ocpu_options: Sequence['outputs.GetPodShapesPodShapeOcpuOptionResult'],
                 processor_description: builtins.str):
        """
        :param Sequence['GetPodShapesPodShapeMemoryOptionArgs'] memory_options: ShapeMemoryOptions.
        :param builtins.str name: The name to filter on.
        :param Sequence['GetPodShapesPodShapeNetworkBandwidthOptionArgs'] network_bandwidth_options: ShapeNetworkBandwidthOptions.
        :param Sequence['GetPodShapesPodShapeOcpuOptionArgs'] ocpu_options: Options for OCPU shape.
        :param builtins.str processor_description: A short description of the VM's processor (CPU).
        """
        pulumi.set(__self__, "memory_options", memory_options)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_bandwidth_options", network_bandwidth_options)
        pulumi.set(__self__, "ocpu_options", ocpu_options)
        pulumi.set(__self__, "processor_description", processor_description)

    @property
    @pulumi.getter(name="memoryOptions")
    def memory_options(self) -> Sequence['outputs.GetPodShapesPodShapeMemoryOptionResult']:
        """
        ShapeMemoryOptions.
        """
        return pulumi.get(self, "memory_options")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name to filter on.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkBandwidthOptions")
    def network_bandwidth_options(self) -> Sequence['outputs.GetPodShapesPodShapeNetworkBandwidthOptionResult']:
        """
        ShapeNetworkBandwidthOptions.
        """
        return pulumi.get(self, "network_bandwidth_options")

    @property
    @pulumi.getter(name="ocpuOptions")
    def ocpu_options(self) -> Sequence['outputs.GetPodShapesPodShapeOcpuOptionResult']:
        """
        Options for OCPU shape.
        """
        return pulumi.get(self, "ocpu_options")

    @property
    @pulumi.getter(name="processorDescription")
    def processor_description(self) -> builtins.str:
        """
        A short description of the VM's processor (CPU).
        """
        return pulumi.get(self, "processor_description")


@pulumi.output_type
class GetPodShapesPodShapeMemoryOptionResult(dict):
    def __init__(__self__, *,
                 default_per_ocpu_in_gbs: builtins.float,
                 max_in_gbs: builtins.float,
                 max_per_ocpu_in_gbs: builtins.float,
                 min_in_gbs: builtins.float,
                 min_per_ocpu_in_gbs: builtins.float):
        """
        :param builtins.float default_per_ocpu_in_gbs: The default amount of memory per OCPU available for this shape, in gigabytes.
        :param builtins.float max_in_gbs: The maximum amount of memory, in gigabytes.
        :param builtins.float max_per_ocpu_in_gbs: The maximum amount of memory per OCPU available for this shape, in gigabytes.
        :param builtins.float min_in_gbs: The minimum amount of memory, in gigabytes.
        :param builtins.float min_per_ocpu_in_gbs: The minimum amount of memory per OCPU available for this shape, in gigabytes.
        """
        pulumi.set(__self__, "default_per_ocpu_in_gbs", default_per_ocpu_in_gbs)
        pulumi.set(__self__, "max_in_gbs", max_in_gbs)
        pulumi.set(__self__, "max_per_ocpu_in_gbs", max_per_ocpu_in_gbs)
        pulumi.set(__self__, "min_in_gbs", min_in_gbs)
        pulumi.set(__self__, "min_per_ocpu_in_gbs", min_per_ocpu_in_gbs)

    @property
    @pulumi.getter(name="defaultPerOcpuInGbs")
    def default_per_ocpu_in_gbs(self) -> builtins.float:
        """
        The default amount of memory per OCPU available for this shape, in gigabytes.
        """
        return pulumi.get(self, "default_per_ocpu_in_gbs")

    @property
    @pulumi.getter(name="maxInGbs")
    def max_in_gbs(self) -> builtins.float:
        """
        The maximum amount of memory, in gigabytes.
        """
        return pulumi.get(self, "max_in_gbs")

    @property
    @pulumi.getter(name="maxPerOcpuInGbs")
    def max_per_ocpu_in_gbs(self) -> builtins.float:
        """
        The maximum amount of memory per OCPU available for this shape, in gigabytes.
        """
        return pulumi.get(self, "max_per_ocpu_in_gbs")

    @property
    @pulumi.getter(name="minInGbs")
    def min_in_gbs(self) -> builtins.float:
        """
        The minimum amount of memory, in gigabytes.
        """
        return pulumi.get(self, "min_in_gbs")

    @property
    @pulumi.getter(name="minPerOcpuInGbs")
    def min_per_ocpu_in_gbs(self) -> builtins.float:
        """
        The minimum amount of memory per OCPU available for this shape, in gigabytes.
        """
        return pulumi.get(self, "min_per_ocpu_in_gbs")


@pulumi.output_type
class GetPodShapesPodShapeNetworkBandwidthOptionResult(dict):
    def __init__(__self__, *,
                 default_per_ocpu_in_gbps: builtins.float,
                 max_in_gbps: builtins.float,
                 min_in_gbps: builtins.float):
        """
        :param builtins.float default_per_ocpu_in_gbps: The default amount of networking bandwidth per OCPU, in gigabits per second.
        :param builtins.float max_in_gbps: The maximum amount of networking bandwidth, in gigabits per second.
        :param builtins.float min_in_gbps: The minimum amount of networking bandwidth, in gigabits per second.
        """
        pulumi.set(__self__, "default_per_ocpu_in_gbps", default_per_ocpu_in_gbps)
        pulumi.set(__self__, "max_in_gbps", max_in_gbps)
        pulumi.set(__self__, "min_in_gbps", min_in_gbps)

    @property
    @pulumi.getter(name="defaultPerOcpuInGbps")
    def default_per_ocpu_in_gbps(self) -> builtins.float:
        """
        The default amount of networking bandwidth per OCPU, in gigabits per second.
        """
        return pulumi.get(self, "default_per_ocpu_in_gbps")

    @property
    @pulumi.getter(name="maxInGbps")
    def max_in_gbps(self) -> builtins.float:
        """
        The maximum amount of networking bandwidth, in gigabits per second.
        """
        return pulumi.get(self, "max_in_gbps")

    @property
    @pulumi.getter(name="minInGbps")
    def min_in_gbps(self) -> builtins.float:
        """
        The minimum amount of networking bandwidth, in gigabits per second.
        """
        return pulumi.get(self, "min_in_gbps")


@pulumi.output_type
class GetPodShapesPodShapeOcpuOptionResult(dict):
    def __init__(__self__, *,
                 max: builtins.float,
                 min: builtins.float):
        """
        :param builtins.float max: The maximum number of OCPUs.
        :param builtins.float min: The minimum number of OCPUs.
        """
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> builtins.float:
        """
        The maximum number of OCPUs.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> builtins.float:
        """
        The minimum number of OCPUs.
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class GetVirtualNodePoolInitialVirtualNodeLabelResult(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The key of the pair.
        :param builtins.str value: The value of the pair.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetVirtualNodePoolPlacementConfigurationResult(dict):
    def __init__(__self__, *,
                 availability_domain: builtins.str,
                 fault_domains: Sequence[builtins.str],
                 subnet_id: builtins.str):
        """
        :param builtins.str availability_domain: The availability domain in which to place virtual nodes. Example: `Uocm:PHX-AD-1`
        :param Sequence[builtins.str] fault_domains: The fault domain of this virtual node.
        :param builtins.str subnet_id: The regional subnet where pods' VNIC will be placed.
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "fault_domains", fault_domains)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        The availability domain in which to place virtual nodes. Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> Sequence[builtins.str]:
        """
        The fault domain of this virtual node.
        """
        return pulumi.get(self, "fault_domains")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The regional subnet where pods' VNIC will be placed.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetVirtualNodePoolPodConfigurationResult(dict):
    def __init__(__self__, *,
                 nsg_ids: Sequence[builtins.str],
                 shape: builtins.str,
                 subnet_id: builtins.str):
        """
        :param Sequence[builtins.str] nsg_ids: List of network security group IDs applied to the Pod VNIC.
        :param builtins.str shape: Shape of the pods.
        :param builtins.str subnet_id: The regional subnet where pods' VNIC will be placed.
        """
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "shape", shape)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[builtins.str]:
        """
        List of network security group IDs applied to the Pod VNIC.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter
    def shape(self) -> builtins.str:
        """
        Shape of the pods.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The regional subnet where pods' VNIC will be placed.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetVirtualNodePoolTaintResult(dict):
    def __init__(__self__, *,
                 effect: builtins.str,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str effect: The effect of the pair.
        :param builtins.str key: The key of the pair.
        :param builtins.str value: The value of the pair.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> builtins.str:
        """
        The effect of the pair.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetVirtualNodePoolVirtualNodeTagResult(dict):
    def __init__(__self__, *,
                 defined_tags: Mapping[str, builtins.str],
                 freeform_tags: Mapping[str, builtins.str]):
        """
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")


@pulumi.output_type
class GetVirtualNodePoolsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: The name to filter on.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name to filter on.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetVirtualNodePoolsVirtualNodePoolResult(dict):
    def __init__(__self__, *,
                 cluster_id: builtins.str,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 initial_virtual_node_labels: Sequence['outputs.GetVirtualNodePoolsVirtualNodePoolInitialVirtualNodeLabelResult'],
                 kubernetes_version: builtins.str,
                 lifecycle_details: builtins.str,
                 nsg_ids: Sequence[builtins.str],
                 placement_configurations: Sequence['outputs.GetVirtualNodePoolsVirtualNodePoolPlacementConfigurationResult'],
                 pod_configurations: Sequence['outputs.GetVirtualNodePoolsVirtualNodePoolPodConfigurationResult'],
                 size: builtins.int,
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 taints: Sequence['outputs.GetVirtualNodePoolsVirtualNodePoolTaintResult'],
                 time_created: builtins.str,
                 time_updated: builtins.str,
                 virtual_node_pool_id: builtins.str,
                 virtual_node_tags: Sequence['outputs.GetVirtualNodePoolsVirtualNodePoolVirtualNodeTagResult']):
        """
        :param builtins.str cluster_id: The OCID of the cluster.
        :param builtins.str compartment_id: The OCID of the compartment.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str display_name: Display name of the virtual node pool. This is a non-unique value.
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param builtins.str id: The OCID of the virtual node pool.
        :param Sequence['GetVirtualNodePoolsVirtualNodePoolInitialVirtualNodeLabelArgs'] initial_virtual_node_labels: Initial labels that will be added to the Kubernetes Virtual Node object when it registers. This is the same as virtualNodePool resources.
        :param builtins.str kubernetes_version: The version of Kubernetes running on the nodes in the node pool.
        :param builtins.str lifecycle_details: Details about the state of the Virtual Node Pool.
        :param Sequence[builtins.str] nsg_ids: List of network security group IDs applied to the Pod VNIC.
        :param Sequence['GetVirtualNodePoolsVirtualNodePoolPlacementConfigurationArgs'] placement_configurations: The list of placement configurations which determines where Virtual Nodes will be provisioned across as it relates to the subnet and availability domains. The size attribute determines how many we evenly spread across these placement configurations
        :param Sequence['GetVirtualNodePoolsVirtualNodePoolPodConfigurationArgs'] pod_configurations: The pod configuration for pods run on virtual nodes of this virtual node pool.
        :param builtins.int size: The number of Virtual Nodes that should be in the Virtual Node Pool. The placement configurations determine where these virtual nodes are placed.
        :param builtins.str state: A virtual node pool lifecycle state to filter on. Can have multiple parameters of this name.
        :param Mapping[str, builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param Sequence['GetVirtualNodePoolsVirtualNodePoolTaintArgs'] taints: A taint is a collection of <key, value, effect>. These taints will be applied to the Virtual Nodes of this Virtual Node Pool for Kubernetes scheduling.
        :param builtins.str time_created: The time the virtual node pool was created.
        :param builtins.str time_updated: The time the virtual node pool was updated.
        :param Sequence['GetVirtualNodePoolsVirtualNodePoolVirtualNodeTagArgs'] virtual_node_tags: The tags associated to the virtual nodes in this virtual node pool.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "initial_virtual_node_labels", initial_virtual_node_labels)
        pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "placement_configurations", placement_configurations)
        pulumi.set(__self__, "pod_configurations", pod_configurations)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "taints", taints)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "virtual_node_pool_id", virtual_node_pool_id)
        pulumi.set(__self__, "virtual_node_tags", virtual_node_tags)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> builtins.str:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Display name of the virtual node pool. This is a non-unique value.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the virtual node pool.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="initialVirtualNodeLabels")
    def initial_virtual_node_labels(self) -> Sequence['outputs.GetVirtualNodePoolsVirtualNodePoolInitialVirtualNodeLabelResult']:
        """
        Initial labels that will be added to the Kubernetes Virtual Node object when it registers. This is the same as virtualNodePool resources.
        """
        return pulumi.get(self, "initial_virtual_node_labels")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> builtins.str:
        """
        The version of Kubernetes running on the nodes in the node pool.
        """
        return pulumi.get(self, "kubernetes_version")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Details about the state of the Virtual Node Pool.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[builtins.str]:
        """
        List of network security group IDs applied to the Pod VNIC.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="placementConfigurations")
    def placement_configurations(self) -> Sequence['outputs.GetVirtualNodePoolsVirtualNodePoolPlacementConfigurationResult']:
        """
        The list of placement configurations which determines where Virtual Nodes will be provisioned across as it relates to the subnet and availability domains. The size attribute determines how many we evenly spread across these placement configurations
        """
        return pulumi.get(self, "placement_configurations")

    @property
    @pulumi.getter(name="podConfigurations")
    def pod_configurations(self) -> Sequence['outputs.GetVirtualNodePoolsVirtualNodePoolPodConfigurationResult']:
        """
        The pod configuration for pods run on virtual nodes of this virtual node pool.
        """
        return pulumi.get(self, "pod_configurations")

    @property
    @pulumi.getter
    def size(self) -> builtins.int:
        """
        The number of Virtual Nodes that should be in the Virtual Node Pool. The placement configurations determine where these virtual nodes are placed.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A virtual node pool lifecycle state to filter on. Can have multiple parameters of this name.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter
    def taints(self) -> Sequence['outputs.GetVirtualNodePoolsVirtualNodePoolTaintResult']:
        """
        A taint is a collection of <key, value, effect>. These taints will be applied to the Virtual Nodes of this Virtual Node Pool for Kubernetes scheduling.
        """
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the virtual node pool was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the virtual node pool was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="virtualNodePoolId")
    def virtual_node_pool_id(self) -> builtins.str:
        return pulumi.get(self, "virtual_node_pool_id")

    @property
    @pulumi.getter(name="virtualNodeTags")
    def virtual_node_tags(self) -> Sequence['outputs.GetVirtualNodePoolsVirtualNodePoolVirtualNodeTagResult']:
        """
        The tags associated to the virtual nodes in this virtual node pool.
        """
        return pulumi.get(self, "virtual_node_tags")


@pulumi.output_type
class GetVirtualNodePoolsVirtualNodePoolInitialVirtualNodeLabelResult(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The key of the pair.
        :param builtins.str value: The value of the pair.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetVirtualNodePoolsVirtualNodePoolPlacementConfigurationResult(dict):
    def __init__(__self__, *,
                 availability_domain: builtins.str,
                 fault_domains: Sequence[builtins.str],
                 subnet_id: builtins.str):
        """
        :param builtins.str availability_domain: The availability domain in which to place virtual nodes. Example: `Uocm:PHX-AD-1`
        :param Sequence[builtins.str] fault_domains: The fault domain of this virtual node.
        :param builtins.str subnet_id: The regional subnet where pods' VNIC will be placed.
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "fault_domains", fault_domains)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        The availability domain in which to place virtual nodes. Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> Sequence[builtins.str]:
        """
        The fault domain of this virtual node.
        """
        return pulumi.get(self, "fault_domains")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The regional subnet where pods' VNIC will be placed.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetVirtualNodePoolsVirtualNodePoolPodConfigurationResult(dict):
    def __init__(__self__, *,
                 nsg_ids: Sequence[builtins.str],
                 shape: builtins.str,
                 subnet_id: builtins.str):
        """
        :param Sequence[builtins.str] nsg_ids: List of network security group IDs applied to the Pod VNIC.
        :param builtins.str shape: Shape of the pods.
        :param builtins.str subnet_id: The regional subnet where pods' VNIC will be placed.
        """
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "shape", shape)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[builtins.str]:
        """
        List of network security group IDs applied to the Pod VNIC.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter
    def shape(self) -> builtins.str:
        """
        Shape of the pods.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The regional subnet where pods' VNIC will be placed.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetVirtualNodePoolsVirtualNodePoolTaintResult(dict):
    def __init__(__self__, *,
                 effect: builtins.str,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str effect: The effect of the pair.
        :param builtins.str key: The key of the pair.
        :param builtins.str value: The value of the pair.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> builtins.str:
        """
        The effect of the pair.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetVirtualNodePoolsVirtualNodePoolVirtualNodeTagResult(dict):
    def __init__(__self__, *,
                 defined_tags: Mapping[str, builtins.str],
                 freeform_tags: Mapping[str, builtins.str]):
        """
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")


@pulumi.output_type
class GetWorkRequestErrorsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetWorkRequestErrorsWorkRequestErrorResult(dict):
    def __init__(__self__, *,
                 code: builtins.str,
                 message: builtins.str,
                 timestamp: builtins.str):
        """
        :param builtins.str code: A short error code that defines the error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        :param builtins.str message: A human-readable error string.
        :param builtins.str timestamp: The date and time the error occurred.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "timestamp", timestamp)

    @property
    @pulumi.getter
    def code(self) -> builtins.str:
        """
        A short error code that defines the error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        """
        A human-readable error string.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def timestamp(self) -> builtins.str:
        """
        The date and time the error occurred.
        """
        return pulumi.get(self, "timestamp")


@pulumi.output_type
class GetWorkRequestLogEntriesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetWorkRequestLogEntriesWorkRequestLogEntryResult(dict):
    def __init__(__self__, *,
                 message: builtins.str,
                 timestamp: builtins.str):
        """
        :param builtins.str message: The description of an action that occurred.
        :param builtins.str timestamp: The date and time the log entry occurred.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "timestamp", timestamp)

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        """
        The description of an action that occurred.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def timestamp(self) -> builtins.str:
        """
        The date and time the log entry occurred.
        """
        return pulumi.get(self, "timestamp")


@pulumi.output_type
class GetWorkRequestsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetWorkRequestsWorkRequestResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 id: builtins.str,
                 operation_type: builtins.str,
                 resources: Sequence['outputs.GetWorkRequestsWorkRequestResourceResult'],
                 status: builtins.str,
                 time_accepted: builtins.str,
                 time_finished: builtins.str,
                 time_started: builtins.str):
        """
        :param builtins.str compartment_id: The OCID of the compartment.
        :param builtins.str id: The OCID of the work request.
        :param builtins.str operation_type: The type of work the work request is doing.
        :param Sequence['GetWorkRequestsWorkRequestResourceArgs'] resources: The resources this work request affects.
        :param builtins.str status: A work request status to filter on. Can have multiple parameters of this name.
        :param builtins.str time_accepted: The time the work request was accepted.
        :param builtins.str time_finished: The time the work request was finished.
        :param builtins.str time_started: The time the work request was started.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "operation_type", operation_type)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "time_accepted", time_accepted)
        pulumi.set(__self__, "time_finished", time_finished)
        pulumi.set(__self__, "time_started", time_started)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the work request.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="operationType")
    def operation_type(self) -> builtins.str:
        """
        The type of work the work request is doing.
        """
        return pulumi.get(self, "operation_type")

    @property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetWorkRequestsWorkRequestResourceResult']:
        """
        The resources this work request affects.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        A work request status to filter on. Can have multiple parameters of this name.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> builtins.str:
        """
        The time the work request was accepted.
        """
        return pulumi.get(self, "time_accepted")

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> builtins.str:
        """
        The time the work request was finished.
        """
        return pulumi.get(self, "time_finished")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> builtins.str:
        """
        The time the work request was started.
        """
        return pulumi.get(self, "time_started")


@pulumi.output_type
class GetWorkRequestsWorkRequestResourceResult(dict):
    def __init__(__self__, *,
                 action_type: builtins.str,
                 entity_type: builtins.str,
                 entity_uri: builtins.str,
                 identifier: builtins.str):
        """
        :param builtins.str action_type: The way in which this resource was affected by the work tracked by the work request.
        :param builtins.str entity_type: The resource type the work request affects.
        :param builtins.str entity_uri: The URI path on which the user can issue a GET request to access the resource metadata.
        :param builtins.str identifier: The OCID of the resource the work request affects.
        """
        pulumi.set(__self__, "action_type", action_type)
        pulumi.set(__self__, "entity_type", entity_type)
        pulumi.set(__self__, "entity_uri", entity_uri)
        pulumi.set(__self__, "identifier", identifier)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> builtins.str:
        """
        The way in which this resource was affected by the work tracked by the work request.
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> builtins.str:
        """
        The resource type the work request affects.
        """
        return pulumi.get(self, "entity_type")

    @property
    @pulumi.getter(name="entityUri")
    def entity_uri(self) -> builtins.str:
        """
        The URI path on which the user can issue a GET request to access the resource metadata.
        """
        return pulumi.get(self, "entity_uri")

    @property
    @pulumi.getter
    def identifier(self) -> builtins.str:
        """
        The OCID of the resource the work request affects.
        """
        return pulumi.get(self, "identifier")


