# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetIpInventoryVcnOverlapsResult',
    'AwaitableGetIpInventoryVcnOverlapsResult',
    'get_ip_inventory_vcn_overlaps',
    'get_ip_inventory_vcn_overlaps_output',
]

@pulumi.output_type
class GetIpInventoryVcnOverlapsResult:
    """
    A collection of values returned by getIpInventoryVcnOverlaps.
    """
    def __init__(__self__, compartment_lists=None, filters=None, id=None, ip_inventory_vcn_overlap_summaries=None, last_updated_timestamp=None, message=None, overlap_count=None, region_lists=None, vcn_id=None):
        if compartment_lists and not isinstance(compartment_lists, list):
            raise TypeError("Expected argument 'compartment_lists' to be a list")
        pulumi.set(__self__, "compartment_lists", compartment_lists)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_inventory_vcn_overlap_summaries and not isinstance(ip_inventory_vcn_overlap_summaries, list):
            raise TypeError("Expected argument 'ip_inventory_vcn_overlap_summaries' to be a list")
        pulumi.set(__self__, "ip_inventory_vcn_overlap_summaries", ip_inventory_vcn_overlap_summaries)
        if last_updated_timestamp and not isinstance(last_updated_timestamp, str):
            raise TypeError("Expected argument 'last_updated_timestamp' to be a str")
        pulumi.set(__self__, "last_updated_timestamp", last_updated_timestamp)
        if message and not isinstance(message, str):
            raise TypeError("Expected argument 'message' to be a str")
        pulumi.set(__self__, "message", message)
        if overlap_count and not isinstance(overlap_count, int):
            raise TypeError("Expected argument 'overlap_count' to be a int")
        pulumi.set(__self__, "overlap_count", overlap_count)
        if region_lists and not isinstance(region_lists, list):
            raise TypeError("Expected argument 'region_lists' to be a list")
        pulumi.set(__self__, "region_lists", region_lists)
        if vcn_id and not isinstance(vcn_id, str):
            raise TypeError("Expected argument 'vcn_id' to be a str")
        pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="compartmentLists")
    def compartment_lists(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "compartment_lists")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetIpInventoryVcnOverlapsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipInventoryVcnOverlapSummaries")
    def ip_inventory_vcn_overlap_summaries(self) -> Sequence['outputs.GetIpInventoryVcnOverlapsIpInventoryVcnOverlapSummaryResult']:
        """
        Lists `IpInventoryVcnOverlapSummary` object.
        """
        return pulumi.get(self, "ip_inventory_vcn_overlap_summaries")

    @property
    @pulumi.getter(name="lastUpdatedTimestamp")
    def last_updated_timestamp(self) -> builtins.str:
        """
        The timestamp of the latest update from the database in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "last_updated_timestamp")

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        """
        Indicates the status of the data.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="overlapCount")
    def overlap_count(self) -> builtins.int:
        """
        The overlap count for the given VCN and compartments.
        """
        return pulumi.get(self, "overlap_count")

    @property
    @pulumi.getter(name="regionLists")
    def region_lists(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "region_lists")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> builtins.str:
        return pulumi.get(self, "vcn_id")


class AwaitableGetIpInventoryVcnOverlapsResult(GetIpInventoryVcnOverlapsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpInventoryVcnOverlapsResult(
            compartment_lists=self.compartment_lists,
            filters=self.filters,
            id=self.id,
            ip_inventory_vcn_overlap_summaries=self.ip_inventory_vcn_overlap_summaries,
            last_updated_timestamp=self.last_updated_timestamp,
            message=self.message,
            overlap_count=self.overlap_count,
            region_lists=self.region_lists,
            vcn_id=self.vcn_id)


def get_ip_inventory_vcn_overlaps(compartment_lists: Optional[Sequence[builtins.str]] = None,
                                  filters: Optional[Sequence[Union['GetIpInventoryVcnOverlapsFilterArgs', 'GetIpInventoryVcnOverlapsFilterArgsDict']]] = None,
                                  region_lists: Optional[Sequence[builtins.str]] = None,
                                  vcn_id: Optional[builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpInventoryVcnOverlapsResult:
    """
    This data source provides the list of Ip Inventory Vcn Overlaps in Oracle Cloud Infrastructure Core service.

    Gets the CIDR overlap information of the specified VCN in selected compartments. Specify the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ip_inventory_vcn_overlaps = oci.Core.get_ip_inventory_vcn_overlaps(compartment_lists=ip_inventory_vcn_overlap_compartment_list,
        region_lists=ip_inventory_vcn_overlap_region_list,
        vcn_id=test_vcn["id"])
    ```


    :param Sequence[builtins.str] compartment_lists: The list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartments.
    :param Sequence[builtins.str] region_lists: Lists the selected regions.
    :param builtins.str vcn_id: Specify the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
    """
    __args__ = dict()
    __args__['compartmentLists'] = compartment_lists
    __args__['filters'] = filters
    __args__['regionLists'] = region_lists
    __args__['vcnId'] = vcn_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getIpInventoryVcnOverlaps:getIpInventoryVcnOverlaps', __args__, opts=opts, typ=GetIpInventoryVcnOverlapsResult).value

    return AwaitableGetIpInventoryVcnOverlapsResult(
        compartment_lists=pulumi.get(__ret__, 'compartment_lists'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ip_inventory_vcn_overlap_summaries=pulumi.get(__ret__, 'ip_inventory_vcn_overlap_summaries'),
        last_updated_timestamp=pulumi.get(__ret__, 'last_updated_timestamp'),
        message=pulumi.get(__ret__, 'message'),
        overlap_count=pulumi.get(__ret__, 'overlap_count'),
        region_lists=pulumi.get(__ret__, 'region_lists'),
        vcn_id=pulumi.get(__ret__, 'vcn_id'))
def get_ip_inventory_vcn_overlaps_output(compartment_lists: Optional[pulumi.Input[Sequence[builtins.str]]] = None,
                                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetIpInventoryVcnOverlapsFilterArgs', 'GetIpInventoryVcnOverlapsFilterArgsDict']]]]] = None,
                                         region_lists: Optional[pulumi.Input[Sequence[builtins.str]]] = None,
                                         vcn_id: Optional[pulumi.Input[builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIpInventoryVcnOverlapsResult]:
    """
    This data source provides the list of Ip Inventory Vcn Overlaps in Oracle Cloud Infrastructure Core service.

    Gets the CIDR overlap information of the specified VCN in selected compartments. Specify the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ip_inventory_vcn_overlaps = oci.Core.get_ip_inventory_vcn_overlaps(compartment_lists=ip_inventory_vcn_overlap_compartment_list,
        region_lists=ip_inventory_vcn_overlap_region_list,
        vcn_id=test_vcn["id"])
    ```


    :param Sequence[builtins.str] compartment_lists: The list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartments.
    :param Sequence[builtins.str] region_lists: Lists the selected regions.
    :param builtins.str vcn_id: Specify the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
    """
    __args__ = dict()
    __args__['compartmentLists'] = compartment_lists
    __args__['filters'] = filters
    __args__['regionLists'] = region_lists
    __args__['vcnId'] = vcn_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getIpInventoryVcnOverlaps:getIpInventoryVcnOverlaps', __args__, opts=opts, typ=GetIpInventoryVcnOverlapsResult)
    return __ret__.apply(lambda __response__: GetIpInventoryVcnOverlapsResult(
        compartment_lists=pulumi.get(__response__, 'compartment_lists'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        ip_inventory_vcn_overlap_summaries=pulumi.get(__response__, 'ip_inventory_vcn_overlap_summaries'),
        last_updated_timestamp=pulumi.get(__response__, 'last_updated_timestamp'),
        message=pulumi.get(__response__, 'message'),
        overlap_count=pulumi.get(__response__, 'overlap_count'),
        region_lists=pulumi.get(__response__, 'region_lists'),
        vcn_id=pulumi.get(__response__, 'vcn_id')))
