# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRemotePeeringConnectionsResult',
    'AwaitableGetRemotePeeringConnectionsResult',
    'get_remote_peering_connections',
    'get_remote_peering_connections_output',
]

@pulumi.output_type
class GetRemotePeeringConnectionsResult:
    """
    A collection of values returned by getRemotePeeringConnections.
    """
    def __init__(__self__, compartment_id=None, drg_id=None, filters=None, id=None, remote_peering_connections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if drg_id and not isinstance(drg_id, str):
            raise TypeError("Expected argument 'drg_id' to be a str")
        pulumi.set(__self__, "drg_id", drg_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if remote_peering_connections and not isinstance(remote_peering_connections, list):
            raise TypeError("Expected argument 'remote_peering_connections' to be a list")
        pulumi.set(__self__, "remote_peering_connections", remote_peering_connections)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the RPC.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="drgId")
    def drg_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG that this RPC belongs to.
        """
        return pulumi.get(self, "drg_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetRemotePeeringConnectionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="remotePeeringConnections")
    def remote_peering_connections(self) -> Sequence['outputs.GetRemotePeeringConnectionsRemotePeeringConnectionResult']:
        """
        The list of remote_peering_connections.
        """
        return pulumi.get(self, "remote_peering_connections")


class AwaitableGetRemotePeeringConnectionsResult(GetRemotePeeringConnectionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRemotePeeringConnectionsResult(
            compartment_id=self.compartment_id,
            drg_id=self.drg_id,
            filters=self.filters,
            id=self.id,
            remote_peering_connections=self.remote_peering_connections)


def get_remote_peering_connections(compartment_id: Optional[builtins.str] = None,
                                   drg_id: Optional[builtins.str] = None,
                                   filters: Optional[Sequence[Union['GetRemotePeeringConnectionsFilterArgs', 'GetRemotePeeringConnectionsFilterArgsDict']]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRemotePeeringConnectionsResult:
    """
    This data source provides the list of Remote Peering Connections in Oracle Cloud Infrastructure Core service.

    Lists the remote peering connections (RPCs) for the specified DRG and compartment
    (the RPC's compartment).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_remote_peering_connections = oci.Core.get_remote_peering_connections(compartment_id=compartment_id,
        drg_id=test_drg["id"])
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str drg_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['drgId'] = drg_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getRemotePeeringConnections:getRemotePeeringConnections', __args__, opts=opts, typ=GetRemotePeeringConnectionsResult).value

    return AwaitableGetRemotePeeringConnectionsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        drg_id=pulumi.get(__ret__, 'drg_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        remote_peering_connections=pulumi.get(__ret__, 'remote_peering_connections'))
def get_remote_peering_connections_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                          drg_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                          filters: Optional[pulumi.Input[Optional[Sequence[Union['GetRemotePeeringConnectionsFilterArgs', 'GetRemotePeeringConnectionsFilterArgsDict']]]]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRemotePeeringConnectionsResult]:
    """
    This data source provides the list of Remote Peering Connections in Oracle Cloud Infrastructure Core service.

    Lists the remote peering connections (RPCs) for the specified DRG and compartment
    (the RPC's compartment).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_remote_peering_connections = oci.Core.get_remote_peering_connections(compartment_id=compartment_id,
        drg_id=test_drg["id"])
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str drg_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['drgId'] = drg_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getRemotePeeringConnections:getRemotePeeringConnections', __args__, opts=opts, typ=GetRemotePeeringConnectionsResult)
    return __ret__.apply(lambda __response__: GetRemotePeeringConnectionsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        drg_id=pulumi.get(__response__, 'drg_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        remote_peering_connections=pulumi.get(__response__, 'remote_peering_connections')))
