# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVolumeAttachmentsResult',
    'AwaitableGetVolumeAttachmentsResult',
    'get_volume_attachments',
    'get_volume_attachments_output',
]

@pulumi.output_type
class GetVolumeAttachmentsResult:
    """
    A collection of values returned by getVolumeAttachments.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, filters=None, id=None, instance_id=None, volume_attachments=None, volume_id=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if volume_attachments and not isinstance(volume_attachments, list):
            raise TypeError("Expected argument 'volume_attachments' to be a list")
        pulumi.set(__self__, "volume_attachments", volume_attachments)
        if volume_id and not isinstance(volume_id, str):
            raise TypeError("Expected argument 'volume_id' to be a str")
        pulumi.set(__self__, "volume_id", volume_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[builtins.str]:
        """
        The availability domain of an instance.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVolumeAttachmentsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[builtins.str]:
        """
        The OCID of the instance the volume is attached to.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="volumeAttachments")
    def volume_attachments(self) -> Sequence['outputs.GetVolumeAttachmentsVolumeAttachmentResult']:
        """
        The list of volume_attachments.
        """
        return pulumi.get(self, "volume_attachments")

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[builtins.str]:
        """
        The OCID of the volume.
        """
        return pulumi.get(self, "volume_id")


class AwaitableGetVolumeAttachmentsResult(GetVolumeAttachmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVolumeAttachmentsResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            instance_id=self.instance_id,
            volume_attachments=self.volume_attachments,
            volume_id=self.volume_id)


def get_volume_attachments(availability_domain: Optional[builtins.str] = None,
                           compartment_id: Optional[builtins.str] = None,
                           filters: Optional[Sequence[Union['GetVolumeAttachmentsFilterArgs', 'GetVolumeAttachmentsFilterArgsDict']]] = None,
                           instance_id: Optional[builtins.str] = None,
                           volume_id: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVolumeAttachmentsResult:
    """
    This data source provides the list of Volume Attachments in Oracle Cloud Infrastructure Core service.

    Lists the volume attachments in the specified compartment. You can filter the
    list by specifying an instance OCID, volume OCID, or both.

    Currently, the only supported volume attachment type are [IScsiVolumeAttachment](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/IScsiVolumeAttachment/) and
    [ParavirtualizedVolumeAttachment](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/ParavirtualizedVolumeAttachment/).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_volume_attachments = oci.Core.get_volume_attachments(compartment_id=compartment_id,
        availability_domain=volume_attachment_availability_domain,
        instance_id=test_instance["id"],
        volume_id=test_volume["id"])
    ```


    :param builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str instance_id: The OCID of the instance.
    :param builtins.str volume_id: The OCID of the volume.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['instanceId'] = instance_id
    __args__['volumeId'] = volume_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getVolumeAttachments:getVolumeAttachments', __args__, opts=opts, typ=GetVolumeAttachmentsResult).value

    return AwaitableGetVolumeAttachmentsResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        volume_attachments=pulumi.get(__ret__, 'volume_attachments'),
        volume_id=pulumi.get(__ret__, 'volume_id'))
def get_volume_attachments_output(availability_domain: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                  filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVolumeAttachmentsFilterArgs', 'GetVolumeAttachmentsFilterArgsDict']]]]] = None,
                                  instance_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  volume_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVolumeAttachmentsResult]:
    """
    This data source provides the list of Volume Attachments in Oracle Cloud Infrastructure Core service.

    Lists the volume attachments in the specified compartment. You can filter the
    list by specifying an instance OCID, volume OCID, or both.

    Currently, the only supported volume attachment type are [IScsiVolumeAttachment](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/IScsiVolumeAttachment/) and
    [ParavirtualizedVolumeAttachment](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/ParavirtualizedVolumeAttachment/).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_volume_attachments = oci.Core.get_volume_attachments(compartment_id=compartment_id,
        availability_domain=volume_attachment_availability_domain,
        instance_id=test_instance["id"],
        volume_id=test_volume["id"])
    ```


    :param builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str instance_id: The OCID of the instance.
    :param builtins.str volume_id: The OCID of the volume.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['instanceId'] = instance_id
    __args__['volumeId'] = volume_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getVolumeAttachments:getVolumeAttachments', __args__, opts=opts, typ=GetVolumeAttachmentsResult)
    return __ret__.apply(lambda __response__: GetVolumeAttachmentsResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        volume_attachments=pulumi.get(__response__, 'volume_attachments'),
        volume_id=pulumi.get(__response__, 'volume_id')))
