# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VolumeArgs', 'Volume']

@pulumi.input_type
class VolumeArgs:
    def __init__(__self__, *,
                 availability_domain: pulumi.Input[builtins.str],
                 compartment_id: pulumi.Input[builtins.str],
                 autotune_policies: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeAutotunePolicyArgs']]]] = None,
                 backup_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 block_volume_replicas: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeBlockVolumeReplicaArgs']]]] = None,
                 block_volume_replicas_deletion: Optional[pulumi.Input[builtins.bool]] = None,
                 cluster_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_auto_tune_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_reservations_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 size_in_gbs: Optional[pulumi.Input[builtins.str]] = None,
                 size_in_mbs: Optional[pulumi.Input[builtins.str]] = None,
                 source_details: Optional[pulumi.Input['VolumeSourceDetailsArgs']] = None,
                 volume_backup_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpus_per_gb: Optional[pulumi.Input[builtins.str]] = None,
                 xrc_kms_key_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Volume resource.
        :param pulumi.Input[builtins.str] availability_domain: The availability domain of the volume. Omissible for cloning a volume. The new volume will be created in the availability domain of the source volume.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains the volume.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeAutotunePolicyArgs']]] autotune_policies: (Updatable) The list of autotune policies to be enabled for this volume.
        :param pulumi.Input[builtins.str] backup_policy_id: If provided, specifies the ID of the volume backup policy to assign to the newly created volume. If omitted, no policy will be assigned. This field is deprecated. Use the `core_get_volume_backup_policy_assignments` instead to assign a backup policy to a volume.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeBlockVolumeReplicaArgs']]] block_volume_replicas: (Updatable) The list of block volume replicas to be enabled for this volume in the specified destination availability domains.
        :param pulumi.Input[builtins.str] cluster_placement_group_id: The clusterPlacementGroup Id of the volume for volume placement.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_auto_tune_enabled: (Updatable) Specifies whether the auto-tune performance is enabled for this volume. This field is deprecated. Use the `DetachedVolumeAutotunePolicy` instead to enable the volume for detached autotune.
        :param pulumi.Input[builtins.bool] is_reservations_enabled: (Updatable) Reservations-enabled is a boolean field that allows to enable PR (Persistent Reservation) on a volume.
        :param pulumi.Input[builtins.str] kms_key_id: (Updatable) The OCID of the Vault service key to assign as the master encryption key for the volume.
        :param pulumi.Input[builtins.str] size_in_gbs: (Updatable) The size of the volume in GBs.
        :param pulumi.Input[builtins.str] size_in_mbs: The size of the volume in MBs. The value must be a multiple of 1024. This field is deprecated. Use sizeInGBs instead.
        :param pulumi.Input['VolumeSourceDetailsArgs'] source_details: Specifies the volume source details for a new Block volume. The volume source is either another Block volume in the same Availability Domain or a Block volume backup. This is an optional field. If not specified or set to null, the new Block volume will be empty. When specified, the new Block volume will contain data from the source volume or backup.
        :param pulumi.Input[builtins.str] volume_backup_id: The OCID of the volume backup from which the data should be restored on the newly created volume. This field is deprecated. Use the sourceDetails field instead to specify the backup for the volume.
        :param pulumi.Input[builtins.str] vpus_per_gb: (Updatable) The number of volume performance units (VPUs) that will be applied to this volume per GB, representing the Block Volume service's elastic performance options. See [Block Volume Performance Levels](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/blockvolumeperformance.htm#perf_levels) for more information.
               
               Allowed values:
        :param pulumi.Input[builtins.str] xrc_kms_key_id: The OCID of the Vault service key which is the master encryption key for the block volume cross region backups, which will be used in the destination region to encrypt the backup's encryption keys. For more information about the Vault service and encryption keys, see [Overview of Vault service](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm) and [Using Keys](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Tasks/usingkeys.htm). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "compartment_id", compartment_id)
        if autotune_policies is not None:
            pulumi.set(__self__, "autotune_policies", autotune_policies)
        if backup_policy_id is not None:
            warnings.warn("""The 'backup_policy_id' field has been deprecated. Please use the 'oci_core_volume_backup_policy_assignment' resource instead.""", DeprecationWarning)
            pulumi.log.warn("""backup_policy_id is deprecated: The 'backup_policy_id' field has been deprecated. Please use the 'oci_core_volume_backup_policy_assignment' resource instead.""")
        if backup_policy_id is not None:
            pulumi.set(__self__, "backup_policy_id", backup_policy_id)
        if block_volume_replicas is not None:
            pulumi.set(__self__, "block_volume_replicas", block_volume_replicas)
        if block_volume_replicas_deletion is not None:
            pulumi.set(__self__, "block_volume_replicas_deletion", block_volume_replicas_deletion)
        if cluster_placement_group_id is not None:
            pulumi.set(__self__, "cluster_placement_group_id", cluster_placement_group_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_auto_tune_enabled is not None:
            pulumi.set(__self__, "is_auto_tune_enabled", is_auto_tune_enabled)
        if is_reservations_enabled is not None:
            pulumi.set(__self__, "is_reservations_enabled", is_reservations_enabled)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if size_in_gbs is not None:
            pulumi.set(__self__, "size_in_gbs", size_in_gbs)
        if size_in_mbs is not None:
            warnings.warn("""The 'size_in_mbs' field has been deprecated. Please use 'size_in_gbs' instead.""", DeprecationWarning)
            pulumi.log.warn("""size_in_mbs is deprecated: The 'size_in_mbs' field has been deprecated. Please use 'size_in_gbs' instead.""")
        if size_in_mbs is not None:
            pulumi.set(__self__, "size_in_mbs", size_in_mbs)
        if source_details is not None:
            pulumi.set(__self__, "source_details", source_details)
        if volume_backup_id is not None:
            pulumi.set(__self__, "volume_backup_id", volume_backup_id)
        if vpus_per_gb is not None:
            pulumi.set(__self__, "vpus_per_gb", vpus_per_gb)
        if xrc_kms_key_id is not None:
            pulumi.set(__self__, "xrc_kms_key_id", xrc_kms_key_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Input[builtins.str]:
        """
        The availability domain of the volume. Omissible for cloning a volume. The new volume will be created in the availability domain of the source volume.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The OCID of the compartment that contains the volume.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="autotunePolicies")
    def autotune_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeAutotunePolicyArgs']]]]:
        """
        (Updatable) The list of autotune policies to be enabled for this volume.
        """
        return pulumi.get(self, "autotune_policies")

    @autotune_policies.setter
    def autotune_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeAutotunePolicyArgs']]]]):
        pulumi.set(self, "autotune_policies", value)

    @property
    @pulumi.getter(name="backupPolicyId")
    @_utilities.deprecated("""The 'backup_policy_id' field has been deprecated. Please use the 'oci_core_volume_backup_policy_assignment' resource instead.""")
    def backup_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If provided, specifies the ID of the volume backup policy to assign to the newly created volume. If omitted, no policy will be assigned. This field is deprecated. Use the `core_get_volume_backup_policy_assignments` instead to assign a backup policy to a volume.
        """
        return pulumi.get(self, "backup_policy_id")

    @backup_policy_id.setter
    def backup_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backup_policy_id", value)

    @property
    @pulumi.getter(name="blockVolumeReplicas")
    def block_volume_replicas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeBlockVolumeReplicaArgs']]]]:
        """
        (Updatable) The list of block volume replicas to be enabled for this volume in the specified destination availability domains.
        """
        return pulumi.get(self, "block_volume_replicas")

    @block_volume_replicas.setter
    def block_volume_replicas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeBlockVolumeReplicaArgs']]]]):
        pulumi.set(self, "block_volume_replicas", value)

    @property
    @pulumi.getter(name="blockVolumeReplicasDeletion")
    def block_volume_replicas_deletion(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "block_volume_replicas_deletion")

    @block_volume_replicas_deletion.setter
    def block_volume_replicas_deletion(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "block_volume_replicas_deletion", value)

    @property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The clusterPlacementGroup Id of the volume for volume placement.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @cluster_placement_group_id.setter
    def cluster_placement_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_placement_group_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isAutoTuneEnabled")
    def is_auto_tune_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Specifies whether the auto-tune performance is enabled for this volume. This field is deprecated. Use the `DetachedVolumeAutotunePolicy` instead to enable the volume for detached autotune.
        """
        return pulumi.get(self, "is_auto_tune_enabled")

    @is_auto_tune_enabled.setter
    def is_auto_tune_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_auto_tune_enabled", value)

    @property
    @pulumi.getter(name="isReservationsEnabled")
    def is_reservations_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Reservations-enabled is a boolean field that allows to enable PR (Persistent Reservation) on a volume.
        """
        return pulumi.get(self, "is_reservations_enabled")

    @is_reservations_enabled.setter
    def is_reservations_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_reservations_enabled", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the Vault service key to assign as the master encryption key for the volume.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="sizeInGbs")
    def size_in_gbs(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The size of the volume in GBs.
        """
        return pulumi.get(self, "size_in_gbs")

    @size_in_gbs.setter
    def size_in_gbs(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "size_in_gbs", value)

    @property
    @pulumi.getter(name="sizeInMbs")
    @_utilities.deprecated("""The 'size_in_mbs' field has been deprecated. Please use 'size_in_gbs' instead.""")
    def size_in_mbs(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The size of the volume in MBs. The value must be a multiple of 1024. This field is deprecated. Use sizeInGBs instead.
        """
        return pulumi.get(self, "size_in_mbs")

    @size_in_mbs.setter
    def size_in_mbs(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "size_in_mbs", value)

    @property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> Optional[pulumi.Input['VolumeSourceDetailsArgs']]:
        """
        Specifies the volume source details for a new Block volume. The volume source is either another Block volume in the same Availability Domain or a Block volume backup. This is an optional field. If not specified or set to null, the new Block volume will be empty. When specified, the new Block volume will contain data from the source volume or backup.
        """
        return pulumi.get(self, "source_details")

    @source_details.setter
    def source_details(self, value: Optional[pulumi.Input['VolumeSourceDetailsArgs']]):
        pulumi.set(self, "source_details", value)

    @property
    @pulumi.getter(name="volumeBackupId")
    def volume_backup_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the volume backup from which the data should be restored on the newly created volume. This field is deprecated. Use the sourceDetails field instead to specify the backup for the volume.
        """
        return pulumi.get(self, "volume_backup_id")

    @volume_backup_id.setter
    def volume_backup_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "volume_backup_id", value)

    @property
    @pulumi.getter(name="vpusPerGb")
    def vpus_per_gb(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The number of volume performance units (VPUs) that will be applied to this volume per GB, representing the Block Volume service's elastic performance options. See [Block Volume Performance Levels](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/blockvolumeperformance.htm#perf_levels) for more information.

        Allowed values:
        """
        return pulumi.get(self, "vpus_per_gb")

    @vpus_per_gb.setter
    def vpus_per_gb(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpus_per_gb", value)

    @property
    @pulumi.getter(name="xrcKmsKeyId")
    def xrc_kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the Vault service key which is the master encryption key for the block volume cross region backups, which will be used in the destination region to encrypt the backup's encryption keys. For more information about the Vault service and encryption keys, see [Overview of Vault service](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm) and [Using Keys](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Tasks/usingkeys.htm). 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "xrc_kms_key_id")

    @xrc_kms_key_id.setter
    def xrc_kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "xrc_kms_key_id", value)


@pulumi.input_type
class _VolumeState:
    def __init__(__self__, *,
                 auto_tuned_vpus_per_gb: Optional[pulumi.Input[builtins.str]] = None,
                 autotune_policies: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeAutotunePolicyArgs']]]] = None,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 backup_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 block_volume_replicas: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeBlockVolumeReplicaArgs']]]] = None,
                 block_volume_replicas_deletion: Optional[pulumi.Input[builtins.bool]] = None,
                 cluster_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_auto_tune_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_hydrated: Optional[pulumi.Input[builtins.bool]] = None,
                 is_reservations_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 size_in_gbs: Optional[pulumi.Input[builtins.str]] = None,
                 size_in_mbs: Optional[pulumi.Input[builtins.str]] = None,
                 source_details: Optional[pulumi.Input['VolumeSourceDetailsArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 volume_backup_id: Optional[pulumi.Input[builtins.str]] = None,
                 volume_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpus_per_gb: Optional[pulumi.Input[builtins.str]] = None,
                 xrc_kms_key_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Volume resources.
        :param pulumi.Input[builtins.str] auto_tuned_vpus_per_gb: The number of Volume Performance Units per GB that this volume is effectively tuned to.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeAutotunePolicyArgs']]] autotune_policies: (Updatable) The list of autotune policies to be enabled for this volume.
        :param pulumi.Input[builtins.str] availability_domain: The availability domain of the volume. Omissible for cloning a volume. The new volume will be created in the availability domain of the source volume.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[builtins.str] backup_policy_id: If provided, specifies the ID of the volume backup policy to assign to the newly created volume. If omitted, no policy will be assigned. This field is deprecated. Use the `core_get_volume_backup_policy_assignments` instead to assign a backup policy to a volume.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeBlockVolumeReplicaArgs']]] block_volume_replicas: (Updatable) The list of block volume replicas to be enabled for this volume in the specified destination availability domains.
        :param pulumi.Input[builtins.str] cluster_placement_group_id: The clusterPlacementGroup Id of the volume for volume placement.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains the volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_auto_tune_enabled: (Updatable) Specifies whether the auto-tune performance is enabled for this volume. This field is deprecated. Use the `DetachedVolumeAutotunePolicy` instead to enable the volume for detached autotune.
        :param pulumi.Input[builtins.bool] is_hydrated: Specifies whether the cloned volume's data has finished copying from the source volume or backup.
        :param pulumi.Input[builtins.bool] is_reservations_enabled: (Updatable) Reservations-enabled is a boolean field that allows to enable PR (Persistent Reservation) on a volume.
        :param pulumi.Input[builtins.str] kms_key_id: (Updatable) The OCID of the Vault service key to assign as the master encryption key for the volume.
        :param pulumi.Input[builtins.str] size_in_gbs: (Updatable) The size of the volume in GBs.
        :param pulumi.Input[builtins.str] size_in_mbs: The size of the volume in MBs. The value must be a multiple of 1024. This field is deprecated. Use sizeInGBs instead.
        :param pulumi.Input['VolumeSourceDetailsArgs'] source_details: Specifies the volume source details for a new Block volume. The volume source is either another Block volume in the same Availability Domain or a Block volume backup. This is an optional field. If not specified or set to null, the new Block volume will be empty. When specified, the new Block volume will contain data from the source volume or backup.
        :param pulumi.Input[builtins.str] state: The current state of a volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] time_created: The date and time the volume was created. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[builtins.str] volume_backup_id: The OCID of the volume backup from which the data should be restored on the newly created volume. This field is deprecated. Use the sourceDetails field instead to specify the backup for the volume.
        :param pulumi.Input[builtins.str] volume_group_id: The OCID of the source volume group.
        :param pulumi.Input[builtins.str] vpus_per_gb: (Updatable) The number of volume performance units (VPUs) that will be applied to this volume per GB, representing the Block Volume service's elastic performance options. See [Block Volume Performance Levels](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/blockvolumeperformance.htm#perf_levels) for more information.
               
               Allowed values:
        :param pulumi.Input[builtins.str] xrc_kms_key_id: The OCID of the Vault service key which is the master encryption key for the block volume cross region backups, which will be used in the destination region to encrypt the backup's encryption keys. For more information about the Vault service and encryption keys, see [Overview of Vault service](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm) and [Using Keys](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Tasks/usingkeys.htm). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if auto_tuned_vpus_per_gb is not None:
            pulumi.set(__self__, "auto_tuned_vpus_per_gb", auto_tuned_vpus_per_gb)
        if autotune_policies is not None:
            pulumi.set(__self__, "autotune_policies", autotune_policies)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if backup_policy_id is not None:
            warnings.warn("""The 'backup_policy_id' field has been deprecated. Please use the 'oci_core_volume_backup_policy_assignment' resource instead.""", DeprecationWarning)
            pulumi.log.warn("""backup_policy_id is deprecated: The 'backup_policy_id' field has been deprecated. Please use the 'oci_core_volume_backup_policy_assignment' resource instead.""")
        if backup_policy_id is not None:
            pulumi.set(__self__, "backup_policy_id", backup_policy_id)
        if block_volume_replicas is not None:
            pulumi.set(__self__, "block_volume_replicas", block_volume_replicas)
        if block_volume_replicas_deletion is not None:
            pulumi.set(__self__, "block_volume_replicas_deletion", block_volume_replicas_deletion)
        if cluster_placement_group_id is not None:
            pulumi.set(__self__, "cluster_placement_group_id", cluster_placement_group_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_auto_tune_enabled is not None:
            pulumi.set(__self__, "is_auto_tune_enabled", is_auto_tune_enabled)
        if is_hydrated is not None:
            pulumi.set(__self__, "is_hydrated", is_hydrated)
        if is_reservations_enabled is not None:
            pulumi.set(__self__, "is_reservations_enabled", is_reservations_enabled)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if size_in_gbs is not None:
            pulumi.set(__self__, "size_in_gbs", size_in_gbs)
        if size_in_mbs is not None:
            warnings.warn("""The 'size_in_mbs' field has been deprecated. Please use 'size_in_gbs' instead.""", DeprecationWarning)
            pulumi.log.warn("""size_in_mbs is deprecated: The 'size_in_mbs' field has been deprecated. Please use 'size_in_gbs' instead.""")
        if size_in_mbs is not None:
            pulumi.set(__self__, "size_in_mbs", size_in_mbs)
        if source_details is not None:
            pulumi.set(__self__, "source_details", source_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if volume_backup_id is not None:
            pulumi.set(__self__, "volume_backup_id", volume_backup_id)
        if volume_group_id is not None:
            pulumi.set(__self__, "volume_group_id", volume_group_id)
        if vpus_per_gb is not None:
            pulumi.set(__self__, "vpus_per_gb", vpus_per_gb)
        if xrc_kms_key_id is not None:
            pulumi.set(__self__, "xrc_kms_key_id", xrc_kms_key_id)

    @property
    @pulumi.getter(name="autoTunedVpusPerGb")
    def auto_tuned_vpus_per_gb(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The number of Volume Performance Units per GB that this volume is effectively tuned to.
        """
        return pulumi.get(self, "auto_tuned_vpus_per_gb")

    @auto_tuned_vpus_per_gb.setter
    def auto_tuned_vpus_per_gb(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "auto_tuned_vpus_per_gb", value)

    @property
    @pulumi.getter(name="autotunePolicies")
    def autotune_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeAutotunePolicyArgs']]]]:
        """
        (Updatable) The list of autotune policies to be enabled for this volume.
        """
        return pulumi.get(self, "autotune_policies")

    @autotune_policies.setter
    def autotune_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeAutotunePolicyArgs']]]]):
        pulumi.set(self, "autotune_policies", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The availability domain of the volume. Omissible for cloning a volume. The new volume will be created in the availability domain of the source volume.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="backupPolicyId")
    @_utilities.deprecated("""The 'backup_policy_id' field has been deprecated. Please use the 'oci_core_volume_backup_policy_assignment' resource instead.""")
    def backup_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If provided, specifies the ID of the volume backup policy to assign to the newly created volume. If omitted, no policy will be assigned. This field is deprecated. Use the `core_get_volume_backup_policy_assignments` instead to assign a backup policy to a volume.
        """
        return pulumi.get(self, "backup_policy_id")

    @backup_policy_id.setter
    def backup_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backup_policy_id", value)

    @property
    @pulumi.getter(name="blockVolumeReplicas")
    def block_volume_replicas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeBlockVolumeReplicaArgs']]]]:
        """
        (Updatable) The list of block volume replicas to be enabled for this volume in the specified destination availability domains.
        """
        return pulumi.get(self, "block_volume_replicas")

    @block_volume_replicas.setter
    def block_volume_replicas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeBlockVolumeReplicaArgs']]]]):
        pulumi.set(self, "block_volume_replicas", value)

    @property
    @pulumi.getter(name="blockVolumeReplicasDeletion")
    def block_volume_replicas_deletion(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "block_volume_replicas_deletion")

    @block_volume_replicas_deletion.setter
    def block_volume_replicas_deletion(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "block_volume_replicas_deletion", value)

    @property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The clusterPlacementGroup Id of the volume for volume placement.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @cluster_placement_group_id.setter
    def cluster_placement_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_placement_group_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the compartment that contains the volume.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isAutoTuneEnabled")
    def is_auto_tune_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Specifies whether the auto-tune performance is enabled for this volume. This field is deprecated. Use the `DetachedVolumeAutotunePolicy` instead to enable the volume for detached autotune.
        """
        return pulumi.get(self, "is_auto_tune_enabled")

    @is_auto_tune_enabled.setter
    def is_auto_tune_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_auto_tune_enabled", value)

    @property
    @pulumi.getter(name="isHydrated")
    def is_hydrated(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the cloned volume's data has finished copying from the source volume or backup.
        """
        return pulumi.get(self, "is_hydrated")

    @is_hydrated.setter
    def is_hydrated(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_hydrated", value)

    @property
    @pulumi.getter(name="isReservationsEnabled")
    def is_reservations_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Reservations-enabled is a boolean field that allows to enable PR (Persistent Reservation) on a volume.
        """
        return pulumi.get(self, "is_reservations_enabled")

    @is_reservations_enabled.setter
    def is_reservations_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_reservations_enabled", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the Vault service key to assign as the master encryption key for the volume.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="sizeInGbs")
    def size_in_gbs(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The size of the volume in GBs.
        """
        return pulumi.get(self, "size_in_gbs")

    @size_in_gbs.setter
    def size_in_gbs(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "size_in_gbs", value)

    @property
    @pulumi.getter(name="sizeInMbs")
    @_utilities.deprecated("""The 'size_in_mbs' field has been deprecated. Please use 'size_in_gbs' instead.""")
    def size_in_mbs(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The size of the volume in MBs. The value must be a multiple of 1024. This field is deprecated. Use sizeInGBs instead.
        """
        return pulumi.get(self, "size_in_mbs")

    @size_in_mbs.setter
    def size_in_mbs(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "size_in_mbs", value)

    @property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> Optional[pulumi.Input['VolumeSourceDetailsArgs']]:
        """
        Specifies the volume source details for a new Block volume. The volume source is either another Block volume in the same Availability Domain or a Block volume backup. This is an optional field. If not specified or set to null, the new Block volume will be empty. When specified, the new Block volume will contain data from the source volume or backup.
        """
        return pulumi.get(self, "source_details")

    @source_details.setter
    def source_details(self, value: Optional[pulumi.Input['VolumeSourceDetailsArgs']]):
        pulumi.set(self, "source_details", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of a volume.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the volume was created. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="volumeBackupId")
    def volume_backup_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the volume backup from which the data should be restored on the newly created volume. This field is deprecated. Use the sourceDetails field instead to specify the backup for the volume.
        """
        return pulumi.get(self, "volume_backup_id")

    @volume_backup_id.setter
    def volume_backup_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "volume_backup_id", value)

    @property
    @pulumi.getter(name="volumeGroupId")
    def volume_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the source volume group.
        """
        return pulumi.get(self, "volume_group_id")

    @volume_group_id.setter
    def volume_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "volume_group_id", value)

    @property
    @pulumi.getter(name="vpusPerGb")
    def vpus_per_gb(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The number of volume performance units (VPUs) that will be applied to this volume per GB, representing the Block Volume service's elastic performance options. See [Block Volume Performance Levels](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/blockvolumeperformance.htm#perf_levels) for more information.

        Allowed values:
        """
        return pulumi.get(self, "vpus_per_gb")

    @vpus_per_gb.setter
    def vpus_per_gb(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpus_per_gb", value)

    @property
    @pulumi.getter(name="xrcKmsKeyId")
    def xrc_kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the Vault service key which is the master encryption key for the block volume cross region backups, which will be used in the destination region to encrypt the backup's encryption keys. For more information about the Vault service and encryption keys, see [Overview of Vault service](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm) and [Using Keys](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Tasks/usingkeys.htm). 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "xrc_kms_key_id")

    @xrc_kms_key_id.setter
    def xrc_kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "xrc_kms_key_id", value)


@pulumi.type_token("oci:Core/volume:Volume")
class Volume(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autotune_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeAutotunePolicyArgs', 'VolumeAutotunePolicyArgsDict']]]]] = None,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 backup_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 block_volume_replicas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeBlockVolumeReplicaArgs', 'VolumeBlockVolumeReplicaArgsDict']]]]] = None,
                 block_volume_replicas_deletion: Optional[pulumi.Input[builtins.bool]] = None,
                 cluster_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_auto_tune_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_reservations_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 size_in_gbs: Optional[pulumi.Input[builtins.str]] = None,
                 size_in_mbs: Optional[pulumi.Input[builtins.str]] = None,
                 source_details: Optional[pulumi.Input[Union['VolumeSourceDetailsArgs', 'VolumeSourceDetailsArgsDict']]] = None,
                 volume_backup_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpus_per_gb: Optional[pulumi.Input[builtins.str]] = None,
                 xrc_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Volume resource in Oracle Cloud Infrastructure Core service.

        Creates a new volume in the specified compartment. Volumes can be created in sizes ranging from
        50 GB (51200 MB) to 32 TB (33554432 MB), in 1 GB (1024 MB) increments. By default, volumes are 1 TB (1048576 MB).
        For general information about block volumes, see
        [Overview of Block Volume Service](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/overview.htm).

        A volume and instance can be in separate compartments but must be in the same availability domain.
        For information about access control and compartments, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm). For information about
        availability domains, see [Regions and Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm).
        To get a list of availability domains, use the `ListAvailabilityDomains` operation
        in the Identity and Access Management Service API.

        You may optionally specify a *display name* for the volume, which is simply a friendly name or
        description. It does not have to be unique, and you can change it. Avoid entering confidential information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_volume = oci.core.Volume("test_volume",
            compartment_id=compartment_id,
            autotune_policies=[{
                "autotune_type": volume_autotune_policies_autotune_type,
                "max_vpus_per_gb": volume_autotune_policies_max_vpus_per_gb,
            }],
            availability_domain=volume_availability_domain,
            backup_policy_id=test_volume_backup_policies["volumeBackupPolicies"][0]["id"],
            block_volume_replicas=[{
                "availability_domain": volume_block_volume_replicas_availability_domain,
                "display_name": volume_block_volume_replicas_display_name,
                "xrr_kms_key_id": test_key["id"],
            }],
            cluster_placement_group_id=test_group["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=volume_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            is_auto_tune_enabled=volume_is_auto_tune_enabled,
            is_reservations_enabled=volume_is_reservations_enabled,
            kms_key_id=test_key["id"],
            size_in_gbs=volume_size_in_gbs,
            size_in_mbs=volume_size_in_mbs,
            source_details={
                "type": volume_source_details_type,
                "change_block_size_in_bytes": volume_source_details_change_block_size_in_bytes,
                "first_backup_id": test_backup["id"],
                "id": volume_source_details_id,
                "second_backup_id": test_backup["id"],
            },
            vpus_per_gb=volume_vpus_per_gb,
            xrc_kms_key_id=test_key["id"],
            block_volume_replicas_deletion=True)
        ```

        ## Import

        Volumes can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/volume:Volume test_volume "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeAutotunePolicyArgs', 'VolumeAutotunePolicyArgsDict']]]] autotune_policies: (Updatable) The list of autotune policies to be enabled for this volume.
        :param pulumi.Input[builtins.str] availability_domain: The availability domain of the volume. Omissible for cloning a volume. The new volume will be created in the availability domain of the source volume.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[builtins.str] backup_policy_id: If provided, specifies the ID of the volume backup policy to assign to the newly created volume. If omitted, no policy will be assigned. This field is deprecated. Use the `core_get_volume_backup_policy_assignments` instead to assign a backup policy to a volume.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeBlockVolumeReplicaArgs', 'VolumeBlockVolumeReplicaArgsDict']]]] block_volume_replicas: (Updatable) The list of block volume replicas to be enabled for this volume in the specified destination availability domains.
        :param pulumi.Input[builtins.str] cluster_placement_group_id: The clusterPlacementGroup Id of the volume for volume placement.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains the volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_auto_tune_enabled: (Updatable) Specifies whether the auto-tune performance is enabled for this volume. This field is deprecated. Use the `DetachedVolumeAutotunePolicy` instead to enable the volume for detached autotune.
        :param pulumi.Input[builtins.bool] is_reservations_enabled: (Updatable) Reservations-enabled is a boolean field that allows to enable PR (Persistent Reservation) on a volume.
        :param pulumi.Input[builtins.str] kms_key_id: (Updatable) The OCID of the Vault service key to assign as the master encryption key for the volume.
        :param pulumi.Input[builtins.str] size_in_gbs: (Updatable) The size of the volume in GBs.
        :param pulumi.Input[builtins.str] size_in_mbs: The size of the volume in MBs. The value must be a multiple of 1024. This field is deprecated. Use sizeInGBs instead.
        :param pulumi.Input[Union['VolumeSourceDetailsArgs', 'VolumeSourceDetailsArgsDict']] source_details: Specifies the volume source details for a new Block volume. The volume source is either another Block volume in the same Availability Domain or a Block volume backup. This is an optional field. If not specified or set to null, the new Block volume will be empty. When specified, the new Block volume will contain data from the source volume or backup.
        :param pulumi.Input[builtins.str] volume_backup_id: The OCID of the volume backup from which the data should be restored on the newly created volume. This field is deprecated. Use the sourceDetails field instead to specify the backup for the volume.
        :param pulumi.Input[builtins.str] vpus_per_gb: (Updatable) The number of volume performance units (VPUs) that will be applied to this volume per GB, representing the Block Volume service's elastic performance options. See [Block Volume Performance Levels](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/blockvolumeperformance.htm#perf_levels) for more information.
               
               Allowed values:
        :param pulumi.Input[builtins.str] xrc_kms_key_id: The OCID of the Vault service key which is the master encryption key for the block volume cross region backups, which will be used in the destination region to encrypt the backup's encryption keys. For more information about the Vault service and encryption keys, see [Overview of Vault service](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm) and [Using Keys](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Tasks/usingkeys.htm). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Volume resource in Oracle Cloud Infrastructure Core service.

        Creates a new volume in the specified compartment. Volumes can be created in sizes ranging from
        50 GB (51200 MB) to 32 TB (33554432 MB), in 1 GB (1024 MB) increments. By default, volumes are 1 TB (1048576 MB).
        For general information about block volumes, see
        [Overview of Block Volume Service](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/overview.htm).

        A volume and instance can be in separate compartments but must be in the same availability domain.
        For information about access control and compartments, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm). For information about
        availability domains, see [Regions and Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm).
        To get a list of availability domains, use the `ListAvailabilityDomains` operation
        in the Identity and Access Management Service API.

        You may optionally specify a *display name* for the volume, which is simply a friendly name or
        description. It does not have to be unique, and you can change it. Avoid entering confidential information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_volume = oci.core.Volume("test_volume",
            compartment_id=compartment_id,
            autotune_policies=[{
                "autotune_type": volume_autotune_policies_autotune_type,
                "max_vpus_per_gb": volume_autotune_policies_max_vpus_per_gb,
            }],
            availability_domain=volume_availability_domain,
            backup_policy_id=test_volume_backup_policies["volumeBackupPolicies"][0]["id"],
            block_volume_replicas=[{
                "availability_domain": volume_block_volume_replicas_availability_domain,
                "display_name": volume_block_volume_replicas_display_name,
                "xrr_kms_key_id": test_key["id"],
            }],
            cluster_placement_group_id=test_group["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=volume_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            is_auto_tune_enabled=volume_is_auto_tune_enabled,
            is_reservations_enabled=volume_is_reservations_enabled,
            kms_key_id=test_key["id"],
            size_in_gbs=volume_size_in_gbs,
            size_in_mbs=volume_size_in_mbs,
            source_details={
                "type": volume_source_details_type,
                "change_block_size_in_bytes": volume_source_details_change_block_size_in_bytes,
                "first_backup_id": test_backup["id"],
                "id": volume_source_details_id,
                "second_backup_id": test_backup["id"],
            },
            vpus_per_gb=volume_vpus_per_gb,
            xrc_kms_key_id=test_key["id"],
            block_volume_replicas_deletion=True)
        ```

        ## Import

        Volumes can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/volume:Volume test_volume "id"
        ```

        :param str resource_name: The name of the resource.
        :param VolumeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autotune_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeAutotunePolicyArgs', 'VolumeAutotunePolicyArgsDict']]]]] = None,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 backup_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 block_volume_replicas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeBlockVolumeReplicaArgs', 'VolumeBlockVolumeReplicaArgsDict']]]]] = None,
                 block_volume_replicas_deletion: Optional[pulumi.Input[builtins.bool]] = None,
                 cluster_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_auto_tune_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_reservations_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 size_in_gbs: Optional[pulumi.Input[builtins.str]] = None,
                 size_in_mbs: Optional[pulumi.Input[builtins.str]] = None,
                 source_details: Optional[pulumi.Input[Union['VolumeSourceDetailsArgs', 'VolumeSourceDetailsArgsDict']]] = None,
                 volume_backup_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpus_per_gb: Optional[pulumi.Input[builtins.str]] = None,
                 xrc_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeArgs.__new__(VolumeArgs)

            __props__.__dict__["autotune_policies"] = autotune_policies
            if availability_domain is None and not opts.urn:
                raise TypeError("Missing required property 'availability_domain'")
            __props__.__dict__["availability_domain"] = availability_domain
            __props__.__dict__["backup_policy_id"] = backup_policy_id
            __props__.__dict__["block_volume_replicas"] = block_volume_replicas
            __props__.__dict__["block_volume_replicas_deletion"] = block_volume_replicas_deletion
            __props__.__dict__["cluster_placement_group_id"] = cluster_placement_group_id
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_auto_tune_enabled"] = is_auto_tune_enabled
            __props__.__dict__["is_reservations_enabled"] = is_reservations_enabled
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["size_in_gbs"] = size_in_gbs
            __props__.__dict__["size_in_mbs"] = size_in_mbs
            __props__.__dict__["source_details"] = source_details
            __props__.__dict__["volume_backup_id"] = volume_backup_id
            __props__.__dict__["vpus_per_gb"] = vpus_per_gb
            __props__.__dict__["xrc_kms_key_id"] = xrc_kms_key_id
            __props__.__dict__["auto_tuned_vpus_per_gb"] = None
            __props__.__dict__["is_hydrated"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["volume_group_id"] = None
        super(Volume, __self__).__init__(
            'oci:Core/volume:Volume',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_tuned_vpus_per_gb: Optional[pulumi.Input[builtins.str]] = None,
            autotune_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeAutotunePolicyArgs', 'VolumeAutotunePolicyArgsDict']]]]] = None,
            availability_domain: Optional[pulumi.Input[builtins.str]] = None,
            backup_policy_id: Optional[pulumi.Input[builtins.str]] = None,
            block_volume_replicas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeBlockVolumeReplicaArgs', 'VolumeBlockVolumeReplicaArgsDict']]]]] = None,
            block_volume_replicas_deletion: Optional[pulumi.Input[builtins.bool]] = None,
            cluster_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            is_auto_tune_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            is_hydrated: Optional[pulumi.Input[builtins.bool]] = None,
            is_reservations_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
            size_in_gbs: Optional[pulumi.Input[builtins.str]] = None,
            size_in_mbs: Optional[pulumi.Input[builtins.str]] = None,
            source_details: Optional[pulumi.Input[Union['VolumeSourceDetailsArgs', 'VolumeSourceDetailsArgsDict']]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            volume_backup_id: Optional[pulumi.Input[builtins.str]] = None,
            volume_group_id: Optional[pulumi.Input[builtins.str]] = None,
            vpus_per_gb: Optional[pulumi.Input[builtins.str]] = None,
            xrc_kms_key_id: Optional[pulumi.Input[builtins.str]] = None) -> 'Volume':
        """
        Get an existing Volume resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] auto_tuned_vpus_per_gb: The number of Volume Performance Units per GB that this volume is effectively tuned to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeAutotunePolicyArgs', 'VolumeAutotunePolicyArgsDict']]]] autotune_policies: (Updatable) The list of autotune policies to be enabled for this volume.
        :param pulumi.Input[builtins.str] availability_domain: The availability domain of the volume. Omissible for cloning a volume. The new volume will be created in the availability domain of the source volume.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[builtins.str] backup_policy_id: If provided, specifies the ID of the volume backup policy to assign to the newly created volume. If omitted, no policy will be assigned. This field is deprecated. Use the `core_get_volume_backup_policy_assignments` instead to assign a backup policy to a volume.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeBlockVolumeReplicaArgs', 'VolumeBlockVolumeReplicaArgsDict']]]] block_volume_replicas: (Updatable) The list of block volume replicas to be enabled for this volume in the specified destination availability domains.
        :param pulumi.Input[builtins.str] cluster_placement_group_id: The clusterPlacementGroup Id of the volume for volume placement.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains the volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_auto_tune_enabled: (Updatable) Specifies whether the auto-tune performance is enabled for this volume. This field is deprecated. Use the `DetachedVolumeAutotunePolicy` instead to enable the volume for detached autotune.
        :param pulumi.Input[builtins.bool] is_hydrated: Specifies whether the cloned volume's data has finished copying from the source volume or backup.
        :param pulumi.Input[builtins.bool] is_reservations_enabled: (Updatable) Reservations-enabled is a boolean field that allows to enable PR (Persistent Reservation) on a volume.
        :param pulumi.Input[builtins.str] kms_key_id: (Updatable) The OCID of the Vault service key to assign as the master encryption key for the volume.
        :param pulumi.Input[builtins.str] size_in_gbs: (Updatable) The size of the volume in GBs.
        :param pulumi.Input[builtins.str] size_in_mbs: The size of the volume in MBs. The value must be a multiple of 1024. This field is deprecated. Use sizeInGBs instead.
        :param pulumi.Input[Union['VolumeSourceDetailsArgs', 'VolumeSourceDetailsArgsDict']] source_details: Specifies the volume source details for a new Block volume. The volume source is either another Block volume in the same Availability Domain or a Block volume backup. This is an optional field. If not specified or set to null, the new Block volume will be empty. When specified, the new Block volume will contain data from the source volume or backup.
        :param pulumi.Input[builtins.str] state: The current state of a volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] time_created: The date and time the volume was created. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[builtins.str] volume_backup_id: The OCID of the volume backup from which the data should be restored on the newly created volume. This field is deprecated. Use the sourceDetails field instead to specify the backup for the volume.
        :param pulumi.Input[builtins.str] volume_group_id: The OCID of the source volume group.
        :param pulumi.Input[builtins.str] vpus_per_gb: (Updatable) The number of volume performance units (VPUs) that will be applied to this volume per GB, representing the Block Volume service's elastic performance options. See [Block Volume Performance Levels](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/blockvolumeperformance.htm#perf_levels) for more information.
               
               Allowed values:
        :param pulumi.Input[builtins.str] xrc_kms_key_id: The OCID of the Vault service key which is the master encryption key for the block volume cross region backups, which will be used in the destination region to encrypt the backup's encryption keys. For more information about the Vault service and encryption keys, see [Overview of Vault service](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm) and [Using Keys](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Tasks/usingkeys.htm). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeState.__new__(_VolumeState)

        __props__.__dict__["auto_tuned_vpus_per_gb"] = auto_tuned_vpus_per_gb
        __props__.__dict__["autotune_policies"] = autotune_policies
        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["backup_policy_id"] = backup_policy_id
        __props__.__dict__["block_volume_replicas"] = block_volume_replicas
        __props__.__dict__["block_volume_replicas_deletion"] = block_volume_replicas_deletion
        __props__.__dict__["cluster_placement_group_id"] = cluster_placement_group_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_auto_tune_enabled"] = is_auto_tune_enabled
        __props__.__dict__["is_hydrated"] = is_hydrated
        __props__.__dict__["is_reservations_enabled"] = is_reservations_enabled
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["size_in_gbs"] = size_in_gbs
        __props__.__dict__["size_in_mbs"] = size_in_mbs
        __props__.__dict__["source_details"] = source_details
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["volume_backup_id"] = volume_backup_id
        __props__.__dict__["volume_group_id"] = volume_group_id
        __props__.__dict__["vpus_per_gb"] = vpus_per_gb
        __props__.__dict__["xrc_kms_key_id"] = xrc_kms_key_id
        return Volume(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoTunedVpusPerGb")
    def auto_tuned_vpus_per_gb(self) -> pulumi.Output[builtins.str]:
        """
        The number of Volume Performance Units per GB that this volume is effectively tuned to.
        """
        return pulumi.get(self, "auto_tuned_vpus_per_gb")

    @property
    @pulumi.getter(name="autotunePolicies")
    def autotune_policies(self) -> pulumi.Output[Sequence['outputs.VolumeAutotunePolicy']]:
        """
        (Updatable) The list of autotune policies to be enabled for this volume.
        """
        return pulumi.get(self, "autotune_policies")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[builtins.str]:
        """
        The availability domain of the volume. Omissible for cloning a volume. The new volume will be created in the availability domain of the source volume.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="backupPolicyId")
    @_utilities.deprecated("""The 'backup_policy_id' field has been deprecated. Please use the 'oci_core_volume_backup_policy_assignment' resource instead.""")
    def backup_policy_id(self) -> pulumi.Output[builtins.str]:
        """
        If provided, specifies the ID of the volume backup policy to assign to the newly created volume. If omitted, no policy will be assigned. This field is deprecated. Use the `core_get_volume_backup_policy_assignments` instead to assign a backup policy to a volume.
        """
        return pulumi.get(self, "backup_policy_id")

    @property
    @pulumi.getter(name="blockVolumeReplicas")
    def block_volume_replicas(self) -> pulumi.Output[Sequence['outputs.VolumeBlockVolumeReplica']]:
        """
        (Updatable) The list of block volume replicas to be enabled for this volume in the specified destination availability domains.
        """
        return pulumi.get(self, "block_volume_replicas")

    @property
    @pulumi.getter(name="blockVolumeReplicasDeletion")
    def block_volume_replicas_deletion(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "block_volume_replicas_deletion")

    @property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> pulumi.Output[builtins.str]:
        """
        The clusterPlacementGroup Id of the volume for volume placement.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the compartment that contains the volume.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isAutoTuneEnabled")
    def is_auto_tune_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Specifies whether the auto-tune performance is enabled for this volume. This field is deprecated. Use the `DetachedVolumeAutotunePolicy` instead to enable the volume for detached autotune.
        """
        return pulumi.get(self, "is_auto_tune_enabled")

    @property
    @pulumi.getter(name="isHydrated")
    def is_hydrated(self) -> pulumi.Output[builtins.bool]:
        """
        Specifies whether the cloned volume's data has finished copying from the source volume or backup.
        """
        return pulumi.get(self, "is_hydrated")

    @property
    @pulumi.getter(name="isReservationsEnabled")
    def is_reservations_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Reservations-enabled is a boolean field that allows to enable PR (Persistent Reservation) on a volume.
        """
        return pulumi.get(self, "is_reservations_enabled")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the Vault service key to assign as the master encryption key for the volume.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="sizeInGbs")
    def size_in_gbs(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The size of the volume in GBs.
        """
        return pulumi.get(self, "size_in_gbs")

    @property
    @pulumi.getter(name="sizeInMbs")
    @_utilities.deprecated("""The 'size_in_mbs' field has been deprecated. Please use 'size_in_gbs' instead.""")
    def size_in_mbs(self) -> pulumi.Output[builtins.str]:
        """
        The size of the volume in MBs. The value must be a multiple of 1024. This field is deprecated. Use sizeInGBs instead.
        """
        return pulumi.get(self, "size_in_mbs")

    @property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> pulumi.Output['outputs.VolumeSourceDetails']:
        """
        Specifies the volume source details for a new Block volume. The volume source is either another Block volume in the same Availability Domain or a Block volume backup. This is an optional field. If not specified or set to null, the new Block volume will be empty. When specified, the new Block volume will contain data from the source volume or backup.
        """
        return pulumi.get(self, "source_details")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of a volume.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the volume was created. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="volumeBackupId")
    def volume_backup_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the volume backup from which the data should be restored on the newly created volume. This field is deprecated. Use the sourceDetails field instead to specify the backup for the volume.
        """
        return pulumi.get(self, "volume_backup_id")

    @property
    @pulumi.getter(name="volumeGroupId")
    def volume_group_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the source volume group.
        """
        return pulumi.get(self, "volume_group_id")

    @property
    @pulumi.getter(name="vpusPerGb")
    def vpus_per_gb(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The number of volume performance units (VPUs) that will be applied to this volume per GB, representing the Block Volume service's elastic performance options. See [Block Volume Performance Levels](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/blockvolumeperformance.htm#perf_levels) for more information.

        Allowed values:
        """
        return pulumi.get(self, "vpus_per_gb")

    @property
    @pulumi.getter(name="xrcKmsKeyId")
    def xrc_kms_key_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the Vault service key which is the master encryption key for the block volume cross region backups, which will be used in the destination region to encrypt the backup's encryption keys. For more information about the Vault service and encryption keys, see [Overview of Vault service](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm) and [Using Keys](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Tasks/usingkeys.htm). 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "xrc_kms_key_id")

