# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AutonomousContainerDatabaseDataguardAssociationArgs', 'AutonomousContainerDatabaseDataguardAssociation']

@pulumi.input_type
class AutonomousContainerDatabaseDataguardAssociationArgs:
    def __init__(__self__, *,
                 autonomous_container_database_id: pulumi.Input[builtins.str],
                 peer_autonomous_container_database_display_name: pulumi.Input[builtins.str],
                 protection_mode: pulumi.Input[builtins.str],
                 autonomous_container_database_dataguard_association_id: Optional[pulumi.Input[builtins.str]] = None,
                 fast_start_fail_over_lag_limit_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 is_automatic_failover_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 migrate_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 peer_autonomous_container_database_backup_config: Optional[pulumi.Input['AutonomousContainerDatabaseDataguardAssociationPeerAutonomousContainerDatabaseBackupConfigArgs']] = None,
                 peer_autonomous_container_database_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_cloud_autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_db_unique_name: Optional[pulumi.Input[builtins.str]] = None,
                 standby_maintenance_buffer_in_days: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a AutonomousContainerDatabaseDataguardAssociation resource.
        :param pulumi.Input[builtins.str] autonomous_container_database_id: The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.str] peer_autonomous_container_database_display_name: The display name for the peer Autonomous Container Database.
        :param pulumi.Input[builtins.str] protection_mode: (Updatable) The protection mode of this Autonomous Data Guard association. For more information, see [Oracle Data Guard Protection Modes](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000) in the Oracle Data Guard documentation.
        :param pulumi.Input[builtins.int] fast_start_fail_over_lag_limit_in_seconds: (Updatable) The lag time for my preference based on data loss tolerance in seconds.
        :param pulumi.Input[builtins.bool] is_automatic_failover_enabled: (Updatable) Indicates whether Automatic Failover is enabled for Autonomous Container Database Dataguard Association. Input DataType: boolean. Example : `is_automatic_failover_enabled = true`.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.int] migrate_trigger: (Updatable) An optional property when incremented triggers Migrate. Could be set to any integer value.
        :param pulumi.Input['AutonomousContainerDatabaseDataguardAssociationPeerAutonomousContainerDatabaseBackupConfigArgs'] peer_autonomous_container_database_backup_config: Backup options for the standby Autonomous Container Database.
        :param pulumi.Input[builtins.str] peer_autonomous_container_database_compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where the standby Autonomous Container Database will be created.
        :param pulumi.Input[builtins.str] peer_autonomous_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer Autonomous Exadata VM Cluster.
        :param pulumi.Input[builtins.str] peer_cloud_autonomous_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer cloud Autonomous Exadata VM Cluster.
        :param pulumi.Input[builtins.str] peer_db_unique_name: Specifies the `DB_UNIQUE_NAME` of the peer database to be created.
        :param pulumi.Input[builtins.int] standby_maintenance_buffer_in_days: The scheduling detail for the quarterly maintenance window of the standby Autonomous Container Database. This value represents the number of days before scheduled maintenance of the primary database.
        """
        pulumi.set(__self__, "autonomous_container_database_id", autonomous_container_database_id)
        pulumi.set(__self__, "peer_autonomous_container_database_display_name", peer_autonomous_container_database_display_name)
        pulumi.set(__self__, "protection_mode", protection_mode)
        if autonomous_container_database_dataguard_association_id is not None:
            pulumi.set(__self__, "autonomous_container_database_dataguard_association_id", autonomous_container_database_dataguard_association_id)
        if fast_start_fail_over_lag_limit_in_seconds is not None:
            pulumi.set(__self__, "fast_start_fail_over_lag_limit_in_seconds", fast_start_fail_over_lag_limit_in_seconds)
        if is_automatic_failover_enabled is not None:
            pulumi.set(__self__, "is_automatic_failover_enabled", is_automatic_failover_enabled)
        if migrate_trigger is not None:
            pulumi.set(__self__, "migrate_trigger", migrate_trigger)
        if peer_autonomous_container_database_backup_config is not None:
            pulumi.set(__self__, "peer_autonomous_container_database_backup_config", peer_autonomous_container_database_backup_config)
        if peer_autonomous_container_database_compartment_id is not None:
            pulumi.set(__self__, "peer_autonomous_container_database_compartment_id", peer_autonomous_container_database_compartment_id)
        if peer_autonomous_vm_cluster_id is not None:
            pulumi.set(__self__, "peer_autonomous_vm_cluster_id", peer_autonomous_vm_cluster_id)
        if peer_cloud_autonomous_vm_cluster_id is not None:
            pulumi.set(__self__, "peer_cloud_autonomous_vm_cluster_id", peer_cloud_autonomous_vm_cluster_id)
        if peer_db_unique_name is not None:
            pulumi.set(__self__, "peer_db_unique_name", peer_db_unique_name)
        if standby_maintenance_buffer_in_days is not None:
            pulumi.set(__self__, "standby_maintenance_buffer_in_days", standby_maintenance_buffer_in_days)

    @property
    @pulumi.getter(name="autonomousContainerDatabaseId")
    def autonomous_container_database_id(self) -> pulumi.Input[builtins.str]:
        """
        The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "autonomous_container_database_id")

    @autonomous_container_database_id.setter
    def autonomous_container_database_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "autonomous_container_database_id", value)

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseDisplayName")
    def peer_autonomous_container_database_display_name(self) -> pulumi.Input[builtins.str]:
        """
        The display name for the peer Autonomous Container Database.
        """
        return pulumi.get(self, "peer_autonomous_container_database_display_name")

    @peer_autonomous_container_database_display_name.setter
    def peer_autonomous_container_database_display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "peer_autonomous_container_database_display_name", value)

    @property
    @pulumi.getter(name="protectionMode")
    def protection_mode(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The protection mode of this Autonomous Data Guard association. For more information, see [Oracle Data Guard Protection Modes](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000) in the Oracle Data Guard documentation.
        """
        return pulumi.get(self, "protection_mode")

    @protection_mode.setter
    def protection_mode(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "protection_mode", value)

    @property
    @pulumi.getter(name="autonomousContainerDatabaseDataguardAssociationId")
    def autonomous_container_database_dataguard_association_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "autonomous_container_database_dataguard_association_id")

    @autonomous_container_database_dataguard_association_id.setter
    def autonomous_container_database_dataguard_association_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "autonomous_container_database_dataguard_association_id", value)

    @property
    @pulumi.getter(name="fastStartFailOverLagLimitInSeconds")
    def fast_start_fail_over_lag_limit_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The lag time for my preference based on data loss tolerance in seconds.
        """
        return pulumi.get(self, "fast_start_fail_over_lag_limit_in_seconds")

    @fast_start_fail_over_lag_limit_in_seconds.setter
    def fast_start_fail_over_lag_limit_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "fast_start_fail_over_lag_limit_in_seconds", value)

    @property
    @pulumi.getter(name="isAutomaticFailoverEnabled")
    def is_automatic_failover_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Indicates whether Automatic Failover is enabled for Autonomous Container Database Dataguard Association. Input DataType: boolean. Example : `is_automatic_failover_enabled = true`.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "is_automatic_failover_enabled")

    @is_automatic_failover_enabled.setter
    def is_automatic_failover_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_automatic_failover_enabled", value)

    @property
    @pulumi.getter(name="migrateTrigger")
    def migrate_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Migrate. Could be set to any integer value.
        """
        return pulumi.get(self, "migrate_trigger")

    @migrate_trigger.setter
    def migrate_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "migrate_trigger", value)

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseBackupConfig")
    def peer_autonomous_container_database_backup_config(self) -> Optional[pulumi.Input['AutonomousContainerDatabaseDataguardAssociationPeerAutonomousContainerDatabaseBackupConfigArgs']]:
        """
        Backup options for the standby Autonomous Container Database.
        """
        return pulumi.get(self, "peer_autonomous_container_database_backup_config")

    @peer_autonomous_container_database_backup_config.setter
    def peer_autonomous_container_database_backup_config(self, value: Optional[pulumi.Input['AutonomousContainerDatabaseDataguardAssociationPeerAutonomousContainerDatabaseBackupConfigArgs']]):
        pulumi.set(self, "peer_autonomous_container_database_backup_config", value)

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseCompartmentId")
    def peer_autonomous_container_database_compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where the standby Autonomous Container Database will be created.
        """
        return pulumi.get(self, "peer_autonomous_container_database_compartment_id")

    @peer_autonomous_container_database_compartment_id.setter
    def peer_autonomous_container_database_compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_autonomous_container_database_compartment_id", value)

    @property
    @pulumi.getter(name="peerAutonomousVmClusterId")
    def peer_autonomous_vm_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer Autonomous Exadata VM Cluster.
        """
        return pulumi.get(self, "peer_autonomous_vm_cluster_id")

    @peer_autonomous_vm_cluster_id.setter
    def peer_autonomous_vm_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_autonomous_vm_cluster_id", value)

    @property
    @pulumi.getter(name="peerCloudAutonomousVmClusterId")
    def peer_cloud_autonomous_vm_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer cloud Autonomous Exadata VM Cluster.
        """
        return pulumi.get(self, "peer_cloud_autonomous_vm_cluster_id")

    @peer_cloud_autonomous_vm_cluster_id.setter
    def peer_cloud_autonomous_vm_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_cloud_autonomous_vm_cluster_id", value)

    @property
    @pulumi.getter(name="peerDbUniqueName")
    def peer_db_unique_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the `DB_UNIQUE_NAME` of the peer database to be created.
        """
        return pulumi.get(self, "peer_db_unique_name")

    @peer_db_unique_name.setter
    def peer_db_unique_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_db_unique_name", value)

    @property
    @pulumi.getter(name="standbyMaintenanceBufferInDays")
    def standby_maintenance_buffer_in_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The scheduling detail for the quarterly maintenance window of the standby Autonomous Container Database. This value represents the number of days before scheduled maintenance of the primary database.
        """
        return pulumi.get(self, "standby_maintenance_buffer_in_days")

    @standby_maintenance_buffer_in_days.setter
    def standby_maintenance_buffer_in_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "standby_maintenance_buffer_in_days", value)


@pulumi.input_type
class _AutonomousContainerDatabaseDataguardAssociationState:
    def __init__(__self__, *,
                 apply_lag: Optional[pulumi.Input[builtins.str]] = None,
                 apply_rate: Optional[pulumi.Input[builtins.str]] = None,
                 autonomous_container_database_dataguard_association_id: Optional[pulumi.Input[builtins.str]] = None,
                 autonomous_container_database_id: Optional[pulumi.Input[builtins.str]] = None,
                 fast_start_fail_over_lag_limit_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 is_automatic_failover_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 migrate_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 peer_autonomous_container_database_backup_config: Optional[pulumi.Input['AutonomousContainerDatabaseDataguardAssociationPeerAutonomousContainerDatabaseBackupConfigArgs']] = None,
                 peer_autonomous_container_database_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_autonomous_container_database_dataguard_association_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_autonomous_container_database_display_name: Optional[pulumi.Input[builtins.str]] = None,
                 peer_autonomous_container_database_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_cloud_autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_db_unique_name: Optional[pulumi.Input[builtins.str]] = None,
                 peer_lifecycle_state: Optional[pulumi.Input[builtins.str]] = None,
                 peer_role: Optional[pulumi.Input[builtins.str]] = None,
                 protection_mode: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 standby_maintenance_buffer_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_last_role_changed: Optional[pulumi.Input[builtins.str]] = None,
                 time_last_synced: Optional[pulumi.Input[builtins.str]] = None,
                 transport_lag: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AutonomousContainerDatabaseDataguardAssociation resources.
        :param pulumi.Input[builtins.str] apply_lag: The lag time between updates to the primary Autonomous Container Database and application of the redo data on the standby Autonomous Container Database, as computed by the reporting database.  Example: `9 seconds`
        :param pulumi.Input[builtins.str] apply_rate: The rate at which redo logs are synchronized between the associated Autonomous Container Databases.  Example: `180 Mb per second`
        :param pulumi.Input[builtins.str] autonomous_container_database_id: The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.int] fast_start_fail_over_lag_limit_in_seconds: (Updatable) The lag time for my preference based on data loss tolerance in seconds.
        :param pulumi.Input[builtins.bool] is_automatic_failover_enabled: (Updatable) Indicates whether Automatic Failover is enabled for Autonomous Container Database Dataguard Association. Input DataType: boolean. Example : `is_automatic_failover_enabled = true`.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current lifecycleState, if available.
        :param pulumi.Input[builtins.int] migrate_trigger: (Updatable) An optional property when incremented triggers Migrate. Could be set to any integer value.
        :param pulumi.Input['AutonomousContainerDatabaseDataguardAssociationPeerAutonomousContainerDatabaseBackupConfigArgs'] peer_autonomous_container_database_backup_config: Backup options for the standby Autonomous Container Database.
        :param pulumi.Input[builtins.str] peer_autonomous_container_database_compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where the standby Autonomous Container Database will be created.
        :param pulumi.Input[builtins.str] peer_autonomous_container_database_dataguard_association_id: The OCID of the peer Autonomous Container Database-Autonomous Data Guard association.
        :param pulumi.Input[builtins.str] peer_autonomous_container_database_display_name: The display name for the peer Autonomous Container Database.
        :param pulumi.Input[builtins.str] peer_autonomous_container_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer Autonomous Container Database.
        :param pulumi.Input[builtins.str] peer_autonomous_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer Autonomous Exadata VM Cluster.
        :param pulumi.Input[builtins.str] peer_cloud_autonomous_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer cloud Autonomous Exadata VM Cluster.
        :param pulumi.Input[builtins.str] peer_db_unique_name: Specifies the `DB_UNIQUE_NAME` of the peer database to be created.
        :param pulumi.Input[builtins.str] peer_lifecycle_state: The current state of the Autonomous Container Database.
        :param pulumi.Input[builtins.str] peer_role: The Data Guard role of the Autonomous Container Database or Autonomous Database, if Autonomous Data Guard is enabled.
        :param pulumi.Input[builtins.str] protection_mode: (Updatable) The protection mode of this Autonomous Data Guard association. For more information, see [Oracle Data Guard Protection Modes](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000) in the Oracle Data Guard documentation.
        :param pulumi.Input[builtins.str] role: The Data Guard role of the Autonomous Container Database or Autonomous Database, if Autonomous Data Guard is enabled.
        :param pulumi.Input[builtins.int] standby_maintenance_buffer_in_days: The scheduling detail for the quarterly maintenance window of the standby Autonomous Container Database. This value represents the number of days before scheduled maintenance of the primary database.
        :param pulumi.Input[builtins.str] state: The current state of Autonomous Data Guard.
        :param pulumi.Input[builtins.str] time_created: The date and time the Autonomous DataGuard association was created.
        :param pulumi.Input[builtins.str] time_last_role_changed: The date and time when the last role change action happened.
        :param pulumi.Input[builtins.str] time_last_synced: The date and time of the last update to the apply lag, apply rate, and transport lag values.
        :param pulumi.Input[builtins.str] transport_lag: The approximate number of seconds of redo data not yet available on the standby Autonomous Container Database, as computed by the reporting database.  Example: `7 seconds`
        """
        if apply_lag is not None:
            pulumi.set(__self__, "apply_lag", apply_lag)
        if apply_rate is not None:
            pulumi.set(__self__, "apply_rate", apply_rate)
        if autonomous_container_database_dataguard_association_id is not None:
            pulumi.set(__self__, "autonomous_container_database_dataguard_association_id", autonomous_container_database_dataguard_association_id)
        if autonomous_container_database_id is not None:
            pulumi.set(__self__, "autonomous_container_database_id", autonomous_container_database_id)
        if fast_start_fail_over_lag_limit_in_seconds is not None:
            pulumi.set(__self__, "fast_start_fail_over_lag_limit_in_seconds", fast_start_fail_over_lag_limit_in_seconds)
        if is_automatic_failover_enabled is not None:
            pulumi.set(__self__, "is_automatic_failover_enabled", is_automatic_failover_enabled)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if migrate_trigger is not None:
            pulumi.set(__self__, "migrate_trigger", migrate_trigger)
        if peer_autonomous_container_database_backup_config is not None:
            pulumi.set(__self__, "peer_autonomous_container_database_backup_config", peer_autonomous_container_database_backup_config)
        if peer_autonomous_container_database_compartment_id is not None:
            pulumi.set(__self__, "peer_autonomous_container_database_compartment_id", peer_autonomous_container_database_compartment_id)
        if peer_autonomous_container_database_dataguard_association_id is not None:
            pulumi.set(__self__, "peer_autonomous_container_database_dataguard_association_id", peer_autonomous_container_database_dataguard_association_id)
        if peer_autonomous_container_database_display_name is not None:
            pulumi.set(__self__, "peer_autonomous_container_database_display_name", peer_autonomous_container_database_display_name)
        if peer_autonomous_container_database_id is not None:
            pulumi.set(__self__, "peer_autonomous_container_database_id", peer_autonomous_container_database_id)
        if peer_autonomous_vm_cluster_id is not None:
            pulumi.set(__self__, "peer_autonomous_vm_cluster_id", peer_autonomous_vm_cluster_id)
        if peer_cloud_autonomous_vm_cluster_id is not None:
            pulumi.set(__self__, "peer_cloud_autonomous_vm_cluster_id", peer_cloud_autonomous_vm_cluster_id)
        if peer_db_unique_name is not None:
            pulumi.set(__self__, "peer_db_unique_name", peer_db_unique_name)
        if peer_lifecycle_state is not None:
            pulumi.set(__self__, "peer_lifecycle_state", peer_lifecycle_state)
        if peer_role is not None:
            pulumi.set(__self__, "peer_role", peer_role)
        if protection_mode is not None:
            pulumi.set(__self__, "protection_mode", protection_mode)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if standby_maintenance_buffer_in_days is not None:
            pulumi.set(__self__, "standby_maintenance_buffer_in_days", standby_maintenance_buffer_in_days)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_last_role_changed is not None:
            pulumi.set(__self__, "time_last_role_changed", time_last_role_changed)
        if time_last_synced is not None:
            pulumi.set(__self__, "time_last_synced", time_last_synced)
        if transport_lag is not None:
            pulumi.set(__self__, "transport_lag", transport_lag)

    @property
    @pulumi.getter(name="applyLag")
    def apply_lag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The lag time between updates to the primary Autonomous Container Database and application of the redo data on the standby Autonomous Container Database, as computed by the reporting database.  Example: `9 seconds`
        """
        return pulumi.get(self, "apply_lag")

    @apply_lag.setter
    def apply_lag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "apply_lag", value)

    @property
    @pulumi.getter(name="applyRate")
    def apply_rate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The rate at which redo logs are synchronized between the associated Autonomous Container Databases.  Example: `180 Mb per second`
        """
        return pulumi.get(self, "apply_rate")

    @apply_rate.setter
    def apply_rate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "apply_rate", value)

    @property
    @pulumi.getter(name="autonomousContainerDatabaseDataguardAssociationId")
    def autonomous_container_database_dataguard_association_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "autonomous_container_database_dataguard_association_id")

    @autonomous_container_database_dataguard_association_id.setter
    def autonomous_container_database_dataguard_association_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "autonomous_container_database_dataguard_association_id", value)

    @property
    @pulumi.getter(name="autonomousContainerDatabaseId")
    def autonomous_container_database_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "autonomous_container_database_id")

    @autonomous_container_database_id.setter
    def autonomous_container_database_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "autonomous_container_database_id", value)

    @property
    @pulumi.getter(name="fastStartFailOverLagLimitInSeconds")
    def fast_start_fail_over_lag_limit_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The lag time for my preference based on data loss tolerance in seconds.
        """
        return pulumi.get(self, "fast_start_fail_over_lag_limit_in_seconds")

    @fast_start_fail_over_lag_limit_in_seconds.setter
    def fast_start_fail_over_lag_limit_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "fast_start_fail_over_lag_limit_in_seconds", value)

    @property
    @pulumi.getter(name="isAutomaticFailoverEnabled")
    def is_automatic_failover_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Indicates whether Automatic Failover is enabled for Autonomous Container Database Dataguard Association. Input DataType: boolean. Example : `is_automatic_failover_enabled = true`.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "is_automatic_failover_enabled")

    @is_automatic_failover_enabled.setter
    def is_automatic_failover_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_automatic_failover_enabled", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional information about the current lifecycleState, if available.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="migrateTrigger")
    def migrate_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Migrate. Could be set to any integer value.
        """
        return pulumi.get(self, "migrate_trigger")

    @migrate_trigger.setter
    def migrate_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "migrate_trigger", value)

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseBackupConfig")
    def peer_autonomous_container_database_backup_config(self) -> Optional[pulumi.Input['AutonomousContainerDatabaseDataguardAssociationPeerAutonomousContainerDatabaseBackupConfigArgs']]:
        """
        Backup options for the standby Autonomous Container Database.
        """
        return pulumi.get(self, "peer_autonomous_container_database_backup_config")

    @peer_autonomous_container_database_backup_config.setter
    def peer_autonomous_container_database_backup_config(self, value: Optional[pulumi.Input['AutonomousContainerDatabaseDataguardAssociationPeerAutonomousContainerDatabaseBackupConfigArgs']]):
        pulumi.set(self, "peer_autonomous_container_database_backup_config", value)

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseCompartmentId")
    def peer_autonomous_container_database_compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where the standby Autonomous Container Database will be created.
        """
        return pulumi.get(self, "peer_autonomous_container_database_compartment_id")

    @peer_autonomous_container_database_compartment_id.setter
    def peer_autonomous_container_database_compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_autonomous_container_database_compartment_id", value)

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseDataguardAssociationId")
    def peer_autonomous_container_database_dataguard_association_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the peer Autonomous Container Database-Autonomous Data Guard association.
        """
        return pulumi.get(self, "peer_autonomous_container_database_dataguard_association_id")

    @peer_autonomous_container_database_dataguard_association_id.setter
    def peer_autonomous_container_database_dataguard_association_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_autonomous_container_database_dataguard_association_id", value)

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseDisplayName")
    def peer_autonomous_container_database_display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name for the peer Autonomous Container Database.
        """
        return pulumi.get(self, "peer_autonomous_container_database_display_name")

    @peer_autonomous_container_database_display_name.setter
    def peer_autonomous_container_database_display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_autonomous_container_database_display_name", value)

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseId")
    def peer_autonomous_container_database_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer Autonomous Container Database.
        """
        return pulumi.get(self, "peer_autonomous_container_database_id")

    @peer_autonomous_container_database_id.setter
    def peer_autonomous_container_database_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_autonomous_container_database_id", value)

    @property
    @pulumi.getter(name="peerAutonomousVmClusterId")
    def peer_autonomous_vm_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer Autonomous Exadata VM Cluster.
        """
        return pulumi.get(self, "peer_autonomous_vm_cluster_id")

    @peer_autonomous_vm_cluster_id.setter
    def peer_autonomous_vm_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_autonomous_vm_cluster_id", value)

    @property
    @pulumi.getter(name="peerCloudAutonomousVmClusterId")
    def peer_cloud_autonomous_vm_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer cloud Autonomous Exadata VM Cluster.
        """
        return pulumi.get(self, "peer_cloud_autonomous_vm_cluster_id")

    @peer_cloud_autonomous_vm_cluster_id.setter
    def peer_cloud_autonomous_vm_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_cloud_autonomous_vm_cluster_id", value)

    @property
    @pulumi.getter(name="peerDbUniqueName")
    def peer_db_unique_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the `DB_UNIQUE_NAME` of the peer database to be created.
        """
        return pulumi.get(self, "peer_db_unique_name")

    @peer_db_unique_name.setter
    def peer_db_unique_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_db_unique_name", value)

    @property
    @pulumi.getter(name="peerLifecycleState")
    def peer_lifecycle_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the Autonomous Container Database.
        """
        return pulumi.get(self, "peer_lifecycle_state")

    @peer_lifecycle_state.setter
    def peer_lifecycle_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_lifecycle_state", value)

    @property
    @pulumi.getter(name="peerRole")
    def peer_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Data Guard role of the Autonomous Container Database or Autonomous Database, if Autonomous Data Guard is enabled.
        """
        return pulumi.get(self, "peer_role")

    @peer_role.setter
    def peer_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_role", value)

    @property
    @pulumi.getter(name="protectionMode")
    def protection_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The protection mode of this Autonomous Data Guard association. For more information, see [Oracle Data Guard Protection Modes](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000) in the Oracle Data Guard documentation.
        """
        return pulumi.get(self, "protection_mode")

    @protection_mode.setter
    def protection_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protection_mode", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Data Guard role of the Autonomous Container Database or Autonomous Database, if Autonomous Data Guard is enabled.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="standbyMaintenanceBufferInDays")
    def standby_maintenance_buffer_in_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The scheduling detail for the quarterly maintenance window of the standby Autonomous Container Database. This value represents the number of days before scheduled maintenance of the primary database.
        """
        return pulumi.get(self, "standby_maintenance_buffer_in_days")

    @standby_maintenance_buffer_in_days.setter
    def standby_maintenance_buffer_in_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "standby_maintenance_buffer_in_days", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of Autonomous Data Guard.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the Autonomous DataGuard association was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeLastRoleChanged")
    def time_last_role_changed(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time when the last role change action happened.
        """
        return pulumi.get(self, "time_last_role_changed")

    @time_last_role_changed.setter
    def time_last_role_changed(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_last_role_changed", value)

    @property
    @pulumi.getter(name="timeLastSynced")
    def time_last_synced(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time of the last update to the apply lag, apply rate, and transport lag values.
        """
        return pulumi.get(self, "time_last_synced")

    @time_last_synced.setter
    def time_last_synced(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_last_synced", value)

    @property
    @pulumi.getter(name="transportLag")
    def transport_lag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The approximate number of seconds of redo data not yet available on the standby Autonomous Container Database, as computed by the reporting database.  Example: `7 seconds`
        """
        return pulumi.get(self, "transport_lag")

    @transport_lag.setter
    def transport_lag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "transport_lag", value)


@pulumi.type_token("oci:Database/autonomousContainerDatabaseDataguardAssociation:AutonomousContainerDatabaseDataguardAssociation")
class AutonomousContainerDatabaseDataguardAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autonomous_container_database_dataguard_association_id: Optional[pulumi.Input[builtins.str]] = None,
                 autonomous_container_database_id: Optional[pulumi.Input[builtins.str]] = None,
                 fast_start_fail_over_lag_limit_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 is_automatic_failover_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 migrate_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 peer_autonomous_container_database_backup_config: Optional[pulumi.Input[Union['AutonomousContainerDatabaseDataguardAssociationPeerAutonomousContainerDatabaseBackupConfigArgs', 'AutonomousContainerDatabaseDataguardAssociationPeerAutonomousContainerDatabaseBackupConfigArgsDict']]] = None,
                 peer_autonomous_container_database_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_autonomous_container_database_display_name: Optional[pulumi.Input[builtins.str]] = None,
                 peer_autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_cloud_autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_db_unique_name: Optional[pulumi.Input[builtins.str]] = None,
                 protection_mode: Optional[pulumi.Input[builtins.str]] = None,
                 standby_maintenance_buffer_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        This resource provides the Autonomous Container Database Dataguard Association resource in Oracle Cloud Infrastructure Database service.

        Create a new Autonomous Data Guard association. An Autonomous Data Guard association represents the replication relationship between the
        specified Autonomous Container database and a peer Autonomous Container database. For more information, see [Using Oracle Data Guard](https://docs.cloud.oracle.com/iaas/Content/Database/Tasks/usingdataguard.htm).

        All Oracle Cloud Infrastructure resources, including Data Guard associations, get an Oracle-assigned, unique ID
        called an Oracle Cloud Identifier (OCID). When you create a resource, you can find its OCID in the response.
        You can also retrieve a resource's OCID by using a List API operation on that resource type, or by viewing the
        resource in the Console. For more information, see
        [Resource Identifiers](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_autonomous_container_database_dataguard_association = oci.database.AutonomousContainerDatabaseDataguardAssociation("test_autonomous_container_database_dataguard_association",
            autonomous_container_database_id=test_autonomous_container_database["id"],
            peer_autonomous_container_database_display_name=autonomous_container_database_dataguard_association_peer_autonomous_container_database_display_name,
            protection_mode=autonomous_container_database_dataguard_association_protection_mode,
            fast_start_fail_over_lag_limit_in_seconds=autonomous_container_database_dataguard_association_fast_start_fail_over_lag_limit_in_seconds,
            is_automatic_failover_enabled=autonomous_container_database_dataguard_association_is_automatic_failover_enabled,
            peer_autonomous_container_database_backup_config={
                "backup_destination_details": [{
                    "type": autonomous_container_database_dataguard_association_peer_autonomous_container_database_backup_config_backup_destination_details_type,
                    "dbrs_policy_id": test_policy["id"],
                    "id": autonomous_container_database_dataguard_association_peer_autonomous_container_database_backup_config_backup_destination_details_id,
                    "internet_proxy": autonomous_container_database_dataguard_association_peer_autonomous_container_database_backup_config_backup_destination_details_internet_proxy,
                    "vpc_password": autonomous_container_database_dataguard_association_peer_autonomous_container_database_backup_config_backup_destination_details_vpc_password,
                    "vpc_user": autonomous_container_database_dataguard_association_peer_autonomous_container_database_backup_config_backup_destination_details_vpc_user,
                }],
                "recovery_window_in_days": autonomous_container_database_dataguard_association_peer_autonomous_container_database_backup_config_recovery_window_in_days,
            },
            peer_autonomous_container_database_compartment_id=test_compartment["id"],
            peer_autonomous_vm_cluster_id=test_autonomous_vm_cluster["id"],
            peer_cloud_autonomous_vm_cluster_id=test_cloud_autonomous_vm_cluster["id"],
            peer_db_unique_name=autonomous_container_database_dataguard_association_peer_db_unique_name,
            standby_maintenance_buffer_in_days=autonomous_container_database_dataguard_association_standby_maintenance_buffer_in_days)
        ```

        ## Import

        AutonomousContainerDatabaseDataguardAssociations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/autonomousContainerDatabaseDataguardAssociation:AutonomousContainerDatabaseDataguardAssociation test_autonomous_container_database_dataguard_association "autonomousContainerDatabases/{autonomousContainerDatabaseId}/autonomousContainerDatabaseDataguardAssociations/{autonomousContainerDatabaseDataguardAssociationId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] autonomous_container_database_id: The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.int] fast_start_fail_over_lag_limit_in_seconds: (Updatable) The lag time for my preference based on data loss tolerance in seconds.
        :param pulumi.Input[builtins.bool] is_automatic_failover_enabled: (Updatable) Indicates whether Automatic Failover is enabled for Autonomous Container Database Dataguard Association. Input DataType: boolean. Example : `is_automatic_failover_enabled = true`.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.int] migrate_trigger: (Updatable) An optional property when incremented triggers Migrate. Could be set to any integer value.
        :param pulumi.Input[Union['AutonomousContainerDatabaseDataguardAssociationPeerAutonomousContainerDatabaseBackupConfigArgs', 'AutonomousContainerDatabaseDataguardAssociationPeerAutonomousContainerDatabaseBackupConfigArgsDict']] peer_autonomous_container_database_backup_config: Backup options for the standby Autonomous Container Database.
        :param pulumi.Input[builtins.str] peer_autonomous_container_database_compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where the standby Autonomous Container Database will be created.
        :param pulumi.Input[builtins.str] peer_autonomous_container_database_display_name: The display name for the peer Autonomous Container Database.
        :param pulumi.Input[builtins.str] peer_autonomous_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer Autonomous Exadata VM Cluster.
        :param pulumi.Input[builtins.str] peer_cloud_autonomous_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer cloud Autonomous Exadata VM Cluster.
        :param pulumi.Input[builtins.str] peer_db_unique_name: Specifies the `DB_UNIQUE_NAME` of the peer database to be created.
        :param pulumi.Input[builtins.str] protection_mode: (Updatable) The protection mode of this Autonomous Data Guard association. For more information, see [Oracle Data Guard Protection Modes](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000) in the Oracle Data Guard documentation.
        :param pulumi.Input[builtins.int] standby_maintenance_buffer_in_days: The scheduling detail for the quarterly maintenance window of the standby Autonomous Container Database. This value represents the number of days before scheduled maintenance of the primary database.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutonomousContainerDatabaseDataguardAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Autonomous Container Database Dataguard Association resource in Oracle Cloud Infrastructure Database service.

        Create a new Autonomous Data Guard association. An Autonomous Data Guard association represents the replication relationship between the
        specified Autonomous Container database and a peer Autonomous Container database. For more information, see [Using Oracle Data Guard](https://docs.cloud.oracle.com/iaas/Content/Database/Tasks/usingdataguard.htm).

        All Oracle Cloud Infrastructure resources, including Data Guard associations, get an Oracle-assigned, unique ID
        called an Oracle Cloud Identifier (OCID). When you create a resource, you can find its OCID in the response.
        You can also retrieve a resource's OCID by using a List API operation on that resource type, or by viewing the
        resource in the Console. For more information, see
        [Resource Identifiers](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_autonomous_container_database_dataguard_association = oci.database.AutonomousContainerDatabaseDataguardAssociation("test_autonomous_container_database_dataguard_association",
            autonomous_container_database_id=test_autonomous_container_database["id"],
            peer_autonomous_container_database_display_name=autonomous_container_database_dataguard_association_peer_autonomous_container_database_display_name,
            protection_mode=autonomous_container_database_dataguard_association_protection_mode,
            fast_start_fail_over_lag_limit_in_seconds=autonomous_container_database_dataguard_association_fast_start_fail_over_lag_limit_in_seconds,
            is_automatic_failover_enabled=autonomous_container_database_dataguard_association_is_automatic_failover_enabled,
            peer_autonomous_container_database_backup_config={
                "backup_destination_details": [{
                    "type": autonomous_container_database_dataguard_association_peer_autonomous_container_database_backup_config_backup_destination_details_type,
                    "dbrs_policy_id": test_policy["id"],
                    "id": autonomous_container_database_dataguard_association_peer_autonomous_container_database_backup_config_backup_destination_details_id,
                    "internet_proxy": autonomous_container_database_dataguard_association_peer_autonomous_container_database_backup_config_backup_destination_details_internet_proxy,
                    "vpc_password": autonomous_container_database_dataguard_association_peer_autonomous_container_database_backup_config_backup_destination_details_vpc_password,
                    "vpc_user": autonomous_container_database_dataguard_association_peer_autonomous_container_database_backup_config_backup_destination_details_vpc_user,
                }],
                "recovery_window_in_days": autonomous_container_database_dataguard_association_peer_autonomous_container_database_backup_config_recovery_window_in_days,
            },
            peer_autonomous_container_database_compartment_id=test_compartment["id"],
            peer_autonomous_vm_cluster_id=test_autonomous_vm_cluster["id"],
            peer_cloud_autonomous_vm_cluster_id=test_cloud_autonomous_vm_cluster["id"],
            peer_db_unique_name=autonomous_container_database_dataguard_association_peer_db_unique_name,
            standby_maintenance_buffer_in_days=autonomous_container_database_dataguard_association_standby_maintenance_buffer_in_days)
        ```

        ## Import

        AutonomousContainerDatabaseDataguardAssociations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/autonomousContainerDatabaseDataguardAssociation:AutonomousContainerDatabaseDataguardAssociation test_autonomous_container_database_dataguard_association "autonomousContainerDatabases/{autonomousContainerDatabaseId}/autonomousContainerDatabaseDataguardAssociations/{autonomousContainerDatabaseDataguardAssociationId}"
        ```

        :param str resource_name: The name of the resource.
        :param AutonomousContainerDatabaseDataguardAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutonomousContainerDatabaseDataguardAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autonomous_container_database_dataguard_association_id: Optional[pulumi.Input[builtins.str]] = None,
                 autonomous_container_database_id: Optional[pulumi.Input[builtins.str]] = None,
                 fast_start_fail_over_lag_limit_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 is_automatic_failover_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 migrate_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 peer_autonomous_container_database_backup_config: Optional[pulumi.Input[Union['AutonomousContainerDatabaseDataguardAssociationPeerAutonomousContainerDatabaseBackupConfigArgs', 'AutonomousContainerDatabaseDataguardAssociationPeerAutonomousContainerDatabaseBackupConfigArgsDict']]] = None,
                 peer_autonomous_container_database_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_autonomous_container_database_display_name: Optional[pulumi.Input[builtins.str]] = None,
                 peer_autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_cloud_autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_db_unique_name: Optional[pulumi.Input[builtins.str]] = None,
                 protection_mode: Optional[pulumi.Input[builtins.str]] = None,
                 standby_maintenance_buffer_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutonomousContainerDatabaseDataguardAssociationArgs.__new__(AutonomousContainerDatabaseDataguardAssociationArgs)

            __props__.__dict__["autonomous_container_database_dataguard_association_id"] = autonomous_container_database_dataguard_association_id
            if autonomous_container_database_id is None and not opts.urn:
                raise TypeError("Missing required property 'autonomous_container_database_id'")
            __props__.__dict__["autonomous_container_database_id"] = autonomous_container_database_id
            __props__.__dict__["fast_start_fail_over_lag_limit_in_seconds"] = fast_start_fail_over_lag_limit_in_seconds
            __props__.__dict__["is_automatic_failover_enabled"] = is_automatic_failover_enabled
            __props__.__dict__["migrate_trigger"] = migrate_trigger
            __props__.__dict__["peer_autonomous_container_database_backup_config"] = peer_autonomous_container_database_backup_config
            __props__.__dict__["peer_autonomous_container_database_compartment_id"] = peer_autonomous_container_database_compartment_id
            if peer_autonomous_container_database_display_name is None and not opts.urn:
                raise TypeError("Missing required property 'peer_autonomous_container_database_display_name'")
            __props__.__dict__["peer_autonomous_container_database_display_name"] = peer_autonomous_container_database_display_name
            __props__.__dict__["peer_autonomous_vm_cluster_id"] = peer_autonomous_vm_cluster_id
            __props__.__dict__["peer_cloud_autonomous_vm_cluster_id"] = peer_cloud_autonomous_vm_cluster_id
            __props__.__dict__["peer_db_unique_name"] = peer_db_unique_name
            if protection_mode is None and not opts.urn:
                raise TypeError("Missing required property 'protection_mode'")
            __props__.__dict__["protection_mode"] = protection_mode
            __props__.__dict__["standby_maintenance_buffer_in_days"] = standby_maintenance_buffer_in_days
            __props__.__dict__["apply_lag"] = None
            __props__.__dict__["apply_rate"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["peer_autonomous_container_database_dataguard_association_id"] = None
            __props__.__dict__["peer_autonomous_container_database_id"] = None
            __props__.__dict__["peer_lifecycle_state"] = None
            __props__.__dict__["peer_role"] = None
            __props__.__dict__["role"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_last_role_changed"] = None
            __props__.__dict__["time_last_synced"] = None
            __props__.__dict__["transport_lag"] = None
        super(AutonomousContainerDatabaseDataguardAssociation, __self__).__init__(
            'oci:Database/autonomousContainerDatabaseDataguardAssociation:AutonomousContainerDatabaseDataguardAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apply_lag: Optional[pulumi.Input[builtins.str]] = None,
            apply_rate: Optional[pulumi.Input[builtins.str]] = None,
            autonomous_container_database_dataguard_association_id: Optional[pulumi.Input[builtins.str]] = None,
            autonomous_container_database_id: Optional[pulumi.Input[builtins.str]] = None,
            fast_start_fail_over_lag_limit_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
            is_automatic_failover_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            migrate_trigger: Optional[pulumi.Input[builtins.int]] = None,
            peer_autonomous_container_database_backup_config: Optional[pulumi.Input[Union['AutonomousContainerDatabaseDataguardAssociationPeerAutonomousContainerDatabaseBackupConfigArgs', 'AutonomousContainerDatabaseDataguardAssociationPeerAutonomousContainerDatabaseBackupConfigArgsDict']]] = None,
            peer_autonomous_container_database_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            peer_autonomous_container_database_dataguard_association_id: Optional[pulumi.Input[builtins.str]] = None,
            peer_autonomous_container_database_display_name: Optional[pulumi.Input[builtins.str]] = None,
            peer_autonomous_container_database_id: Optional[pulumi.Input[builtins.str]] = None,
            peer_autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
            peer_cloud_autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
            peer_db_unique_name: Optional[pulumi.Input[builtins.str]] = None,
            peer_lifecycle_state: Optional[pulumi.Input[builtins.str]] = None,
            peer_role: Optional[pulumi.Input[builtins.str]] = None,
            protection_mode: Optional[pulumi.Input[builtins.str]] = None,
            role: Optional[pulumi.Input[builtins.str]] = None,
            standby_maintenance_buffer_in_days: Optional[pulumi.Input[builtins.int]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_last_role_changed: Optional[pulumi.Input[builtins.str]] = None,
            time_last_synced: Optional[pulumi.Input[builtins.str]] = None,
            transport_lag: Optional[pulumi.Input[builtins.str]] = None) -> 'AutonomousContainerDatabaseDataguardAssociation':
        """
        Get an existing AutonomousContainerDatabaseDataguardAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] apply_lag: The lag time between updates to the primary Autonomous Container Database and application of the redo data on the standby Autonomous Container Database, as computed by the reporting database.  Example: `9 seconds`
        :param pulumi.Input[builtins.str] apply_rate: The rate at which redo logs are synchronized between the associated Autonomous Container Databases.  Example: `180 Mb per second`
        :param pulumi.Input[builtins.str] autonomous_container_database_id: The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.int] fast_start_fail_over_lag_limit_in_seconds: (Updatable) The lag time for my preference based on data loss tolerance in seconds.
        :param pulumi.Input[builtins.bool] is_automatic_failover_enabled: (Updatable) Indicates whether Automatic Failover is enabled for Autonomous Container Database Dataguard Association. Input DataType: boolean. Example : `is_automatic_failover_enabled = true`.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current lifecycleState, if available.
        :param pulumi.Input[builtins.int] migrate_trigger: (Updatable) An optional property when incremented triggers Migrate. Could be set to any integer value.
        :param pulumi.Input[Union['AutonomousContainerDatabaseDataguardAssociationPeerAutonomousContainerDatabaseBackupConfigArgs', 'AutonomousContainerDatabaseDataguardAssociationPeerAutonomousContainerDatabaseBackupConfigArgsDict']] peer_autonomous_container_database_backup_config: Backup options for the standby Autonomous Container Database.
        :param pulumi.Input[builtins.str] peer_autonomous_container_database_compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where the standby Autonomous Container Database will be created.
        :param pulumi.Input[builtins.str] peer_autonomous_container_database_dataguard_association_id: The OCID of the peer Autonomous Container Database-Autonomous Data Guard association.
        :param pulumi.Input[builtins.str] peer_autonomous_container_database_display_name: The display name for the peer Autonomous Container Database.
        :param pulumi.Input[builtins.str] peer_autonomous_container_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer Autonomous Container Database.
        :param pulumi.Input[builtins.str] peer_autonomous_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer Autonomous Exadata VM Cluster.
        :param pulumi.Input[builtins.str] peer_cloud_autonomous_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer cloud Autonomous Exadata VM Cluster.
        :param pulumi.Input[builtins.str] peer_db_unique_name: Specifies the `DB_UNIQUE_NAME` of the peer database to be created.
        :param pulumi.Input[builtins.str] peer_lifecycle_state: The current state of the Autonomous Container Database.
        :param pulumi.Input[builtins.str] peer_role: The Data Guard role of the Autonomous Container Database or Autonomous Database, if Autonomous Data Guard is enabled.
        :param pulumi.Input[builtins.str] protection_mode: (Updatable) The protection mode of this Autonomous Data Guard association. For more information, see [Oracle Data Guard Protection Modes](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000) in the Oracle Data Guard documentation.
        :param pulumi.Input[builtins.str] role: The Data Guard role of the Autonomous Container Database or Autonomous Database, if Autonomous Data Guard is enabled.
        :param pulumi.Input[builtins.int] standby_maintenance_buffer_in_days: The scheduling detail for the quarterly maintenance window of the standby Autonomous Container Database. This value represents the number of days before scheduled maintenance of the primary database.
        :param pulumi.Input[builtins.str] state: The current state of Autonomous Data Guard.
        :param pulumi.Input[builtins.str] time_created: The date and time the Autonomous DataGuard association was created.
        :param pulumi.Input[builtins.str] time_last_role_changed: The date and time when the last role change action happened.
        :param pulumi.Input[builtins.str] time_last_synced: The date and time of the last update to the apply lag, apply rate, and transport lag values.
        :param pulumi.Input[builtins.str] transport_lag: The approximate number of seconds of redo data not yet available on the standby Autonomous Container Database, as computed by the reporting database.  Example: `7 seconds`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutonomousContainerDatabaseDataguardAssociationState.__new__(_AutonomousContainerDatabaseDataguardAssociationState)

        __props__.__dict__["apply_lag"] = apply_lag
        __props__.__dict__["apply_rate"] = apply_rate
        __props__.__dict__["autonomous_container_database_dataguard_association_id"] = autonomous_container_database_dataguard_association_id
        __props__.__dict__["autonomous_container_database_id"] = autonomous_container_database_id
        __props__.__dict__["fast_start_fail_over_lag_limit_in_seconds"] = fast_start_fail_over_lag_limit_in_seconds
        __props__.__dict__["is_automatic_failover_enabled"] = is_automatic_failover_enabled
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["migrate_trigger"] = migrate_trigger
        __props__.__dict__["peer_autonomous_container_database_backup_config"] = peer_autonomous_container_database_backup_config
        __props__.__dict__["peer_autonomous_container_database_compartment_id"] = peer_autonomous_container_database_compartment_id
        __props__.__dict__["peer_autonomous_container_database_dataguard_association_id"] = peer_autonomous_container_database_dataguard_association_id
        __props__.__dict__["peer_autonomous_container_database_display_name"] = peer_autonomous_container_database_display_name
        __props__.__dict__["peer_autonomous_container_database_id"] = peer_autonomous_container_database_id
        __props__.__dict__["peer_autonomous_vm_cluster_id"] = peer_autonomous_vm_cluster_id
        __props__.__dict__["peer_cloud_autonomous_vm_cluster_id"] = peer_cloud_autonomous_vm_cluster_id
        __props__.__dict__["peer_db_unique_name"] = peer_db_unique_name
        __props__.__dict__["peer_lifecycle_state"] = peer_lifecycle_state
        __props__.__dict__["peer_role"] = peer_role
        __props__.__dict__["protection_mode"] = protection_mode
        __props__.__dict__["role"] = role
        __props__.__dict__["standby_maintenance_buffer_in_days"] = standby_maintenance_buffer_in_days
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_last_role_changed"] = time_last_role_changed
        __props__.__dict__["time_last_synced"] = time_last_synced
        __props__.__dict__["transport_lag"] = transport_lag
        return AutonomousContainerDatabaseDataguardAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applyLag")
    def apply_lag(self) -> pulumi.Output[builtins.str]:
        """
        The lag time between updates to the primary Autonomous Container Database and application of the redo data on the standby Autonomous Container Database, as computed by the reporting database.  Example: `9 seconds`
        """
        return pulumi.get(self, "apply_lag")

    @property
    @pulumi.getter(name="applyRate")
    def apply_rate(self) -> pulumi.Output[builtins.str]:
        """
        The rate at which redo logs are synchronized between the associated Autonomous Container Databases.  Example: `180 Mb per second`
        """
        return pulumi.get(self, "apply_rate")

    @property
    @pulumi.getter(name="autonomousContainerDatabaseDataguardAssociationId")
    def autonomous_container_database_dataguard_association_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "autonomous_container_database_dataguard_association_id")

    @property
    @pulumi.getter(name="autonomousContainerDatabaseId")
    def autonomous_container_database_id(self) -> pulumi.Output[builtins.str]:
        """
        The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "autonomous_container_database_id")

    @property
    @pulumi.getter(name="fastStartFailOverLagLimitInSeconds")
    def fast_start_fail_over_lag_limit_in_seconds(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) The lag time for my preference based on data loss tolerance in seconds.
        """
        return pulumi.get(self, "fast_start_fail_over_lag_limit_in_seconds")

    @property
    @pulumi.getter(name="isAutomaticFailoverEnabled")
    def is_automatic_failover_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Indicates whether Automatic Failover is enabled for Autonomous Container Database Dataguard Association. Input DataType: boolean. Example : `is_automatic_failover_enabled = true`.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "is_automatic_failover_enabled")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        Additional information about the current lifecycleState, if available.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="migrateTrigger")
    def migrate_trigger(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Migrate. Could be set to any integer value.
        """
        return pulumi.get(self, "migrate_trigger")

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseBackupConfig")
    def peer_autonomous_container_database_backup_config(self) -> pulumi.Output['outputs.AutonomousContainerDatabaseDataguardAssociationPeerAutonomousContainerDatabaseBackupConfig']:
        """
        Backup options for the standby Autonomous Container Database.
        """
        return pulumi.get(self, "peer_autonomous_container_database_backup_config")

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseCompartmentId")
    def peer_autonomous_container_database_compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where the standby Autonomous Container Database will be created.
        """
        return pulumi.get(self, "peer_autonomous_container_database_compartment_id")

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseDataguardAssociationId")
    def peer_autonomous_container_database_dataguard_association_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the peer Autonomous Container Database-Autonomous Data Guard association.
        """
        return pulumi.get(self, "peer_autonomous_container_database_dataguard_association_id")

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseDisplayName")
    def peer_autonomous_container_database_display_name(self) -> pulumi.Output[builtins.str]:
        """
        The display name for the peer Autonomous Container Database.
        """
        return pulumi.get(self, "peer_autonomous_container_database_display_name")

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseId")
    def peer_autonomous_container_database_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer Autonomous Container Database.
        """
        return pulumi.get(self, "peer_autonomous_container_database_id")

    @property
    @pulumi.getter(name="peerAutonomousVmClusterId")
    def peer_autonomous_vm_cluster_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer Autonomous Exadata VM Cluster.
        """
        return pulumi.get(self, "peer_autonomous_vm_cluster_id")

    @property
    @pulumi.getter(name="peerCloudAutonomousVmClusterId")
    def peer_cloud_autonomous_vm_cluster_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer cloud Autonomous Exadata VM Cluster.
        """
        return pulumi.get(self, "peer_cloud_autonomous_vm_cluster_id")

    @property
    @pulumi.getter(name="peerDbUniqueName")
    def peer_db_unique_name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the `DB_UNIQUE_NAME` of the peer database to be created.
        """
        return pulumi.get(self, "peer_db_unique_name")

    @property
    @pulumi.getter(name="peerLifecycleState")
    def peer_lifecycle_state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the Autonomous Container Database.
        """
        return pulumi.get(self, "peer_lifecycle_state")

    @property
    @pulumi.getter(name="peerRole")
    def peer_role(self) -> pulumi.Output[builtins.str]:
        """
        The Data Guard role of the Autonomous Container Database or Autonomous Database, if Autonomous Data Guard is enabled.
        """
        return pulumi.get(self, "peer_role")

    @property
    @pulumi.getter(name="protectionMode")
    def protection_mode(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The protection mode of this Autonomous Data Guard association. For more information, see [Oracle Data Guard Protection Modes](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000) in the Oracle Data Guard documentation.
        """
        return pulumi.get(self, "protection_mode")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[builtins.str]:
        """
        The Data Guard role of the Autonomous Container Database or Autonomous Database, if Autonomous Data Guard is enabled.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="standbyMaintenanceBufferInDays")
    def standby_maintenance_buffer_in_days(self) -> pulumi.Output[builtins.int]:
        """
        The scheduling detail for the quarterly maintenance window of the standby Autonomous Container Database. This value represents the number of days before scheduled maintenance of the primary database.
        """
        return pulumi.get(self, "standby_maintenance_buffer_in_days")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of Autonomous Data Guard.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the Autonomous DataGuard association was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastRoleChanged")
    def time_last_role_changed(self) -> pulumi.Output[builtins.str]:
        """
        The date and time when the last role change action happened.
        """
        return pulumi.get(self, "time_last_role_changed")

    @property
    @pulumi.getter(name="timeLastSynced")
    def time_last_synced(self) -> pulumi.Output[builtins.str]:
        """
        The date and time of the last update to the apply lag, apply rate, and transport lag values.
        """
        return pulumi.get(self, "time_last_synced")

    @property
    @pulumi.getter(name="transportLag")
    def transport_lag(self) -> pulumi.Output[builtins.str]:
        """
        The approximate number of seconds of redo data not yet available on the standby Autonomous Container Database, as computed by the reporting database.  Example: `7 seconds`
        """
        return pulumi.get(self, "transport_lag")

