# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DbNodeConsoleConnectionArgs', 'DbNodeConsoleConnection']

@pulumi.input_type
class DbNodeConsoleConnectionArgs:
    def __init__(__self__, *,
                 db_node_id: pulumi.Input[builtins.str],
                 public_key: pulumi.Input[builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a DbNodeConsoleConnection resource.
        :param pulumi.Input[builtins.str] db_node_id: The database node [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.str] public_key: The SSH public key used to authenticate the console connection.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "db_node_id", db_node_id)
        pulumi.set(__self__, "public_key", public_key)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="dbNodeId")
    def db_node_id(self) -> pulumi.Input[builtins.str]:
        """
        The database node [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "db_node_id")

    @db_node_id.setter
    def db_node_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "db_node_id", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Input[builtins.str]:
        """
        The SSH public key used to authenticate the console connection.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _DbNodeConsoleConnectionState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 db_node_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 fingerprint: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 public_key: Optional[pulumi.Input[builtins.str]] = None,
                 service_host_key_fingerprint: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DbNodeConsoleConnection resources.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the compartment to contain the console connection.
        :param pulumi.Input[builtins.str] connection_string: The SSH connection string for the console connection.
        :param pulumi.Input[builtins.str] db_node_id: The database node [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] fingerprint: The SSH public key fingerprint for the console connection.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] lifecycle_details: Information about the current lifecycle state.
        :param pulumi.Input[builtins.str] public_key: The SSH public key used to authenticate the console connection.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] service_host_key_fingerprint: The SSH public key's fingerprint for the console connection service host.
        :param pulumi.Input[builtins.str] state: The current state of the console connection.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if db_node_id is not None:
            pulumi.set(__self__, "db_node_id", db_node_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if service_host_key_fingerprint is not None:
            pulumi.set(__self__, "service_host_key_fingerprint", service_host_key_fingerprint)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the compartment to contain the console connection.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SSH connection string for the console connection.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="dbNodeId")
    def db_node_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The database node [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "db_node_id")

    @db_node_id.setter
    def db_node_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_node_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SSH public key fingerprint for the console connection.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SSH public key used to authenticate the console connection.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter(name="serviceHostKeyFingerprint")
    def service_host_key_fingerprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SSH public key's fingerprint for the console connection service host.
        """
        return pulumi.get(self, "service_host_key_fingerprint")

    @service_host_key_fingerprint.setter
    def service_host_key_fingerprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_host_key_fingerprint", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the console connection.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("oci:Database/dbNodeConsoleConnection:DbNodeConsoleConnection")
class DbNodeConsoleConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_node_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 public_key: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Db Node Console Connection resource in Oracle Cloud Infrastructure Database service.

        Creates a new console connection to the specified database node.
        After the console connection has been created and is available,
        you connect to the console using SSH.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_db_node_console_connection = oci.database.DbNodeConsoleConnection("test_db_node_console_connection",
            db_node_id=test_db_node["id"],
            public_key=db_node_console_connection_public_key,
            defined_tags=db_node_console_connection_defined_tags,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        DbNodeConsoleConnections can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/dbNodeConsoleConnection:DbNodeConsoleConnection test_db_node_console_connection "dbNodes/{dbNodeId}/consoleConnections/{consoleConnectionId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] db_node_id: The database node [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] public_key: The SSH public key used to authenticate the console connection.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DbNodeConsoleConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Db Node Console Connection resource in Oracle Cloud Infrastructure Database service.

        Creates a new console connection to the specified database node.
        After the console connection has been created and is available,
        you connect to the console using SSH.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_db_node_console_connection = oci.database.DbNodeConsoleConnection("test_db_node_console_connection",
            db_node_id=test_db_node["id"],
            public_key=db_node_console_connection_public_key,
            defined_tags=db_node_console_connection_defined_tags,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        DbNodeConsoleConnections can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/dbNodeConsoleConnection:DbNodeConsoleConnection test_db_node_console_connection "dbNodes/{dbNodeId}/consoleConnections/{consoleConnectionId}"
        ```

        :param str resource_name: The name of the resource.
        :param DbNodeConsoleConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbNodeConsoleConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_node_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 public_key: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbNodeConsoleConnectionArgs.__new__(DbNodeConsoleConnectionArgs)

            if db_node_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_node_id'")
            __props__.__dict__["db_node_id"] = db_node_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["freeform_tags"] = freeform_tags
            if public_key is None and not opts.urn:
                raise TypeError("Missing required property 'public_key'")
            __props__.__dict__["public_key"] = public_key
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["connection_string"] = None
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["service_host_key_fingerprint"] = None
            __props__.__dict__["state"] = None
        super(DbNodeConsoleConnection, __self__).__init__(
            'oci:Database/dbNodeConsoleConnection:DbNodeConsoleConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            connection_string: Optional[pulumi.Input[builtins.str]] = None,
            db_node_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            fingerprint: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            public_key: Optional[pulumi.Input[builtins.str]] = None,
            service_host_key_fingerprint: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None) -> 'DbNodeConsoleConnection':
        """
        Get an existing DbNodeConsoleConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the compartment to contain the console connection.
        :param pulumi.Input[builtins.str] connection_string: The SSH connection string for the console connection.
        :param pulumi.Input[builtins.str] db_node_id: The database node [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] fingerprint: The SSH public key fingerprint for the console connection.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] lifecycle_details: Information about the current lifecycle state.
        :param pulumi.Input[builtins.str] public_key: The SSH public key used to authenticate the console connection.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] service_host_key_fingerprint: The SSH public key's fingerprint for the console connection service host.
        :param pulumi.Input[builtins.str] state: The current state of the console connection.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DbNodeConsoleConnectionState.__new__(_DbNodeConsoleConnectionState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["db_node_id"] = db_node_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["public_key"] = public_key
        __props__.__dict__["service_host_key_fingerprint"] = service_host_key_fingerprint
        __props__.__dict__["state"] = state
        return DbNodeConsoleConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the compartment to contain the console connection.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[builtins.str]:
        """
        The SSH connection string for the console connection.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="dbNodeId")
    def db_node_id(self) -> pulumi.Output[builtins.str]:
        """
        The database node [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "db_node_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[builtins.str]:
        """
        The SSH public key fingerprint for the console connection.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        Information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Output[builtins.str]:
        """
        The SSH public key used to authenticate the console connection.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="serviceHostKeyFingerprint")
    def service_host_key_fingerprint(self) -> pulumi.Output[builtins.str]:
        """
        The SSH public key's fingerprint for the console connection service host.
        """
        return pulumi.get(self, "service_host_key_fingerprint")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the console connection.
        """
        return pulumi.get(self, "state")

