# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAutonomousDatabaseSoftwareImageResult',
    'AwaitableGetAutonomousDatabaseSoftwareImageResult',
    'get_autonomous_database_software_image',
    'get_autonomous_database_software_image_output',
]

@pulumi.output_type
class GetAutonomousDatabaseSoftwareImageResult:
    """
    A collection of values returned by getAutonomousDatabaseSoftwareImage.
    """
    def __init__(__self__, autonomous_database_software_image_id=None, autonomous_dsi_one_off_patches=None, compartment_id=None, database_version=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, image_shape_family=None, lifecycle_details=None, release_update=None, source_cdb_id=None, state=None, time_created=None):
        if autonomous_database_software_image_id and not isinstance(autonomous_database_software_image_id, str):
            raise TypeError("Expected argument 'autonomous_database_software_image_id' to be a str")
        pulumi.set(__self__, "autonomous_database_software_image_id", autonomous_database_software_image_id)
        if autonomous_dsi_one_off_patches and not isinstance(autonomous_dsi_one_off_patches, list):
            raise TypeError("Expected argument 'autonomous_dsi_one_off_patches' to be a list")
        pulumi.set(__self__, "autonomous_dsi_one_off_patches", autonomous_dsi_one_off_patches)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if database_version and not isinstance(database_version, str):
            raise TypeError("Expected argument 'database_version' to be a str")
        pulumi.set(__self__, "database_version", database_version)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_shape_family and not isinstance(image_shape_family, str):
            raise TypeError("Expected argument 'image_shape_family' to be a str")
        pulumi.set(__self__, "image_shape_family", image_shape_family)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if release_update and not isinstance(release_update, str):
            raise TypeError("Expected argument 'release_update' to be a str")
        pulumi.set(__self__, "release_update", release_update)
        if source_cdb_id and not isinstance(source_cdb_id, str):
            raise TypeError("Expected argument 'source_cdb_id' to be a str")
        pulumi.set(__self__, "source_cdb_id", source_cdb_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="autonomousDatabaseSoftwareImageId")
    def autonomous_database_software_image_id(self) -> builtins.str:
        return pulumi.get(self, "autonomous_database_software_image_id")

    @property
    @pulumi.getter(name="autonomousDsiOneOffPatches")
    def autonomous_dsi_one_off_patches(self) -> Sequence[builtins.str]:
        """
        One-off patches included in the Autonomous Database Software Image
        """
        return pulumi.get(self, "autonomous_dsi_one_off_patches")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> builtins.str:
        """
        The database version with which the Autonomous Database Software Image is to be built.
        """
        return pulumi.get(self, "database_version")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The user-friendly name for the Autonomous Database Software Image. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Database Software Image.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageShapeFamily")
    def image_shape_family(self) -> builtins.str:
        """
        To what shape the image is meant for.
        """
        return pulumi.get(self, "image_shape_family")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Detailed message for the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="releaseUpdate")
    def release_update(self) -> builtins.str:
        """
        The Release Updates.
        """
        return pulumi.get(self, "release_update")

    @property
    @pulumi.getter(name="sourceCdbId")
    def source_cdb_id(self) -> builtins.str:
        return pulumi.get(self, "source_cdb_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the Autonomous Database Software Image.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the Autonomous Database Software Image was created.
        """
        return pulumi.get(self, "time_created")


class AwaitableGetAutonomousDatabaseSoftwareImageResult(GetAutonomousDatabaseSoftwareImageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousDatabaseSoftwareImageResult(
            autonomous_database_software_image_id=self.autonomous_database_software_image_id,
            autonomous_dsi_one_off_patches=self.autonomous_dsi_one_off_patches,
            compartment_id=self.compartment_id,
            database_version=self.database_version,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            image_shape_family=self.image_shape_family,
            lifecycle_details=self.lifecycle_details,
            release_update=self.release_update,
            source_cdb_id=self.source_cdb_id,
            state=self.state,
            time_created=self.time_created)


def get_autonomous_database_software_image(autonomous_database_software_image_id: Optional[builtins.str] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousDatabaseSoftwareImageResult:
    """
    This data source provides details about a specific Autonomous Database Software Image resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified Autonomous Database Software Image.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_database_software_image = oci.Database.get_autonomous_database_software_image(autonomous_database_software_image_id=test_autonomous_database_software_image_oci_database_autonomous_database_software_image["id"])
    ```


    :param builtins.str autonomous_database_software_image_id: The Autonomous Database Software Image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['autonomousDatabaseSoftwareImageId'] = autonomous_database_software_image_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousDatabaseSoftwareImage:getAutonomousDatabaseSoftwareImage', __args__, opts=opts, typ=GetAutonomousDatabaseSoftwareImageResult).value

    return AwaitableGetAutonomousDatabaseSoftwareImageResult(
        autonomous_database_software_image_id=pulumi.get(__ret__, 'autonomous_database_software_image_id'),
        autonomous_dsi_one_off_patches=pulumi.get(__ret__, 'autonomous_dsi_one_off_patches'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        database_version=pulumi.get(__ret__, 'database_version'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        image_shape_family=pulumi.get(__ret__, 'image_shape_family'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        release_update=pulumi.get(__ret__, 'release_update'),
        source_cdb_id=pulumi.get(__ret__, 'source_cdb_id'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'))
def get_autonomous_database_software_image_output(autonomous_database_software_image_id: Optional[pulumi.Input[builtins.str]] = None,
                                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAutonomousDatabaseSoftwareImageResult]:
    """
    This data source provides details about a specific Autonomous Database Software Image resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified Autonomous Database Software Image.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_database_software_image = oci.Database.get_autonomous_database_software_image(autonomous_database_software_image_id=test_autonomous_database_software_image_oci_database_autonomous_database_software_image["id"])
    ```


    :param builtins.str autonomous_database_software_image_id: The Autonomous Database Software Image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['autonomousDatabaseSoftwareImageId'] = autonomous_database_software_image_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getAutonomousDatabaseSoftwareImage:getAutonomousDatabaseSoftwareImage', __args__, opts=opts, typ=GetAutonomousDatabaseSoftwareImageResult)
    return __ret__.apply(lambda __response__: GetAutonomousDatabaseSoftwareImageResult(
        autonomous_database_software_image_id=pulumi.get(__response__, 'autonomous_database_software_image_id'),
        autonomous_dsi_one_off_patches=pulumi.get(__response__, 'autonomous_dsi_one_off_patches'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        database_version=pulumi.get(__response__, 'database_version'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        image_shape_family=pulumi.get(__response__, 'image_shape_family'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        release_update=pulumi.get(__response__, 'release_update'),
        source_cdb_id=pulumi.get(__response__, 'source_cdb_id'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created')))
