# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetExadbVmClusterResult',
    'AwaitableGetExadbVmClusterResult',
    'get_exadb_vm_cluster',
    'get_exadb_vm_cluster_output',
]

@pulumi.output_type
class GetExadbVmClusterResult:
    """
    A collection of values returned by getExadbVmCluster.
    """
    def __init__(__self__, availability_domain=None, backup_network_nsg_ids=None, backup_subnet_id=None, cluster_name=None, cluster_placement_group_id=None, compartment_id=None, data_collection_options=None, defined_tags=None, display_name=None, domain=None, exadb_vm_cluster_id=None, exascale_db_storage_vault_id=None, freeform_tags=None, gi_version=None, grid_image_id=None, grid_image_type=None, hostname=None, id=None, iorm_config_caches=None, last_update_history_entry_id=None, license_model=None, lifecycle_details=None, listener_port=None, node_configs=None, node_resources=None, nsg_ids=None, private_zone_id=None, scan_dns_name=None, scan_dns_record_id=None, scan_ip_ids=None, scan_listener_port_tcp=None, scan_listener_port_tcp_ssl=None, security_attributes=None, shape=None, ssh_public_keys=None, state=None, subnet_id=None, subscription_id=None, system_tags=None, system_version=None, time_created=None, time_zone=None, vip_ids=None, zone_id=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if backup_network_nsg_ids and not isinstance(backup_network_nsg_ids, list):
            raise TypeError("Expected argument 'backup_network_nsg_ids' to be a list")
        pulumi.set(__self__, "backup_network_nsg_ids", backup_network_nsg_ids)
        if backup_subnet_id and not isinstance(backup_subnet_id, str):
            raise TypeError("Expected argument 'backup_subnet_id' to be a str")
        pulumi.set(__self__, "backup_subnet_id", backup_subnet_id)
        if cluster_name and not isinstance(cluster_name, str):
            raise TypeError("Expected argument 'cluster_name' to be a str")
        pulumi.set(__self__, "cluster_name", cluster_name)
        if cluster_placement_group_id and not isinstance(cluster_placement_group_id, str):
            raise TypeError("Expected argument 'cluster_placement_group_id' to be a str")
        pulumi.set(__self__, "cluster_placement_group_id", cluster_placement_group_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if data_collection_options and not isinstance(data_collection_options, list):
            raise TypeError("Expected argument 'data_collection_options' to be a list")
        pulumi.set(__self__, "data_collection_options", data_collection_options)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if exadb_vm_cluster_id and not isinstance(exadb_vm_cluster_id, str):
            raise TypeError("Expected argument 'exadb_vm_cluster_id' to be a str")
        pulumi.set(__self__, "exadb_vm_cluster_id", exadb_vm_cluster_id)
        if exascale_db_storage_vault_id and not isinstance(exascale_db_storage_vault_id, str):
            raise TypeError("Expected argument 'exascale_db_storage_vault_id' to be a str")
        pulumi.set(__self__, "exascale_db_storage_vault_id", exascale_db_storage_vault_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if gi_version and not isinstance(gi_version, str):
            raise TypeError("Expected argument 'gi_version' to be a str")
        pulumi.set(__self__, "gi_version", gi_version)
        if grid_image_id and not isinstance(grid_image_id, str):
            raise TypeError("Expected argument 'grid_image_id' to be a str")
        pulumi.set(__self__, "grid_image_id", grid_image_id)
        if grid_image_type and not isinstance(grid_image_type, str):
            raise TypeError("Expected argument 'grid_image_type' to be a str")
        pulumi.set(__self__, "grid_image_type", grid_image_type)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if iorm_config_caches and not isinstance(iorm_config_caches, list):
            raise TypeError("Expected argument 'iorm_config_caches' to be a list")
        pulumi.set(__self__, "iorm_config_caches", iorm_config_caches)
        if last_update_history_entry_id and not isinstance(last_update_history_entry_id, str):
            raise TypeError("Expected argument 'last_update_history_entry_id' to be a str")
        pulumi.set(__self__, "last_update_history_entry_id", last_update_history_entry_id)
        if license_model and not isinstance(license_model, str):
            raise TypeError("Expected argument 'license_model' to be a str")
        pulumi.set(__self__, "license_model", license_model)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if listener_port and not isinstance(listener_port, str):
            raise TypeError("Expected argument 'listener_port' to be a str")
        pulumi.set(__self__, "listener_port", listener_port)
        if node_configs and not isinstance(node_configs, list):
            raise TypeError("Expected argument 'node_configs' to be a list")
        pulumi.set(__self__, "node_configs", node_configs)
        if node_resources and not isinstance(node_resources, list):
            raise TypeError("Expected argument 'node_resources' to be a list")
        pulumi.set(__self__, "node_resources", node_resources)
        if nsg_ids and not isinstance(nsg_ids, list):
            raise TypeError("Expected argument 'nsg_ids' to be a list")
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        if private_zone_id and not isinstance(private_zone_id, str):
            raise TypeError("Expected argument 'private_zone_id' to be a str")
        pulumi.set(__self__, "private_zone_id", private_zone_id)
        if scan_dns_name and not isinstance(scan_dns_name, str):
            raise TypeError("Expected argument 'scan_dns_name' to be a str")
        pulumi.set(__self__, "scan_dns_name", scan_dns_name)
        if scan_dns_record_id and not isinstance(scan_dns_record_id, str):
            raise TypeError("Expected argument 'scan_dns_record_id' to be a str")
        pulumi.set(__self__, "scan_dns_record_id", scan_dns_record_id)
        if scan_ip_ids and not isinstance(scan_ip_ids, list):
            raise TypeError("Expected argument 'scan_ip_ids' to be a list")
        pulumi.set(__self__, "scan_ip_ids", scan_ip_ids)
        if scan_listener_port_tcp and not isinstance(scan_listener_port_tcp, int):
            raise TypeError("Expected argument 'scan_listener_port_tcp' to be a int")
        pulumi.set(__self__, "scan_listener_port_tcp", scan_listener_port_tcp)
        if scan_listener_port_tcp_ssl and not isinstance(scan_listener_port_tcp_ssl, int):
            raise TypeError("Expected argument 'scan_listener_port_tcp_ssl' to be a int")
        pulumi.set(__self__, "scan_listener_port_tcp_ssl", scan_listener_port_tcp_ssl)
        if security_attributes and not isinstance(security_attributes, dict):
            raise TypeError("Expected argument 'security_attributes' to be a dict")
        pulumi.set(__self__, "security_attributes", security_attributes)
        if shape and not isinstance(shape, str):
            raise TypeError("Expected argument 'shape' to be a str")
        pulumi.set(__self__, "shape", shape)
        if ssh_public_keys and not isinstance(ssh_public_keys, list):
            raise TypeError("Expected argument 'ssh_public_keys' to be a list")
        pulumi.set(__self__, "ssh_public_keys", ssh_public_keys)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if system_version and not isinstance(system_version, str):
            raise TypeError("Expected argument 'system_version' to be a str")
        pulumi.set(__self__, "system_version", system_version)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_zone and not isinstance(time_zone, str):
            raise TypeError("Expected argument 'time_zone' to be a str")
        pulumi.set(__self__, "time_zone", time_zone)
        if vip_ids and not isinstance(vip_ids, list):
            raise TypeError("Expected argument 'vip_ids' to be a list")
        pulumi.set(__self__, "vip_ids", vip_ids)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        The name of the availability domain in which the Exadata VM cluster on Exascale Infrastructure is located.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="backupNetworkNsgIds")
    def backup_network_nsg_ids(self) -> Sequence[builtins.str]:
        """
        A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        """
        return pulumi.get(self, "backup_network_nsg_ids")

    @property
    @pulumi.getter(name="backupSubnetId")
    def backup_subnet_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup network subnet associated with the Exadata VM cluster on Exascale Infrastructure.
        """
        return pulumi.get(self, "backup_subnet_id")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> builtins.str:
        """
        The cluster name for Exadata VM cluster on Exascale Infrastructure. The cluster name must begin with an alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted. The cluster name can be no longer than 11 characters and is not case sensitive.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group of the Exadata Infrastructure.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dataCollectionOptions")
    def data_collection_options(self) -> Sequence['outputs.GetExadbVmClusterDataCollectionOptionResult']:
        """
        Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        """
        return pulumi.get(self, "data_collection_options")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The user-friendly name for the Exadata VM cluster on Exascale Infrastructure. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def domain(self) -> builtins.str:
        """
        A domain name used for the Exadata VM cluster on Exascale Infrastructure. If the Oracle-provided internet and VCN resolver is enabled for the specified subnet, then the domain name for the subnet is used (do not provide one). Otherwise, provide a valid DNS domain name. Hyphens (-) are not permitted.  Applies to Exadata Database Service on Exascale Infrastructure only.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="exadbVmClusterId")
    def exadb_vm_cluster_id(self) -> builtins.str:
        return pulumi.get(self, "exadb_vm_cluster_id")

    @property
    @pulumi.getter(name="exascaleDbStorageVaultId")
    def exascale_db_storage_vault_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Storage Vault.
        """
        return pulumi.get(self, "exascale_db_storage_vault_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="giVersion")
    def gi_version(self) -> builtins.str:
        """
        A valid Oracle Grid Infrastructure (GI) software version.
        """
        return pulumi.get(self, "gi_version")

    @property
    @pulumi.getter(name="gridImageId")
    def grid_image_id(self) -> builtins.str:
        """
        Grid Setup will be done using this grid image id.
        """
        return pulumi.get(self, "grid_image_id")

    @property
    @pulumi.getter(name="gridImageType")
    def grid_image_type(self) -> builtins.str:
        """
        The type of Grid Image
        """
        return pulumi.get(self, "grid_image_type")

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        """
        The hostname for the Exadata VM cluster on Exascale Infrastructure. The hostname must begin with an alphabetic character, and  can contain alphanumeric characters and hyphens (-). For Exadata systems, the maximum length of the hostname is 12 characters.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata VM cluster on Exascale Infrastructure.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="iormConfigCaches")
    def iorm_config_caches(self) -> Sequence['outputs.GetExadbVmClusterIormConfigCachResult']:
        """
        The IORM settings of the Exadata DB system.
        """
        return pulumi.get(self, "iorm_config_caches")

    @property
    @pulumi.getter(name="lastUpdateHistoryEntryId")
    def last_update_history_entry_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance update history entry. This value is updated when a maintenance update starts.
        """
        return pulumi.get(self, "last_update_history_entry_id")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> builtins.str:
        """
        The Oracle license model that applies to the Exadata VM cluster on Exascale Infrastructure. The default is BRING_YOUR_OWN_LICENSE.
        """
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> builtins.str:
        """
        The port number configured for the listener on the Exadata VM cluster on Exascale Infrastructure.
        """
        return pulumi.get(self, "listener_port")

    @property
    @pulumi.getter(name="nodeConfigs")
    def node_configs(self) -> Sequence['outputs.GetExadbVmClusterNodeConfigResult']:
        """
        The configuration of each node in the Exadata VM cluster on Exascale Infrastructure.
        """
        return pulumi.get(self, "node_configs")

    @property
    @pulumi.getter(name="nodeResources")
    def node_resources(self) -> Sequence['outputs.GetExadbVmClusterNodeResourceResult']:
        """
        The list of node in the Exadata VM cluster on Exascale Infrastructure.
        """
        return pulumi.get(self, "node_resources")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[builtins.str]:
        """
        The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
        * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="privateZoneId")
    def private_zone_id(self) -> builtins.str:
        """
        The private zone ID in which you want DNS records to be created.
        """
        return pulumi.get(self, "private_zone_id")

    @property
    @pulumi.getter(name="scanDnsName")
    def scan_dns_name(self) -> builtins.str:
        """
        The FQDN of the DNS record for the SCAN IP addresses that are associated with the Exadata VM cluster on Exascale Infrastructure.
        """
        return pulumi.get(self, "scan_dns_name")

    @property
    @pulumi.getter(name="scanDnsRecordId")
    def scan_dns_record_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DNS record for the SCAN IP addresses that are associated with the Exadata VM cluster on Exascale Infrastructure.
        """
        return pulumi.get(self, "scan_dns_record_id")

    @property
    @pulumi.getter(name="scanIpIds")
    def scan_ip_ids(self) -> Sequence[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Single Client Access Name (SCAN) IP addresses associated with the Exadata VM cluster on Exascale Infrastructure. SCAN IP addresses are typically used for load balancing and are not assigned to any interface. Oracle Clusterware directs the requests to the appropriate nodes in the cluster.
        """
        return pulumi.get(self, "scan_ip_ids")

    @property
    @pulumi.getter(name="scanListenerPortTcp")
    def scan_listener_port_tcp(self) -> builtins.int:
        """
        The TCP Single Client Access Name (SCAN) port. The default port is 1521.
        """
        return pulumi.get(self, "scan_listener_port_tcp")

    @property
    @pulumi.getter(name="scanListenerPortTcpSsl")
    def scan_listener_port_tcp_ssl(self) -> builtins.int:
        """
        The Secured Communication (TCPS) protocol Single Client Access Name (SCAN) port. The default port is 2484.
        """
        return pulumi.get(self, "scan_listener_port_tcp_ssl")

    @property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> Mapping[str, builtins.str]:
        """
        Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        """
        return pulumi.get(self, "security_attributes")

    @property
    @pulumi.getter
    def shape(self) -> builtins.str:
        """
        The shape of the Exadata VM cluster on Exascale Infrastructure resource
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> Sequence[builtins.str]:
        """
        The public key portion of one or more key pairs used for SSH access to the Exadata VM cluster on Exascale Infrastructure.
        """
        return pulumi.get(self, "ssh_public_keys")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the Exadata VM cluster on Exascale Infrastructure.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet associated with the Exadata VM cluster on Exascale Infrastructure.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="systemVersion")
    def system_version(self) -> builtins.str:
        """
        Operating system version of the image.
        """
        return pulumi.get(self, "system_version")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time that the Exadata VM cluster on Exascale Infrastructure was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> builtins.str:
        """
        The time zone to use for the Exadata VM cluster on Exascale Infrastructure. For details, see [Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="vipIds")
    def vip_ids(self) -> Sequence[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the virtual IP (VIP) addresses associated with the Exadata VM cluster on Exascale Infrastructure.  The Cluster Ready Services (CRS) creates and maintains one VIP address for each node in the Exadata Cloud Service instance to  enable failover. If one node fails, then the VIP is reassigned to another active node in the cluster.
        """
        return pulumi.get(self, "vip_ids")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        The OCID of the zone with which the Exadata VM cluster on Exascale Infrastructure is associated.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetExadbVmClusterResult(GetExadbVmClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExadbVmClusterResult(
            availability_domain=self.availability_domain,
            backup_network_nsg_ids=self.backup_network_nsg_ids,
            backup_subnet_id=self.backup_subnet_id,
            cluster_name=self.cluster_name,
            cluster_placement_group_id=self.cluster_placement_group_id,
            compartment_id=self.compartment_id,
            data_collection_options=self.data_collection_options,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            domain=self.domain,
            exadb_vm_cluster_id=self.exadb_vm_cluster_id,
            exascale_db_storage_vault_id=self.exascale_db_storage_vault_id,
            freeform_tags=self.freeform_tags,
            gi_version=self.gi_version,
            grid_image_id=self.grid_image_id,
            grid_image_type=self.grid_image_type,
            hostname=self.hostname,
            id=self.id,
            iorm_config_caches=self.iorm_config_caches,
            last_update_history_entry_id=self.last_update_history_entry_id,
            license_model=self.license_model,
            lifecycle_details=self.lifecycle_details,
            listener_port=self.listener_port,
            node_configs=self.node_configs,
            node_resources=self.node_resources,
            nsg_ids=self.nsg_ids,
            private_zone_id=self.private_zone_id,
            scan_dns_name=self.scan_dns_name,
            scan_dns_record_id=self.scan_dns_record_id,
            scan_ip_ids=self.scan_ip_ids,
            scan_listener_port_tcp=self.scan_listener_port_tcp,
            scan_listener_port_tcp_ssl=self.scan_listener_port_tcp_ssl,
            security_attributes=self.security_attributes,
            shape=self.shape,
            ssh_public_keys=self.ssh_public_keys,
            state=self.state,
            subnet_id=self.subnet_id,
            subscription_id=self.subscription_id,
            system_tags=self.system_tags,
            system_version=self.system_version,
            time_created=self.time_created,
            time_zone=self.time_zone,
            vip_ids=self.vip_ids,
            zone_id=self.zone_id)


def get_exadb_vm_cluster(exadb_vm_cluster_id: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExadbVmClusterResult:
    """
    This data source provides details about a specific Exadb Vm Cluster resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified Exadata VM cluster on Exascale Infrastructure. Applies to Exadata Database Service on Exascale Infrastructure only.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_exadb_vm_cluster = oci.Database.get_exadb_vm_cluster(exadb_vm_cluster_id=test_exadb_vm_cluster_oci_database_exadb_vm_cluster["id"])
    ```


    :param builtins.str exadb_vm_cluster_id: The Exadata VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) on Exascale Infrastructure.
    """
    __args__ = dict()
    __args__['exadbVmClusterId'] = exadb_vm_cluster_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getExadbVmCluster:getExadbVmCluster', __args__, opts=opts, typ=GetExadbVmClusterResult).value

    return AwaitableGetExadbVmClusterResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        backup_network_nsg_ids=pulumi.get(__ret__, 'backup_network_nsg_ids'),
        backup_subnet_id=pulumi.get(__ret__, 'backup_subnet_id'),
        cluster_name=pulumi.get(__ret__, 'cluster_name'),
        cluster_placement_group_id=pulumi.get(__ret__, 'cluster_placement_group_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        data_collection_options=pulumi.get(__ret__, 'data_collection_options'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        domain=pulumi.get(__ret__, 'domain'),
        exadb_vm_cluster_id=pulumi.get(__ret__, 'exadb_vm_cluster_id'),
        exascale_db_storage_vault_id=pulumi.get(__ret__, 'exascale_db_storage_vault_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        gi_version=pulumi.get(__ret__, 'gi_version'),
        grid_image_id=pulumi.get(__ret__, 'grid_image_id'),
        grid_image_type=pulumi.get(__ret__, 'grid_image_type'),
        hostname=pulumi.get(__ret__, 'hostname'),
        id=pulumi.get(__ret__, 'id'),
        iorm_config_caches=pulumi.get(__ret__, 'iorm_config_caches'),
        last_update_history_entry_id=pulumi.get(__ret__, 'last_update_history_entry_id'),
        license_model=pulumi.get(__ret__, 'license_model'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        listener_port=pulumi.get(__ret__, 'listener_port'),
        node_configs=pulumi.get(__ret__, 'node_configs'),
        node_resources=pulumi.get(__ret__, 'node_resources'),
        nsg_ids=pulumi.get(__ret__, 'nsg_ids'),
        private_zone_id=pulumi.get(__ret__, 'private_zone_id'),
        scan_dns_name=pulumi.get(__ret__, 'scan_dns_name'),
        scan_dns_record_id=pulumi.get(__ret__, 'scan_dns_record_id'),
        scan_ip_ids=pulumi.get(__ret__, 'scan_ip_ids'),
        scan_listener_port_tcp=pulumi.get(__ret__, 'scan_listener_port_tcp'),
        scan_listener_port_tcp_ssl=pulumi.get(__ret__, 'scan_listener_port_tcp_ssl'),
        security_attributes=pulumi.get(__ret__, 'security_attributes'),
        shape=pulumi.get(__ret__, 'shape'),
        ssh_public_keys=pulumi.get(__ret__, 'ssh_public_keys'),
        state=pulumi.get(__ret__, 'state'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        subscription_id=pulumi.get(__ret__, 'subscription_id'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        system_version=pulumi.get(__ret__, 'system_version'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_zone=pulumi.get(__ret__, 'time_zone'),
        vip_ids=pulumi.get(__ret__, 'vip_ids'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_exadb_vm_cluster_output(exadb_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExadbVmClusterResult]:
    """
    This data source provides details about a specific Exadb Vm Cluster resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified Exadata VM cluster on Exascale Infrastructure. Applies to Exadata Database Service on Exascale Infrastructure only.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_exadb_vm_cluster = oci.Database.get_exadb_vm_cluster(exadb_vm_cluster_id=test_exadb_vm_cluster_oci_database_exadb_vm_cluster["id"])
    ```


    :param builtins.str exadb_vm_cluster_id: The Exadata VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) on Exascale Infrastructure.
    """
    __args__ = dict()
    __args__['exadbVmClusterId'] = exadb_vm_cluster_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getExadbVmCluster:getExadbVmCluster', __args__, opts=opts, typ=GetExadbVmClusterResult)
    return __ret__.apply(lambda __response__: GetExadbVmClusterResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        backup_network_nsg_ids=pulumi.get(__response__, 'backup_network_nsg_ids'),
        backup_subnet_id=pulumi.get(__response__, 'backup_subnet_id'),
        cluster_name=pulumi.get(__response__, 'cluster_name'),
        cluster_placement_group_id=pulumi.get(__response__, 'cluster_placement_group_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        data_collection_options=pulumi.get(__response__, 'data_collection_options'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        domain=pulumi.get(__response__, 'domain'),
        exadb_vm_cluster_id=pulumi.get(__response__, 'exadb_vm_cluster_id'),
        exascale_db_storage_vault_id=pulumi.get(__response__, 'exascale_db_storage_vault_id'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        gi_version=pulumi.get(__response__, 'gi_version'),
        grid_image_id=pulumi.get(__response__, 'grid_image_id'),
        grid_image_type=pulumi.get(__response__, 'grid_image_type'),
        hostname=pulumi.get(__response__, 'hostname'),
        id=pulumi.get(__response__, 'id'),
        iorm_config_caches=pulumi.get(__response__, 'iorm_config_caches'),
        last_update_history_entry_id=pulumi.get(__response__, 'last_update_history_entry_id'),
        license_model=pulumi.get(__response__, 'license_model'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        listener_port=pulumi.get(__response__, 'listener_port'),
        node_configs=pulumi.get(__response__, 'node_configs'),
        node_resources=pulumi.get(__response__, 'node_resources'),
        nsg_ids=pulumi.get(__response__, 'nsg_ids'),
        private_zone_id=pulumi.get(__response__, 'private_zone_id'),
        scan_dns_name=pulumi.get(__response__, 'scan_dns_name'),
        scan_dns_record_id=pulumi.get(__response__, 'scan_dns_record_id'),
        scan_ip_ids=pulumi.get(__response__, 'scan_ip_ids'),
        scan_listener_port_tcp=pulumi.get(__response__, 'scan_listener_port_tcp'),
        scan_listener_port_tcp_ssl=pulumi.get(__response__, 'scan_listener_port_tcp_ssl'),
        security_attributes=pulumi.get(__response__, 'security_attributes'),
        shape=pulumi.get(__response__, 'shape'),
        ssh_public_keys=pulumi.get(__response__, 'ssh_public_keys'),
        state=pulumi.get(__response__, 'state'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        subscription_id=pulumi.get(__response__, 'subscription_id'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        system_version=pulumi.get(__response__, 'system_version'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_zone=pulumi.get(__response__, 'time_zone'),
        vip_ids=pulumi.get(__response__, 'vip_ids'),
        zone_id=pulumi.get(__response__, 'zone_id')))
