# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetExternalContainerDatabaseResult',
    'AwaitableGetExternalContainerDatabaseResult',
    'get_external_container_database',
    'get_external_container_database_output',
]

@pulumi.output_type
class GetExternalContainerDatabaseResult:
    """
    A collection of values returned by getExternalContainerDatabase.
    """
    def __init__(__self__, character_set=None, compartment_id=None, database_configuration=None, database_edition=None, database_management_configs=None, database_version=None, db_id=None, db_packs=None, db_unique_name=None, defined_tags=None, display_name=None, external_container_database_id=None, freeform_tags=None, id=None, lifecycle_details=None, ncharacter_set=None, stack_monitoring_configs=None, state=None, time_created=None, time_zone=None):
        if character_set and not isinstance(character_set, str):
            raise TypeError("Expected argument 'character_set' to be a str")
        pulumi.set(__self__, "character_set", character_set)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if database_configuration and not isinstance(database_configuration, str):
            raise TypeError("Expected argument 'database_configuration' to be a str")
        pulumi.set(__self__, "database_configuration", database_configuration)
        if database_edition and not isinstance(database_edition, str):
            raise TypeError("Expected argument 'database_edition' to be a str")
        pulumi.set(__self__, "database_edition", database_edition)
        if database_management_configs and not isinstance(database_management_configs, list):
            raise TypeError("Expected argument 'database_management_configs' to be a list")
        pulumi.set(__self__, "database_management_configs", database_management_configs)
        if database_version and not isinstance(database_version, str):
            raise TypeError("Expected argument 'database_version' to be a str")
        pulumi.set(__self__, "database_version", database_version)
        if db_id and not isinstance(db_id, str):
            raise TypeError("Expected argument 'db_id' to be a str")
        pulumi.set(__self__, "db_id", db_id)
        if db_packs and not isinstance(db_packs, str):
            raise TypeError("Expected argument 'db_packs' to be a str")
        pulumi.set(__self__, "db_packs", db_packs)
        if db_unique_name and not isinstance(db_unique_name, str):
            raise TypeError("Expected argument 'db_unique_name' to be a str")
        pulumi.set(__self__, "db_unique_name", db_unique_name)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if external_container_database_id and not isinstance(external_container_database_id, str):
            raise TypeError("Expected argument 'external_container_database_id' to be a str")
        pulumi.set(__self__, "external_container_database_id", external_container_database_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if ncharacter_set and not isinstance(ncharacter_set, str):
            raise TypeError("Expected argument 'ncharacter_set' to be a str")
        pulumi.set(__self__, "ncharacter_set", ncharacter_set)
        if stack_monitoring_configs and not isinstance(stack_monitoring_configs, list):
            raise TypeError("Expected argument 'stack_monitoring_configs' to be a list")
        pulumi.set(__self__, "stack_monitoring_configs", stack_monitoring_configs)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_zone and not isinstance(time_zone, str):
            raise TypeError("Expected argument 'time_zone' to be a str")
        pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> builtins.str:
        """
        The character set of the external database.
        """
        return pulumi.get(self, "character_set")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseConfiguration")
    def database_configuration(self) -> builtins.str:
        """
        The Oracle Database configuration
        """
        return pulumi.get(self, "database_configuration")

    @property
    @pulumi.getter(name="databaseEdition")
    def database_edition(self) -> builtins.str:
        """
        The Oracle Database Edition that applies to all the databases on the DB system. Exadata DB systems and 2-node RAC DB systems require ENTERPRISE_EDITION_EXTREME_PERFORMANCE.
        """
        return pulumi.get(self, "database_edition")

    @property
    @pulumi.getter(name="databaseManagementConfigs")
    def database_management_configs(self) -> Sequence['outputs.GetExternalContainerDatabaseDatabaseManagementConfigResult']:
        """
        The configuration of the Database Management service.
        """
        return pulumi.get(self, "database_management_configs")

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> builtins.str:
        """
        The Oracle Database version.
        """
        return pulumi.get(self, "database_version")

    @property
    @pulumi.getter(name="dbId")
    def db_id(self) -> builtins.str:
        """
        The Oracle Database ID, which identifies an Oracle Database located outside of Oracle Cloud.
        """
        return pulumi.get(self, "db_id")

    @property
    @pulumi.getter(name="dbPacks")
    def db_packs(self) -> builtins.str:
        """
        The database packs licensed for the external Oracle Database.
        """
        return pulumi.get(self, "db_packs")

    @property
    @pulumi.getter(name="dbUniqueName")
    def db_unique_name(self) -> builtins.str:
        """
        The `DB_UNIQUE_NAME` of the external database.
        """
        return pulumi.get(self, "db_unique_name")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The user-friendly name for the external database. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externalContainerDatabaseId")
    def external_container_database_id(self) -> builtins.str:
        return pulumi.get(self, "external_container_database_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure external database resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="ncharacterSet")
    def ncharacter_set(self) -> builtins.str:
        """
        The national character of the external database.
        """
        return pulumi.get(self, "ncharacter_set")

    @property
    @pulumi.getter(name="stackMonitoringConfigs")
    def stack_monitoring_configs(self) -> Sequence['outputs.GetExternalContainerDatabaseStackMonitoringConfigResult']:
        """
        The configuration of Stack Monitoring for the external database.
        """
        return pulumi.get(self, "stack_monitoring_configs")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the Oracle Cloud Infrastructure external database resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the database was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> builtins.str:
        """
        The time zone of the external database. It is a time zone offset (a character type in the format '[+|-]TZH:TZM') or a time zone region name, depending on how the time zone value was specified when the database was created / last altered.
        """
        return pulumi.get(self, "time_zone")


class AwaitableGetExternalContainerDatabaseResult(GetExternalContainerDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalContainerDatabaseResult(
            character_set=self.character_set,
            compartment_id=self.compartment_id,
            database_configuration=self.database_configuration,
            database_edition=self.database_edition,
            database_management_configs=self.database_management_configs,
            database_version=self.database_version,
            db_id=self.db_id,
            db_packs=self.db_packs,
            db_unique_name=self.db_unique_name,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            external_container_database_id=self.external_container_database_id,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            ncharacter_set=self.ncharacter_set,
            stack_monitoring_configs=self.stack_monitoring_configs,
            state=self.state,
            time_created=self.time_created,
            time_zone=self.time_zone)


def get_external_container_database(external_container_database_id: Optional[builtins.str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalContainerDatabaseResult:
    """
    This data source provides details about a specific External Container Database resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified external container database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_container_database = oci.Database.get_external_container_database(external_container_database_id=test_external_container_database_oci_database_external_container_database["id"])
    ```


    :param builtins.str external_container_database_id: The ExternalContainerDatabase [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['externalContainerDatabaseId'] = external_container_database_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getExternalContainerDatabase:getExternalContainerDatabase', __args__, opts=opts, typ=GetExternalContainerDatabaseResult).value

    return AwaitableGetExternalContainerDatabaseResult(
        character_set=pulumi.get(__ret__, 'character_set'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        database_configuration=pulumi.get(__ret__, 'database_configuration'),
        database_edition=pulumi.get(__ret__, 'database_edition'),
        database_management_configs=pulumi.get(__ret__, 'database_management_configs'),
        database_version=pulumi.get(__ret__, 'database_version'),
        db_id=pulumi.get(__ret__, 'db_id'),
        db_packs=pulumi.get(__ret__, 'db_packs'),
        db_unique_name=pulumi.get(__ret__, 'db_unique_name'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        external_container_database_id=pulumi.get(__ret__, 'external_container_database_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        ncharacter_set=pulumi.get(__ret__, 'ncharacter_set'),
        stack_monitoring_configs=pulumi.get(__ret__, 'stack_monitoring_configs'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_zone=pulumi.get(__ret__, 'time_zone'))
def get_external_container_database_output(external_container_database_id: Optional[pulumi.Input[builtins.str]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExternalContainerDatabaseResult]:
    """
    This data source provides details about a specific External Container Database resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified external container database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_container_database = oci.Database.get_external_container_database(external_container_database_id=test_external_container_database_oci_database_external_container_database["id"])
    ```


    :param builtins.str external_container_database_id: The ExternalContainerDatabase [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['externalContainerDatabaseId'] = external_container_database_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getExternalContainerDatabase:getExternalContainerDatabase', __args__, opts=opts, typ=GetExternalContainerDatabaseResult)
    return __ret__.apply(lambda __response__: GetExternalContainerDatabaseResult(
        character_set=pulumi.get(__response__, 'character_set'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        database_configuration=pulumi.get(__response__, 'database_configuration'),
        database_edition=pulumi.get(__response__, 'database_edition'),
        database_management_configs=pulumi.get(__response__, 'database_management_configs'),
        database_version=pulumi.get(__response__, 'database_version'),
        db_id=pulumi.get(__response__, 'db_id'),
        db_packs=pulumi.get(__response__, 'db_packs'),
        db_unique_name=pulumi.get(__response__, 'db_unique_name'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        external_container_database_id=pulumi.get(__response__, 'external_container_database_id'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        ncharacter_set=pulumi.get(__response__, 'ncharacter_set'),
        stack_monitoring_configs=pulumi.get(__response__, 'stack_monitoring_configs'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_zone=pulumi.get(__response__, 'time_zone')))
