# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSchedulingPoliciesResult',
    'AwaitableGetSchedulingPoliciesResult',
    'get_scheduling_policies',
    'get_scheduling_policies_output',
]

@pulumi.output_type
class GetSchedulingPoliciesResult:
    """
    A collection of values returned by getSchedulingPolicies.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, scheduling_policies=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if scheduling_policies and not isinstance(scheduling_policies, list):
            raise TypeError("Expected argument 'scheduling_policies' to be a list")
        pulumi.set(__self__, "scheduling_policies", scheduling_policies)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        The user-friendly name for the Scheduling Policy. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSchedulingPoliciesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="schedulingPolicies")
    def scheduling_policies(self) -> Sequence['outputs.GetSchedulingPoliciesSchedulingPolicyResult']:
        """
        The list of scheduling_policies.
        """
        return pulumi.get(self, "scheduling_policies")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the Scheduling Policy. Valid states are CREATING, NEEDS_ATTENTION, ACTIVE, UPDATING, FAILED, DELETING and DELETED.
        """
        return pulumi.get(self, "state")


class AwaitableGetSchedulingPoliciesResult(GetSchedulingPoliciesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSchedulingPoliciesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            scheduling_policies=self.scheduling_policies,
            state=self.state)


def get_scheduling_policies(compartment_id: Optional[builtins.str] = None,
                            display_name: Optional[builtins.str] = None,
                            filters: Optional[Sequence[Union['GetSchedulingPoliciesFilterArgs', 'GetSchedulingPoliciesFilterArgsDict']]] = None,
                            state: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSchedulingPoliciesResult:
    """
    This data source provides the list of Scheduling Policies in Oracle Cloud Infrastructure Database service.

    Lists the Scheduling Policy resources in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduling_policies = oci.Database.get_scheduling_policies(compartment_id=compartment_id,
        display_name=scheduling_policy_display_name,
        state=scheduling_policy_state)
    ```


    :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getSchedulingPolicies:getSchedulingPolicies', __args__, opts=opts, typ=GetSchedulingPoliciesResult).value

    return AwaitableGetSchedulingPoliciesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        scheduling_policies=pulumi.get(__ret__, 'scheduling_policies'),
        state=pulumi.get(__ret__, 'state'))
def get_scheduling_policies_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                   display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSchedulingPoliciesFilterArgs', 'GetSchedulingPoliciesFilterArgsDict']]]]] = None,
                                   state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSchedulingPoliciesResult]:
    """
    This data source provides the list of Scheduling Policies in Oracle Cloud Infrastructure Database service.

    Lists the Scheduling Policy resources in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduling_policies = oci.Database.get_scheduling_policies(compartment_id=compartment_id,
        display_name=scheduling_policy_display_name,
        state=scheduling_policy_state)
    ```


    :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getSchedulingPolicies:getSchedulingPolicies', __args__, opts=opts, typ=GetSchedulingPoliciesResult)
    return __ret__.apply(lambda __response__: GetSchedulingPoliciesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        scheduling_policies=pulumi.get(__response__, 'scheduling_policies'),
        state=pulumi.get(__response__, 'state')))
