# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VmClusterNetworkArgs', 'VmClusterNetwork']

@pulumi.input_type
class VmClusterNetworkArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 exadata_infrastructure_id: pulumi.Input[builtins.str],
                 scans: pulumi.Input[Sequence[pulumi.Input['VmClusterNetworkScanArgs']]],
                 vm_networks: pulumi.Input[Sequence[pulumi.Input['VmClusterNetworkVmNetworkArgs']]],
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 dns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 dr_scans: Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterNetworkDrScanArgs']]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ntps: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 validate_vm_cluster_network: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a VmClusterNetwork resource.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[builtins.str] display_name: The user-friendly name for the Exadata Cloud@Customer VM cluster network. The name does not need to be unique.
        :param pulumi.Input[builtins.str] exadata_infrastructure_id: The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Sequence[pulumi.Input['VmClusterNetworkScanArgs']]] scans: (Updatable) The SCAN details.
        :param pulumi.Input[Sequence[pulumi.Input['VmClusterNetworkVmNetworkArgs']]] vm_networks: (Updatable) Details of the client and backup networks.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dns: (Updatable) The list of DNS server IP addresses. Maximum of 3 allowed.
        :param pulumi.Input[Sequence[pulumi.Input['VmClusterNetworkDrScanArgs']]] dr_scans: (Updatable) The SCAN details for DR network
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ntps: (Updatable) The list of NTP server IP addresses. Maximum of 3 allowed.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "exadata_infrastructure_id", exadata_infrastructure_id)
        pulumi.set(__self__, "scans", scans)
        pulumi.set(__self__, "vm_networks", vm_networks)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if dns is not None:
            pulumi.set(__self__, "dns", dns)
        if dr_scans is not None:
            pulumi.set(__self__, "dr_scans", dr_scans)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if ntps is not None:
            pulumi.set(__self__, "ntps", ntps)
        if validate_vm_cluster_network is not None:
            pulumi.set(__self__, "validate_vm_cluster_network", validate_vm_cluster_network)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The user-friendly name for the Exadata Cloud@Customer VM cluster network. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> pulumi.Input[builtins.str]:
        """
        The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @exadata_infrastructure_id.setter
    def exadata_infrastructure_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "exadata_infrastructure_id", value)

    @property
    @pulumi.getter
    def scans(self) -> pulumi.Input[Sequence[pulumi.Input['VmClusterNetworkScanArgs']]]:
        """
        (Updatable) The SCAN details.
        """
        return pulumi.get(self, "scans")

    @scans.setter
    def scans(self, value: pulumi.Input[Sequence[pulumi.Input['VmClusterNetworkScanArgs']]]):
        pulumi.set(self, "scans", value)

    @property
    @pulumi.getter(name="vmNetworks")
    def vm_networks(self) -> pulumi.Input[Sequence[pulumi.Input['VmClusterNetworkVmNetworkArgs']]]:
        """
        (Updatable) Details of the client and backup networks.
        """
        return pulumi.get(self, "vm_networks")

    @vm_networks.setter
    def vm_networks(self, value: pulumi.Input[Sequence[pulumi.Input['VmClusterNetworkVmNetworkArgs']]]):
        pulumi.set(self, "vm_networks", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def dns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) The list of DNS server IP addresses. Maximum of 3 allowed.
        """
        return pulumi.get(self, "dns")

    @dns.setter
    def dns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "dns", value)

    @property
    @pulumi.getter(name="drScans")
    def dr_scans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterNetworkDrScanArgs']]]]:
        """
        (Updatable) The SCAN details for DR network
        """
        return pulumi.get(self, "dr_scans")

    @dr_scans.setter
    def dr_scans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterNetworkDrScanArgs']]]]):
        pulumi.set(self, "dr_scans", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def ntps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) The list of NTP server IP addresses. Maximum of 3 allowed.
        """
        return pulumi.get(self, "ntps")

    @ntps.setter
    def ntps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ntps", value)

    @property
    @pulumi.getter(name="validateVmClusterNetwork")
    def validate_vm_cluster_network(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "validate_vm_cluster_network")

    @validate_vm_cluster_network.setter
    def validate_vm_cluster_network(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "validate_vm_cluster_network", value)


@pulumi.input_type
class _VmClusterNetworkState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 dns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 dr_scans: Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterNetworkDrScanArgs']]]] = None,
                 exadata_infrastructure_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 ntps: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 scans: Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterNetworkScanArgs']]]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 validate_vm_cluster_network: Optional[pulumi.Input[builtins.bool]] = None,
                 vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 vm_networks: Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterNetworkVmNetworkArgs']]]] = None):
        """
        Input properties used for looking up and filtering VmClusterNetwork resources.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] display_name: The user-friendly name for the Exadata Cloud@Customer VM cluster network. The name does not need to be unique.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dns: (Updatable) The list of DNS server IP addresses. Maximum of 3 allowed.
        :param pulumi.Input[Sequence[pulumi.Input['VmClusterNetworkDrScanArgs']]] dr_scans: (Updatable) The SCAN details for DR network
        :param pulumi.Input[builtins.str] exadata_infrastructure_id: The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ntps: (Updatable) The list of NTP server IP addresses. Maximum of 3 allowed.
        :param pulumi.Input[Sequence[pulumi.Input['VmClusterNetworkScanArgs']]] scans: (Updatable) The SCAN details.
        :param pulumi.Input[builtins.str] state: The current state of the VM cluster network nodes. CREATING - The resource is being created REQUIRES_VALIDATION - The resource is created and may not be usable until it is validated. VALIDATING - The resource is being validated and not available to use. VALIDATED - The resource is validated and is available for consumption by VM cluster. VALIDATION_FAILED - The resource validation has failed and might require user input to be corrected. UPDATING - The resource is being updated and not available to use. ALLOCATED - The resource is currently being used by VM cluster. TERMINATING - The resource is being deleted and not available to use. TERMINATED - The resource is deleted and unavailable. FAILED - The resource is in a failed state due to validation or other errors.
        :param pulumi.Input[builtins.str] time_created: The date and time when the VM cluster network was created.
        :param pulumi.Input[builtins.str] vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated VM Cluster.
        :param pulumi.Input[Sequence[pulumi.Input['VmClusterNetworkVmNetworkArgs']]] vm_networks: (Updatable) Details of the client and backup networks.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if dns is not None:
            pulumi.set(__self__, "dns", dns)
        if dr_scans is not None:
            pulumi.set(__self__, "dr_scans", dr_scans)
        if exadata_infrastructure_id is not None:
            pulumi.set(__self__, "exadata_infrastructure_id", exadata_infrastructure_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if ntps is not None:
            pulumi.set(__self__, "ntps", ntps)
        if scans is not None:
            pulumi.set(__self__, "scans", scans)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if validate_vm_cluster_network is not None:
            pulumi.set(__self__, "validate_vm_cluster_network", validate_vm_cluster_network)
        if vm_cluster_id is not None:
            pulumi.set(__self__, "vm_cluster_id", vm_cluster_id)
        if vm_networks is not None:
            pulumi.set(__self__, "vm_networks", vm_networks)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user-friendly name for the Exadata Cloud@Customer VM cluster network. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def dns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) The list of DNS server IP addresses. Maximum of 3 allowed.
        """
        return pulumi.get(self, "dns")

    @dns.setter
    def dns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "dns", value)

    @property
    @pulumi.getter(name="drScans")
    def dr_scans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterNetworkDrScanArgs']]]]:
        """
        (Updatable) The SCAN details for DR network
        """
        return pulumi.get(self, "dr_scans")

    @dr_scans.setter
    def dr_scans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterNetworkDrScanArgs']]]]):
        pulumi.set(self, "dr_scans", value)

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @exadata_infrastructure_id.setter
    def exadata_infrastructure_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "exadata_infrastructure_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def ntps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) The list of NTP server IP addresses. Maximum of 3 allowed.
        """
        return pulumi.get(self, "ntps")

    @ntps.setter
    def ntps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ntps", value)

    @property
    @pulumi.getter
    def scans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterNetworkScanArgs']]]]:
        """
        (Updatable) The SCAN details.
        """
        return pulumi.get(self, "scans")

    @scans.setter
    def scans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterNetworkScanArgs']]]]):
        pulumi.set(self, "scans", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the VM cluster network nodes. CREATING - The resource is being created REQUIRES_VALIDATION - The resource is created and may not be usable until it is validated. VALIDATING - The resource is being validated and not available to use. VALIDATED - The resource is validated and is available for consumption by VM cluster. VALIDATION_FAILED - The resource validation has failed and might require user input to be corrected. UPDATING - The resource is being updated and not available to use. ALLOCATED - The resource is currently being used by VM cluster. TERMINATING - The resource is being deleted and not available to use. TERMINATED - The resource is deleted and unavailable. FAILED - The resource is in a failed state due to validation or other errors.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time when the VM cluster network was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="validateVmClusterNetwork")
    def validate_vm_cluster_network(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "validate_vm_cluster_network")

    @validate_vm_cluster_network.setter
    def validate_vm_cluster_network(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "validate_vm_cluster_network", value)

    @property
    @pulumi.getter(name="vmClusterId")
    def vm_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated VM Cluster.
        """
        return pulumi.get(self, "vm_cluster_id")

    @vm_cluster_id.setter
    def vm_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vm_cluster_id", value)

    @property
    @pulumi.getter(name="vmNetworks")
    def vm_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterNetworkVmNetworkArgs']]]]:
        """
        (Updatable) Details of the client and backup networks.
        """
        return pulumi.get(self, "vm_networks")

    @vm_networks.setter
    def vm_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterNetworkVmNetworkArgs']]]]):
        pulumi.set(self, "vm_networks", value)


@pulumi.type_token("oci:Database/vmClusterNetwork:VmClusterNetwork")
class VmClusterNetwork(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 dns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 dr_scans: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmClusterNetworkDrScanArgs', 'VmClusterNetworkDrScanArgsDict']]]]] = None,
                 exadata_infrastructure_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ntps: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 scans: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmClusterNetworkScanArgs', 'VmClusterNetworkScanArgsDict']]]]] = None,
                 validate_vm_cluster_network: Optional[pulumi.Input[builtins.bool]] = None,
                 vm_networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmClusterNetworkVmNetworkArgs', 'VmClusterNetworkVmNetworkArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource provides the Vm Cluster Network resource in Oracle Cloud Infrastructure Database service.

        Creates the VM cluster network. Applies to Exadata Cloud@Customer instances only.
        To create a cloud VM cluster in an Exadata Cloud Service instance, use the [CreateCloudVmCluster ](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/CloudVmCluster/CreateCloudVmCluster) operation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_vm_cluster_network = oci.database.VmClusterNetwork("test_vm_cluster_network",
            compartment_id=compartment_id,
            display_name=vm_cluster_network_display_name,
            exadata_infrastructure_id=test_exadata_infrastructure["id"],
            scans=[{
                "hostname": vm_cluster_network_scans_hostname,
                "ips": vm_cluster_network_scans_ips,
                "port": vm_cluster_network_scans_port,
                "scan_listener_port_tcp": vm_cluster_network_scans_scan_listener_port_tcp,
                "scan_listener_port_tcp_ssl": vm_cluster_network_scans_scan_listener_port_tcp_ssl,
            }],
            vm_networks=[{
                "network_type": vm_cluster_network_vm_networks_network_type,
                "nodes": [{
                    "hostname": vm_cluster_network_vm_networks_nodes_hostname,
                    "ip": vm_cluster_network_vm_networks_nodes_ip,
                    "db_server_id": test_db_server["id"],
                    "state": vm_cluster_network_vm_networks_nodes_state,
                    "vip": vm_cluster_network_vm_networks_nodes_vip,
                    "vip_hostname": vm_cluster_network_vm_networks_nodes_vip_hostname,
                }],
                "domain_name": test_domain["name"],
                "gateway": vm_cluster_network_vm_networks_gateway,
                "netmask": vm_cluster_network_vm_networks_netmask,
                "vlan_id": vm_cluster_network_vm_networks_vlan_id,
            }],
            defined_tags=vm_cluster_network_defined_tags,
            dns=vm_cluster_network_dns,
            dr_scans=[{
                "hostname": vm_cluster_network_dr_scans_hostname,
                "ips": vm_cluster_network_dr_scans_ips,
                "scan_listener_port_tcp": vm_cluster_network_dr_scans_scan_listener_port_tcp,
            }],
            freeform_tags={
                "Department": "Finance",
            },
            ntps=vm_cluster_network_ntp,
            validate_vm_cluster_network=vm_cluster_network_validate_vm_cluster_network)
        ```

        ## Import

        VmClusterNetworks can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/vmClusterNetwork:VmClusterNetwork test_vm_cluster_network "exadataInfrastructures/{exadataInfrastructureId}/vmClusterNetworks/{vmClusterNetworkId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] display_name: The user-friendly name for the Exadata Cloud@Customer VM cluster network. The name does not need to be unique.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dns: (Updatable) The list of DNS server IP addresses. Maximum of 3 allowed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VmClusterNetworkDrScanArgs', 'VmClusterNetworkDrScanArgsDict']]]] dr_scans: (Updatable) The SCAN details for DR network
        :param pulumi.Input[builtins.str] exadata_infrastructure_id: The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ntps: (Updatable) The list of NTP server IP addresses. Maximum of 3 allowed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VmClusterNetworkScanArgs', 'VmClusterNetworkScanArgsDict']]]] scans: (Updatable) The SCAN details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VmClusterNetworkVmNetworkArgs', 'VmClusterNetworkVmNetworkArgsDict']]]] vm_networks: (Updatable) Details of the client and backup networks.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VmClusterNetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Vm Cluster Network resource in Oracle Cloud Infrastructure Database service.

        Creates the VM cluster network. Applies to Exadata Cloud@Customer instances only.
        To create a cloud VM cluster in an Exadata Cloud Service instance, use the [CreateCloudVmCluster ](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/CloudVmCluster/CreateCloudVmCluster) operation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_vm_cluster_network = oci.database.VmClusterNetwork("test_vm_cluster_network",
            compartment_id=compartment_id,
            display_name=vm_cluster_network_display_name,
            exadata_infrastructure_id=test_exadata_infrastructure["id"],
            scans=[{
                "hostname": vm_cluster_network_scans_hostname,
                "ips": vm_cluster_network_scans_ips,
                "port": vm_cluster_network_scans_port,
                "scan_listener_port_tcp": vm_cluster_network_scans_scan_listener_port_tcp,
                "scan_listener_port_tcp_ssl": vm_cluster_network_scans_scan_listener_port_tcp_ssl,
            }],
            vm_networks=[{
                "network_type": vm_cluster_network_vm_networks_network_type,
                "nodes": [{
                    "hostname": vm_cluster_network_vm_networks_nodes_hostname,
                    "ip": vm_cluster_network_vm_networks_nodes_ip,
                    "db_server_id": test_db_server["id"],
                    "state": vm_cluster_network_vm_networks_nodes_state,
                    "vip": vm_cluster_network_vm_networks_nodes_vip,
                    "vip_hostname": vm_cluster_network_vm_networks_nodes_vip_hostname,
                }],
                "domain_name": test_domain["name"],
                "gateway": vm_cluster_network_vm_networks_gateway,
                "netmask": vm_cluster_network_vm_networks_netmask,
                "vlan_id": vm_cluster_network_vm_networks_vlan_id,
            }],
            defined_tags=vm_cluster_network_defined_tags,
            dns=vm_cluster_network_dns,
            dr_scans=[{
                "hostname": vm_cluster_network_dr_scans_hostname,
                "ips": vm_cluster_network_dr_scans_ips,
                "scan_listener_port_tcp": vm_cluster_network_dr_scans_scan_listener_port_tcp,
            }],
            freeform_tags={
                "Department": "Finance",
            },
            ntps=vm_cluster_network_ntp,
            validate_vm_cluster_network=vm_cluster_network_validate_vm_cluster_network)
        ```

        ## Import

        VmClusterNetworks can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/vmClusterNetwork:VmClusterNetwork test_vm_cluster_network "exadataInfrastructures/{exadataInfrastructureId}/vmClusterNetworks/{vmClusterNetworkId}"
        ```

        :param str resource_name: The name of the resource.
        :param VmClusterNetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VmClusterNetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 dns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 dr_scans: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmClusterNetworkDrScanArgs', 'VmClusterNetworkDrScanArgsDict']]]]] = None,
                 exadata_infrastructure_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ntps: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 scans: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmClusterNetworkScanArgs', 'VmClusterNetworkScanArgsDict']]]]] = None,
                 validate_vm_cluster_network: Optional[pulumi.Input[builtins.bool]] = None,
                 vm_networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmClusterNetworkVmNetworkArgs', 'VmClusterNetworkVmNetworkArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VmClusterNetworkArgs.__new__(VmClusterNetworkArgs)

            __props__.__dict__["action"] = action
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["dns"] = dns
            __props__.__dict__["dr_scans"] = dr_scans
            if exadata_infrastructure_id is None and not opts.urn:
                raise TypeError("Missing required property 'exadata_infrastructure_id'")
            __props__.__dict__["exadata_infrastructure_id"] = exadata_infrastructure_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["ntps"] = ntps
            if scans is None and not opts.urn:
                raise TypeError("Missing required property 'scans'")
            __props__.__dict__["scans"] = scans
            __props__.__dict__["validate_vm_cluster_network"] = validate_vm_cluster_network
            if vm_networks is None and not opts.urn:
                raise TypeError("Missing required property 'vm_networks'")
            __props__.__dict__["vm_networks"] = vm_networks
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["vm_cluster_id"] = None
        super(VmClusterNetwork, __self__).__init__(
            'oci:Database/vmClusterNetwork:VmClusterNetwork',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            dns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            dr_scans: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmClusterNetworkDrScanArgs', 'VmClusterNetworkDrScanArgsDict']]]]] = None,
            exadata_infrastructure_id: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            ntps: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            scans: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmClusterNetworkScanArgs', 'VmClusterNetworkScanArgsDict']]]]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            validate_vm_cluster_network: Optional[pulumi.Input[builtins.bool]] = None,
            vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
            vm_networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmClusterNetworkVmNetworkArgs', 'VmClusterNetworkVmNetworkArgsDict']]]]] = None) -> 'VmClusterNetwork':
        """
        Get an existing VmClusterNetwork resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] display_name: The user-friendly name for the Exadata Cloud@Customer VM cluster network. The name does not need to be unique.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dns: (Updatable) The list of DNS server IP addresses. Maximum of 3 allowed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VmClusterNetworkDrScanArgs', 'VmClusterNetworkDrScanArgsDict']]]] dr_scans: (Updatable) The SCAN details for DR network
        :param pulumi.Input[builtins.str] exadata_infrastructure_id: The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ntps: (Updatable) The list of NTP server IP addresses. Maximum of 3 allowed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VmClusterNetworkScanArgs', 'VmClusterNetworkScanArgsDict']]]] scans: (Updatable) The SCAN details.
        :param pulumi.Input[builtins.str] state: The current state of the VM cluster network nodes. CREATING - The resource is being created REQUIRES_VALIDATION - The resource is created and may not be usable until it is validated. VALIDATING - The resource is being validated and not available to use. VALIDATED - The resource is validated and is available for consumption by VM cluster. VALIDATION_FAILED - The resource validation has failed and might require user input to be corrected. UPDATING - The resource is being updated and not available to use. ALLOCATED - The resource is currently being used by VM cluster. TERMINATING - The resource is being deleted and not available to use. TERMINATED - The resource is deleted and unavailable. FAILED - The resource is in a failed state due to validation or other errors.
        :param pulumi.Input[builtins.str] time_created: The date and time when the VM cluster network was created.
        :param pulumi.Input[builtins.str] vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated VM Cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VmClusterNetworkVmNetworkArgs', 'VmClusterNetworkVmNetworkArgsDict']]]] vm_networks: (Updatable) Details of the client and backup networks.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VmClusterNetworkState.__new__(_VmClusterNetworkState)

        __props__.__dict__["action"] = action
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["dns"] = dns
        __props__.__dict__["dr_scans"] = dr_scans
        __props__.__dict__["exadata_infrastructure_id"] = exadata_infrastructure_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["ntps"] = ntps
        __props__.__dict__["scans"] = scans
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["validate_vm_cluster_network"] = validate_vm_cluster_network
        __props__.__dict__["vm_cluster_id"] = vm_cluster_id
        __props__.__dict__["vm_networks"] = vm_networks
        return VmClusterNetwork(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The user-friendly name for the Exadata Cloud@Customer VM cluster network. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def dns(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) The list of DNS server IP addresses. Maximum of 3 allowed.
        """
        return pulumi.get(self, "dns")

    @property
    @pulumi.getter(name="drScans")
    def dr_scans(self) -> pulumi.Output[Sequence['outputs.VmClusterNetworkDrScan']]:
        """
        (Updatable) The SCAN details for DR network
        """
        return pulumi.get(self, "dr_scans")

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> pulumi.Output[builtins.str]:
        """
        The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def ntps(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) The list of NTP server IP addresses. Maximum of 3 allowed.
        """
        return pulumi.get(self, "ntps")

    @property
    @pulumi.getter
    def scans(self) -> pulumi.Output[Sequence['outputs.VmClusterNetworkScan']]:
        """
        (Updatable) The SCAN details.
        """
        return pulumi.get(self, "scans")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the VM cluster network nodes. CREATING - The resource is being created REQUIRES_VALIDATION - The resource is created and may not be usable until it is validated. VALIDATING - The resource is being validated and not available to use. VALIDATED - The resource is validated and is available for consumption by VM cluster. VALIDATION_FAILED - The resource validation has failed and might require user input to be corrected. UPDATING - The resource is being updated and not available to use. ALLOCATED - The resource is currently being used by VM cluster. TERMINATING - The resource is being deleted and not available to use. TERMINATED - The resource is deleted and unavailable. FAILED - The resource is in a failed state due to validation or other errors.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time when the VM cluster network was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="validateVmClusterNetwork")
    def validate_vm_cluster_network(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "validate_vm_cluster_network")

    @property
    @pulumi.getter(name="vmClusterId")
    def vm_cluster_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated VM Cluster.
        """
        return pulumi.get(self, "vm_cluster_id")

    @property
    @pulumi.getter(name="vmNetworks")
    def vm_networks(self) -> pulumi.Output[Sequence['outputs.VmClusterNetworkVmNetwork']]:
        """
        (Updatable) Details of the client and backup networks.
        """
        return pulumi.get(self, "vm_networks")

