# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCompatibleFormatsForDataTypeResult',
    'AwaitableGetCompatibleFormatsForDataTypeResult',
    'get_compatible_formats_for_data_type',
    'get_compatible_formats_for_data_type_output',
]

@pulumi.output_type
class GetCompatibleFormatsForDataTypeResult:
    """
    A collection of values returned by getCompatibleFormatsForDataType.
    """
    def __init__(__self__, formats_for_data_types=None, id=None):
        if formats_for_data_types and not isinstance(formats_for_data_types, list):
            raise TypeError("Expected argument 'formats_for_data_types' to be a list")
        pulumi.set(__self__, "formats_for_data_types", formats_for_data_types)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="formatsForDataTypes")
    def formats_for_data_types(self) -> Sequence['outputs.GetCompatibleFormatsForDataTypeFormatsForDataTypeResult']:
        """
        An array of lists of basic masking formats compatible with the supported data types.
        """
        return pulumi.get(self, "formats_for_data_types")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetCompatibleFormatsForDataTypeResult(GetCompatibleFormatsForDataTypeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCompatibleFormatsForDataTypeResult(
            formats_for_data_types=self.formats_for_data_types,
            id=self.id)


def get_compatible_formats_for_data_type(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCompatibleFormatsForDataTypeResult:
    """
    This data source provides details about a specific Compatible Formats For Data Type resource in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of basic masking formats compatible with the supported data types.
    The data types are grouped into the following categories -
    Character - Includes CHAR, NCHAR, VARCHAR2, and NVARCHAR2
    Numeric - Includes NUMBER, FLOAT, RAW, BINARY_FLOAT, and BINARY_DOUBLE
    Date - Includes DATE and TIMESTAMP
    LOB - Includes BLOB, CLOB, and NCLOB
    All - Includes all the supported data types

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compatible_formats_for_data_type = oci.DataSafe.get_compatible_formats_for_data_type()
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getCompatibleFormatsForDataType:getCompatibleFormatsForDataType', __args__, opts=opts, typ=GetCompatibleFormatsForDataTypeResult).value

    return AwaitableGetCompatibleFormatsForDataTypeResult(
        formats_for_data_types=pulumi.get(__ret__, 'formats_for_data_types'),
        id=pulumi.get(__ret__, 'id'))
def get_compatible_formats_for_data_type_output(opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCompatibleFormatsForDataTypeResult]:
    """
    This data source provides details about a specific Compatible Formats For Data Type resource in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of basic masking formats compatible with the supported data types.
    The data types are grouped into the following categories -
    Character - Includes CHAR, NCHAR, VARCHAR2, and NVARCHAR2
    Numeric - Includes NUMBER, FLOAT, RAW, BINARY_FLOAT, and BINARY_DOUBLE
    Date - Includes DATE and TIMESTAMP
    LOB - Includes BLOB, CLOB, and NCLOB
    All - Includes all the supported data types

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compatible_formats_for_data_type = oci.DataSafe.get_compatible_formats_for_data_type()
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getCompatibleFormatsForDataType:getCompatibleFormatsForDataType', __args__, opts=opts, typ=GetCompatibleFormatsForDataTypeResult)
    return __ret__.apply(lambda __response__: GetCompatibleFormatsForDataTypeResult(
        formats_for_data_types=pulumi.get(__response__, 'formats_for_data_types'),
        id=pulumi.get(__response__, 'id')))
