# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSdmMaskingPolicyDifferenceDifferenceColumnResult',
    'AwaitableGetSdmMaskingPolicyDifferenceDifferenceColumnResult',
    'get_sdm_masking_policy_difference_difference_column',
    'get_sdm_masking_policy_difference_difference_column_output',
]

@pulumi.output_type
class GetSdmMaskingPolicyDifferenceDifferenceColumnResult:
    """
    A collection of values returned by getSdmMaskingPolicyDifferenceDifferenceColumn.
    """
    def __init__(__self__, column_name=None, difference_column_key=None, difference_type=None, id=None, key=None, masking_columnkey=None, object=None, planned_action=None, schema_name=None, sdm_masking_policy_difference_id=None, sensitive_columnkey=None, sensitive_type_id=None, sync_status=None, time_last_synced=None):
        if column_name and not isinstance(column_name, str):
            raise TypeError("Expected argument 'column_name' to be a str")
        pulumi.set(__self__, "column_name", column_name)
        if difference_column_key and not isinstance(difference_column_key, str):
            raise TypeError("Expected argument 'difference_column_key' to be a str")
        pulumi.set(__self__, "difference_column_key", difference_column_key)
        if difference_type and not isinstance(difference_type, str):
            raise TypeError("Expected argument 'difference_type' to be a str")
        pulumi.set(__self__, "difference_type", difference_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if masking_columnkey and not isinstance(masking_columnkey, str):
            raise TypeError("Expected argument 'masking_columnkey' to be a str")
        pulumi.set(__self__, "masking_columnkey", masking_columnkey)
        if object and not isinstance(object, str):
            raise TypeError("Expected argument 'object' to be a str")
        pulumi.set(__self__, "object", object)
        if planned_action and not isinstance(planned_action, str):
            raise TypeError("Expected argument 'planned_action' to be a str")
        pulumi.set(__self__, "planned_action", planned_action)
        if schema_name and not isinstance(schema_name, str):
            raise TypeError("Expected argument 'schema_name' to be a str")
        pulumi.set(__self__, "schema_name", schema_name)
        if sdm_masking_policy_difference_id and not isinstance(sdm_masking_policy_difference_id, str):
            raise TypeError("Expected argument 'sdm_masking_policy_difference_id' to be a str")
        pulumi.set(__self__, "sdm_masking_policy_difference_id", sdm_masking_policy_difference_id)
        if sensitive_columnkey and not isinstance(sensitive_columnkey, str):
            raise TypeError("Expected argument 'sensitive_columnkey' to be a str")
        pulumi.set(__self__, "sensitive_columnkey", sensitive_columnkey)
        if sensitive_type_id and not isinstance(sensitive_type_id, str):
            raise TypeError("Expected argument 'sensitive_type_id' to be a str")
        pulumi.set(__self__, "sensitive_type_id", sensitive_type_id)
        if sync_status and not isinstance(sync_status, str):
            raise TypeError("Expected argument 'sync_status' to be a str")
        pulumi.set(__self__, "sync_status", sync_status)
        if time_last_synced and not isinstance(time_last_synced, str):
            raise TypeError("Expected argument 'time_last_synced' to be a str")
        pulumi.set(__self__, "time_last_synced", time_last_synced)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> builtins.str:
        """
        The name of the difference column.
        """
        return pulumi.get(self, "column_name")

    @property
    @pulumi.getter(name="differenceColumnKey")
    def difference_column_key(self) -> builtins.str:
        return pulumi.get(self, "difference_column_key")

    @property
    @pulumi.getter(name="differenceType")
    def difference_type(self) -> builtins.str:
        """
        The type of the SDM masking policy difference column. It can be one of the following three types: NEW: A new sensitive column in the sensitive data model that is not in the masking policy. DELETED: A column that is present in the masking policy but has been deleted from the sensitive data model. MODIFIED: A column that is present in the masking policy as well as the sensitive data model but some of its attributes have been modified.
        """
        return pulumi.get(self, "difference_type")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The unique key that identifies the SDM masking policy difference column.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="maskingColumnkey")
    def masking_columnkey(self) -> builtins.str:
        """
        The unique key that identifies the masking column represented by the SDM masking policy difference column.
        """
        return pulumi.get(self, "masking_columnkey")

    @property
    @pulumi.getter
    def object(self) -> builtins.str:
        """
        The database object that contains the difference column.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="plannedAction")
    def planned_action(self) -> builtins.str:
        """
        Specifies how to process the difference column. It's set to SYNC by default. Use the PatchSdmMaskingPolicyDifferenceColumns operation to update this attribute. You can choose one of the following options: SYNC: To sync the difference column and update the masking policy to reflect the changes. NO_SYNC: To not sync the difference column so that it doesn't change the masking policy. After specifying the planned action, you can use the ApplySdmMaskingPolicyDifference operation to automatically process the difference columns.
        """
        return pulumi.get(self, "planned_action")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> builtins.str:
        """
        The database schema that contains the difference column.
        """
        return pulumi.get(self, "schema_name")

    @property
    @pulumi.getter(name="sdmMaskingPolicyDifferenceId")
    def sdm_masking_policy_difference_id(self) -> builtins.str:
        return pulumi.get(self, "sdm_masking_policy_difference_id")

    @property
    @pulumi.getter(name="sensitiveColumnkey")
    def sensitive_columnkey(self) -> builtins.str:
        """
        The unique key that identifies the sensitive column represented by the SDM masking policy difference column.
        """
        return pulumi.get(self, "sensitive_columnkey")

    @property
    @pulumi.getter(name="sensitiveTypeId")
    def sensitive_type_id(self) -> builtins.str:
        """
        The OCID of the sensitive type associated with the difference column.
        """
        return pulumi.get(self, "sensitive_type_id")

    @property
    @pulumi.getter(name="syncStatus")
    def sync_status(self) -> builtins.str:
        """
        Indicates if the difference column has been processed. Use GetDifferenceColumn operation to  track whether the difference column has already been processed and applied to the masking policy.
        """
        return pulumi.get(self, "sync_status")

    @property
    @pulumi.getter(name="timeLastSynced")
    def time_last_synced(self) -> builtins.str:
        """
        The date and time the SDM masking policy difference column was last synced, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_last_synced")


class AwaitableGetSdmMaskingPolicyDifferenceDifferenceColumnResult(GetSdmMaskingPolicyDifferenceDifferenceColumnResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSdmMaskingPolicyDifferenceDifferenceColumnResult(
            column_name=self.column_name,
            difference_column_key=self.difference_column_key,
            difference_type=self.difference_type,
            id=self.id,
            key=self.key,
            masking_columnkey=self.masking_columnkey,
            object=self.object,
            planned_action=self.planned_action,
            schema_name=self.schema_name,
            sdm_masking_policy_difference_id=self.sdm_masking_policy_difference_id,
            sensitive_columnkey=self.sensitive_columnkey,
            sensitive_type_id=self.sensitive_type_id,
            sync_status=self.sync_status,
            time_last_synced=self.time_last_synced)


def get_sdm_masking_policy_difference_difference_column(difference_column_key: Optional[builtins.str] = None,
                                                        sdm_masking_policy_difference_id: Optional[builtins.str] = None,
                                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSdmMaskingPolicyDifferenceDifferenceColumnResult:
    """
    This data source provides details about a specific Sdm Masking Policy Difference Difference Column resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the specified SDM Masking policy difference column.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sdm_masking_policy_difference_difference_column = oci.DataSafe.get_sdm_masking_policy_difference_difference_column(difference_column_key=sdm_masking_policy_difference_difference_column_difference_column_key,
        sdm_masking_policy_difference_id=test_sdm_masking_policy_difference["id"])
    ```


    :param builtins.str difference_column_key: The unique key that identifies the difference column.
    :param builtins.str sdm_masking_policy_difference_id: The OCID of the SDM masking policy difference.
    """
    __args__ = dict()
    __args__['differenceColumnKey'] = difference_column_key
    __args__['sdmMaskingPolicyDifferenceId'] = sdm_masking_policy_difference_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSdmMaskingPolicyDifferenceDifferenceColumn:getSdmMaskingPolicyDifferenceDifferenceColumn', __args__, opts=opts, typ=GetSdmMaskingPolicyDifferenceDifferenceColumnResult).value

    return AwaitableGetSdmMaskingPolicyDifferenceDifferenceColumnResult(
        column_name=pulumi.get(__ret__, 'column_name'),
        difference_column_key=pulumi.get(__ret__, 'difference_column_key'),
        difference_type=pulumi.get(__ret__, 'difference_type'),
        id=pulumi.get(__ret__, 'id'),
        key=pulumi.get(__ret__, 'key'),
        masking_columnkey=pulumi.get(__ret__, 'masking_columnkey'),
        object=pulumi.get(__ret__, 'object'),
        planned_action=pulumi.get(__ret__, 'planned_action'),
        schema_name=pulumi.get(__ret__, 'schema_name'),
        sdm_masking_policy_difference_id=pulumi.get(__ret__, 'sdm_masking_policy_difference_id'),
        sensitive_columnkey=pulumi.get(__ret__, 'sensitive_columnkey'),
        sensitive_type_id=pulumi.get(__ret__, 'sensitive_type_id'),
        sync_status=pulumi.get(__ret__, 'sync_status'),
        time_last_synced=pulumi.get(__ret__, 'time_last_synced'))
def get_sdm_masking_policy_difference_difference_column_output(difference_column_key: Optional[pulumi.Input[builtins.str]] = None,
                                                               sdm_masking_policy_difference_id: Optional[pulumi.Input[builtins.str]] = None,
                                                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSdmMaskingPolicyDifferenceDifferenceColumnResult]:
    """
    This data source provides details about a specific Sdm Masking Policy Difference Difference Column resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the specified SDM Masking policy difference column.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sdm_masking_policy_difference_difference_column = oci.DataSafe.get_sdm_masking_policy_difference_difference_column(difference_column_key=sdm_masking_policy_difference_difference_column_difference_column_key,
        sdm_masking_policy_difference_id=test_sdm_masking_policy_difference["id"])
    ```


    :param builtins.str difference_column_key: The unique key that identifies the difference column.
    :param builtins.str sdm_masking_policy_difference_id: The OCID of the SDM masking policy difference.
    """
    __args__ = dict()
    __args__['differenceColumnKey'] = difference_column_key
    __args__['sdmMaskingPolicyDifferenceId'] = sdm_masking_policy_difference_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getSdmMaskingPolicyDifferenceDifferenceColumn:getSdmMaskingPolicyDifferenceDifferenceColumn', __args__, opts=opts, typ=GetSdmMaskingPolicyDifferenceDifferenceColumnResult)
    return __ret__.apply(lambda __response__: GetSdmMaskingPolicyDifferenceDifferenceColumnResult(
        column_name=pulumi.get(__response__, 'column_name'),
        difference_column_key=pulumi.get(__response__, 'difference_column_key'),
        difference_type=pulumi.get(__response__, 'difference_type'),
        id=pulumi.get(__response__, 'id'),
        key=pulumi.get(__response__, 'key'),
        masking_columnkey=pulumi.get(__response__, 'masking_columnkey'),
        object=pulumi.get(__response__, 'object'),
        planned_action=pulumi.get(__response__, 'planned_action'),
        schema_name=pulumi.get(__response__, 'schema_name'),
        sdm_masking_policy_difference_id=pulumi.get(__response__, 'sdm_masking_policy_difference_id'),
        sensitive_columnkey=pulumi.get(__response__, 'sensitive_columnkey'),
        sensitive_type_id=pulumi.get(__response__, 'sensitive_type_id'),
        sync_status=pulumi.get(__response__, 'sync_status'),
        time_last_synced=pulumi.get(__response__, 'time_last_synced')))
