# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSecurityAssessmentSecurityFeaturesResult',
    'AwaitableGetSecurityAssessmentSecurityFeaturesResult',
    'get_security_assessment_security_features',
    'get_security_assessment_security_features_output',
]

@pulumi.output_type
class GetSecurityAssessmentSecurityFeaturesResult:
    """
    A collection of values returned by getSecurityAssessmentSecurityFeatures.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, filters=None, id=None, security_feature_collections=None, target_id=None, targets_with_column_encryption=None, targets_with_database_vault=None, targets_with_external_authentication=None, targets_with_fine_grained_audit=None, targets_with_global_authentication=None, targets_with_network_encryption=None, targets_with_password_authentication=None, targets_with_privilege_analysis=None, targets_with_tablespace_encryption=None, targets_with_traditional_audit=None, targets_with_unified_audit=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if security_feature_collections and not isinstance(security_feature_collections, list):
            raise TypeError("Expected argument 'security_feature_collections' to be a list")
        pulumi.set(__self__, "security_feature_collections", security_feature_collections)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)
        if targets_with_column_encryption and not isinstance(targets_with_column_encryption, str):
            raise TypeError("Expected argument 'targets_with_column_encryption' to be a str")
        pulumi.set(__self__, "targets_with_column_encryption", targets_with_column_encryption)
        if targets_with_database_vault and not isinstance(targets_with_database_vault, str):
            raise TypeError("Expected argument 'targets_with_database_vault' to be a str")
        pulumi.set(__self__, "targets_with_database_vault", targets_with_database_vault)
        if targets_with_external_authentication and not isinstance(targets_with_external_authentication, str):
            raise TypeError("Expected argument 'targets_with_external_authentication' to be a str")
        pulumi.set(__self__, "targets_with_external_authentication", targets_with_external_authentication)
        if targets_with_fine_grained_audit and not isinstance(targets_with_fine_grained_audit, str):
            raise TypeError("Expected argument 'targets_with_fine_grained_audit' to be a str")
        pulumi.set(__self__, "targets_with_fine_grained_audit", targets_with_fine_grained_audit)
        if targets_with_global_authentication and not isinstance(targets_with_global_authentication, str):
            raise TypeError("Expected argument 'targets_with_global_authentication' to be a str")
        pulumi.set(__self__, "targets_with_global_authentication", targets_with_global_authentication)
        if targets_with_network_encryption and not isinstance(targets_with_network_encryption, str):
            raise TypeError("Expected argument 'targets_with_network_encryption' to be a str")
        pulumi.set(__self__, "targets_with_network_encryption", targets_with_network_encryption)
        if targets_with_password_authentication and not isinstance(targets_with_password_authentication, str):
            raise TypeError("Expected argument 'targets_with_password_authentication' to be a str")
        pulumi.set(__self__, "targets_with_password_authentication", targets_with_password_authentication)
        if targets_with_privilege_analysis and not isinstance(targets_with_privilege_analysis, str):
            raise TypeError("Expected argument 'targets_with_privilege_analysis' to be a str")
        pulumi.set(__self__, "targets_with_privilege_analysis", targets_with_privilege_analysis)
        if targets_with_tablespace_encryption and not isinstance(targets_with_tablespace_encryption, str):
            raise TypeError("Expected argument 'targets_with_tablespace_encryption' to be a str")
        pulumi.set(__self__, "targets_with_tablespace_encryption", targets_with_tablespace_encryption)
        if targets_with_traditional_audit and not isinstance(targets_with_traditional_audit, str):
            raise TypeError("Expected argument 'targets_with_traditional_audit' to be a str")
        pulumi.set(__self__, "targets_with_traditional_audit", targets_with_traditional_audit)
        if targets_with_unified_audit and not isinstance(targets_with_unified_audit, str):
            raise TypeError("Expected argument 'targets_with_unified_audit' to be a str")
        pulumi.set(__self__, "targets_with_unified_audit", targets_with_unified_audit)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[builtins.str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSecurityAssessmentSecurityFeaturesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="securityFeatureCollections")
    def security_feature_collections(self) -> Sequence['outputs.GetSecurityAssessmentSecurityFeaturesSecurityFeatureCollectionResult']:
        """
        The list of security_feature_collection.
        """
        return pulumi.get(self, "security_feature_collections")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[builtins.str]:
        """
        The OCID of the target database.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="targetsWithColumnEncryption")
    def targets_with_column_encryption(self) -> Optional[builtins.str]:
        return pulumi.get(self, "targets_with_column_encryption")

    @property
    @pulumi.getter(name="targetsWithDatabaseVault")
    def targets_with_database_vault(self) -> Optional[builtins.str]:
        return pulumi.get(self, "targets_with_database_vault")

    @property
    @pulumi.getter(name="targetsWithExternalAuthentication")
    def targets_with_external_authentication(self) -> Optional[builtins.str]:
        return pulumi.get(self, "targets_with_external_authentication")

    @property
    @pulumi.getter(name="targetsWithFineGrainedAudit")
    def targets_with_fine_grained_audit(self) -> Optional[builtins.str]:
        return pulumi.get(self, "targets_with_fine_grained_audit")

    @property
    @pulumi.getter(name="targetsWithGlobalAuthentication")
    def targets_with_global_authentication(self) -> Optional[builtins.str]:
        return pulumi.get(self, "targets_with_global_authentication")

    @property
    @pulumi.getter(name="targetsWithNetworkEncryption")
    def targets_with_network_encryption(self) -> Optional[builtins.str]:
        return pulumi.get(self, "targets_with_network_encryption")

    @property
    @pulumi.getter(name="targetsWithPasswordAuthentication")
    def targets_with_password_authentication(self) -> Optional[builtins.str]:
        return pulumi.get(self, "targets_with_password_authentication")

    @property
    @pulumi.getter(name="targetsWithPrivilegeAnalysis")
    def targets_with_privilege_analysis(self) -> Optional[builtins.str]:
        return pulumi.get(self, "targets_with_privilege_analysis")

    @property
    @pulumi.getter(name="targetsWithTablespaceEncryption")
    def targets_with_tablespace_encryption(self) -> Optional[builtins.str]:
        return pulumi.get(self, "targets_with_tablespace_encryption")

    @property
    @pulumi.getter(name="targetsWithTraditionalAudit")
    def targets_with_traditional_audit(self) -> Optional[builtins.str]:
        return pulumi.get(self, "targets_with_traditional_audit")

    @property
    @pulumi.getter(name="targetsWithUnifiedAudit")
    def targets_with_unified_audit(self) -> Optional[builtins.str]:
        return pulumi.get(self, "targets_with_unified_audit")


class AwaitableGetSecurityAssessmentSecurityFeaturesResult(GetSecurityAssessmentSecurityFeaturesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityAssessmentSecurityFeaturesResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            filters=self.filters,
            id=self.id,
            security_feature_collections=self.security_feature_collections,
            target_id=self.target_id,
            targets_with_column_encryption=self.targets_with_column_encryption,
            targets_with_database_vault=self.targets_with_database_vault,
            targets_with_external_authentication=self.targets_with_external_authentication,
            targets_with_fine_grained_audit=self.targets_with_fine_grained_audit,
            targets_with_global_authentication=self.targets_with_global_authentication,
            targets_with_network_encryption=self.targets_with_network_encryption,
            targets_with_password_authentication=self.targets_with_password_authentication,
            targets_with_privilege_analysis=self.targets_with_privilege_analysis,
            targets_with_tablespace_encryption=self.targets_with_tablespace_encryption,
            targets_with_traditional_audit=self.targets_with_traditional_audit,
            targets_with_unified_audit=self.targets_with_unified_audit)


def get_security_assessment_security_features(access_level: Optional[builtins.str] = None,
                                              compartment_id: Optional[builtins.str] = None,
                                              compartment_id_in_subtree: Optional[builtins.bool] = None,
                                              filters: Optional[Sequence[Union['GetSecurityAssessmentSecurityFeaturesFilterArgs', 'GetSecurityAssessmentSecurityFeaturesFilterArgsDict']]] = None,
                                              target_id: Optional[builtins.str] = None,
                                              targets_with_column_encryption: Optional[builtins.str] = None,
                                              targets_with_database_vault: Optional[builtins.str] = None,
                                              targets_with_external_authentication: Optional[builtins.str] = None,
                                              targets_with_fine_grained_audit: Optional[builtins.str] = None,
                                              targets_with_global_authentication: Optional[builtins.str] = None,
                                              targets_with_network_encryption: Optional[builtins.str] = None,
                                              targets_with_password_authentication: Optional[builtins.str] = None,
                                              targets_with_privilege_analysis: Optional[builtins.str] = None,
                                              targets_with_tablespace_encryption: Optional[builtins.str] = None,
                                              targets_with_traditional_audit: Optional[builtins.str] = None,
                                              targets_with_unified_audit: Optional[builtins.str] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityAssessmentSecurityFeaturesResult:
    """
    This data source provides the list of Security Assessment Security Features in Oracle Cloud Infrastructure Data Safe service.

    Lists the usage of Database security features for a given compartment or a target level, based on the filters provided.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_assessment_security_features = oci.DataSafe.get_security_assessment_security_features(compartment_id=compartment_id,
        access_level=security_assessment_security_feature_access_level,
        compartment_id_in_subtree=security_assessment_security_feature_compartment_id_in_subtree,
        target_id=test_target["id"],
        targets_with_column_encryption=security_assessment_security_feature_targets_with_column_encryption,
        targets_with_database_vault=security_assessment_security_feature_targets_with_database_vault,
        targets_with_external_authentication=security_assessment_security_feature_targets_with_external_authentication,
        targets_with_fine_grained_audit=security_assessment_security_feature_targets_with_fine_grained_audit,
        targets_with_global_authentication=security_assessment_security_feature_targets_with_global_authentication,
        targets_with_network_encryption=security_assessment_security_feature_targets_with_network_encryption,
        targets_with_password_authentication=security_assessment_security_feature_targets_with_password_authentication,
        targets_with_privilege_analysis=security_assessment_security_feature_targets_with_privilege_analysis,
        targets_with_tablespace_encryption=security_assessment_security_feature_targets_with_tablespace_encryption,
        targets_with_traditional_audit=security_assessment_security_feature_targets_with_traditional_audit,
        targets_with_unified_audit=security_assessment_security_feature_targets_with_unified_audit)
    ```


    :param builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param builtins.str target_id: A filter to return only items related to a specific target OCID.
    :param builtins.str targets_with_column_encryption: A filter to return only the targets that enable the DB security feature - Column Encryption enabled/disabled.
    :param builtins.str targets_with_database_vault: A filter to return only the targets with the DB security feature - Database Vault enabled/disabled.
    :param builtins.str targets_with_external_authentication: A filter to return only the targets with the DB security feature - External Authentication enabled/disabled.
    :param builtins.str targets_with_fine_grained_audit: A filter to return only the targets with the DB security feature - Fine Grained Audit enabled/disabled.
    :param builtins.str targets_with_global_authentication: A filter to return only the targets with the DB security feature - Global Authentication enabled/disabled.
    :param builtins.str targets_with_network_encryption: A filter to return only the targets with the DB security feature - Network Encryption enabled/disabled.
    :param builtins.str targets_with_password_authentication: A filter to return only the targets with the DB security feature - Password Authentication enabled/disabled.
    :param builtins.str targets_with_privilege_analysis: A filter to return only the targets with the DB security feature - Privilege Analysis enabled/disabled.
    :param builtins.str targets_with_tablespace_encryption: A filter to return only the targets with the DB security feature - Tablespace Encryption enabled/disabled.
    :param builtins.str targets_with_traditional_audit: A filter to return only the targets with the DB security feature - Traditional Audit enabled/disabled.
    :param builtins.str targets_with_unified_audit: A filter to return only the targets with the DB security feature - Unified Audit enabled/disabled.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['targetId'] = target_id
    __args__['targetsWithColumnEncryption'] = targets_with_column_encryption
    __args__['targetsWithDatabaseVault'] = targets_with_database_vault
    __args__['targetsWithExternalAuthentication'] = targets_with_external_authentication
    __args__['targetsWithFineGrainedAudit'] = targets_with_fine_grained_audit
    __args__['targetsWithGlobalAuthentication'] = targets_with_global_authentication
    __args__['targetsWithNetworkEncryption'] = targets_with_network_encryption
    __args__['targetsWithPasswordAuthentication'] = targets_with_password_authentication
    __args__['targetsWithPrivilegeAnalysis'] = targets_with_privilege_analysis
    __args__['targetsWithTablespaceEncryption'] = targets_with_tablespace_encryption
    __args__['targetsWithTraditionalAudit'] = targets_with_traditional_audit
    __args__['targetsWithUnifiedAudit'] = targets_with_unified_audit
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSecurityAssessmentSecurityFeatures:getSecurityAssessmentSecurityFeatures', __args__, opts=opts, typ=GetSecurityAssessmentSecurityFeaturesResult).value

    return AwaitableGetSecurityAssessmentSecurityFeaturesResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        security_feature_collections=pulumi.get(__ret__, 'security_feature_collections'),
        target_id=pulumi.get(__ret__, 'target_id'),
        targets_with_column_encryption=pulumi.get(__ret__, 'targets_with_column_encryption'),
        targets_with_database_vault=pulumi.get(__ret__, 'targets_with_database_vault'),
        targets_with_external_authentication=pulumi.get(__ret__, 'targets_with_external_authentication'),
        targets_with_fine_grained_audit=pulumi.get(__ret__, 'targets_with_fine_grained_audit'),
        targets_with_global_authentication=pulumi.get(__ret__, 'targets_with_global_authentication'),
        targets_with_network_encryption=pulumi.get(__ret__, 'targets_with_network_encryption'),
        targets_with_password_authentication=pulumi.get(__ret__, 'targets_with_password_authentication'),
        targets_with_privilege_analysis=pulumi.get(__ret__, 'targets_with_privilege_analysis'),
        targets_with_tablespace_encryption=pulumi.get(__ret__, 'targets_with_tablespace_encryption'),
        targets_with_traditional_audit=pulumi.get(__ret__, 'targets_with_traditional_audit'),
        targets_with_unified_audit=pulumi.get(__ret__, 'targets_with_unified_audit'))
def get_security_assessment_security_features_output(access_level: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                     compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                                     compartment_id_in_subtree: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSecurityAssessmentSecurityFeaturesFilterArgs', 'GetSecurityAssessmentSecurityFeaturesFilterArgsDict']]]]] = None,
                                                     target_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                     targets_with_column_encryption: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                     targets_with_database_vault: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                     targets_with_external_authentication: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                     targets_with_fine_grained_audit: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                     targets_with_global_authentication: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                     targets_with_network_encryption: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                     targets_with_password_authentication: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                     targets_with_privilege_analysis: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                     targets_with_tablespace_encryption: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                     targets_with_traditional_audit: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                     targets_with_unified_audit: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityAssessmentSecurityFeaturesResult]:
    """
    This data source provides the list of Security Assessment Security Features in Oracle Cloud Infrastructure Data Safe service.

    Lists the usage of Database security features for a given compartment or a target level, based on the filters provided.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_assessment_security_features = oci.DataSafe.get_security_assessment_security_features(compartment_id=compartment_id,
        access_level=security_assessment_security_feature_access_level,
        compartment_id_in_subtree=security_assessment_security_feature_compartment_id_in_subtree,
        target_id=test_target["id"],
        targets_with_column_encryption=security_assessment_security_feature_targets_with_column_encryption,
        targets_with_database_vault=security_assessment_security_feature_targets_with_database_vault,
        targets_with_external_authentication=security_assessment_security_feature_targets_with_external_authentication,
        targets_with_fine_grained_audit=security_assessment_security_feature_targets_with_fine_grained_audit,
        targets_with_global_authentication=security_assessment_security_feature_targets_with_global_authentication,
        targets_with_network_encryption=security_assessment_security_feature_targets_with_network_encryption,
        targets_with_password_authentication=security_assessment_security_feature_targets_with_password_authentication,
        targets_with_privilege_analysis=security_assessment_security_feature_targets_with_privilege_analysis,
        targets_with_tablespace_encryption=security_assessment_security_feature_targets_with_tablespace_encryption,
        targets_with_traditional_audit=security_assessment_security_feature_targets_with_traditional_audit,
        targets_with_unified_audit=security_assessment_security_feature_targets_with_unified_audit)
    ```


    :param builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param builtins.str target_id: A filter to return only items related to a specific target OCID.
    :param builtins.str targets_with_column_encryption: A filter to return only the targets that enable the DB security feature - Column Encryption enabled/disabled.
    :param builtins.str targets_with_database_vault: A filter to return only the targets with the DB security feature - Database Vault enabled/disabled.
    :param builtins.str targets_with_external_authentication: A filter to return only the targets with the DB security feature - External Authentication enabled/disabled.
    :param builtins.str targets_with_fine_grained_audit: A filter to return only the targets with the DB security feature - Fine Grained Audit enabled/disabled.
    :param builtins.str targets_with_global_authentication: A filter to return only the targets with the DB security feature - Global Authentication enabled/disabled.
    :param builtins.str targets_with_network_encryption: A filter to return only the targets with the DB security feature - Network Encryption enabled/disabled.
    :param builtins.str targets_with_password_authentication: A filter to return only the targets with the DB security feature - Password Authentication enabled/disabled.
    :param builtins.str targets_with_privilege_analysis: A filter to return only the targets with the DB security feature - Privilege Analysis enabled/disabled.
    :param builtins.str targets_with_tablespace_encryption: A filter to return only the targets with the DB security feature - Tablespace Encryption enabled/disabled.
    :param builtins.str targets_with_traditional_audit: A filter to return only the targets with the DB security feature - Traditional Audit enabled/disabled.
    :param builtins.str targets_with_unified_audit: A filter to return only the targets with the DB security feature - Unified Audit enabled/disabled.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['targetId'] = target_id
    __args__['targetsWithColumnEncryption'] = targets_with_column_encryption
    __args__['targetsWithDatabaseVault'] = targets_with_database_vault
    __args__['targetsWithExternalAuthentication'] = targets_with_external_authentication
    __args__['targetsWithFineGrainedAudit'] = targets_with_fine_grained_audit
    __args__['targetsWithGlobalAuthentication'] = targets_with_global_authentication
    __args__['targetsWithNetworkEncryption'] = targets_with_network_encryption
    __args__['targetsWithPasswordAuthentication'] = targets_with_password_authentication
    __args__['targetsWithPrivilegeAnalysis'] = targets_with_privilege_analysis
    __args__['targetsWithTablespaceEncryption'] = targets_with_tablespace_encryption
    __args__['targetsWithTraditionalAudit'] = targets_with_traditional_audit
    __args__['targetsWithUnifiedAudit'] = targets_with_unified_audit
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getSecurityAssessmentSecurityFeatures:getSecurityAssessmentSecurityFeatures', __args__, opts=opts, typ=GetSecurityAssessmentSecurityFeaturesResult)
    return __ret__.apply(lambda __response__: GetSecurityAssessmentSecurityFeaturesResult(
        access_level=pulumi.get(__response__, 'access_level'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        security_feature_collections=pulumi.get(__response__, 'security_feature_collections'),
        target_id=pulumi.get(__response__, 'target_id'),
        targets_with_column_encryption=pulumi.get(__response__, 'targets_with_column_encryption'),
        targets_with_database_vault=pulumi.get(__response__, 'targets_with_database_vault'),
        targets_with_external_authentication=pulumi.get(__response__, 'targets_with_external_authentication'),
        targets_with_fine_grained_audit=pulumi.get(__response__, 'targets_with_fine_grained_audit'),
        targets_with_global_authentication=pulumi.get(__response__, 'targets_with_global_authentication'),
        targets_with_network_encryption=pulumi.get(__response__, 'targets_with_network_encryption'),
        targets_with_password_authentication=pulumi.get(__response__, 'targets_with_password_authentication'),
        targets_with_privilege_analysis=pulumi.get(__response__, 'targets_with_privilege_analysis'),
        targets_with_tablespace_encryption=pulumi.get(__response__, 'targets_with_tablespace_encryption'),
        targets_with_traditional_audit=pulumi.get(__response__, 'targets_with_traditional_audit'),
        targets_with_unified_audit=pulumi.get(__response__, 'targets_with_unified_audit')))
