# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSecurityPolicyReportDatabaseViewAccessEntryResult',
    'AwaitableGetSecurityPolicyReportDatabaseViewAccessEntryResult',
    'get_security_policy_report_database_view_access_entry',
    'get_security_policy_report_database_view_access_entry_output',
]

@pulumi.output_type
class GetSecurityPolicyReportDatabaseViewAccessEntryResult:
    """
    A collection of values returned by getSecurityPolicyReportDatabaseViewAccessEntry.
    """
    def __init__(__self__, access_type=None, column_name=None, database_view_access_entry_key=None, grant_from_role=None, grantee=None, grantor=None, id=None, is_access_constrained_by_database_vault=None, is_access_constrained_by_real_application_security=None, is_access_constrained_by_redaction=None, is_access_constrained_by_sql_firewall=None, is_access_constrained_by_virtual_private_database=None, key=None, privilege=None, privilege_grantable=None, privilege_type=None, security_policy_report_id=None, table_name=None, table_schema=None, target_id=None, view_name=None, view_schema=None, view_text=None):
        if access_type and not isinstance(access_type, str):
            raise TypeError("Expected argument 'access_type' to be a str")
        pulumi.set(__self__, "access_type", access_type)
        if column_name and not isinstance(column_name, str):
            raise TypeError("Expected argument 'column_name' to be a str")
        pulumi.set(__self__, "column_name", column_name)
        if database_view_access_entry_key and not isinstance(database_view_access_entry_key, str):
            raise TypeError("Expected argument 'database_view_access_entry_key' to be a str")
        pulumi.set(__self__, "database_view_access_entry_key", database_view_access_entry_key)
        if grant_from_role and not isinstance(grant_from_role, str):
            raise TypeError("Expected argument 'grant_from_role' to be a str")
        pulumi.set(__self__, "grant_from_role", grant_from_role)
        if grantee and not isinstance(grantee, str):
            raise TypeError("Expected argument 'grantee' to be a str")
        pulumi.set(__self__, "grantee", grantee)
        if grantor and not isinstance(grantor, str):
            raise TypeError("Expected argument 'grantor' to be a str")
        pulumi.set(__self__, "grantor", grantor)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_access_constrained_by_database_vault and not isinstance(is_access_constrained_by_database_vault, bool):
            raise TypeError("Expected argument 'is_access_constrained_by_database_vault' to be a bool")
        pulumi.set(__self__, "is_access_constrained_by_database_vault", is_access_constrained_by_database_vault)
        if is_access_constrained_by_real_application_security and not isinstance(is_access_constrained_by_real_application_security, bool):
            raise TypeError("Expected argument 'is_access_constrained_by_real_application_security' to be a bool")
        pulumi.set(__self__, "is_access_constrained_by_real_application_security", is_access_constrained_by_real_application_security)
        if is_access_constrained_by_redaction and not isinstance(is_access_constrained_by_redaction, bool):
            raise TypeError("Expected argument 'is_access_constrained_by_redaction' to be a bool")
        pulumi.set(__self__, "is_access_constrained_by_redaction", is_access_constrained_by_redaction)
        if is_access_constrained_by_sql_firewall and not isinstance(is_access_constrained_by_sql_firewall, bool):
            raise TypeError("Expected argument 'is_access_constrained_by_sql_firewall' to be a bool")
        pulumi.set(__self__, "is_access_constrained_by_sql_firewall", is_access_constrained_by_sql_firewall)
        if is_access_constrained_by_virtual_private_database and not isinstance(is_access_constrained_by_virtual_private_database, bool):
            raise TypeError("Expected argument 'is_access_constrained_by_virtual_private_database' to be a bool")
        pulumi.set(__self__, "is_access_constrained_by_virtual_private_database", is_access_constrained_by_virtual_private_database)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if privilege and not isinstance(privilege, str):
            raise TypeError("Expected argument 'privilege' to be a str")
        pulumi.set(__self__, "privilege", privilege)
        if privilege_grantable and not isinstance(privilege_grantable, str):
            raise TypeError("Expected argument 'privilege_grantable' to be a str")
        pulumi.set(__self__, "privilege_grantable", privilege_grantable)
        if privilege_type and not isinstance(privilege_type, str):
            raise TypeError("Expected argument 'privilege_type' to be a str")
        pulumi.set(__self__, "privilege_type", privilege_type)
        if security_policy_report_id and not isinstance(security_policy_report_id, str):
            raise TypeError("Expected argument 'security_policy_report_id' to be a str")
        pulumi.set(__self__, "security_policy_report_id", security_policy_report_id)
        if table_name and not isinstance(table_name, str):
            raise TypeError("Expected argument 'table_name' to be a str")
        pulumi.set(__self__, "table_name", table_name)
        if table_schema and not isinstance(table_schema, str):
            raise TypeError("Expected argument 'table_schema' to be a str")
        pulumi.set(__self__, "table_schema", table_schema)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)
        if view_name and not isinstance(view_name, str):
            raise TypeError("Expected argument 'view_name' to be a str")
        pulumi.set(__self__, "view_name", view_name)
        if view_schema and not isinstance(view_schema, str):
            raise TypeError("Expected argument 'view_schema' to be a str")
        pulumi.set(__self__, "view_schema", view_schema)
        if view_text and not isinstance(view_text, str):
            raise TypeError("Expected argument 'view_text' to be a str")
        pulumi.set(__self__, "view_text", view_text)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> builtins.str:
        """
        The type of the access the user has on the table, there can be one or more from SELECT, UPDATE, INSERT or DELETE.
        """
        return pulumi.get(self, "access_type")

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> builtins.str:
        """
        If there are column level privileges on a table or view.
        """
        return pulumi.get(self, "column_name")

    @property
    @pulumi.getter(name="databaseViewAccessEntryKey")
    def database_view_access_entry_key(self) -> builtins.str:
        return pulumi.get(self, "database_view_access_entry_key")

    @property
    @pulumi.getter(name="grantFromRole")
    def grant_from_role(self) -> builtins.str:
        """
        This can be empty in case of direct grant, in case of indirect grant, this attribute displays the name of the  role which is granted to the user though which the user has access to the table.
        """
        return pulumi.get(self, "grant_from_role")

    @property
    @pulumi.getter
    def grantee(self) -> builtins.str:
        """
        Grantee is the user who can access the table or view
        """
        return pulumi.get(self, "grantee")

    @property
    @pulumi.getter
    def grantor(self) -> builtins.str:
        """
        The user who granted the privilege.
        """
        return pulumi.get(self, "grantor")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAccessConstrainedByDatabaseVault")
    def is_access_constrained_by_database_vault(self) -> builtins.bool:
        """
        Indicates whether the table access is constrained via Oracle Database Vault.
        """
        return pulumi.get(self, "is_access_constrained_by_database_vault")

    @property
    @pulumi.getter(name="isAccessConstrainedByRealApplicationSecurity")
    def is_access_constrained_by_real_application_security(self) -> builtins.bool:
        """
        Indicates whether the view access is constrained via Real Application Security.
        """
        return pulumi.get(self, "is_access_constrained_by_real_application_security")

    @property
    @pulumi.getter(name="isAccessConstrainedByRedaction")
    def is_access_constrained_by_redaction(self) -> builtins.bool:
        """
        Indicates whether the view access is constrained via Oracle Data Redaction.
        """
        return pulumi.get(self, "is_access_constrained_by_redaction")

    @property
    @pulumi.getter(name="isAccessConstrainedBySqlFirewall")
    def is_access_constrained_by_sql_firewall(self) -> builtins.bool:
        """
        Indicates whether the view access is constrained via Oracle Database SQL Firewall.
        """
        return pulumi.get(self, "is_access_constrained_by_sql_firewall")

    @property
    @pulumi.getter(name="isAccessConstrainedByVirtualPrivateDatabase")
    def is_access_constrained_by_virtual_private_database(self) -> builtins.bool:
        """
        Indicates whether the view access is constrained via Virtual Private Database.
        """
        return pulumi.get(self, "is_access_constrained_by_virtual_private_database")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The unique key that identifies the table access report. It is numeric and unique within a security policy report.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def privilege(self) -> builtins.str:
        """
        The name of the privilege.
        """
        return pulumi.get(self, "privilege")

    @property
    @pulumi.getter(name="privilegeGrantable")
    def privilege_grantable(self) -> builtins.str:
        """
        Indicates whether the grantee can grant this privilege to other users. Privileges can be granted to a user or role with  GRANT_OPTION or ADMIN_OPTION
        """
        return pulumi.get(self, "privilege_grantable")

    @property
    @pulumi.getter(name="privilegeType")
    def privilege_type(self) -> builtins.str:
        """
        Type of the privilege user has, this includes System Privilege, Schema Privilege, Object Privilege, Column Privilege, Owner or Schema Privilege on a schema.
        """
        return pulumi.get(self, "privilege_type")

    @property
    @pulumi.getter(name="securityPolicyReportId")
    def security_policy_report_id(self) -> builtins.str:
        return pulumi.get(self, "security_policy_report_id")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> builtins.str:
        """
        The name of the database table the user has access to.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="tableSchema")
    def table_schema(self) -> builtins.str:
        """
        The name of the schema the table belongs to.
        """
        return pulumi.get(self, "table_schema")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> builtins.str:
        """
        The OCID of the of the  target database.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="viewName")
    def view_name(self) -> builtins.str:
        """
        The name of the view.
        """
        return pulumi.get(self, "view_name")

    @property
    @pulumi.getter(name="viewSchema")
    def view_schema(self) -> builtins.str:
        """
        The name of the schema.
        """
        return pulumi.get(self, "view_schema")

    @property
    @pulumi.getter(name="viewText")
    def view_text(self) -> builtins.str:
        """
        Definition of the view.
        """
        return pulumi.get(self, "view_text")


class AwaitableGetSecurityPolicyReportDatabaseViewAccessEntryResult(GetSecurityPolicyReportDatabaseViewAccessEntryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityPolicyReportDatabaseViewAccessEntryResult(
            access_type=self.access_type,
            column_name=self.column_name,
            database_view_access_entry_key=self.database_view_access_entry_key,
            grant_from_role=self.grant_from_role,
            grantee=self.grantee,
            grantor=self.grantor,
            id=self.id,
            is_access_constrained_by_database_vault=self.is_access_constrained_by_database_vault,
            is_access_constrained_by_real_application_security=self.is_access_constrained_by_real_application_security,
            is_access_constrained_by_redaction=self.is_access_constrained_by_redaction,
            is_access_constrained_by_sql_firewall=self.is_access_constrained_by_sql_firewall,
            is_access_constrained_by_virtual_private_database=self.is_access_constrained_by_virtual_private_database,
            key=self.key,
            privilege=self.privilege,
            privilege_grantable=self.privilege_grantable,
            privilege_type=self.privilege_type,
            security_policy_report_id=self.security_policy_report_id,
            table_name=self.table_name,
            table_schema=self.table_schema,
            target_id=self.target_id,
            view_name=self.view_name,
            view_schema=self.view_schema,
            view_text=self.view_text)


def get_security_policy_report_database_view_access_entry(database_view_access_entry_key: Optional[builtins.str] = None,
                                                          security_policy_report_id: Optional[builtins.str] = None,
                                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityPolicyReportDatabaseViewAccessEntryResult:
    """
    This data source provides details about a specific Security Policy Report Database View Access Entry resource in Oracle Cloud Infrastructure Data Safe service.

    Gets a database view access object by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_policy_report_database_view_access_entry = oci.DataSafe.get_security_policy_report_database_view_access_entry(database_view_access_entry_key=security_policy_report_database_view_access_entry_database_view_access_entry_key,
        security_policy_report_id=test_security_policy_report["id"])
    ```


    :param builtins.str database_view_access_entry_key: The unique key that identifies the view access object. This is a system-generated identifier.
    :param builtins.str security_policy_report_id: The OCID of the security policy report resource.
    """
    __args__ = dict()
    __args__['databaseViewAccessEntryKey'] = database_view_access_entry_key
    __args__['securityPolicyReportId'] = security_policy_report_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSecurityPolicyReportDatabaseViewAccessEntry:getSecurityPolicyReportDatabaseViewAccessEntry', __args__, opts=opts, typ=GetSecurityPolicyReportDatabaseViewAccessEntryResult).value

    return AwaitableGetSecurityPolicyReportDatabaseViewAccessEntryResult(
        access_type=pulumi.get(__ret__, 'access_type'),
        column_name=pulumi.get(__ret__, 'column_name'),
        database_view_access_entry_key=pulumi.get(__ret__, 'database_view_access_entry_key'),
        grant_from_role=pulumi.get(__ret__, 'grant_from_role'),
        grantee=pulumi.get(__ret__, 'grantee'),
        grantor=pulumi.get(__ret__, 'grantor'),
        id=pulumi.get(__ret__, 'id'),
        is_access_constrained_by_database_vault=pulumi.get(__ret__, 'is_access_constrained_by_database_vault'),
        is_access_constrained_by_real_application_security=pulumi.get(__ret__, 'is_access_constrained_by_real_application_security'),
        is_access_constrained_by_redaction=pulumi.get(__ret__, 'is_access_constrained_by_redaction'),
        is_access_constrained_by_sql_firewall=pulumi.get(__ret__, 'is_access_constrained_by_sql_firewall'),
        is_access_constrained_by_virtual_private_database=pulumi.get(__ret__, 'is_access_constrained_by_virtual_private_database'),
        key=pulumi.get(__ret__, 'key'),
        privilege=pulumi.get(__ret__, 'privilege'),
        privilege_grantable=pulumi.get(__ret__, 'privilege_grantable'),
        privilege_type=pulumi.get(__ret__, 'privilege_type'),
        security_policy_report_id=pulumi.get(__ret__, 'security_policy_report_id'),
        table_name=pulumi.get(__ret__, 'table_name'),
        table_schema=pulumi.get(__ret__, 'table_schema'),
        target_id=pulumi.get(__ret__, 'target_id'),
        view_name=pulumi.get(__ret__, 'view_name'),
        view_schema=pulumi.get(__ret__, 'view_schema'),
        view_text=pulumi.get(__ret__, 'view_text'))
def get_security_policy_report_database_view_access_entry_output(database_view_access_entry_key: Optional[pulumi.Input[builtins.str]] = None,
                                                                 security_policy_report_id: Optional[pulumi.Input[builtins.str]] = None,
                                                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityPolicyReportDatabaseViewAccessEntryResult]:
    """
    This data source provides details about a specific Security Policy Report Database View Access Entry resource in Oracle Cloud Infrastructure Data Safe service.

    Gets a database view access object by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_policy_report_database_view_access_entry = oci.DataSafe.get_security_policy_report_database_view_access_entry(database_view_access_entry_key=security_policy_report_database_view_access_entry_database_view_access_entry_key,
        security_policy_report_id=test_security_policy_report["id"])
    ```


    :param builtins.str database_view_access_entry_key: The unique key that identifies the view access object. This is a system-generated identifier.
    :param builtins.str security_policy_report_id: The OCID of the security policy report resource.
    """
    __args__ = dict()
    __args__['databaseViewAccessEntryKey'] = database_view_access_entry_key
    __args__['securityPolicyReportId'] = security_policy_report_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getSecurityPolicyReportDatabaseViewAccessEntry:getSecurityPolicyReportDatabaseViewAccessEntry', __args__, opts=opts, typ=GetSecurityPolicyReportDatabaseViewAccessEntryResult)
    return __ret__.apply(lambda __response__: GetSecurityPolicyReportDatabaseViewAccessEntryResult(
        access_type=pulumi.get(__response__, 'access_type'),
        column_name=pulumi.get(__response__, 'column_name'),
        database_view_access_entry_key=pulumi.get(__response__, 'database_view_access_entry_key'),
        grant_from_role=pulumi.get(__response__, 'grant_from_role'),
        grantee=pulumi.get(__response__, 'grantee'),
        grantor=pulumi.get(__response__, 'grantor'),
        id=pulumi.get(__response__, 'id'),
        is_access_constrained_by_database_vault=pulumi.get(__response__, 'is_access_constrained_by_database_vault'),
        is_access_constrained_by_real_application_security=pulumi.get(__response__, 'is_access_constrained_by_real_application_security'),
        is_access_constrained_by_redaction=pulumi.get(__response__, 'is_access_constrained_by_redaction'),
        is_access_constrained_by_sql_firewall=pulumi.get(__response__, 'is_access_constrained_by_sql_firewall'),
        is_access_constrained_by_virtual_private_database=pulumi.get(__response__, 'is_access_constrained_by_virtual_private_database'),
        key=pulumi.get(__response__, 'key'),
        privilege=pulumi.get(__response__, 'privilege'),
        privilege_grantable=pulumi.get(__response__, 'privilege_grantable'),
        privilege_type=pulumi.get(__response__, 'privilege_type'),
        security_policy_report_id=pulumi.get(__response__, 'security_policy_report_id'),
        table_name=pulumi.get(__response__, 'table_name'),
        table_schema=pulumi.get(__response__, 'table_schema'),
        target_id=pulumi.get(__response__, 'target_id'),
        view_name=pulumi.get(__response__, 'view_name'),
        view_schema=pulumi.get(__response__, 'view_schema'),
        view_text=pulumi.get(__response__, 'view_text')))
