# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDeployStagesResult',
    'AwaitableGetDeployStagesResult',
    'get_deploy_stages',
    'get_deploy_stages_output',
]

@pulumi.output_type
class GetDeployStagesResult:
    """
    A collection of values returned by getDeployStages.
    """
    def __init__(__self__, compartment_id=None, deploy_pipeline_id=None, deploy_stage_collections=None, display_name=None, filters=None, id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if deploy_pipeline_id and not isinstance(deploy_pipeline_id, str):
            raise TypeError("Expected argument 'deploy_pipeline_id' to be a str")
        pulumi.set(__self__, "deploy_pipeline_id", deploy_pipeline_id)
        if deploy_stage_collections and not isinstance(deploy_stage_collections, list):
            raise TypeError("Expected argument 'deploy_stage_collections' to be a list")
        pulumi.set(__self__, "deploy_stage_collections", deploy_stage_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        The OCID of the compartment where the ContainerInstance will be created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="deployPipelineId")
    def deploy_pipeline_id(self) -> Optional[builtins.str]:
        """
        The OCID of a pipeline.
        """
        return pulumi.get(self, "deploy_pipeline_id")

    @property
    @pulumi.getter(name="deployStageCollections")
    def deploy_stage_collections(self) -> Sequence['outputs.GetDeployStagesDeployStageCollectionResult']:
        """
        The list of deploy_stage_collection.
        """
        return pulumi.get(self, "deploy_stage_collections")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        Deployment stage display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDeployStagesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the deployment stage.
        """
        return pulumi.get(self, "state")


class AwaitableGetDeployStagesResult(GetDeployStagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDeployStagesResult(
            compartment_id=self.compartment_id,
            deploy_pipeline_id=self.deploy_pipeline_id,
            deploy_stage_collections=self.deploy_stage_collections,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_deploy_stages(compartment_id: Optional[builtins.str] = None,
                      deploy_pipeline_id: Optional[builtins.str] = None,
                      display_name: Optional[builtins.str] = None,
                      filters: Optional[Sequence[Union['GetDeployStagesFilterArgs', 'GetDeployStagesFilterArgsDict']]] = None,
                      id: Optional[builtins.str] = None,
                      state: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDeployStagesResult:
    """
    This data source provides the list of Deploy Stages in Oracle Cloud Infrastructure Devops service.

    Retrieves a list of deployment stages.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_deploy_stages = oci.DevOps.get_deploy_stages(compartment_id=compartment_id,
        deploy_pipeline_id=test_deploy_pipeline["id"],
        display_name=deploy_stage_display_name,
        id=deploy_stage_id,
        state=deploy_stage_state)
    ```


    :param builtins.str compartment_id: The OCID of the compartment in which to list resources.
    :param builtins.str deploy_pipeline_id: The ID of the parent pipeline.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str id: Unique identifier or OCID for listing a single resource by ID.
    :param builtins.str state: A filter to return only deployment stages that matches the given lifecycle state.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['deployPipelineId'] = deploy_pipeline_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DevOps/getDeployStages:getDeployStages', __args__, opts=opts, typ=GetDeployStagesResult).value

    return AwaitableGetDeployStagesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        deploy_pipeline_id=pulumi.get(__ret__, 'deploy_pipeline_id'),
        deploy_stage_collections=pulumi.get(__ret__, 'deploy_stage_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_deploy_stages_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             deploy_pipeline_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDeployStagesFilterArgs', 'GetDeployStagesFilterArgsDict']]]]] = None,
                             id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDeployStagesResult]:
    """
    This data source provides the list of Deploy Stages in Oracle Cloud Infrastructure Devops service.

    Retrieves a list of deployment stages.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_deploy_stages = oci.DevOps.get_deploy_stages(compartment_id=compartment_id,
        deploy_pipeline_id=test_deploy_pipeline["id"],
        display_name=deploy_stage_display_name,
        id=deploy_stage_id,
        state=deploy_stage_state)
    ```


    :param builtins.str compartment_id: The OCID of the compartment in which to list resources.
    :param builtins.str deploy_pipeline_id: The ID of the parent pipeline.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str id: Unique identifier or OCID for listing a single resource by ID.
    :param builtins.str state: A filter to return only deployment stages that matches the given lifecycle state.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['deployPipelineId'] = deploy_pipeline_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DevOps/getDeployStages:getDeployStages', __args__, opts=opts, typ=GetDeployStagesResult)
    return __ret__.apply(lambda __response__: GetDeployStagesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        deploy_pipeline_id=pulumi.get(__response__, 'deploy_pipeline_id'),
        deploy_stage_collections=pulumi.get(__response__, 'deploy_stage_collections'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
