# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRepositoryDiffsResult',
    'AwaitableGetRepositoryDiffsResult',
    'get_repository_diffs',
    'get_repository_diffs_output',
]

@pulumi.output_type
class GetRepositoryDiffsResult:
    """
    A collection of values returned by getRepositoryDiffs.
    """
    def __init__(__self__, base_version=None, diff_collections=None, filters=None, id=None, is_comparison_from_merge_base=None, repository_id=None, target_repository_id=None, target_version=None):
        if base_version and not isinstance(base_version, str):
            raise TypeError("Expected argument 'base_version' to be a str")
        pulumi.set(__self__, "base_version", base_version)
        if diff_collections and not isinstance(diff_collections, list):
            raise TypeError("Expected argument 'diff_collections' to be a list")
        pulumi.set(__self__, "diff_collections", diff_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_comparison_from_merge_base and not isinstance(is_comparison_from_merge_base, bool):
            raise TypeError("Expected argument 'is_comparison_from_merge_base' to be a bool")
        pulumi.set(__self__, "is_comparison_from_merge_base", is_comparison_from_merge_base)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)
        if target_repository_id and not isinstance(target_repository_id, str):
            raise TypeError("Expected argument 'target_repository_id' to be a str")
        pulumi.set(__self__, "target_repository_id", target_repository_id)
        if target_version and not isinstance(target_version, str):
            raise TypeError("Expected argument 'target_version' to be a str")
        pulumi.set(__self__, "target_version", target_version)

    @property
    @pulumi.getter(name="baseVersion")
    def base_version(self) -> builtins.str:
        return pulumi.get(self, "base_version")

    @property
    @pulumi.getter(name="diffCollections")
    def diff_collections(self) -> Sequence['outputs.GetRepositoryDiffsDiffCollectionResult']:
        """
        The list of diff_collection.
        """
        return pulumi.get(self, "diff_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetRepositoryDiffsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isComparisonFromMergeBase")
    def is_comparison_from_merge_base(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "is_comparison_from_merge_base")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> builtins.str:
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="targetRepositoryId")
    def target_repository_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "target_repository_id")

    @property
    @pulumi.getter(name="targetVersion")
    def target_version(self) -> builtins.str:
        return pulumi.get(self, "target_version")


class AwaitableGetRepositoryDiffsResult(GetRepositoryDiffsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryDiffsResult(
            base_version=self.base_version,
            diff_collections=self.diff_collections,
            filters=self.filters,
            id=self.id,
            is_comparison_from_merge_base=self.is_comparison_from_merge_base,
            repository_id=self.repository_id,
            target_repository_id=self.target_repository_id,
            target_version=self.target_version)


def get_repository_diffs(base_version: Optional[builtins.str] = None,
                         filters: Optional[Sequence[Union['GetRepositoryDiffsFilterArgs', 'GetRepositoryDiffsFilterArgsDict']]] = None,
                         is_comparison_from_merge_base: Optional[builtins.bool] = None,
                         repository_id: Optional[builtins.str] = None,
                         target_repository_id: Optional[builtins.str] = None,
                         target_version: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryDiffsResult:
    """
    This data source provides the list of Repository Diffs in Oracle Cloud Infrastructure Devops service.

    Compares two revisions and lists the differences. Supports comparison between two references or commits.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_diffs = oci.DevOps.get_repository_diffs(base_version=repository_diff_base_version,
        repository_id=test_repository["id"],
        target_version=repository_diff_target_version,
        is_comparison_from_merge_base=repository_diff_is_comparison_from_merge_base,
        target_repository_id=test_repository["id"])
    ```


    :param builtins.str base_version: The commit or reference name to compare changes against.
    :param builtins.bool is_comparison_from_merge_base: Boolean value to indicate whether to use merge base or most recent revision.
    :param builtins.str repository_id: Unique repository identifier.
    :param builtins.str target_repository_id: The target repository identifier
    :param builtins.str target_version: The commit or reference name where changes are coming from.
    """
    __args__ = dict()
    __args__['baseVersion'] = base_version
    __args__['filters'] = filters
    __args__['isComparisonFromMergeBase'] = is_comparison_from_merge_base
    __args__['repositoryId'] = repository_id
    __args__['targetRepositoryId'] = target_repository_id
    __args__['targetVersion'] = target_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DevOps/getRepositoryDiffs:getRepositoryDiffs', __args__, opts=opts, typ=GetRepositoryDiffsResult).value

    return AwaitableGetRepositoryDiffsResult(
        base_version=pulumi.get(__ret__, 'base_version'),
        diff_collections=pulumi.get(__ret__, 'diff_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_comparison_from_merge_base=pulumi.get(__ret__, 'is_comparison_from_merge_base'),
        repository_id=pulumi.get(__ret__, 'repository_id'),
        target_repository_id=pulumi.get(__ret__, 'target_repository_id'),
        target_version=pulumi.get(__ret__, 'target_version'))
def get_repository_diffs_output(base_version: Optional[pulumi.Input[builtins.str]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetRepositoryDiffsFilterArgs', 'GetRepositoryDiffsFilterArgsDict']]]]] = None,
                                is_comparison_from_merge_base: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                repository_id: Optional[pulumi.Input[builtins.str]] = None,
                                target_repository_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                target_version: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRepositoryDiffsResult]:
    """
    This data source provides the list of Repository Diffs in Oracle Cloud Infrastructure Devops service.

    Compares two revisions and lists the differences. Supports comparison between two references or commits.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_diffs = oci.DevOps.get_repository_diffs(base_version=repository_diff_base_version,
        repository_id=test_repository["id"],
        target_version=repository_diff_target_version,
        is_comparison_from_merge_base=repository_diff_is_comparison_from_merge_base,
        target_repository_id=test_repository["id"])
    ```


    :param builtins.str base_version: The commit or reference name to compare changes against.
    :param builtins.bool is_comparison_from_merge_base: Boolean value to indicate whether to use merge base or most recent revision.
    :param builtins.str repository_id: Unique repository identifier.
    :param builtins.str target_repository_id: The target repository identifier
    :param builtins.str target_version: The commit or reference name where changes are coming from.
    """
    __args__ = dict()
    __args__['baseVersion'] = base_version
    __args__['filters'] = filters
    __args__['isComparisonFromMergeBase'] = is_comparison_from_merge_base
    __args__['repositoryId'] = repository_id
    __args__['targetRepositoryId'] = target_repository_id
    __args__['targetVersion'] = target_version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DevOps/getRepositoryDiffs:getRepositoryDiffs', __args__, opts=opts, typ=GetRepositoryDiffsResult)
    return __ret__.apply(lambda __response__: GetRepositoryDiffsResult(
        base_version=pulumi.get(__response__, 'base_version'),
        diff_collections=pulumi.get(__response__, 'diff_collections'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        is_comparison_from_merge_base=pulumi.get(__response__, 'is_comparison_from_merge_base'),
        repository_id=pulumi.get(__response__, 'repository_id'),
        target_repository_id=pulumi.get(__response__, 'target_repository_id'),
        target_version=pulumi.get(__response__, 'target_version')))
