# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRepositoryObjectContentResult',
    'AwaitableGetRepositoryObjectContentResult',
    'get_repository_object_content',
    'get_repository_object_content_output',
]

@pulumi.output_type
class GetRepositoryObjectContentResult:
    """
    A collection of values returned by getRepositoryObjectContent.
    """
    def __init__(__self__, file_path=None, id=None, repository_id=None, sha=None):
        if file_path and not isinstance(file_path, str):
            raise TypeError("Expected argument 'file_path' to be a str")
        pulumi.set(__self__, "file_path", file_path)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)
        if sha and not isinstance(sha, str):
            raise TypeError("Expected argument 'sha' to be a str")
        pulumi.set(__self__, "sha", sha)

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> Optional[builtins.str]:
        return pulumi.get(self, "file_path")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> builtins.str:
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter
    def sha(self) -> builtins.str:
        return pulumi.get(self, "sha")


class AwaitableGetRepositoryObjectContentResult(GetRepositoryObjectContentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryObjectContentResult(
            file_path=self.file_path,
            id=self.id,
            repository_id=self.repository_id,
            sha=self.sha)


def get_repository_object_content(file_path: Optional[builtins.str] = None,
                                  repository_id: Optional[builtins.str] = None,
                                  sha: Optional[builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryObjectContentResult:
    """
    This data source provides details about a specific Repository Object Content resource in Oracle Cloud Infrastructure Devops service.

    Retrieve contents of a specified object.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_object_content = oci.DevOps.get_repository_object_content(repository_id=test_repository["id"],
        sha=repository_object_content_sha,
        file_path=repository_object_content_file_path)
    ```


    :param builtins.str file_path: A filter to return only commits that affect any of the specified paths.
    :param builtins.str repository_id: Unique repository identifier.
    :param builtins.str sha: The SHA of a blob or tree.
    """
    __args__ = dict()
    __args__['filePath'] = file_path
    __args__['repositoryId'] = repository_id
    __args__['sha'] = sha
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DevOps/getRepositoryObjectContent:getRepositoryObjectContent', __args__, opts=opts, typ=GetRepositoryObjectContentResult).value

    return AwaitableGetRepositoryObjectContentResult(
        file_path=pulumi.get(__ret__, 'file_path'),
        id=pulumi.get(__ret__, 'id'),
        repository_id=pulumi.get(__ret__, 'repository_id'),
        sha=pulumi.get(__ret__, 'sha'))
def get_repository_object_content_output(file_path: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         repository_id: Optional[pulumi.Input[builtins.str]] = None,
                                         sha: Optional[pulumi.Input[builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRepositoryObjectContentResult]:
    """
    This data source provides details about a specific Repository Object Content resource in Oracle Cloud Infrastructure Devops service.

    Retrieve contents of a specified object.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_object_content = oci.DevOps.get_repository_object_content(repository_id=test_repository["id"],
        sha=repository_object_content_sha,
        file_path=repository_object_content_file_path)
    ```


    :param builtins.str file_path: A filter to return only commits that affect any of the specified paths.
    :param builtins.str repository_id: Unique repository identifier.
    :param builtins.str sha: The SHA of a blob or tree.
    """
    __args__ = dict()
    __args__['filePath'] = file_path
    __args__['repositoryId'] = repository_id
    __args__['sha'] = sha
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DevOps/getRepositoryObjectContent:getRepositoryObjectContent', __args__, opts=opts, typ=GetRepositoryObjectContentResult)
    return __ret__.apply(lambda __response__: GetRepositoryObjectContentResult(
        file_path=pulumi.get(__response__, 'file_path'),
        id=pulumi.get(__response__, 'id'),
        repository_id=pulumi.get(__response__, 'repository_id'),
        sha=pulumi.get(__response__, 'sha')))
